/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.objektpanels;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh49Analysen;
import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh49Fachdaten;
import de.bielefeld.umweltamt.aui.module.BasisObjektBearbeiten;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.SelectTable;
import de.bielefeld.umweltamt.aui.utils.TableFocusListener;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.EditableListTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableColumn;

public class Anh49AnalysenPanel
extends JPanel {
    private String name = "Analysen";
    private BasisObjektBearbeiten hauptModul;
    private Anh49Fachdaten fachdaten;
    private Anh49AnalysenModel analysenModel;
    private JTable analysenTabelle;
    private JButton speichernButton;

    public Anh49AnalysenPanel(BasisObjektBearbeiten hauptModul) {
        this.hauptModul = hauptModul;
        this.analysenModel = new Anh49AnalysenModel();
        TableFocusListener tfl = TableFocusListener.getInstance();
        this.getAnalysenTabelle().addFocusListener(tfl);
        JScrollPane abscheiderScroller = new JScrollPane(this.getAnalysenTabelle(), 20, 31);
        FormLayout layout = new FormLayout("150dlu:grow, 100dlu", "f:100dlu:grow, 3dlu, pref");
        PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.add((Component)abscheiderScroller, cc.xyw(1, 1, 2));
        builder.add((Component)this.getSpeichernButton(), cc.xy(2, 3));
    }

    private JTable getAnalysenTabelle() {
        if (this.analysenTabelle == null) {
            this.analysenTabelle = new SelectTable(this.analysenModel);
            this.analysenTabelle.setAutoResizeMode(1);
            KeyStroke deleteKeyStroke = KeyStroke.getKeyStroke(127, 0, false);
            this.analysenTabelle.getInputMap().put(deleteKeyStroke, "DEL");
            AbstractAction anaRemoveAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = Anh49AnalysenPanel.this.analysenTabelle.getSelectedRow();
                    if (row != -1 && Anh49AnalysenPanel.this.analysenTabelle.getEditingRow() == -1) {
                        Anh49Analysen analyse = Anh49AnalysenPanel.this.analysenModel.getRow(row);
                        if (Anh49AnalysenPanel.this.hauptModul.getFrame().showQuestion("Soll die Analyse " + analyse.getAnalysenid() + " wirklich inkl. aller untersuchten Parameter gel\u00f6scht werden?", "L\u00f6schen best\u00e4tigen")) {
                            Anh49AnalysenPanel.this.analysenModel.removeRow(row);
                            AUIKataster.debugOutput("Analyse " + analyse.getAnalysenid() + " wurde gel\u00f6scht!");
                        } else {
                            AUIKataster.debugOutput("L\u00f6schen von " + analyse.getAnalysenid() + " wurde abgebrochen!");
                        }
                    }
                }
            };
            this.analysenTabelle.getActionMap().put("DEL", anaRemoveAction);
            TableColumn column = null;
            for (int i = 0; i < this.analysenTabelle.getColumnCount(); ++i) {
                column = this.analysenTabelle.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setMaxWidth(100);
                    column.setPreferredWidth(75);
                    continue;
                }
                if (i == 1) {
                    column.setMaxWidth(250);
                    column.setPreferredWidth(150);
                    continue;
                }
                if (i == 8) {
                    column.setMaxWidth(400);
                    column.setPreferredWidth(300);
                    continue;
                }
                column.setMaxWidth(80);
                column.setPreferredWidth(50);
            }
        }
        return this.analysenTabelle;
    }

    public void speichernAnalyse() {
        List anaListe = this.analysenModel.getList();
        for (int i = 0; i < anaListe.size(); ++i) {
            Anh49Analysen analyse = (Anh49Analysen)anaListe.get(i);
            Anh49Analysen.saveOrUpdateAnalyse(analyse);
        }
        this.analysenModel.updateList();
    }

    public void setFachdaten(Anh49Fachdaten fachdaten) {
        this.fachdaten = fachdaten;
    }

    public void updateForm() {
        if (this.fachdaten != null) {
            this.analysenModel.setFachdaten(this.fachdaten);
            this.analysenModel.updateList();
        }
    }

    public void clearForm() {
        this.analysenModel.setList(new ArrayList());
    }

    public void enableAll(boolean enabled) {
        if (!enabled || this.fachdaten != null) {
            this.getAnalysenTabelle().setEnabled(enabled);
            this.getSpeichernButton().setEnabled(enabled);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    private JButton getSpeichernButton() {
        if (this.speichernButton == null) {
            this.speichernButton = new JButton("Analysen speichern");
            this.speichernButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Anh49AnalysenPanel.this.speichernAnalyse();
                }
            });
        }
        return this.speichernButton;
    }

    private class Anh49AnalysenModel
    extends EditableListTableModel {
        private Anh49Fachdaten fachdaten;

        public Anh49AnalysenModel() {
            super(new String[]{"Datum", "Institut", "CSB", "pH", "KW", "Zink", "BSB5", "BIK", "Bemerkung"}, false, true);
        }

        public void setFachdaten(Anh49Fachdaten fachdaten) {
            this.fachdaten = fachdaten;
            this.updateList();
        }

        @Override
        public boolean objectRemoved(Object objectAtRow) {
            Anh49Analysen removedAna = (Anh49Analysen)objectAtRow;
            boolean removed = removedAna.getAnalysenid() != null ? Anh49Analysen.removeAnalyse(removedAna) : true;
            return removed;
        }

        @Override
        public Object getColumnValue(Object objectAtRow, int columnIndex) {
            String tmp;
            Anh49Analysen analysen = (Anh49Analysen)objectAtRow;
            switch (columnIndex) {
                case 0: {
                    tmp = AuikUtils.getStringFromDate(analysen.getDatum());
                    break;
                }
                case 1: {
                    tmp = analysen.getInstitut();
                    break;
                }
                case 2: {
                    tmp = analysen.getCsbWert();
                    break;
                }
                case 3: {
                    tmp = analysen.getPhWert();
                    break;
                }
                case 4: {
                    tmp = analysen.getKwWert();
                    break;
                }
                case 5: {
                    tmp = analysen.getZinkWert();
                    break;
                }
                case 6: {
                    tmp = analysen.getBsb5Wert();
                    break;
                }
                case 7: {
                    tmp = analysen.getBikWert();
                    break;
                }
                case 8: {
                    tmp = analysen.getBemerkungen();
                    break;
                }
                default: {
                    tmp = null;
                }
            }
            return tmp;
        }

        @Override
        public void updateList() {
            if (this.fachdaten != null) {
                this.setList(Anh49Analysen.getAnalyse(this.fachdaten));
            }
            this.fireTableDataChanged();
        }

        @Override
        public void editObject(Object objectAtRow, int columnIndex, Object newValue) {
            Anh49Analysen analyse = (Anh49Analysen)objectAtRow;
            switch (columnIndex) {
                case 0: {
                    DateFormat format = DateFormat.getDateInstance(3);
                    try {
                        Date tmpDate = format.parse((String)newValue);
                        analyse.setDatum(tmpDate);
                    }
                    catch (ParseException e) {
                        Anh49AnalysenPanel.this.hauptModul.getFrame().changeStatus("Bitte geben Sie das Datum in der Form MM.TT.JJJJ ein!", HauptFrame.ERROR_COLOR);
                    }
                    break;
                }
                case 1: {
                    String tmpInst = (String)newValue;
                    if (tmpInst.length() > 50) {
                        tmpInst = tmpInst.substring(0, 50);
                    }
                    analyse.setInstitut(tmpInst);
                    break;
                }
                case 2: {
                    String tmpCsb = (String)newValue;
                    if (tmpCsb.length() > 50) {
                        tmpCsb = tmpCsb.substring(0, 50);
                    }
                    analyse.setCsbWert(tmpCsb);
                    break;
                }
                case 3: {
                    String tmpPh = (String)newValue;
                    if (tmpPh.length() > 50) {
                        tmpPh = tmpPh.substring(0, 50);
                    }
                    analyse.setPhWert(tmpPh);
                    break;
                }
                case 4: {
                    String tmpKw = (String)newValue;
                    if (tmpKw.length() > 50) {
                        tmpKw = tmpKw.substring(0, 50);
                    }
                    analyse.setKwWert(tmpKw);
                    break;
                }
                case 5: {
                    String tmpZn = (String)newValue;
                    if (tmpZn.length() > 50) {
                        tmpZn = tmpZn.substring(0, 50);
                    }
                    analyse.setZinkWert(tmpZn);
                    break;
                }
                case 6: {
                    String tmpBSB = (String)newValue;
                    if (tmpBSB.length() > 50) {
                        tmpBSB = tmpBSB.substring(0, 50);
                    }
                    analyse.setBsb5Wert(tmpBSB);
                    break;
                }
                case 7: {
                    String tmpBik = (String)newValue;
                    if (tmpBik.length() > 50) {
                        tmpBik = tmpBik.substring(0, 50);
                    }
                    analyse.setBikWert(tmpBik);
                    break;
                }
                case 8: {
                    String tmpBem = (String)newValue;
                    if (tmpBem.length() > 255) {
                        tmpBem = tmpBem.substring(0, 255);
                    }
                    analyse.setBemerkungen(tmpBem);
                    break;
                }
            }
        }

        @Override
        public Object newObject() {
            Anh49Analysen ana = new Anh49Analysen();
            ana.setAnh49Fachdaten(this.fachdaten);
            ana.setDatum(new Date());
            return ana;
        }

        public Anh49Analysen getRow(int rowIndex) {
            return (Anh49Analysen)this.getObjectAtRow(rowIndex);
        }
    }
}

