/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.objektpanels;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjektverknuepfung;
import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh40Fachdaten;
import de.bielefeld.umweltamt.aui.module.BasisObjektBearbeiten;
import de.bielefeld.umweltamt.aui.module.common.ObjektChooser;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.ObjektVerknuepfungModel;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.IntegerField;
import de.bielefeld.umweltamt.aui.utils.LimitedTextArea;
import de.bielefeld.umweltamt.aui.utils.LimitedTextField;
import de.bielefeld.umweltamt.aui.utils.TextFieldDateChooser;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class Anh40Panel
extends JPanel {
    private String name = "Anhang 40";
    private BasisObjektBearbeiten hauptModul;
    private JTextArea anh40BemerkungArea = null;
    private JTextField ansprechpartnerFeld = null;
    private JTextField sachbearbeiterravFeld = null;
    private JTextField sachbearbeiterheepenFeld = null;
    private JTextField klaeranlageFeld = null;
    private JTextField herkunftsbereichFeld = null;
    private JTextField prioritaetFeld = null;
    private JCheckBox wsgCheck = null;
    private JCheckBox genehmigungspflichtCheck = null;
    private JCheckBox nachtragCheck = null;
    private JCheckBox bimschCheck = null;
    private JFormattedTextField abwmengegenehmigtFeld = null;
    private JFormattedTextField abwmengeprodspezFeld = null;
    private JFormattedTextField abwmengegesamtFeld = null;
    private TextFieldDateChooser gen58Datum = null;
    private TextFieldDateChooser gen59Datum = null;
    private JButton saveAnh40Button = null;
    private Anh40Fachdaten fachdaten = null;
    private ActionListener editButtonListener;
    private ObjektVerknuepfungModel objektVerknuepfungModel;
    private JTable objektverknuepfungTabelle = null;
    private JButton selectObjektButton = null;
    private Action verknuepfungLoeschAction;
    private JPopupMenu verknuepfungPopup;

    public Anh40Panel(BasisObjektBearbeiten hauptModul) {
        this.hauptModul = hauptModul;
        FormLayout layout = new FormLayout("r:100dlu, 5dlu, 80dlu, 5dlu, r:65dlu, 5dlu, 100dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("Fachdaten");
        builder.append("SachbearbeiterIn Rav.-Str.:", (Component)this.getSachbearbeiterravFeld());
        builder.append("", (Component)this.getWsgCheck());
        builder.nextLine();
        builder.append("SachbearbeiterIn Heepen.:", (Component)this.getSachbearbeiterheepenFeld());
        builder.append("", (Component)this.getGenehmigungspflichtCheck());
        builder.nextLine();
        builder.append("AnsprechpartnerIn:", (Component)this.getAnsprechpartnerFeld());
        builder.append("Genehmigung \u00a758:", (Component)this.getGen58Datum());
        builder.nextLine();
        builder.append("Herkunftsbereich:", (Component)this.getHerkunftsbereichFeld());
        builder.append("Genehmigung \u00a759:", (Component)this.getGen59Datum());
        builder.nextLine();
        builder.append("Kl\u00e4ranlage:", (Component)this.getKlaeranlageFeld());
        builder.append("Priorit\u00e4t:", (Component)this.getPrioritaetFeld());
        builder.nextLine();
        builder.append("Abwassermenge genehmigt:", (Component)this.getAbwmengegenehmigtFeld());
        builder.append("", (Component)this.getNachtragCheck());
        builder.nextLine();
        builder.append("Abwassermenge produktionsspez.:", (Component)this.getAbwmengeprodspezFeld());
        builder.append("", (Component)this.getBimschCheck());
        builder.nextLine();
        builder.append("Abwassermenge gesamt:", (Component)this.getAbwmengegesamtFeld());
        builder.nextLine();
        builder.appendSeparator("Bemerkungen");
        builder.appendRow("3dlu");
        builder.nextLine(2);
        JScrollPane bemerkungsScroller = new JScrollPane(this.getAnh40BemerkungArea(), 20, 31);
        builder.appendRow("fill:30dlu");
        builder.append((Component)bemerkungsScroller, 7);
        builder.nextLine();
        builder.appendSeparator("Verkn\u00fcpfte Objekte");
        builder.appendRow("3dlu");
        builder.nextLine(2);
        JScrollPane objektverknuepfungScroller = new JScrollPane(this.getObjektverknuepungTabelle(), 20, 31);
        builder.appendRow("fill:100dlu");
        builder.append((Component)objektverknuepfungScroller, 7);
        builder.nextLine();
        JPanel buttonBar = ButtonBarFactory.buildRightAlignedBar((JButton)this.getSelectObjektButton(), (JButton)this.getSaveAnh40Button());
        builder.append((Component)buttonBar, 7);
    }

    public void fetchFormData() throws RuntimeException {
        this.fachdaten = Anh40Fachdaten.getAnh40ByObjekt(this.hauptModul.getObjekt());
        AUIKataster.debugOutput("Anhang 40 Objekt aus DB geholt: ID" + this.fachdaten, "Anh50Panel.fetchFormData");
    }

    public void updateForm() throws RuntimeException {
        if (this.fachdaten != null) {
            if (this.fachdaten.getBemerkungen() != null) {
                this.getAnh40BemerkungArea().setText(this.fachdaten.getBemerkungen());
            }
            if (this.fachdaten.getAnsprechpartner() != null) {
                this.getAnsprechpartnerFeld().setText(this.fachdaten.getAnsprechpartner());
            }
            if (this.fachdaten.getHerkunftsbereich() != null) {
                this.getHerkunftsbereichFeld().setText(this.fachdaten.getHerkunftsbereich());
            }
            if (this.fachdaten.getSachbearbeiterrav() != null) {
                this.getSachbearbeiterravFeld().setText(this.fachdaten.getSachbearbeiterrav());
            }
            if (this.fachdaten.getSachbearbeiterheepen() != null) {
                this.getSachbearbeiterheepenFeld().setText(this.fachdaten.getSachbearbeiterheepen());
            }
            if (this.fachdaten.getKlaeranlage() != null) {
                this.getKlaeranlageFeld().setText(this.fachdaten.getKlaeranlage());
            }
            if (this.fachdaten.getWsg() != null) {
                if (this.fachdaten.getWsg().booleanValue()) {
                    this.getWsgCheck().setSelected(true);
                } else {
                    this.getWsgCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getGenehmigungspflicht() != null) {
                if (this.fachdaten.getGenehmigungspflicht().booleanValue()) {
                    this.getGenehmigungspflichtCheck().setSelected(true);
                } else {
                    this.getGenehmigungspflichtCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getNachtrag() != null) {
                if (this.fachdaten.getNachtrag().booleanValue()) {
                    this.getNachtragCheck().setSelected(true);
                } else {
                    this.getNachtragCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getBimsch() != null) {
                if (this.fachdaten.getBimsch().booleanValue()) {
                    this.getBimschCheck().setSelected(true);
                } else {
                    this.getBimschCheck().setSelected(false);
                }
            }
            if (this.fachdaten.getAbwmengegenehmigt() != null) {
                this.getAbwmengegenehmigtFeld().setText(this.fachdaten.getAbwmengegenehmigt().toString());
            }
            if (this.fachdaten.getAbwmengeprodspez() != null) {
                this.getAbwmengeprodspezFeld().setText(this.fachdaten.getAbwmengeprodspez().toString());
            }
            if (this.fachdaten.getAbwmengegesamt() != null) {
                this.getAbwmengegesamtFeld().setText(this.fachdaten.getAbwmengegesamt().toString());
            }
            if (this.fachdaten.getGen58() != null) {
                this.getGen58Datum().setDate(this.fachdaten.getGen58());
            }
            if (this.fachdaten.getGen59() != null) {
                this.getGen59Datum().setDate(this.fachdaten.getGen59());
            }
            this.objektVerknuepfungModel.setObjekt(this.hauptModul.getObjekt());
        }
    }

    public void clearForm() {
        this.getAnh40BemerkungArea().setText(null);
        this.getAnsprechpartnerFeld().setText(null);
        this.getSachbearbeiterravFeld().setText(null);
        this.getSachbearbeiterheepenFeld().setText(null);
        this.getKlaeranlageFeld().setText(null);
        this.getHerkunftsbereichFeld().setText(null);
        this.getWsgCheck().setSelected(false);
        this.getGenehmigungspflichtCheck().setSelected(false);
        this.getNachtragCheck().setSelected(false);
        this.getBimschCheck().setSelected(false);
        this.getAbwmengegenehmigtFeld().setText(null);
        this.getAbwmengeprodspezFeld().setText(null);
        this.getAbwmengegesamtFeld().setText(null);
        this.getGen58Datum().setDate(null);
        this.getGen59Datum().setDate(null);
    }

    public void enableAll(boolean enabled) {
        this.getAnh40BemerkungArea().setEnabled(enabled);
        this.getAnsprechpartnerFeld().setEnabled(enabled);
        this.getSachbearbeiterravFeld().setEnabled(enabled);
        this.getSachbearbeiterheepenFeld().setEnabled(enabled);
        this.getKlaeranlageFeld().setEnabled(enabled);
        this.getHerkunftsbereichFeld().setEnabled(enabled);
        this.getWsgCheck().setEnabled(enabled);
        this.getGenehmigungspflichtCheck().setEnabled(enabled);
        this.getNachtragCheck().setEnabled(enabled);
        this.getBimschCheck().setEnabled(enabled);
        this.getAbwmengegenehmigtFeld().setEnabled(enabled);
        this.getAbwmengeprodspezFeld().setEnabled(enabled);
        this.getAbwmengegesamtFeld().setEnabled(enabled);
        this.getGen58Datum().setEnabled(enabled);
        this.getGen59Datum().setEnabled(enabled);
    }

    private boolean saveAnh40Daten() {
        String bemerkungen = this.anh40BemerkungArea.getText();
        if ("".equals(bemerkungen)) {
            this.fachdaten.setBemerkungen(null);
        } else {
            this.fachdaten.setBemerkungen(bemerkungen);
        }
        String ansprechp = this.ansprechpartnerFeld.getText();
        if ("".equals(ansprechp)) {
            this.fachdaten.setAnsprechpartner(null);
        } else {
            this.fachdaten.setAnsprechpartner(ansprechp);
        }
        String sachbearbrav = this.sachbearbeiterravFeld.getText();
        if ("".equals(sachbearbrav)) {
            this.fachdaten.setSachbearbeiterrav(null);
        } else {
            this.fachdaten.setSachbearbeiterrav(sachbearbrav);
        }
        String sachbearbheepen = this.sachbearbeiterheepenFeld.getText();
        if ("".equals(sachbearbheepen)) {
            this.fachdaten.setSachbearbeiterheepen(null);
        } else {
            this.fachdaten.setSachbearbeiterheepen(sachbearbheepen);
        }
        String klaeranlage = this.klaeranlageFeld.getText();
        if ("".equals(klaeranlage)) {
            this.fachdaten.setKlaeranlage(null);
        } else {
            this.fachdaten.setKlaeranlage(klaeranlage);
        }
        String herkunft = this.herkunftsbereichFeld.getText();
        if ("".equals(herkunft)) {
            this.fachdaten.setHerkunftsbereich(null);
        } else {
            this.fachdaten.setHerkunftsbereich(herkunft);
        }
        if (this.getWsgCheck().isSelected()) {
            this.fachdaten.setWsg(true);
        } else {
            this.fachdaten.setWsg(false);
        }
        if (this.getGenehmigungspflichtCheck().isSelected()) {
            this.fachdaten.setGenehmigungspflicht(true);
        } else {
            this.fachdaten.setGenehmigungspflicht(false);
        }
        if (this.getNachtragCheck().isSelected()) {
            this.fachdaten.setNachtrag(true);
        } else {
            this.fachdaten.setNachtrag(false);
        }
        if (this.getBimschCheck().isSelected()) {
            this.fachdaten.setBimsch(true);
        } else {
            this.fachdaten.setBimsch(false);
        }
        Integer abwgen = ((IntegerField)this.abwmengegenehmigtFeld).getIntValue();
        this.fachdaten.setAbwmengegenehmigt(abwgen);
        Integer abwprod = ((IntegerField)this.abwmengeprodspezFeld).getIntValue();
        this.fachdaten.setAbwmengeprodspez(abwprod);
        Integer abwges = ((IntegerField)this.abwmengegesamtFeld).getIntValue();
        this.fachdaten.setAbwmengegesamt(abwges);
        Date gen58 = this.gen58Datum.getDate();
        this.fachdaten.setGen58(gen58);
        Date gen59 = this.gen59Datum.getDate();
        this.fachdaten.setGen59(gen59);
        boolean success = Anh40Fachdaten.saveAnh40(this.fachdaten);
        if (success) {
            AUIKataster.debugOutput("Anh 40 Objekt " + this.fachdaten.getObjektid() + " gespeichert.", "Anh40Panel.saveAnh40Daten");
        } else {
            AUIKataster.debugOutput("Anh 40 Objekt " + this.fachdaten + " konnte nicht gespeichert werden!", "Anh40Panel.saveAnh40Daten");
        }
        return success;
    }

    public void completeObjekt() {
        if (this.hauptModul.isNew() || this.fachdaten == null) {
            this.fachdaten = new Anh40Fachdaten();
            this.fachdaten.setBasisObjekt(this.hauptModul.getObjekt());
            Anh40Fachdaten.saveAnh40(this.fachdaten);
            AUIKataster.debugOutput("Neues Anh 40 Objekt " + this.fachdaten + " gespeichert.", "BasisObjektBearbeiten.completeObjekt");
        }
    }

    private JButton getSaveAnh40Button() {
        if (this.saveAnh40Button == null) {
            this.saveAnh40Button = new JButton("Speichern");
            this.saveAnh40Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Anh40Panel.this.enableAll(false);
                    if (Anh40Panel.this.saveAnh40Daten()) {
                        Anh40Panel.this.hauptModul.getFrame().changeStatus("Anh 40 Objekt " + Anh40Panel.this.fachdaten.getObjektid() + " erfolgreich gespeichert.", HauptFrame.SUCCESS_COLOR);
                    } else {
                        Anh40Panel.this.hauptModul.getFrame().changeStatus("Fehler beim Speichern des Anh 40 Objekt!", HauptFrame.ERROR_COLOR);
                    }
                    Anh40Panel.this.hauptModul.fillForm();
                }
            });
        }
        return this.saveAnh40Button;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private JTextArea getAnh40BemerkungArea() {
        if (this.anh40BemerkungArea == null) {
            this.anh40BemerkungArea = new LimitedTextArea(150);
            this.anh40BemerkungArea.setLineWrap(true);
            this.anh40BemerkungArea.setWrapStyleWord(true);
        }
        return this.anh40BemerkungArea;
    }

    private JTextField getAnsprechpartnerFeld() {
        if (this.ansprechpartnerFeld == null) {
            this.ansprechpartnerFeld = new LimitedTextField(50);
        }
        return this.ansprechpartnerFeld;
    }

    private TextFieldDateChooser getGen58Datum() {
        if (this.gen58Datum == null) {
            this.gen58Datum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.gen58Datum;
    }

    private TextFieldDateChooser getGen59Datum() {
        if (this.gen59Datum == null) {
            this.gen59Datum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        }
        return this.gen59Datum;
    }

    private JTextField getHerkunftsbereichFeld() {
        if (this.herkunftsbereichFeld == null) {
            this.herkunftsbereichFeld = new IntegerField();
        }
        return this.herkunftsbereichFeld;
    }

    private JTextField getSachbearbeiterravFeld() {
        if (this.sachbearbeiterravFeld == null) {
            this.sachbearbeiterravFeld = new LimitedTextField(50);
        }
        return this.sachbearbeiterravFeld;
    }

    private JTextField getSachbearbeiterheepenFeld() {
        if (this.sachbearbeiterheepenFeld == null) {
            this.sachbearbeiterheepenFeld = new LimitedTextField(50);
        }
        return this.sachbearbeiterheepenFeld;
    }

    private JCheckBox getWsgCheck() {
        if (this.wsgCheck == null) {
            this.wsgCheck = new JCheckBox("Wasserschutzgebiet");
        }
        return this.wsgCheck;
    }

    private JCheckBox getGenehmigungspflichtCheck() {
        if (this.genehmigungspflichtCheck == null) {
            this.genehmigungspflichtCheck = new JCheckBox("Genehmigungspflicht");
        }
        return this.genehmigungspflichtCheck;
    }

    private JCheckBox getNachtragCheck() {
        if (this.nachtragCheck == null) {
            this.nachtragCheck = new JCheckBox("Nachtragsgenehmigung");
        }
        return this.nachtragCheck;
    }

    private JCheckBox getBimschCheck() {
        if (this.bimschCheck == null) {
            this.bimschCheck = new JCheckBox("BImSch-Genehmigung");
        }
        return this.bimschCheck;
    }

    private JFormattedTextField getAbwmengegenehmigtFeld() {
        if (this.abwmengegenehmigtFeld == null) {
            this.abwmengegenehmigtFeld = new IntegerField();
        }
        return this.abwmengegenehmigtFeld;
    }

    private JFormattedTextField getAbwmengeprodspezFeld() {
        if (this.abwmengeprodspezFeld == null) {
            this.abwmengeprodspezFeld = new IntegerField();
        }
        return this.abwmengeprodspezFeld;
    }

    private JFormattedTextField getAbwmengegesamtFeld() {
        if (this.abwmengegesamtFeld == null) {
            this.abwmengegesamtFeld = new IntegerField();
        }
        return this.abwmengegesamtFeld;
    }

    private JTextField getKlaeranlageFeld() {
        if (this.klaeranlageFeld == null) {
            this.klaeranlageFeld = new LimitedTextField(50);
        }
        return this.klaeranlageFeld;
    }

    private JTextField getPrioritaetFeld() {
        if (this.prioritaetFeld == null) {
            this.prioritaetFeld = new IntegerField();
        }
        return this.prioritaetFeld;
    }

    private JTable getObjektverknuepungTabelle() {
        if (this.objektVerknuepfungModel == null) {
            this.objektVerknuepfungModel = new ObjektVerknuepfungModel(this.hauptModul.getObjekt());
            if (this.objektverknuepfungTabelle == null) {
                this.objektverknuepfungTabelle = new JTable(this.objektVerknuepfungModel);
            } else {
                this.objektverknuepfungTabelle.setModel(this.objektVerknuepfungModel);
            }
            this.objektverknuepfungTabelle.getColumnModel().getColumn(0).setPreferredWidth(5);
            this.objektverknuepfungTabelle.getColumnModel().getColumn(1).setPreferredWidth(100);
            this.objektverknuepfungTabelle.getColumnModel().getColumn(2).setPreferredWidth(250);
            this.objektverknuepfungTabelle.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        Point origin = e.getPoint();
                        int row = Anh40Panel.this.getObjektverknuepungTabelle().rowAtPoint(origin);
                        if (row != -1) {
                            BasisObjektverknuepfung obj = Anh40Panel.this.objektVerknuepfungModel.getRow(row);
                            if (obj.getBasisObjektByIstVerknuepftMit().getObjektid().intValue() != Anh40Panel.this.hauptModul.getObjekt().getObjektid().intValue()) {
                                Anh40Panel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.edit_object", obj.getBasisObjektByIstVerknuepftMit().getObjektid(), false);
                            } else {
                                Anh40Panel.this.hauptModul.getManager().getSettingsManager().setSetting("auik.imc.edit_object", obj.getBasisObjektByObjekt().getObjektid(), false);
                            }
                            Anh40Panel.this.hauptModul.getManager().switchModul("m_objekt_bearbeiten");
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    Anh40Panel.this.showVerknuepfungPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    Anh40Panel.this.showVerknuepfungPopup(e);
                }
            });
            this.objektverknuepfungTabelle.getInputMap().put((KeyStroke)this.getVerknuepfungLoeschAction().getValue("AcceleratorKey"), this.getVerknuepfungLoeschAction().getValue("Name"));
            this.objektverknuepfungTabelle.getActionMap().put(this.getVerknuepfungLoeschAction().getValue("Name"), this.getVerknuepfungLoeschAction());
        }
        return this.objektverknuepfungTabelle;
    }

    private void showVerknuepfungPopup(MouseEvent e) {
        Point origin;
        int row;
        if (this.verknuepfungPopup == null) {
            this.verknuepfungPopup = new JPopupMenu("Objekt");
            JMenuItem loeschItem = new JMenuItem(this.getVerknuepfungLoeschAction());
            this.verknuepfungPopup.add(loeschItem);
        }
        if (e.isPopupTrigger() && (row = this.objektverknuepfungTabelle.rowAtPoint(origin = e.getPoint())) != -1) {
            this.objektverknuepfungTabelle.setRowSelectionInterval(row, row);
            this.verknuepfungPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private Action getVerknuepfungLoeschAction() {
        if (this.verknuepfungLoeschAction == null) {
            this.verknuepfungLoeschAction = new AbstractAction("L\u00f6schen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = Anh40Panel.this.getObjektverknuepungTabelle().getSelectedRow();
                    if (row != -1 && Anh40Panel.this.getObjektverknuepungTabelle().getEditingRow() == -1) {
                        BasisObjektverknuepfung verknuepfung = Anh40Panel.this.objektVerknuepfungModel.getRow(row);
                        int answer = JOptionPane.showConfirmDialog(Anh40Panel.this.hauptModul.getPanel(), "Soll die Verkn\u00fcpfung wirklich gel\u00f6scht werden?\nHinweis: Die Aktion betrifft nur die Verkn\u00fcpfung, die Objekte bleiben erhalten und k\u00f6nnen jederzeit neu verkn\u00fcpft werden.", "L\u00f6schen best\u00e4tigen", 0);
                        if (answer == 0) {
                            if (Anh40Panel.this.objektVerknuepfungModel.removeRow(row)) {
                                Anh40Panel.this.hauptModul.getFrame().changeStatus("Objekt gel\u00f6scht.", HauptFrame.SUCCESS_COLOR);
                                AUIKataster.debugOutput("Objekt " + verknuepfung.getId() + " wurde gel\u00f6scht!", "BasisBetreiberSuchen.removeAction");
                            } else {
                                Anh40Panel.this.hauptModul.getFrame().changeStatus("Konnte das Objekt nicht l\u00f6schen!", HauptFrame.ERROR_COLOR);
                            }
                        }
                    }
                }
            };
            this.verknuepfungLoeschAction.putValue("MnemonicKey", new Integer(76));
            this.verknuepfungLoeschAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0, false));
        }
        return this.verknuepfungLoeschAction;
    }

    private JButton getSelectObjektButton() {
        if (this.selectObjektButton == null) {
            this.selectObjektButton = new JButton("Objekt ausw\u00e4hlen");
            this.selectObjektButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ObjektChooser chooser = new ObjektChooser(Anh40Panel.this.hauptModul.getFrame(), Anh40Panel.this.fachdaten.getBasisObjekt(), Anh40Panel.this.objektVerknuepfungModel);
                    chooser.setVisible(true);
                }
            });
        }
        return this.selectObjektButton;
    }
}

