/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.common.tablemodels;

import de.bielefeld.umweltamt.aui.mappings.vaws.VawsFachdaten;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.ListTableModel;

public class VawsModel
extends ListTableModel {
    public VawsModel() {
        super(new String[]{"Anlagenart", "Herstellnr.", "Fl\u00fcssigkeit", "Menge", "Stillgelegt"}, false);
    }

    @Override
    public Object getColumnValue(Object objectAtRow, int columnIndex) {
        Object tmp;
        VawsFachdaten fd = (VawsFachdaten)objectAtRow;
        switch (columnIndex) {
            case 0: {
                tmp = fd.getAnlagenart();
                break;
            }
            case 1: {
                tmp = fd.getHerstellnr();
                break;
            }
            case 2: {
                tmp = fd.getFluessigkeit();
                break;
            }
            case 3: {
                if (fd.getMenge() != null) {
                    tmp = (double)Math.round(fd.getMenge() * 100.0) / 100.0;
                    break;
                }
                tmp = 0;
                break;
            }
            case 4: {
                tmp = fd.getStillegungsDatumString();
                break;
            }
            default: {
                tmp = "ERROR";
            }
        }
        if (fd.getStillegungsdatum() != null && tmp != null) {
            tmp = "<html><strike>" + tmp + "</strike></html>";
        }
        return tmp;
    }

    public VawsFachdaten getDatenSatz(int row) {
        return (VawsFachdaten)this.getObjectAtRow(row);
    }

    @Override
    public void updateList() {
    }
}

