/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.common.tablemodels;

import de.bielefeld.umweltamt.aui.mappings.atl.AtlKlaeranlagen;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbeart;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbenahmen;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbepkt;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.ListTableModel;

public class ProbenahmenModel
extends ListTableModel {
    private AtlProbepkt probepkt = null;
    private String secondColumn = null;

    public ProbenahmenModel(String secondColumn) {
        super(new String[]{"Kennnummer", secondColumn, "Datum", "Bemerkung"}, false, true);
        this.secondColumn = secondColumn;
    }

    public ProbenahmenModel() {
        super(new String[]{"Kennnummer", "Datum", "Bemerkung"}, false, true);
    }

    public void setProbepunkt(AtlProbepkt probepkt) {
        this.probepkt = probepkt;
    }

    @Override
    public void updateList() {
        if (this.probepkt != null) {
            this.setList(AtlProbenahmen.getProbenahmen(this.probepkt, false, -1));
            this.fireTableDataChanged();
        }
    }

    public void findByProperty(String suche, String property) {
        this.setList(AtlProbenahmen.findProbenahmen(suche, property));
    }

    public void findByKA(AtlProbeart art, AtlKlaeranlagen ka) {
        this.setList(AtlProbenahmen.getKSProbenahmen(art, ka));
    }

    @Override
    public Object getColumnValue(Object objectAtRow, int columnIndex) {
        Object value;
        AtlProbenahmen probe = (AtlProbenahmen)objectAtRow;
        if (this.secondColumn == null) {
            switch (columnIndex) {
                case 0: {
                    value = probe.getKennummer();
                    break;
                }
                case 1: {
                    value = AuikUtils.getStringFromDate(probe.getDatumDerEntnahme());
                    break;
                }
                case 2: {
                    value = probe.getBemerkung();
                    break;
                }
                default: {
                    value = null;
                    break;
                }
            }
        } else {
            switch (columnIndex) {
                case 0: {
                    value = probe.getKennummer();
                    break;
                }
                case 1: {
                    if (this.secondColumn.equals("Art")) {
                        value = probe.getAtlProbepkt().getAtlProbeart();
                        break;
                    }
                    if (this.secondColumn.equals("Pkt-ID")) {
                        value = probe.getAtlProbepkt().getObjektid();
                        break;
                    }
                    value = "";
                    break;
                }
                case 2: {
                    value = AuikUtils.getStringFromDate(probe.getDatumDerEntnahme());
                    break;
                }
                case 3: {
                    value = probe.getBemerkung();
                    break;
                }
                default: {
                    value = null;
                }
            }
        }
        return value;
    }

    @Override
    public boolean objectRemoved(Object objectAtRow) {
        AtlProbenahmen removedProbe = (AtlProbenahmen)objectAtRow;
        boolean removed = removedProbe.getKennummer() != null ? AtlProbenahmen.removeProbenahme(removedProbe) : true;
        return removed;
    }

    public AtlProbenahmen getRow(int rowIndex) {
        return (AtlProbenahmen)this.getObjectAtRow(rowIndex);
    }
}

