/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.common.tablemodels;

import de.bielefeld.umweltamt.aui.mappings.vaws.VawsFachdaten;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.ListTableModel;

public class HerstellNrSuchenModel
extends ListTableModel {
    public HerstellNrSuchenModel() {
        super(new String[]{"Herstellnr.", "Betreiber", "Standort", "Anlagenart", "Fl\u00fcssigkeit", "Menge", "Stillgelegt"}, false);
    }

    @Override
    public Object getColumnValue(Object objectAtRow, int columnIndex) {
        Object tmp;
        VawsFachdaten fachdaten = (VawsFachdaten)objectAtRow;
        switch (columnIndex) {
            case 0: {
                tmp = fachdaten.getHerstellnr();
                break;
            }
            case 1: {
                tmp = fachdaten.getBasisObjekt().getBasisBetreiber();
                break;
            }
            case 2: {
                tmp = fachdaten.getBasisObjekt().getBasisStandort();
                break;
            }
            case 3: {
                tmp = fachdaten.getAnlagenart();
                break;
            }
            case 4: {
                tmp = fachdaten.getFluessigkeit();
                break;
            }
            case 5: {
                if (fachdaten.getMenge() != null) {
                    tmp = (double)Math.round(fachdaten.getMenge() * 100.0) / 100.0;
                    break;
                }
                tmp = 0;
                break;
            }
            case 6: {
                tmp = fachdaten.getStillegungsDatumString();
                break;
            }
            default: {
                tmp = "ERROR";
            }
        }
        if (fachdaten.getStillegungsdatum() != null && tmp != null) {
            tmp = "<html><strike>" + tmp + "</strike></html>";
        }
        return tmp;
    }

    public VawsFachdaten getDatenSatz(int row) {
        return (VawsFachdaten)this.getObjectAtRow(row);
    }

    @Override
    public void updateList() {
    }
}

