/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.common.tablemodels;

import de.bielefeld.umweltamt.aui.mappings.indeinl.IndeinlGenehmigung;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.ListTableModel;

public class GenehmigungModel
extends ListTableModel {
    public GenehmigungModel() {
        super(new String[]{"Betreiber", "Standort", "Datum", "Anhang", "58er", "59er", "Bemerkungen"}, false);
    }

    @Override
    public Object getColumnValue(Object objectAtRow, int columnIndex) {
        Object tmp;
        IndeinlGenehmigung fd = (IndeinlGenehmigung)objectAtRow;
        switch (columnIndex) {
            case 0: {
                tmp = fd.getBasisObjekt().getBasisBetreiber();
                break;
            }
            case 1: {
                tmp = fd.getBasisObjekt().getBasisStandort();
                break;
            }
            case 2: {
                tmp = AuikUtils.getStringFromDate(fd.getErstellungsDatum());
                break;
            }
            case 3: {
                tmp = fd.getAnhang();
                break;
            }
            case 4: {
                if (fd.getGen58() != null) {
                    tmp = new Boolean(fd.getGen58());
                    break;
                }
                tmp = new Boolean(false);
                break;
            }
            case 5: {
                if (fd.getGen59() != null) {
                    tmp = new Boolean(fd.getGen59());
                    break;
                }
                tmp = new Boolean(false);
                break;
            }
            case 6: {
                tmp = fd.getBemerkungen();
                break;
            }
            default: {
                tmp = "ERROR";
            }
        }
        if (fd.getBasisObjekt().getInaktiv().booleanValue() && columnIndex != 4 && columnIndex != 5) {
            tmp = "<html><strike>" + tmp + "</strike></html>";
        }
        return tmp;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 4) {
            return Boolean.class;
        }
        if (columnIndex == 5) {
            return Boolean.class;
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public void updateList() {
    }
}

