/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.common.tablemodels;

import de.bielefeld.umweltamt.aui.mappings.basis.BasisStandort;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.ListTableModel;

public class BasisStandortModel
extends ListTableModel {
    private String lastStrasse = null;
    private int lastHausNr = -1;

    public BasisStandortModel() {
        super(new String[]{"Stra\u00dfe", "Hausnr.", "PLZ"}, true);
    }

    @Override
    public void updateList() {
        if (this.lastStrasse != null) {
            this.filterList(this.lastStrasse, this.lastHausNr);
        }
    }

    public BasisStandort getRow(int rowIndex) {
        return (BasisStandort)this.getObjectAtRow(rowIndex);
    }

    public void filterList(String strasse, int hausnr) {
        this.setList(BasisStandort.findStandorte(strasse, hausnr));
        this.lastStrasse = strasse;
        this.lastHausNr = hausnr;
    }

    @Override
    public Object getColumnValue(Object objectAtRow, int columnIndex) {
        Object value;
        BasisStandort bsta = (BasisStandort)objectAtRow;
        switch (columnIndex) {
            case 0: {
                value = bsta.getStrasse();
                break;
            }
            case 1: {
                if (bsta.getHausnrzus() != null) {
                    String tmp = bsta.getHausnr() + bsta.getHausnrzus();
                    value = tmp;
                    break;
                }
                value = bsta.getHausnr();
                break;
            }
            case 2: {
                value = bsta.getPlz();
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }
}

