/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.common.tablemodels;

import de.bielefeld.umweltamt.aui.mappings.basis.BasisBetreiber;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjekt;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjektarten;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisStandort;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.ListTableModel;

public class BasisObjektModel
extends ListTableModel {
    private String secondColumn;
    private String abteilung;

    public BasisObjektModel(String secondColumn, String abteilung) {
        super(new String[]{"Obj.ID", secondColumn, "Objektart", "Beschreibung"}, false, true);
        this.secondColumn = secondColumn;
        this.abteilung = abteilung;
    }

    @Override
    public void updateList() throws Exception {
    }

    @Override
    public Object getColumnValue(Object objectAtRow, int columnIndex) {
        Object tmp;
        BasisObjekt bo = (BasisObjekt)objectAtRow;
        switch (columnIndex) {
            case 0: {
                tmp = bo.getObjektid();
                break;
            }
            case 1: {
                if ("Standort".equals(this.secondColumn)) {
                    tmp = bo.getBasisStandort();
                    break;
                }
                if ("Betreiber".equals(this.secondColumn)) {
                    tmp = bo.getBasisBetreiber();
                    break;
                }
                tmp = this.secondColumn;
                break;
            }
            case 2: {
                BasisObjektarten boa = bo.getBasisObjektarten();
                tmp = boa;
                break;
            }
            case 3: {
                tmp = bo.getBeschreibung();
                break;
            }
            default: {
                tmp = null;
            }
        }
        if (tmp != bo.getBeschreibung() && bo.getInaktiv().booleanValue()) {
            tmp = "<html><strike>" + tmp + "</strike></html>";
        }
        return tmp;
    }

    @Override
    public boolean objectRemoved(Object objectAtRow) {
        BasisObjekt removedObjekt = (BasisObjekt)objectAtRow;
        boolean removed = removedObjekt.getObjektid() != null ? BasisObjekt.removeBasisObjekt(removedObjekt) : true;
        return removed;
    }

    public BasisObjekt getRow(int rowIndex) {
        return (BasisObjekt)this.getObjectAtRow(rowIndex);
    }

    public void searchByBetreiber(BasisBetreiber betr) {
        this.setList(BasisObjekt.getObjekteByBetreiber(betr, this.abteilung));
    }

    public void searchByStandort(BasisStandort standort) {
        this.setList(BasisObjekt.getObjekteByStandort(standort, this.abteilung, null));
    }

    public void searchByStandort(BasisStandort standort, String abteilung) {
        this.setList(BasisObjekt.getObjekteByStandort(standort, abteilung, null));
    }

    public void searchByStandort(BasisStandort standort, String abteilung, Integer nichtartid) {
        this.setList(BasisObjekt.getObjekteByStandort(standort, abteilung, nichtartid));
    }

    public void searchByStandort(BasisStandort standort, Integer istartid) {
        this.setList(BasisObjekt.getObjekteByStandort(standort, istartid));
    }
}

