/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.common.tablemodels;

import de.bielefeld.umweltamt.aui.mappings.basis.BasisBetreiber;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.ListTableModel;

public class BasisBetreiberModel
extends ListTableModel {
    private String lastSuchWort = null;
    private String lastProperty = null;
    private boolean zeigeAdresse;

    public BasisBetreiberModel() {
        this(true);
    }

    public BasisBetreiberModel(boolean zeigeAdresse) {
        super(new String[]{"Name", "Anrede", "Zusatz"}, false, true);
        this.zeigeAdresse = zeigeAdresse;
        if (zeigeAdresse) {
            this.columns = new String[]{"Name", "Anrede", "Zusatz", "Stra\u00dfe", "Nr."};
        }
    }

    @Override
    public void updateList() {
        if (this.lastSuchWort != null) {
            this.filterList(this.lastSuchWort, this.lastProperty);
        }
    }

    @Override
    public Object getColumnValue(Object objectAtRow, int columnIndex) {
        Object value;
        BasisBetreiber betr = (BasisBetreiber)objectAtRow;
        switch (columnIndex) {
            case 0: {
                value = betr.getBetrname();
                break;
            }
            case 1: {
                value = betr.getBetranrede();
                break;
            }
            case 2: {
                value = betr.getBetrnamezus();
                break;
            }
            case 3: {
                value = betr.getStrasse();
                break;
            }
            case 4: {
                if (betr.getHausnrzus() != null) {
                    String tmp = betr.getHausnr() + betr.getHausnrzus();
                    value = tmp;
                    break;
                }
                value = betr.getHausnr();
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    public BasisBetreiber getRow(int rowIndex) {
        return (BasisBetreiber)super.getObjectAtRow(rowIndex);
    }

    @Override
    public boolean objectRemoved(Object objectAtRow) {
        BasisBetreiber removedBetreiber = (BasisBetreiber)objectAtRow;
        return BasisBetreiber.removeBetreiber(removedBetreiber);
    }

    public void filterList(String suche, String property) {
        this.setList(BasisBetreiber.findBetreiber(suche, property));
        this.lastSuchWort = suche;
        this.lastProperty = property;
    }
}

