/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.common.tablemodels;

import de.bielefeld.umweltamt.aui.mappings.indeinl.ViewBwk;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.ListTableModel;

public class AnhBwkModel
extends ListTableModel {
    public AnhBwkModel() {
        super(new String[]{"Betreiber", "Standort", "Hersteller", "Brennmittel", "Leistung", "Erfassung", "Anschreiben", "Genehmigung", "Beschreibung"}, false);
    }

    @Override
    public Object getColumnValue(Object objectAtRow, int columnIndex) {
        Object tmp;
        ViewBwk fd = (ViewBwk)objectAtRow;
        String anrede = fd.getBetranrede() != null ? fd.getBetranrede() + " " : "";
        String hausnr = fd.getHausnr() != null ? fd.getHausnr().toString() : "";
        String hausnrzus = fd.getHausnrzus() != null ? fd.getHausnrzus() : "";
        switch (columnIndex) {
            case 0: {
                tmp = anrede + fd.getBetrname();
                break;
            }
            case 1: {
                tmp = fd.getStrasse() + " " + hausnr + hausnrzus;
                break;
            }
            case 2: {
                tmp = fd.getKHersteller();
                break;
            }
            case 3: {
                tmp = fd.getKBrennmittel();
                break;
            }
            case 4: {
                tmp = fd.getKLeistung();
                break;
            }
            case 5: {
                tmp = fd.getErfassung();
                break;
            }
            case 6: {
                tmp = AuikUtils.getStringFromDate(fd.getAnschreiben());
                break;
            }
            case 7: {
                tmp = AuikUtils.getStringFromDate(fd.getDatumG());
                break;
            }
            case 8: {
                tmp = fd.getBasisObjekt().getBeschreibung();
                break;
            }
            default: {
                tmp = "ERROR";
            }
        }
        if (fd.getBasisObjekt().getInaktiv().booleanValue()) {
            tmp = "<html><strike>" + tmp + "</strike></html>";
        }
        return tmp;
    }

    @Override
    public void updateList() {
    }
}

