/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.common.tablemodels;

import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh50Fachdaten;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.ListTableModel;

public class Anh50Model
extends ListTableModel {
    public Anh50Model() {
        super(new String[]{"Betreiber", "Standort", "Wiedervorl.", "Bemerkungen"}, false);
    }

    @Override
    public Object getColumnValue(Object objectAtRow, int columnIndex) {
        Object tmp;
        Anh50Fachdaten fd = (Anh50Fachdaten)objectAtRow;
        switch (columnIndex) {
            case 0: {
                tmp = fd.getBasisObjekt().getBasisBetreiber();
                break;
            }
            case 1: {
                tmp = fd.getBasisObjekt().getBasisStandort();
                break;
            }
            case 2: {
                tmp = AuikUtils.getStringFromDate(fd.getWiedervorlage());
                break;
            }
            case 3: {
                tmp = fd.getBemerkungen();
                break;
            }
            default: {
                tmp = "ERROR";
            }
        }
        if (fd.getBasisObjekt().getInaktiv().booleanValue()) {
            tmp = "<html><strike>" + tmp + "</strike></html>";
        }
        return tmp;
    }

    @Override
    public void updateList() {
    }
}

