/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.common.tablemodels;

import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh49Fachdaten;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.ListTableModel;

public class Anh49Model
extends ListTableModel {
    public Anh49Model() {
        super(new String[]{"Betreiber", "Standort", "Wiedervorl.", "Sonstiges Technik", "SachbearbeiterIn"}, false);
    }

    @Override
    public Object getColumnValue(Object objectAtRow, int columnIndex) {
        Object tmp;
        Anh49Fachdaten fd = (Anh49Fachdaten)objectAtRow;
        switch (columnIndex) {
            case 0: {
                tmp = fd.getBasisObjekt().getBasisBetreiber();
                break;
            }
            case 1: {
                tmp = fd.getBasisObjekt().getBasisStandort();
                break;
            }
            case 2: {
                tmp = AuikUtils.getStringFromDate(fd.getWiedervorlage());
                break;
            }
            case 3: {
                tmp = fd.getSonstigestechnik();
                break;
            }
            case 4: {
                tmp = fd.getSachbearbeiterIn();
                break;
            }
            default: {
                tmp = "ERROR";
            }
        }
        if (fd.getBasisObjekt().getInaktiv().booleanValue()) {
            tmp = "<html><strike>" + tmp + "</strike></html>";
        }
        return tmp;
    }

    @Override
    public void updateList() {
    }
}

