/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.common.editors;

import de.bielefeld.umweltamt.aui.mappings.vaws.VawsFachdaten;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsVerwaltungsverf;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.EditableListTableModel;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

class VerwVerfahrenModel
extends EditableListTableModel {
    private List geloeschte = new ArrayList();
    private VawsFachdaten fachdaten;

    public VerwVerfahrenModel() {
        super(new String[]{"Datum", "Ma\u00dfnahmen der Verwaltung", "Wiedervorlage", "abgeschl."}, false, true);
    }

    public void setFachdaten(VawsFachdaten fachdaten) {
        this.fachdaten = fachdaten;
        if (fachdaten != null) {
            this.setList(VawsVerwaltungsverf.getVerwaltungsverf(fachdaten));
            this.fireTableDataChanged();
        }
    }

    @Override
    public void editObject(Object objectAtRow, int columnIndex, Object newValue) {
        VawsVerwaltungsverf verf = (VawsVerwaltungsverf)objectAtRow;
        String tmp = "";
        if (newValue instanceof String) {
            tmp = (String)newValue;
        }
        DateFormat format = DateFormat.getDateInstance(3);
        switch (columnIndex) {
            case 0: {
                try {
                    Date tmpDate = format.parse(tmp);
                    verf.setDatum(tmpDate);
                }
                catch (ParseException e) {}
                break;
            }
            case 1: {
                verf.setMassnahme(tmp);
                break;
            }
            case 2: {
                if ("".equals(tmp)) {
                    verf.setWiedervorlage(null);
                    break;
                }
                try {
                    Date tmpDate = format.parse(tmp);
                    verf.setWiedervorlage(tmpDate);
                }
                catch (ParseException e) {}
                break;
            }
            case 3: {
                Boolean tmpB = (Boolean)newValue;
                verf.setWvverwverf((boolean)tmpB);
                break;
            }
        }
    }

    @Override
    public Object newObject() {
        VawsVerwaltungsverf verf = new VawsVerwaltungsverf();
        verf.setVawsFachdaten(this.fachdaten);
        verf.setWvverwverf(false);
        verf.setDatum(new Date());
        return verf;
    }

    @Override
    public boolean objectRemoved(Object objectAtRow) {
        VawsVerwaltungsverf verf = (VawsVerwaltungsverf)objectAtRow;
        if (verf.getId() != null) {
            this.geloeschte.add(verf);
        }
        return true;
    }

    public List getGeloeschte() {
        return this.geloeschte;
    }

    @Override
    public Object getColumnValue(Object objectAtRow, int columnIndex) {
        Object tmp;
        VawsVerwaltungsverf verf = (VawsVerwaltungsverf)objectAtRow;
        switch (columnIndex) {
            case 0: {
                tmp = AuikUtils.getStringFromDate(verf.getDatum());
                break;
            }
            case 1: {
                tmp = verf.getMassnahme();
                break;
            }
            case 2: {
                tmp = AuikUtils.getStringFromDate(verf.getWiedervorlage());
                break;
            }
            case 3: {
                tmp = new Boolean(verf.getWvverwverf());
                break;
            }
            default: {
                tmp = "ERROR";
            }
        }
        return tmp;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 3) {
            return Boolean.class;
        }
        return String.class;
    }

    public VawsVerwaltungsverf getDatenSatz(int row) {
        return (VawsVerwaltungsverf)this.getObjectAtRow(row);
    }

    @Override
    public void updateList() {
    }
}

