/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.common.editors;

import de.bielefeld.umweltamt.aui.mappings.vaws.VawsFachdaten;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsGebuehrenarten;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsVerwaltungsgebuehren;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.KommaDouble;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.EditableListTableModel;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

class VerwGebuehrenModel
extends EditableListTableModel {
    private List geloeschte = new ArrayList();
    private VawsFachdaten fachdaten;

    public VerwGebuehrenModel() {
        super(new String[]{"Datum", "Geb\u00fchrenart", "Betrag", "Abschnitt", "Kassenzeichen"}, false, true);
    }

    public void setFachdaten(VawsFachdaten fachdaten) {
        this.fachdaten = fachdaten;
        if (fachdaten != null) {
            this.setList(VawsVerwaltungsgebuehren.getVerwaltungsgebuehren(fachdaten));
            this.fireTableDataChanged();
        }
    }

    @Override
    public void editObject(Object objectAtRow, int columnIndex, Object newValue) {
        VawsVerwaltungsgebuehren gebuehr = (VawsVerwaltungsgebuehren)objectAtRow;
        String tmp = "";
        if (newValue instanceof String) {
            tmp = (String)newValue;
        }
        DateFormat format = DateFormat.getDateInstance(3);
        switch (columnIndex) {
            case 0: {
                try {
                    Date tmpDate = format.parse(tmp);
                    gebuehr.setDatum(tmpDate);
                }
                catch (ParseException e) {}
                break;
            }
            case 1: {
                gebuehr.setVawsGebuehrenart((VawsGebuehrenarten)newValue);
                break;
            }
            case 2: {
                Float tmpWert = null;
                if (newValue instanceof Float) {
                    tmpWert = (Float)newValue;
                } else if (newValue instanceof KommaDouble) {
                    tmpWert = new Float(((KommaDouble)newValue).getValue());
                }
                gebuehr.setBetrag(tmpWert);
                break;
            }
            case 3: {
                gebuehr.setAbschnitt(tmp);
                break;
            }
            case 4: {
                gebuehr.setKassenzeichen(tmp);
                break;
            }
        }
    }

    @Override
    public Object newObject() {
        VawsVerwaltungsgebuehren gebuehr = new VawsVerwaltungsgebuehren();
        gebuehr.setVawsFachdaten(this.fachdaten);
        gebuehr.setDatum(new Date());
        return gebuehr;
    }

    @Override
    public boolean objectRemoved(Object objectAtRow) {
        VawsVerwaltungsgebuehren gebuehr = (VawsVerwaltungsgebuehren)objectAtRow;
        if (gebuehr.getId() != null) {
            this.geloeschte.add(gebuehr);
        }
        return true;
    }

    public List getGeloeschte() {
        return this.geloeschte;
    }

    @Override
    public Object getColumnValue(Object objectAtRow, int columnIndex) {
        Object tmp;
        VawsVerwaltungsgebuehren gebuehr = (VawsVerwaltungsgebuehren)objectAtRow;
        switch (columnIndex) {
            case 0: {
                tmp = AuikUtils.getStringFromDate(gebuehr.getDatum());
                break;
            }
            case 1: {
                tmp = gebuehr.getVawsGebuehrenart();
                break;
            }
            case 2: {
                tmp = new KommaDouble(gebuehr.getBetrag().doubleValue());
                break;
            }
            case 3: {
                tmp = gebuehr.getAbschnitt();
                break;
            }
            case 4: {
                tmp = gebuehr.getKassenzeichen();
                break;
            }
            default: {
                tmp = "ERROR";
            }
        }
        return tmp;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 1) {
            return VawsGebuehrenarten.class;
        }
        if (columnIndex == 2) {
            return KommaDouble.class;
        }
        return String.class;
    }

    public VawsVerwaltungsgebuehren getDatenSatz(int row) {
        return (VawsVerwaltungsgebuehren)this.getObjectAtRow(row);
    }

    @Override
    public void updateList() {
    }
}

