/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.common.editors;

import de.bielefeld.umweltamt.aui.mappings.vaws.VawsFachdaten;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsKontrollen;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.EditableListTableModel;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

class VawsKontrollenModel
extends EditableListTableModel {
    private List geloeschte = new ArrayList();
    private VawsFachdaten fachdaten;

    public VawsKontrollenModel() {
        super(new String[]{"Pr\u00fcfdatum", "Pr\u00fcfer", "Pr\u00fcfergebnis", "N\u00e4chste Pr\u00fcfung", "Prfg. abgeschl."}, false, true);
    }

    public void setFachdaten(VawsFachdaten fachdaten) {
        this.fachdaten = fachdaten;
        if (fachdaten != null) {
            this.setList(VawsKontrollen.getKontrollen(fachdaten));
            this.fireTableDataChanged();
        }
    }

    @Override
    public void editObject(Object objectAtRow, int columnIndex, Object newValue) {
        VawsKontrollen ktrl = (VawsKontrollen)objectAtRow;
        String tmp = "";
        if (newValue instanceof String) {
            tmp = (String)newValue;
        }
        DateFormat format = DateFormat.getDateInstance(3);
        switch (columnIndex) {
            case 0: {
                try {
                    Date tmpDate = format.parse(tmp);
                    ktrl.setPruefdatum(tmpDate);
                }
                catch (ParseException e) {}
                break;
            }
            case 1: {
                ktrl.setPruefer(tmp);
                break;
            }
            case 2: {
                ktrl.setPruefergebnis(tmp);
                break;
            }
            case 3: {
                if ("".equals(tmp)) {
                    ktrl.setNaechstepruefung(null);
                    break;
                }
                try {
                    Date tmpDate = format.parse(tmp);
                    ktrl.setNaechstepruefung(tmpDate);
                }
                catch (ParseException e) {}
                break;
            }
            case 4: {
                Boolean tmpB = (Boolean)newValue;
                ktrl.setPruefungabgeschlossen((boolean)tmpB);
                break;
            }
        }
    }

    @Override
    public Object newObject() {
        VawsKontrollen ktr = new VawsKontrollen();
        ktr.setVawsFachdaten(this.fachdaten);
        ktr.setPruefdatum(new Date());
        ktr.setPruefungabgeschlossen(false);
        return ktr;
    }

    @Override
    public boolean objectRemoved(Object objectAtRow) {
        VawsKontrollen ktr = (VawsKontrollen)objectAtRow;
        if (ktr.getId() != null) {
            this.geloeschte.add(ktr);
        }
        return true;
    }

    public List getGeloeschte() {
        return this.geloeschte;
    }

    @Override
    public Object getColumnValue(Object objectAtRow, int columnIndex) {
        Object tmp;
        VawsKontrollen ac = (VawsKontrollen)objectAtRow;
        switch (columnIndex) {
            case 0: {
                tmp = AuikUtils.getStringFromDate(ac.getPruefdatum());
                break;
            }
            case 1: {
                tmp = ac.getPruefer();
                break;
            }
            case 2: {
                tmp = ac.getPruefergebnis();
                break;
            }
            case 3: {
                tmp = AuikUtils.getStringFromDate(ac.getNaechstepruefung());
                break;
            }
            case 4: {
                tmp = ac.getPruefungabgeschlossen();
                break;
            }
            default: {
                tmp = "ERROR";
            }
        }
        return tmp;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 4) {
            return Boolean.class;
        }
        return String.class;
    }

    public VawsKontrollen getDatenSatz(int row) {
        return (VawsKontrollen)this.getObjectAtRow(row);
    }

    @Override
    public void updateList() {
    }
}

