/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.common.editors;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsAbfuellflaeche;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsAbscheider;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsAnlagenchrono;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsBehaelterart;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsFachdaten;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsFluessigkeit;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsGebuehrenarten;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsGefaehrdungsstufen;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsKontrollen;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsMaterial;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsPruefer;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsPruefergebnisse;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsVbfeinstufung;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsVerwaltungsgebuehren;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsVerwaltungsverf;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsVerwmassnahmen;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsWgk;
import de.bielefeld.umweltamt.aui.module.common.editors.AbstractBaseEditor;
import de.bielefeld.umweltamt.aui.module.common.editors.VawsAnlagenChronoModel;
import de.bielefeld.umweltamt.aui.module.common.editors.VawsKontrollenModel;
import de.bielefeld.umweltamt.aui.module.common.editors.VerwGebuehrenModel;
import de.bielefeld.umweltamt.aui.module.common.editors.VerwVerfahrenModel;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.DoubleField;
import de.bielefeld.umweltamt.aui.utils.IntegerField;
import de.bielefeld.umweltamt.aui.utils.LimitedTextArea;
import de.bielefeld.umweltamt.aui.utils.LimitedTextField;
import de.bielefeld.umweltamt.aui.utils.TextFieldDateChooser;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.EditableListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class VawsEditor
extends AbstractBaseEditor {
    private VawsAbfuellflaeche abfuellflaeche;
    private VawsAbscheider abscheider;
    private JPanel topPanel;
    private JTabbedPane tabbedPane;
    private Action tabellenItemLoeschAction;
    private JPopupMenu tabellenPopup;
    private JLabel header;
    private LimitedTextField hnrFeld;
    private JComboBox fluessigkeitBox;
    private JComboBox vbfBox;
    private JComboBox gefStufeBox;
    private JComboBox wgkBox;
    private IntegerField baujahrFeld;
    private TextFieldDateChooser inbetriebnahmeChooser;
    private TextFieldDateChooser genehmigungChooser;
    private TextFieldDateChooser erfassungChooser;
    private TextFieldDateChooser stillegungChooser;
    private DoubleField pruefTurnusFeld;
    private LimitedTextArea bemerkungArea;
    private JTable anlagenChronoTabelle;
    private VawsAnlagenChronoModel anlagenChronoModel;
    private JComboBox behaelterArtBox;
    private JComboBox materialBox;
    private JPanel datenVAWSAbscheiderTab;
    private JPanel ausfuehrungVAWSAbscheiderTab;
    private JPanel schutzvorkehrungenVAWSAbscheiderTab;
    private JCheckBox kompSFCheck;
    private JCheckBox kompLFCheck;
    private JCheckBox kompKCheck;
    private JCheckBox kompPSCheck;
    private JCheckBox kompaktCheck;
    private LimitedTextField schlammHerstField;
    private LimitedTextField schlammTypField;
    private DoubleField schlammSFVField;
    private LimitedTextField schlammMatField;
    private LimitedTextField schlammBeschField;
    private LimitedTextField abscheiderHerstField;
    private LimitedTextField abscheiderTypField;
    private LimitedTextField abscheiderPruefField;
    private DoubleField abscheiderNSField;
    private LimitedTextField abscheiderMatField;
    private LimitedTextField abscheiderBeschField;
    private DoubleField abscheideroelField;
    private DoubleField zulDNField;
    private LimitedTextField zulMatField;
    private DoubleField zulLField;
    private DoubleField verbDNField;
    private LimitedTextField verbMatField;
    private DoubleField verbLField;
    private DoubleField sonsDNField;
    private LimitedTextField sonsMatField;
    private DoubleField sonsLField;
    private JCheckBox ueberCheck;
    private JCheckBox waschCheck;
    private JCheckBox abgabeCheck;
    private JCheckBox hochCheck;
    private JCheckBox belueftCheck;
    private JCheckBox rueckCheck;
    private LimitedTextArea bemerkArea;
    private JPanel datenLageranlagenTab;
    private DoubleField mengeFeld;
    private JPanel schutzLageranlagenTab;
    private JCheckBox doppelWandigCheck;
    private JCheckBox leckAnzeigeCheck;
    private JCheckBox auffangRaumCheck;
    private JCheckBox leckSchutzAuskleidungCheck;
    private JCheckBox grenzWertGeberCheck;
    private JCheckBox kellerLagerungCheck;
    private JCheckBox innenBeschichtungCheck;
    private LimitedTextArea beschreibungAFeld;
    private LimitedTextArea beschreibungSFeld;
    private JPanel leitungenLageranlagenTab;
    private JCheckBox oberIrdischCheck;
    private JCheckBox unterIrdischCheck;
    private JCheckBox saugLeitungCheck;
    private JCheckBox rohrKathSchCheck;
    private JCheckBox ausKupferCheck;
    private JCheckBox ausStahlCheck;
    private JCheckBox schutzrohrCheck;
    private LimitedTextArea beschreibungRFeld;
    private JPanel datenRohrleitungenTab;
    private JComboBox ausfuehrungBox;
    private JPanel datenAbfuellflaechenTab;
    private JCheckBox eohCheck;
    private JCheckBox efCheck;
    private JCheckBox svbCheck;
    private ButtonGroup zustandGroup;
    private JRadioButton saniertCheck;
    private JRadioButton neuErstelltCheck;
    private JRadioButton unbktCheck;
    private JPanel ausfuehrungAbfuellflaechenTab;
    private JComboBox bodenflaechenAusfBox;
    private DoubleField dickeFeld;
    private LimitedTextField gueteFeld;
    private LimitedTextField fugenMaterialFeld;
    private JComboBox niederschlagSchutzBox;
    private JCheckBox abscheiderVorhandenCheck;
    private LimitedTextArea beschrBodenflaecheArea;
    private LimitedTextArea beschrFugenmaterialArea;
    private LimitedTextArea beschrAblNiederschlArea;
    private JPanel svPruefungTab;
    private JTable svPruefungTabelle;
    private JComboBox prueferBox;
    private JComboBox pruefergebnisBox;
    private VawsKontrollenModel svPruefungModel;
    private JPanel verwVerfahrenTab;
    private JTable verwVerfahrenTabelle;
    private JComboBox massnahmenBox;
    private VerwVerfahrenModel verwVerfahrenModel;
    private JPanel verwGebuehrenTab;
    private JTable verwGebuehrenTabelle;
    private JComboBox gebArtenBox;
    private VerwGebuehrenModel verwGebuehrenModel;

    public VawsEditor(VawsFachdaten fachdaten, HauptFrame owner) {
        super("VAwS-Einzelanlage " + (fachdaten.getBehaelterId() == null ? "(Neu)" : fachdaten.getBehaelterId().toString()), fachdaten, owner);
    }

    public VawsEditor(VawsFachdaten fachdaten, HauptFrame owner, String tab) {
        this(fachdaten, owner);
        if ("Sachverst\u00e4ndigenpr\u00fcfung".equals(tab)) {
            this.tabbedPane.setSelectedComponent(this.getSvPruefungTab());
        } else if ("Verwaltungsverfahren".equals(tab)) {
            this.tabbedPane.setSelectedComponent(this.getVerwVerfahrenTab());
        } else if ("Herstellnummer".equals(tab)) {
            // empty if block
        }
    }

    @Override
    protected String getEditedClassName() {
        String className = super.getEditedClassName();
        className = this.getFachdaten().isLageranlage() ? className + "-Lageranlage" : className + "-" + this.getFachdaten().getAnlagenart();
        return className;
    }

    public VawsFachdaten getFachdaten() {
        return (VawsFachdaten)this.getEditedObject();
    }

    public VawsAbscheider getAbscheider() {
        if (this.abscheider == null) {
            this.abscheider = VawsAbscheider.getAbscheider(this.getFachdaten());
        }
        return this.abscheider;
    }

    private VawsAbfuellflaeche getAbfuellflaeche() {
        if (this.abfuellflaeche == null) {
            this.abfuellflaeche = VawsAbfuellflaeche.getAbfuellflaeche(this.getFachdaten());
        }
        return this.abfuellflaeche;
    }

    @Override
    protected JComponent buildContentArea() {
        this.header = new JLabel(" ", 2);
        this.header.setFont(new Font("SansSerif", 1, 18));
        this.hnrFeld = new LimitedTextField(25);
        this.fluessigkeitBox = new JComboBox<String>(VawsFluessigkeit.getFluessigkeiten());
        this.fluessigkeitBox.setEditable(true);
        this.vbfBox = new JComboBox<String>(VawsVbfeinstufung.getVbfeinstufungen());
        this.vbfBox.setEditable(false);
        this.gefStufeBox = new JComboBox<String>(VawsGefaehrdungsstufen.getVbfeinstufungen());
        this.gefStufeBox.setEditable(false);
        this.wgkBox = new JComboBox<Integer>(VawsWgk.getWgk());
        this.wgkBox.setEditable(false);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabLayoutPolicy(1);
        this.baujahrFeld = new IntegerField();
        this.inbetriebnahmeChooser = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        this.genehmigungChooser = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        this.erfassungChooser = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        this.stillegungChooser = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        this.pruefTurnusFeld = new DoubleField(0);
        this.behaelterArtBox = new JComboBox<String>(VawsBehaelterart.getBehaelterarten());
        this.behaelterArtBox.setEditable(false);
        this.materialBox = new JComboBox<String>(VawsMaterial.getMaterialien());
        this.materialBox.setEditable(true);
        this.bemerkungArea = new LimitedTextArea(255);
        this.anlagenChronoModel = new VawsAnlagenChronoModel();
        this.anlagenChronoTabelle = new JTable(this.anlagenChronoModel);
        this.anlagenChronoTabelle.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.anlagenChronoTabelle.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.anlagenChronoTabelle.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.anlagenChronoTabelle.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                VawsEditor.this.showTabellenPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                VawsEditor.this.showTabellenPopup(e);
            }
        });
        this.anlagenChronoTabelle.getInputMap().put((KeyStroke)this.getTabellenItemLoeschAction().getValue("AcceleratorKey"), this.getTabellenItemLoeschAction().getValue("Name"));
        this.anlagenChronoTabelle.getActionMap().put(this.getTabellenItemLoeschAction().getValue("Name"), this.getTabellenItemLoeschAction());
        this.mengeFeld = new DoubleField(0);
        this.ausfuehrungBox = new JComboBox<String>(VawsFachdaten.getAusfuehrungen());
        this.ausfuehrungBox.setEditable(false);
        this.eohCheck = new JCheckBox("Einfach o. Herk\u00f6mmlich");
        this.efCheck = new JCheckBox("Eignungsfeststellung");
        this.svbCheck = new JCheckBox("Sachverst\u00e4ndigenbescheinigung");
        this.svbCheck.setEnabled(false);
        this.zustandGroup = new ButtonGroup();
        this.saniertCheck = new JRadioButton("Saniert");
        this.neuErstelltCheck = new JRadioButton("Neu Erstellt");
        this.unbktCheck = new JRadioButton("Unbekannt");
        this.zustandGroup.add(this.saniertCheck);
        this.zustandGroup.add(this.neuErstelltCheck);
        this.zustandGroup.add(this.unbktCheck);
        this.doppelWandigCheck = new JCheckBox("Doppelwandig");
        this.leckAnzeigeCheck = new JCheckBox("Leckanzeige");
        this.auffangRaumCheck = new JCheckBox("Auffangraum");
        this.leckSchutzAuskleidungCheck = new JCheckBox("Leckschutzauskleidung");
        this.grenzWertGeberCheck = new JCheckBox("Grenzwertgeber");
        this.kellerLagerungCheck = new JCheckBox("Kellerlagerung");
        this.innenBeschichtungCheck = new JCheckBox("Innenbeschichtung");
        this.beschreibungAFeld = new LimitedTextArea(255);
        this.beschreibungSFeld = new LimitedTextArea(255);
        this.oberIrdischCheck = new JCheckBox("Oberirdisch");
        this.unterIrdischCheck = new JCheckBox("Unterirdisch");
        this.saugLeitungCheck = new JCheckBox("Als Saugleitung");
        this.rohrKathSchCheck = new JCheckBox("Rohr-Kathodenschutz");
        this.ausKupferCheck = new JCheckBox("Aus Kupfer");
        this.ausStahlCheck = new JCheckBox("Aus Stahl");
        this.schutzrohrCheck = new JCheckBox("Mit Schutzrohr");
        this.beschreibungRFeld = new LimitedTextArea(255);
        this.bodenflaechenAusfBox = new JComboBox<String>(VawsAbfuellflaeche.getBodenflaechenausfArray());
        this.bodenflaechenAusfBox.setEditable(false);
        this.dickeFeld = new DoubleField(0);
        this.gueteFeld = new LimitedTextField(50);
        this.fugenMaterialFeld = new LimitedTextField(50);
        this.niederschlagSchutzBox = new JComboBox<String>(VawsAbfuellflaeche.getNiederschlagschutzArray());
        this.niederschlagSchutzBox.setEditable(false);
        this.abscheiderVorhandenCheck = new JCheckBox("Abscheider vorhanden?");
        this.beschrBodenflaecheArea = new LimitedTextArea(255);
        this.beschrFugenmaterialArea = new LimitedTextArea(255);
        this.beschrAblNiederschlArea = new LimitedTextArea(255);
        this.kompKCheck = new JCheckBox("K (Kl.I)");
        this.kompLFCheck = new JCheckBox("LF (Kl.II)");
        this.kompPSCheck = new JCheckBox("PS");
        this.kompSFCheck = new JCheckBox("SF");
        this.kompaktCheck = new JCheckBox("Kompaktanlage?");
        this.ueberCheck = new JCheckBox("\u00dcberh\u00f6hung ausreichend?");
        this.waschCheck = new JCheckBox("Warnanlage vorhanden?");
        this.abgabeCheck = new JCheckBox("Abgabeeinrichtung?");
        this.hochCheck = new JCheckBox("Hochleistungszapfanlage?");
        this.belueftCheck = new JCheckBox("Bef\u00fcllung von Lagerbeh\u00e4ltern?");
        this.rueckCheck = new JCheckBox("R\u00fcckhalteverm\u00f6gen ausreichend?");
        this.bemerkArea = new LimitedTextArea(255);
        this.schlammBeschField = new LimitedTextField(25);
        this.schlammHerstField = new LimitedTextField(25);
        this.schlammMatField = new LimitedTextField(25);
        this.schlammSFVField = new DoubleField(0);
        this.schlammTypField = new LimitedTextField(25);
        this.abscheiderBeschField = new LimitedTextField(25);
        this.abscheiderHerstField = new LimitedTextField(25);
        this.abscheiderMatField = new LimitedTextField(25);
        this.abscheiderNSField = new DoubleField(0);
        this.abscheiderPruefField = new LimitedTextField(25);
        this.abscheiderTypField = new LimitedTextField(25);
        this.abscheideroelField = new DoubleField(0);
        this.zulDNField = new DoubleField(0);
        this.zulLField = new DoubleField(0);
        this.zulMatField = new LimitedTextField(25);
        this.verbDNField = new DoubleField(0);
        this.verbLField = new DoubleField(0);
        this.verbMatField = new LimitedTextField(25);
        this.sonsDNField = new DoubleField(0);
        this.sonsLField = new DoubleField(0);
        this.sonsMatField = new LimitedTextField(25);
        this.svPruefungModel = new VawsKontrollenModel();
        this.svPruefungTabelle = new JTable(this.svPruefungModel);
        this.svPruefungTabelle.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.svPruefungTabelle.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.svPruefungTabelle.getColumnModel().getColumn(2).setPreferredWidth(200);
        this.svPruefungTabelle.getColumnModel().getColumn(3).setPreferredWidth(50);
        this.svPruefungTabelle.getColumnModel().getColumn(4).setPreferredWidth(50);
        this.prueferBox = new JComboBox<String>(VawsPruefer.getAllPruefer());
        this.prueferBox.setEditable(false);
        this.prueferBox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                VawsEditor.this.prueferBox.showPopup();
            }
        });
        this.prueferBox.setBorder(BorderFactory.createEmptyBorder());
        this.svPruefungTabelle.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.prueferBox));
        this.pruefergebnisBox = new JComboBox<String>(VawsPruefergebnisse.getAllPruefergebnisse());
        this.pruefergebnisBox.setEditable(false);
        this.pruefergebnisBox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                VawsEditor.this.pruefergebnisBox.showPopup();
            }
        });
        this.pruefergebnisBox.setBorder(BorderFactory.createEmptyBorder());
        this.svPruefungTabelle.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(this.pruefergebnisBox));
        this.svPruefungTabelle.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                VawsEditor.this.showTabellenPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                VawsEditor.this.showTabellenPopup(e);
            }
        });
        this.svPruefungTabelle.getInputMap().put((KeyStroke)this.getTabellenItemLoeschAction().getValue("AcceleratorKey"), this.getTabellenItemLoeschAction().getValue("Name"));
        this.svPruefungTabelle.getActionMap().put(this.getTabellenItemLoeschAction().getValue("Name"), this.getTabellenItemLoeschAction());
        this.verwVerfahrenModel = new VerwVerfahrenModel();
        this.verwVerfahrenTabelle = new JTable(this.verwVerfahrenModel);
        this.verwVerfahrenTabelle.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.verwVerfahrenTabelle.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.verwVerfahrenTabelle.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.verwVerfahrenTabelle.getColumnModel().getColumn(3).setPreferredWidth(50);
        this.massnahmenBox = new JComboBox<String>(VawsVerwmassnahmen.getAllMassnahmen());
        this.massnahmenBox.setEditable(true);
        this.massnahmenBox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                VawsEditor.this.massnahmenBox.showPopup();
            }
        });
        this.massnahmenBox.setBorder(BorderFactory.createEmptyBorder());
        this.verwVerfahrenTabelle.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.massnahmenBox));
        this.verwVerfahrenTabelle.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                VawsEditor.this.showTabellenPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                VawsEditor.this.showTabellenPopup(e);
            }
        });
        this.verwVerfahrenTabelle.getInputMap().put((KeyStroke)this.getTabellenItemLoeschAction().getValue("AcceleratorKey"), this.getTabellenItemLoeschAction().getValue("Name"));
        this.verwVerfahrenTabelle.getActionMap().put(this.getTabellenItemLoeschAction().getValue("Name"), this.getTabellenItemLoeschAction());
        this.verwGebuehrenModel = new VerwGebuehrenModel();
        this.verwGebuehrenTabelle = new JTable(this.verwGebuehrenModel);
        this.verwGebuehrenTabelle.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.verwGebuehrenTabelle.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.verwGebuehrenTabelle.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.verwGebuehrenTabelle.getColumnModel().getColumn(3).setPreferredWidth(50);
        this.verwGebuehrenTabelle.getColumnModel().getColumn(4).setPreferredWidth(50);
        this.gebArtenBox = new JComboBox<VawsGebuehrenarten>(VawsGebuehrenarten.getAllGebuehrenarten());
        this.gebArtenBox.setEditable(false);
        this.gebArtenBox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                VawsEditor.this.gebArtenBox.showPopup();
            }
        });
        this.gebArtenBox.setBorder(BorderFactory.createEmptyBorder());
        this.verwGebuehrenTabelle.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.gebArtenBox));
        this.verwGebuehrenTabelle.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                VawsEditor.this.showTabellenPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                VawsEditor.this.showTabellenPopup(e);
            }
        });
        this.verwGebuehrenTabelle.getInputMap().put((KeyStroke)this.getTabellenItemLoeschAction().getValue("AcceleratorKey"), this.getTabellenItemLoeschAction().getValue("Name"));
        this.verwGebuehrenTabelle.getActionMap().put(this.getTabellenItemLoeschAction().getValue("Name"), this.getTabellenItemLoeschAction());
        FormLayout topLayout = new FormLayout("p:g, 3dlu:g, p:g, 3dlu:g, p:g, 3dlu:g, p:g, 3dlu:g, p:g");
        DefaultFormBuilder topBuilder = new DefaultFormBuilder(topLayout);
        topBuilder.setBorder(Borders.DLU2_BORDER);
        topBuilder.append((Component)this.header, 9);
        topBuilder.append("Herstell-Nr.:");
        topBuilder.append("Fl\u00fcssigkeit:");
        topBuilder.append("VbF:");
        topBuilder.append("Gef\u00e4hrdungsstufe:");
        topBuilder.append("WGK:");
        topBuilder.append((Component)this.hnrFeld, (Component)this.fluessigkeitBox, (Component)this.vbfBox);
        topBuilder.append((Component)this.gefStufeBox, (Component)this.wgkBox);
        this.topPanel = topBuilder.getPanel();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.topPanel, "North");
        panel.add((Component)this.tabbedPane, "Center");
        return panel;
    }

    @Override
    protected void fillForm() {
        this.header.setText(this.getFachdaten().getAnlagenart());
        this.hnrFeld.setText(this.getFachdaten().getHerstellnr());
        this.fluessigkeitBox.setSelectedItem(this.getFachdaten().getFluessigkeit());
        this.vbfBox.setSelectedItem(this.getFachdaten().getVbfeinstufung());
        this.gefStufeBox.setSelectedItem(this.getFachdaten().getGefaehrdungsstufe());
        this.wgkBox.setSelectedItem(this.getFachdaten().getWgk());
        this.baujahrFeld.setValue(this.getFachdaten().getBaujahr());
        this.inbetriebnahmeChooser.setDate(this.getFachdaten().getDatumInbetriebnahme());
        this.genehmigungChooser.setDate(this.getFachdaten().getDatumGenehmigung());
        this.erfassungChooser.setDate(this.getFachdaten().getDatumErfassung());
        this.stillegungChooser.setDate(this.getFachdaten().getStillegungsdatum());
        this.pruefTurnusFeld.setValue(this.getFachdaten().getPruefturnus());
        this.behaelterArtBox.setSelectedItem(this.getFachdaten().getBehaelterart());
        this.materialBox.setSelectedItem(this.getFachdaten().getMaterial());
        this.bemerkungArea.setText(this.getFachdaten().getBemerkungen());
        this.anlagenChronoModel.setFachdaten(this.getFachdaten());
        if (this.getFachdaten().isVAWSAbscheider()) {
            this.tabbedPane.addTab("Daten", this.getDatenVAWSAbscheiderTab());
            this.tabbedPane.addTab("Ausf\u00fchrung", this.getAusfuehrungVAWSAbscheiderTab());
            this.tabbedPane.addTab("Schutzvorkehrungen", this.getSchutzvorkehrungenVAWSAbscheiderTab());
            this.mengeFeld.setValue(this.getFachdaten().getMenge());
            if (this.getAbscheider().getKompaktanlage() != null) {
                this.kompaktCheck.setSelected(this.getAbscheider().getKompaktanlage());
            } else {
                this.kompaktCheck.setSelected(false);
            }
            if (this.getAbscheider().getKkl1() != null) {
                this.kompKCheck.setSelected(this.getAbscheider().getKkl1());
            } else {
                this.kompKCheck.setSelected(false);
            }
            if (this.getAbscheider().getLfkl2() != null) {
                this.kompLFCheck.setSelected(this.getAbscheider().getLfkl2());
            } else {
                this.kompLFCheck.setSelected(false);
            }
            if (this.getAbscheider().getPs() != null) {
                this.kompPSCheck.setSelected(this.getAbscheider().getPs());
            } else {
                this.kompPSCheck.setSelected(false);
            }
            if (this.getAbscheider().getSf() != null) {
                this.kompSFCheck.setSelected(this.getAbscheider().getSf());
            } else {
                this.kompSFCheck.setSelected(false);
            }
            this.schlammBeschField.setText(this.getAbscheider().getSfbeschichtung());
            this.schlammHerstField.setText(this.getAbscheider().getSfhersteller());
            this.schlammMatField.setText(this.getAbscheider().getSfmaterial());
            this.schlammSFVField.setText(this.getAbscheider().getSfvolumen());
            this.schlammTypField.setText(this.getAbscheider().getSftyp());
            this.abscheiderBeschField.setText(this.getAbscheider().getAbbeschichtung());
            this.abscheiderHerstField.setText(this.getAbscheider().getAbhersteller());
            this.abscheiderMatField.setText(this.getAbscheider().getAbmaterial());
            this.abscheiderNSField.setText(this.getAbscheider().getAbnenngr());
            this.abscheiderPruefField.setText(this.getAbscheider().getAbpruefz());
            this.abscheiderTypField.setText(this.getAbscheider().getAbtyp());
            this.abscheideroelField.setText(this.getAbscheider().getOelspeichervol());
            this.zulDNField.setText(this.getAbscheider().getZuldn());
            this.zulLField.setText(this.getAbscheider().getZullaenge());
            this.zulMatField.setText(this.getAbscheider().getZulmaterial());
            this.verbDNField.setText(this.getAbscheider().getVerbdn());
            this.verbLField.setText(this.getAbscheider().getVerblaenge());
            this.verbMatField.setText(this.getAbscheider().getVerbmaterial());
            this.sonsDNField.setText(this.getAbscheider().getSondn());
            this.sonsLField.setText(this.getAbscheider().getSonlaenge());
            this.sonsMatField.setText(this.getAbscheider().getSonmaterial());
            if (this.getAbscheider().getUeberhausr() != null) {
                this.ueberCheck.setSelected(this.getAbscheider().getUeberhausr());
            } else {
                this.ueberCheck.setSelected(false);
            }
            if (this.getAbscheider().getWaschanlvorh() != null) {
                this.waschCheck.setSelected(this.getAbscheider().getWaschanlvorh());
            } else {
                this.waschCheck.setSelected(false);
            }
            if (this.getAbscheider().getAbgabe() != null) {
                this.abgabeCheck.setSelected(this.getAbscheider().getAbgabe());
            } else {
                this.abgabeCheck.setSelected(false);
            }
            if (this.getAbscheider().getHlzapfanl() != null) {
                this.hochCheck.setSelected(this.getAbscheider().getHlzapfanl());
            } else {
                this.hochCheck.setSelected(false);
            }
            if (this.getAbscheider().getBelvonlagerbh() != null) {
                this.belueftCheck.setSelected(this.getAbscheider().getBelvonlagerbh());
            } else {
                this.belueftCheck.setSelected(false);
            }
            if (this.getAbscheider().getRueckhalteausr() != null) {
                this.rueckCheck.setSelected(this.getAbscheider().getRueckhalteausr());
            } else {
                this.rueckCheck.setSelected(false);
            }
        } else if (this.getFachdaten().isLageranlage()) {
            this.tabbedPane.addTab("Daten", this.getDatenLageranlagenTab());
            this.tabbedPane.addTab("Schutzvorkehrungen", this.getSchutzLageranlagenTab());
            this.tabbedPane.addTab("Leitungen", this.getLeitungenLageranlagenTab());
            this.mengeFeld.setValue(this.getFachdaten().getMenge());
            if (this.getFachdaten().getDoppelwandig() != null) {
                this.doppelWandigCheck.setSelected(this.getFachdaten().getDoppelwandig());
            } else {
                this.doppelWandigCheck.setSelected(false);
            }
            if (this.getFachdaten().getLeckanzeige() != null) {
                this.leckAnzeigeCheck.setSelected(this.getFachdaten().getLeckanzeige());
            } else {
                this.leckAnzeigeCheck.setSelected(false);
            }
            if (this.getFachdaten().getAuffangraum() != null) {
                this.auffangRaumCheck.setSelected(this.getFachdaten().getAuffangraum());
            } else {
                this.auffangRaumCheck.setSelected(false);
            }
            if (this.getFachdaten().getLeckschutzauskleidung() != null) {
                this.leckSchutzAuskleidungCheck.setSelected(this.getFachdaten().getLeckschutzauskleidung());
            } else {
                this.leckSchutzAuskleidungCheck.setSelected(false);
            }
            if (this.getFachdaten().getGrenzwertgeber() != null) {
                this.grenzWertGeberCheck.setSelected(this.getFachdaten().getGrenzwertgeber());
            } else {
                this.grenzWertGeberCheck.setSelected(false);
            }
            if (this.getFachdaten().getKellerlagerung() != null) {
                this.kellerLagerungCheck.setSelected(this.getFachdaten().getKellerlagerung());
            } else {
                this.kellerLagerungCheck.setSelected(false);
            }
            if (this.getFachdaten().getInnenbeschichtung() != null) {
                this.innenBeschichtungCheck.setSelected(this.getFachdaten().getInnenbeschichtung());
            } else {
                this.innenBeschichtungCheck.setSelected(false);
            }
            this.beschreibungAFeld.setText(this.getFachdaten().getBeschreibung_a());
            this.beschreibungSFeld.setText(this.getFachdaten().getBeschreibung_s());
            if (this.getFachdaten().getOberirdisch() != null) {
                this.oberIrdischCheck.setSelected(this.getFachdaten().getOberirdisch());
            } else {
                this.oberIrdischCheck.setSelected(false);
            }
            if (this.getFachdaten().getUnterirdisch() != null) {
                this.unterIrdischCheck.setSelected(this.getFachdaten().getUnterirdisch());
            } else {
                this.unterIrdischCheck.setSelected(false);
            }
            if (this.getFachdaten().getSaugleitung() != null) {
                this.saugLeitungCheck.setSelected(this.getFachdaten().getSaugleitung());
            } else {
                this.saugLeitungCheck.setSelected(false);
            }
            if (this.getFachdaten().getRohrKathodenschutz() != null) {
                this.rohrKathSchCheck.setSelected(this.getFachdaten().getRohrKathodenschutz());
            } else {
                this.rohrKathSchCheck.setSelected(false);
            }
            if (this.getFachdaten().getAusKupfer() != null) {
                this.ausKupferCheck.setSelected(this.getFachdaten().getAusKupfer());
            } else {
                this.ausKupferCheck.setSelected(false);
            }
            if (this.getFachdaten().getAusStahl() != null) {
                this.ausStahlCheck.setSelected(this.getFachdaten().getAusStahl());
            } else {
                this.ausStahlCheck.setSelected(false);
            }
            if (this.getFachdaten().getMitSchutzrohr() != null) {
                this.schutzrohrCheck.setSelected(this.getFachdaten().getMitSchutzrohr());
            } else {
                this.schutzrohrCheck.setSelected(false);
            }
            this.beschreibungRFeld.setText(this.getFachdaten().getBeschreibung_r());
        } else if (this.getFachdaten().isRohrleitung()) {
            this.tabbedPane.addTab("Daten", this.getDatenRohrleitungenTab());
            this.ausfuehrungBox.setSelectedItem(this.getFachdaten().getAusfuehrung());
        } else if (this.getFachdaten().isAbfuellflaeche()) {
            this.tabbedPane.addTab("Daten", this.getDatenAbfuellflaechenTab());
            this.tabbedPane.addTab("Ausf\u00fchrung", this.getAusfuehrungAbfuellflaechenTab());
            if (this.getAbfuellflaeche().getEoh() != null) {
                this.eohCheck.setSelected(this.getAbfuellflaeche().getEoh());
            } else {
                this.eohCheck.setSelected(false);
            }
            if (this.getAbfuellflaeche().getEf() != null) {
                this.efCheck.setSelected(this.getAbfuellflaeche().getEf());
            } else {
                this.efCheck.setSelected(false);
            }
            if (this.getAbfuellflaeche().getAbfsaniert() != null) {
                this.saniertCheck.setSelected(this.getAbfuellflaeche().getAbfsaniert());
            } else {
                this.saniertCheck.setSelected(false);
            }
            if (this.getAbfuellflaeche().getAbfneuerstellt() != null) {
                this.neuErstelltCheck.setSelected(this.getAbfuellflaeche().getAbfneuerstellt());
            } else {
                this.neuErstelltCheck.setSelected(false);
            }
            this.bodenflaechenAusfBox.setSelectedItem(this.getAbfuellflaeche().getBodenflaechenausf());
            this.dickeFeld.setValue(this.getAbfuellflaeche().getDicke());
            this.gueteFeld.setText(this.getAbfuellflaeche().getGuete());
            this.fugenMaterialFeld.setText(this.getAbfuellflaeche().getFugenmaterial());
            this.niederschlagSchutzBox.setSelectedItem(this.getAbfuellflaeche().getNiederschlagschutz());
            if (this.getFachdaten().getDoppelwandig() != null) {
                this.abscheiderVorhandenCheck.setSelected(this.getFachdaten().getDoppelwandig());
            } else {
                this.abscheiderVorhandenCheck.setSelected(false);
            }
            this.beschrBodenflaecheArea.setText(this.getAbfuellflaeche().getBeschbodenfl());
            this.beschrFugenmaterialArea.setText(this.getAbfuellflaeche().getBeschfugenmat());
            this.beschrAblNiederschlArea.setText(this.getAbfuellflaeche().getBeschableitung());
        }
        this.tabbedPane.addTab("Sachverst\u00e4ndigenpr\u00fcfung", this.getSvPruefungTab());
        this.svPruefungModel.setFachdaten(this.getFachdaten());
        this.tabbedPane.addTab("Verwaltungsverfahren", this.getVerwVerfahrenTab());
        this.verwVerfahrenModel.setFachdaten(this.getFachdaten());
        this.tabbedPane.addTab("Verwaltungsgeb\u00fchren", this.getVerwGebuehrenTab());
        this.verwGebuehrenModel.setFachdaten(this.getFachdaten());
        this.pack();
        this.setLocationRelativeTo(this.frame);
    }

    @Override
    protected boolean canSave() {
        return true;
    }

    @Override
    protected boolean doSave() {
        String tmp;
        if (this.svPruefungTabelle.getCellEditor() != null) {
            this.svPruefungTabelle.getCellEditor().stopCellEditing();
        }
        if (this.verwVerfahrenTabelle.getCellEditor() != null) {
            this.verwVerfahrenTabelle.getCellEditor().stopCellEditing();
        }
        if (this.anlagenChronoTabelle.getCellEditor() != null) {
            this.anlagenChronoTabelle.getCellEditor().stopCellEditing();
        }
        if (this.verwGebuehrenTabelle.getCellEditor() != null) {
            this.verwGebuehrenTabelle.getCellEditor().stopCellEditing();
        }
        if ((tmp = this.hnrFeld.getText()) != null) {
            tmp = tmp.trim();
        }
        this.getFachdaten().setHerstellnr(tmp);
        tmp = (String)this.fluessigkeitBox.getSelectedItem();
        if (tmp != null) {
            tmp = tmp.trim();
        }
        this.getFachdaten().setFluessigkeit(tmp);
        this.getFachdaten().setVbfeinstufung((String)this.vbfBox.getSelectedItem());
        this.getFachdaten().setGefaehrdungsstufe((String)this.gefStufeBox.getSelectedItem());
        this.getFachdaten().setWgk((Integer)this.wgkBox.getSelectedItem());
        this.getFachdaten().setBaujahr(this.baujahrFeld.getIntValue());
        this.getFachdaten().setDatumInbetriebnahme(this.inbetriebnahmeChooser.getDate());
        this.getFachdaten().setDatumGenehmigung(this.genehmigungChooser.getDate());
        this.getFachdaten().setDatumErfassung(this.erfassungChooser.getDate());
        this.getFachdaten().setStillegungsdatum(this.stillegungChooser.getDate());
        this.getFachdaten().setPruefturnus(this.pruefTurnusFeld.getDoubleValue());
        this.getFachdaten().setBehaelterart((String)this.behaelterArtBox.getSelectedItem());
        this.getFachdaten().setMaterial((String)this.materialBox.getSelectedItem());
        this.getFachdaten().setBemerkungen(this.bemerkungArea.getText());
        boolean success = true;
        if (this.getFachdaten().isLageranlage()) {
            this.getFachdaten().setMenge(this.mengeFeld.getDoubleValue());
            this.getFachdaten().setDoppelwandig(this.doppelWandigCheck.isSelected());
            this.getFachdaten().setLeckanzeige(this.leckAnzeigeCheck.isSelected());
            this.getFachdaten().setAuffangraum(this.auffangRaumCheck.isSelected());
            this.getFachdaten().setLeckschutzauskleidung(this.leckSchutzAuskleidungCheck.isSelected());
            this.getFachdaten().setGrenzwertgeber(this.grenzWertGeberCheck.isSelected());
            this.getFachdaten().setKellerlagerung(this.kellerLagerungCheck.isSelected());
            this.getFachdaten().setInnenbeschichtung(this.innenBeschichtungCheck.isSelected());
            this.getFachdaten().setBeschreibung_a(this.beschreibungAFeld.getText());
            this.getFachdaten().setBeschreibung_s(this.beschreibungSFeld.getText());
            this.getFachdaten().setOberirdisch(this.oberIrdischCheck.isSelected());
            this.getFachdaten().setUnterirdisch(this.unterIrdischCheck.isSelected());
            this.getFachdaten().setSaugleitung(this.saugLeitungCheck.isSelected());
            this.getFachdaten().setRohrKathodenschutz(this.rohrKathSchCheck.isSelected());
            this.getFachdaten().setAusKupfer(this.ausKupferCheck.isSelected());
            this.getFachdaten().setAusStahl(this.ausStahlCheck.isSelected());
            this.getFachdaten().setMitSchutzrohr(this.schutzrohrCheck.isSelected());
            this.getFachdaten().setBeschreibung_r(this.beschreibungRFeld.getText());
        } else if (this.getFachdaten().isRohrleitung()) {
            this.getFachdaten().setAusfuehrung((String)this.ausfuehrungBox.getSelectedItem());
        }
        success = success && VawsFachdaten.saveFachdaten(this.getFachdaten());
        this.setEditedObject(VawsFachdaten.getVawsByBehaelterId(this.getFachdaten().getBehaelterId()));
        if (this.getFachdaten().isAbfuellflaeche()) {
            this.getAbfuellflaeche().setEoh(this.eohCheck.isSelected());
            this.getAbfuellflaeche().setEf(this.efCheck.isSelected());
            if (this.unbktCheck.isSelected()) {
                this.getAbfuellflaeche().setAbfneuerstellt(null);
                this.getAbfuellflaeche().setAbfsaniert(null);
            } else {
                this.getAbfuellflaeche().setAbfneuerstellt(this.neuErstelltCheck.isSelected());
                this.getAbfuellflaeche().setAbfsaniert(this.saniertCheck.isSelected());
            }
            this.getAbfuellflaeche().setBodenflaechenausf((String)this.bodenflaechenAusfBox.getSelectedItem());
            this.getAbfuellflaeche().setDicke(this.dickeFeld.getFloatValue());
            this.getAbfuellflaeche().setGuete(this.gueteFeld.getText());
            this.getAbfuellflaeche().setFugenmaterial(this.fugenMaterialFeld.getText());
            this.getAbfuellflaeche().setNiederschlagschutz((String)this.niederschlagSchutzBox.getSelectedItem());
            this.getAbfuellflaeche().setAbscheidervorh(this.abscheiderVorhandenCheck.isSelected());
            this.getAbfuellflaeche().setBeschbodenfl(this.beschrBodenflaecheArea.getText());
            this.getAbfuellflaeche().setBeschfugenmat(this.beschrFugenmaterialArea.getText());
            this.getAbfuellflaeche().setBeschableitung(this.beschrAblNiederschlArea.getText());
            boolean bl = success = success && VawsAbfuellflaeche.saveAbfuellflaeche(this.getAbfuellflaeche());
        }
        if (this.getFachdaten().isVAWSAbscheider()) {
            this.getAbscheider().setAbgabe(this.abgabeCheck.isSelected());
            this.getAbscheider().setBelvonlagerbh(this.belueftCheck.isSelected());
            this.getAbscheider().setHlzapfanl(this.hochCheck.isSelected());
            this.getAbscheider().setKompaktanlage(this.kompaktCheck.isSelected());
            this.getAbscheider().setKkl1(this.kompKCheck.isSelected());
            this.getAbscheider().setLfkl2(this.kompLFCheck.isSelected());
            this.getAbscheider().setPs(this.kompPSCheck.isSelected());
            this.getAbscheider().setSf(this.kompSFCheck.isSelected());
            this.getAbscheider().setRueckhalteausr(this.rueckCheck.isSelected());
            this.getAbscheider().setWaschanlvorh(this.waschCheck.isSelected());
            this.getAbscheider().setUeberhausr(this.ueberCheck.isSelected());
            this.getAbscheider().setAbbeschichtung(this.abscheiderBeschField.getText());
            this.getAbscheider().setAbhersteller(this.abscheiderHerstField.getText());
            this.getAbscheider().setAbmaterial(this.abscheiderMatField.getText());
            this.getAbscheider().setAbnenngr(this.abscheiderNSField.getText());
            this.getAbscheider().setAbpruefz(this.abscheiderPruefField.getText());
            this.getAbscheider().setAbtyp(this.abscheiderTypField.getText());
            this.getAbscheider().setOelspeichervol(this.abscheideroelField.getText());
            this.getAbscheider().setSfbeschichtung(this.schlammBeschField.getText());
            this.getAbscheider().setSfhersteller(this.schlammHerstField.getText());
            this.getAbscheider().setSfmaterial(this.schlammMatField.getText());
            this.getAbscheider().setSftyp(this.schlammTypField.getText());
            this.getAbscheider().setSfvolumen(this.schlammSFVField.getText());
            this.getAbscheider().setZuldn(this.zulDNField.getText());
            this.getAbscheider().setZullaenge(this.zulLField.getText());
            this.getAbscheider().setZulmaterial(this.zulMatField.getText());
            this.getAbscheider().setVerbdn(this.verbDNField.getText());
            this.getAbscheider().setVerblaenge(this.verbLField.getText());
            this.getAbscheider().setVerbmaterial(this.verbMatField.getText());
            this.getAbscheider().setSondn(this.sonsDNField.getText());
            this.getAbscheider().setSonlaenge(this.sonsLField.getText());
            this.getAbscheider().setSonmaterial(this.sonsMatField.getText());
            success = success && VawsAbscheider.saveAbscheider(this.getAbscheider());
        }
        Iterator it = this.anlagenChronoModel.getList().iterator();
        while (it.hasNext()) {
            success = success && VawsAnlagenchrono.saveAnlagenChrono((VawsAnlagenchrono)it.next());
        }
        it = this.anlagenChronoModel.getGeloeschte().iterator();
        while (it.hasNext()) {
            success = success && VawsAnlagenchrono.removeAnlagenChrono((VawsAnlagenchrono)it.next());
        }
        AUIKataster.debugOutput(this.anlagenChronoModel.getList().size() + " AnlagenChrono-Eintr\u00e4ge neu/behalten, " + this.anlagenChronoModel.getGeloeschte().size() + " Eintr\u00e4ge gel\u00f6scht.", "VawsEditor");
        it = this.svPruefungModel.getList().iterator();
        while (it.hasNext()) {
            success = success && VawsKontrollen.saveKontrolle((VawsKontrollen)it.next());
        }
        it = this.svPruefungModel.getGeloeschte().iterator();
        while (it.hasNext()) {
            success = success && VawsKontrollen.removeKontrolle((VawsKontrollen)it.next());
        }
        AUIKataster.debugOutput(this.svPruefungModel.getList().size() + " Sachverst\u00e4ndigenpr\u00fcfungs-Eintr\u00e4ge neu/behalten, " + this.svPruefungModel.getGeloeschte().size() + " Eintr\u00e4ge gel\u00f6scht.", "VawsEditor");
        it = this.verwVerfahrenModel.getList().iterator();
        while (it.hasNext()) {
            success = success && VawsVerwaltungsverf.saveVerfahren((VawsVerwaltungsverf)it.next());
        }
        it = this.verwVerfahrenModel.getGeloeschte().iterator();
        while (it.hasNext()) {
            success = success && VawsVerwaltungsverf.removeVerfahren((VawsVerwaltungsverf)it.next());
        }
        AUIKataster.debugOutput(this.verwVerfahrenModel.getList().size() + " Verwaltungsverfahren-Eintr\u00e4ge neu/behalten, " + this.verwVerfahrenModel.getGeloeschte().size() + " Eintr\u00e4ge gel\u00f6scht.", "VawsEditor");
        it = this.verwGebuehrenModel.getList().iterator();
        while (it.hasNext()) {
            success = success && VawsVerwaltungsgebuehren.saveGebuehr((VawsVerwaltungsgebuehren)it.next());
        }
        it = this.verwGebuehrenModel.getGeloeschte().iterator();
        while (it.hasNext()) {
            success = success && VawsVerwaltungsgebuehren.removeGebuehr((VawsVerwaltungsgebuehren)it.next());
        }
        AUIKataster.debugOutput(this.verwGebuehrenModel.getList().size() + " Verwaltungsgeb\u00fchren-Eintr\u00e4ge neu/behalten, " + this.verwGebuehrenModel.getGeloeschte().size() + " Eintr\u00e4ge gel\u00f6scht.", "VawsEditor");
        return success;
    }

    private void showTabellenPopup(MouseEvent e) {
        if (this.tabellenPopup == null) {
            this.tabellenPopup = new JPopupMenu();
            JMenuItem loeschItem = new JMenuItem(this.getTabellenItemLoeschAction());
            this.tabellenPopup.add(loeschItem);
        }
        if (e.isPopupTrigger()) {
            Point origin = e.getPoint();
            JTable table = (JTable)e.getSource();
            int row = table.rowAtPoint(origin);
            if (row != -1) {
                table.setRowSelectionInterval(row, row);
                this.tabellenPopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private Action getTabellenItemLoeschAction() {
        if (this.tabellenItemLoeschAction == null) {
            this.tabellenItemLoeschAction = new AbstractAction("Eintrag l\u00f6schen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = VawsEditor.this.tabbedPane.getSelectedIndex();
                    System.out.println("index: " + index);
                    if (index == 0) {
                        VawsEditor.this.removeRowFromTable(VawsEditor.this.anlagenChronoTabelle, VawsEditor.this.anlagenChronoModel);
                    } else if (index == VawsEditor.this.tabbedPane.getTabCount() - 3) {
                        VawsEditor.this.removeRowFromTable(VawsEditor.this.svPruefungTabelle, VawsEditor.this.svPruefungModel);
                    } else if (index == VawsEditor.this.tabbedPane.getTabCount() - 2) {
                        VawsEditor.this.removeRowFromTable(VawsEditor.this.verwVerfahrenTabelle, VawsEditor.this.verwVerfahrenModel);
                    } else if (index == VawsEditor.this.tabbedPane.getTabCount() - 1) {
                        VawsEditor.this.removeRowFromTable(VawsEditor.this.verwGebuehrenTabelle, VawsEditor.this.verwGebuehrenModel);
                    }
                }
            };
            this.tabellenItemLoeschAction.putValue("MnemonicKey", new Integer(76));
            this.tabellenItemLoeschAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0, false));
        }
        return this.tabellenItemLoeschAction;
    }

    private void removeRowFromTable(JTable table, EditableListTableModel model) {
        int row = table.getSelectedRow();
        if (row != -1) {
            model.removeRow(row);
        }
    }

    private JPanel getDatenVAWSAbscheiderTab() {
        if (this.datenVAWSAbscheiderTab == null) {
            FormLayout layout = new FormLayout("r:p, 3dlu, f:p:g, 10dlu, r:p, 3dlu, f:p:g, 0:g");
            layout.setColumnGroups((int[][])new int[][]{{1, 5}, {3, 7}});
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.setDefaultDialogBorder();
            builder.appendSeparator("Stammdaten");
            builder.append("Baujahr:", (Component)this.baujahrFeld);
            builder.append("Inbetriebnahme:", (Component)this.inbetriebnahmeChooser);
            builder.nextLine();
            builder.append("Erfassung:", (Component)this.erfassungChooser);
            builder.append("Pr\u00fcfturnus [Jahre]:", (Component)this.pruefTurnusFeld);
            builder.nextLine();
            builder.append("Stillegung:", (Component)this.stillegungChooser);
            builder.nextLine();
            builder.appendSeparator("Komponenten");
            builder.append("", (Component)this.kompaktCheck);
            builder.nextLine();
            builder.append("", (Component)this.kompSFCheck);
            builder.append("", (Component)this.kompPSCheck);
            builder.nextLine();
            builder.append("", (Component)this.kompKCheck);
            builder.append("", (Component)this.kompLFCheck);
            builder.nextLine();
            builder.appendSeparator("Bemerkungen");
            builder.appendRow("3dlu");
            builder.appendRow("fill:30dlu:grow");
            builder.nextLine(2);
            builder.append((Component)new JScrollPane(this.bemerkungArea), 8);
            builder.appendSeparator("Anlagen-Chronologie");
            builder.appendRow("3dlu");
            builder.appendRow("fill:40dlu:grow");
            builder.nextLine(2);
            builder.append((Component)new JScrollPane(this.anlagenChronoTabelle), 8);
            this.datenVAWSAbscheiderTab = builder.getPanel();
        }
        return this.datenVAWSAbscheiderTab;
    }

    private JPanel getAusfuehrungVAWSAbscheiderTab() {
        if (this.ausfuehrungVAWSAbscheiderTab == null) {
            FormLayout layout = new FormLayout("r:p, 3dlu, f:p:g, 10dlu, r:p, 3dlu, f:p:g, 10dlu, r:p, 3dlu, f:p:g");
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.setDefaultDialogBorder();
            builder.appendSeparator("Schlammfang");
            builder.append("Hersteller:", (Component)this.schlammHerstField);
            builder.append("Typ:", (Component)this.schlammTypField);
            builder.append("SF-Volumen [Liter]:", (Component)this.schlammSFVField);
            builder.nextLine();
            builder.append("Material:", (Component)this.schlammMatField);
            builder.append("Beschichtung:", (Component)this.schlammBeschField);
            builder.nextLine();
            builder.appendSeparator("Abscheider");
            builder.append("Hersteller:", (Component)this.abscheiderHerstField);
            builder.append("Typ:", (Component)this.abscheiderTypField);
            builder.append("Pr\u00fcfzeichen:", (Component)this.abscheiderPruefField);
            builder.nextLine();
            builder.append("Material:", (Component)this.abscheiderMatField);
            builder.append("Beschichtung:", (Component)this.abscheiderBeschField);
            builder.append("Nenngr\u00f6\u00dfe (NS):", (Component)this.abscheiderNSField);
            builder.nextLine();
            builder.append("\u00d6lspeichervolumen [Liter]:", (Component)this.abscheideroelField);
            builder.nextLine();
            builder.appendSeparator("Rohrleitungen: Zuleitungen");
            builder.append("DN:", (Component)this.zulDNField);
            builder.append("Material:", (Component)this.zulMatField);
            builder.append("L\u00e4nge [m]:", (Component)this.zulLField);
            builder.nextLine();
            builder.appendSeparator("Rohrleitungen: Verbindungsleitungen");
            builder.append("DN:", (Component)this.verbDNField);
            builder.append("Material:", (Component)this.verbMatField);
            builder.append("L\u00e4nge [m]:", (Component)this.verbLField);
            builder.nextLine();
            builder.appendSeparator("Rohrleitungen: Sonstige");
            builder.append("DN:", (Component)this.sonsDNField);
            builder.append("Material:", (Component)this.sonsMatField);
            builder.append("L\u00e4nge [m]:", (Component)this.sonsLField);
            builder.nextLine();
            this.ausfuehrungVAWSAbscheiderTab = builder.getPanel();
        }
        return this.ausfuehrungVAWSAbscheiderTab;
    }

    private JPanel getSchutzvorkehrungenVAWSAbscheiderTab() {
        if (this.schutzvorkehrungenVAWSAbscheiderTab == null) {
            FormLayout layout = new FormLayout("p:g");
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.setDefaultDialogBorder();
            builder.appendSeparator("Stammdaten");
            builder.append((Component)this.ueberCheck);
            builder.nextLine();
            builder.append((Component)this.waschCheck);
            builder.nextLine();
            builder.appendSeparator("R\u00fcckhalteverm\u00f6gen");
            builder.append((Component)this.abgabeCheck);
            builder.nextLine();
            builder.append((Component)this.hochCheck);
            builder.nextLine();
            builder.append((Component)this.belueftCheck);
            builder.nextLine();
            builder.append((Component)this.rueckCheck);
            builder.nextLine();
            this.schutzvorkehrungenVAWSAbscheiderTab = builder.getPanel();
        }
        return this.schutzvorkehrungenVAWSAbscheiderTab;
    }

    private JPanel getDatenLageranlagenTab() {
        if (this.datenLageranlagenTab == null) {
            FormLayout layout = new FormLayout("r:p, 3dlu, f:p:g, 10dlu, r:p, 3dlu, f:p:g, 0:g");
            layout.setColumnGroups((int[][])new int[][]{{1, 5}, {3, 7}});
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.setDefaultDialogBorder();
            builder.appendSeparator("Stammdaten");
            builder.append("Baujahr:", (Component)this.baujahrFeld);
            builder.append("Menge [m\u00b3]:", (Component)this.mengeFeld);
            builder.nextLine();
            builder.append("Inbetriebnahme:", (Component)this.inbetriebnahmeChooser);
            builder.append("Pr\u00fcfturnus [Jahre]:", (Component)this.pruefTurnusFeld);
            builder.nextLine();
            builder.append("Genehmigung:", (Component)this.genehmigungChooser);
            builder.append("Beh\u00e4lterart:", (Component)this.behaelterArtBox);
            builder.nextLine();
            builder.append("Erfassung:", (Component)this.erfassungChooser);
            builder.append("Material:", (Component)this.materialBox);
            builder.nextLine();
            builder.append("Stillegung:", (Component)this.stillegungChooser);
            builder.nextLine();
            builder.appendSeparator("Bemerkungen");
            builder.appendRow("3dlu");
            builder.appendRow("fill:30dlu:grow");
            builder.nextLine(2);
            builder.append((Component)new JScrollPane(this.bemerkungArea), 8);
            builder.appendSeparator("Anlagen-Chronologie");
            builder.appendRow("3dlu");
            builder.appendRow("fill:40dlu:grow");
            builder.nextLine(2);
            builder.append((Component)new JScrollPane(this.anlagenChronoTabelle), 8);
            this.datenLageranlagenTab = builder.getPanel();
        }
        return this.datenLageranlagenTab;
    }

    private JPanel getSchutzLageranlagenTab() {
        if (this.schutzLageranlagenTab == null) {
            FormLayout layout = new FormLayout("p, 3dlu:g, p, 3dlu:g, p");
            layout.setColumnGroups((int[][])new int[][]{{1, 3, 5}});
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.setDefaultDialogBorder();
            builder.append((Component)this.doppelWandigCheck, (Component)this.leckAnzeigeCheck, (Component)this.leckSchutzAuskleidungCheck);
            builder.append((Component)this.auffangRaumCheck, (Component)this.kellerLagerungCheck, (Component)this.innenBeschichtungCheck);
            builder.append((Component)this.grenzWertGeberCheck);
            builder.nextLine();
            builder.appendSeparator("Beschreibung: Schutzvorkehrungen");
            builder.appendRow("3dlu");
            builder.appendRow("fill:25dlu:grow");
            builder.nextLine(2);
            builder.append((Component)new JScrollPane(this.beschreibungSFeld), 5);
            builder.appendSeparator("Beschreibung: Auffangraum");
            builder.appendRow("3dlu");
            builder.appendRow("fill:25dlu");
            builder.nextLine(2);
            builder.append((Component)new JScrollPane(this.beschreibungAFeld), 5);
            this.schutzLageranlagenTab = builder.getPanel();
        }
        return this.schutzLageranlagenTab;
    }

    private JPanel getLeitungenLageranlagenTab() {
        if (this.leitungenLageranlagenTab == null) {
            FormLayout layout = new FormLayout("p, 3dlu:g, p, 3dlu:g, p");
            layout.setColumnGroups((int[][])new int[][]{{1, 3, 5}});
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.setDefaultDialogBorder();
            builder.append((Component)this.oberIrdischCheck, (Component)this.ausKupferCheck, (Component)this.saugLeitungCheck);
            builder.append((Component)this.unterIrdischCheck, (Component)this.ausStahlCheck, (Component)this.rohrKathSchCheck);
            builder.append((Component)this.schutzrohrCheck);
            builder.nextLine();
            builder.appendSeparator("Beschreibung: Rohrleitung");
            builder.appendRow("3dlu");
            builder.appendRow("fill:25dlu:grow");
            builder.nextLine(2);
            builder.append((Component)new JScrollPane(this.beschreibungRFeld), 5);
            this.leitungenLageranlagenTab = builder.getPanel();
        }
        return this.leitungenLageranlagenTab;
    }

    private JPanel getDatenRohrleitungenTab() {
        if (this.datenRohrleitungenTab == null) {
            FormLayout layout = new FormLayout("r:p, 3dlu, p, 10dlu, r:p, 3dlu, p, 0:g");
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.setDefaultDialogBorder();
            builder.appendSeparator("Stammdaten");
            builder.append("Baujahr:", (Component)this.baujahrFeld);
            builder.append("Ausf\u00fchrung:", (Component)this.ausfuehrungBox);
            builder.nextLine();
            builder.append("Inbetriebnahme:", (Component)this.inbetriebnahmeChooser);
            builder.append("Pr\u00fcfturnus [Jahre]:", (Component)this.pruefTurnusFeld);
            builder.nextLine();
            builder.append("Genehmigung:", (Component)this.genehmigungChooser);
            builder.append("Bauart:", (Component)this.behaelterArtBox);
            builder.nextLine();
            builder.append("Erfassung:", (Component)this.erfassungChooser);
            builder.append("Material:", (Component)this.materialBox);
            builder.nextLine();
            builder.append("Stillegung:", (Component)this.stillegungChooser);
            builder.nextLine();
            builder.appendSeparator("Beschreibung der Rohrleitung:");
            builder.appendRow("3dlu");
            builder.appendRow("fill:25dlu:grow");
            builder.nextLine(2);
            builder.append((Component)new JScrollPane(this.bemerkungArea), 8);
            builder.nextLine();
            builder.appendSeparator("Anlagen-Chronologie");
            builder.appendRow("3dlu");
            builder.appendRow("fill:40dlu:grow");
            builder.nextLine(2);
            builder.append((Component)new JScrollPane(this.anlagenChronoTabelle), 8);
            this.datenRohrleitungenTab = builder.getPanel();
        }
        return this.datenRohrleitungenTab;
    }

    private JPanel getDatenAbfuellflaechenTab() {
        if (this.datenAbfuellflaechenTab == null) {
            FormLayout layout = new FormLayout("r:p, 3dlu, f:p:g, 10dlu, r:p, 3dlu, f:p:g");
            layout.setColumnGroups((int[][])new int[][]{{1, 5}, {3, 7}});
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.setDefaultDialogBorder();
            builder.appendSeparator("Stammdaten");
            builder.append("Baujahr:", (Component)this.baujahrFeld);
            builder.append("Pr\u00fcfturnus [Jahre]:", (Component)this.pruefTurnusFeld);
            builder.append("Inbetriebnahme:", (Component)this.inbetriebnahmeChooser);
            builder.append("Erfassung:", (Component)this.erfassungChooser);
            builder.append("Genehmigung:", (Component)this.genehmigungChooser);
            builder.append("Stillegung:", (Component)this.stillegungChooser);
            builder.appendSeparator("Abf\u00fcllfl\u00e4che");
            builder.append("", (Component)this.neuErstelltCheck);
            builder.append("", (Component)this.eohCheck);
            builder.append("", (Component)this.saniertCheck);
            builder.append("", (Component)this.efCheck);
            builder.append("", (Component)this.unbktCheck);
            builder.append("", (Component)this.svbCheck);
            builder.appendSeparator("Beschreibung der Abf\u00fcllfl\u00e4che");
            builder.appendRow("3dlu");
            builder.appendRow("fill:25dlu:grow(0.3)");
            builder.nextLine(2);
            builder.append((Component)new JScrollPane(this.bemerkungArea), 7);
            builder.nextLine();
            builder.appendSeparator("Anlagen-Chronologie");
            builder.appendRow("3dlu");
            builder.appendRow("fill:40dlu:grow");
            builder.nextLine(2);
            builder.append((Component)new JScrollPane(this.anlagenChronoTabelle), 7);
            this.datenAbfuellflaechenTab = builder.getPanel();
        }
        return this.datenAbfuellflaechenTab;
    }

    private JPanel getAusfuehrungAbfuellflaechenTab() {
        if (this.ausfuehrungAbfuellflaechenTab == null) {
            FormLayout layout = new FormLayout("r:p, 3dlu, f:p:g, 10dlu, r:p, 3dlu, f:p:g");
            layout.setColumnGroups((int[][])new int[][]{{1, 5}, {3, 7}});
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.setDefaultDialogBorder();
            builder.appendSeparator("Daten");
            builder.append("Bodenfl\u00e4chenausf\u00fchrung:", (Component)this.bodenflaechenAusfBox);
            builder.append("Fugenmaterial:", (Component)this.fugenMaterialFeld);
            builder.append("Dicke [cm]:", (Component)this.dickeFeld);
            builder.append("Niederschlagsschutz:", (Component)this.niederschlagSchutzBox);
            builder.append("G\u00fcte:", (Component)this.gueteFeld);
            builder.append("", (Component)this.abscheiderVorhandenCheck);
            builder.appendSeparator("Beschreibung Bodenfl\u00e4che");
            builder.appendRow("3dlu");
            builder.appendRow("fill:25dlu:grow");
            builder.nextLine(2);
            builder.append((Component)new JScrollPane(this.beschrBodenflaecheArea), 7);
            builder.nextLine();
            builder.appendSeparator("Beschreibung Fugenmaterial");
            builder.appendRow("3dlu");
            builder.appendRow("fill:25dlu:grow");
            builder.nextLine(2);
            builder.append((Component)new JScrollPane(this.beschrFugenmaterialArea), 7);
            builder.nextLine();
            builder.appendSeparator("Beschreibung Ableitung / Niederschlagswasser");
            builder.appendRow("3dlu");
            builder.appendRow("fill:25dlu:grow");
            builder.nextLine(2);
            builder.append((Component)new JScrollPane(this.beschrAblNiederschlArea), 7);
            this.ausfuehrungAbfuellflaechenTab = builder.getPanel();
        }
        return this.ausfuehrungAbfuellflaechenTab;
    }

    private JPanel getSvPruefungTab() {
        if (this.svPruefungTab == null) {
            FormLayout layout = new FormLayout("f:p:g");
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.setDefaultDialogBorder();
            builder.appendRow("fill:25dlu:grow");
            builder.append((Component)new JScrollPane(this.svPruefungTabelle));
            this.svPruefungTab = builder.getPanel();
        }
        return this.svPruefungTab;
    }

    private JPanel getVerwVerfahrenTab() {
        if (this.verwVerfahrenTab == null) {
            FormLayout layout = new FormLayout("f:p:g");
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.setDefaultDialogBorder();
            builder.appendRow("fill:25dlu:grow");
            builder.append((Component)new JScrollPane(this.verwVerfahrenTabelle));
            this.verwVerfahrenTab = builder.getPanel();
        }
        return this.verwVerfahrenTab;
    }

    private JPanel getVerwGebuehrenTab() {
        if (this.verwGebuehrenTab == null) {
            FormLayout layout = new FormLayout("f:p:g");
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.setDefaultDialogBorder();
            builder.appendRow("fill:25dlu:grow");
            builder.append((Component)new JScrollPane(this.verwGebuehrenTabelle));
            this.verwGebuehrenTab = builder.getPanel();
        }
        return this.verwGebuehrenTab;
    }
}

