/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.common.editors;

import de.bielefeld.umweltamt.aui.mappings.vaws.VawsAnlagenchrono;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsFachdaten;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.EditableListTableModel;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

class VawsAnlagenChronoModel
extends EditableListTableModel {
    private List geloeschte = new ArrayList();
    private VawsFachdaten fachdaten;

    public VawsAnlagenChronoModel() {
        super(new String[]{"Datum", "Sachverhalt", "Wiedervorlage"}, false, true);
    }

    public void setFachdaten(VawsFachdaten fachdaten) {
        this.fachdaten = fachdaten;
        if (fachdaten != null) {
            this.setList(VawsAnlagenchrono.getAnlagenChrono(fachdaten));
            this.fireTableDataChanged();
        }
    }

    @Override
    public void editObject(Object objectAtRow, int columnIndex, Object newValue) {
        VawsAnlagenchrono chrono = (VawsAnlagenchrono)objectAtRow;
        String tmp = (String)newValue;
        DateFormat format = DateFormat.getDateInstance(3);
        switch (columnIndex) {
            case 0: {
                try {
                    Date tmpDate = format.parse(tmp);
                    chrono.setDatum(tmpDate);
                }
                catch (ParseException e) {}
                break;
            }
            case 1: {
                if (tmp.length() > 255) {
                    tmp = tmp.substring(0, 255);
                }
                chrono.setSachverhalt(tmp);
                break;
            }
            case 2: {
                if ("".equals(tmp)) {
                    chrono.setWv(null);
                    break;
                }
                try {
                    Date tmpDate = format.parse(tmp);
                    chrono.setWv(tmpDate);
                }
                catch (ParseException e) {}
                break;
            }
        }
    }

    @Override
    public Object newObject() {
        VawsAnlagenchrono chr = new VawsAnlagenchrono();
        chr.setVawsFachdaten(this.fachdaten);
        chr.setDatum(new Date());
        return chr;
    }

    @Override
    public boolean objectRemoved(Object objectAtRow) {
        VawsAnlagenchrono chrono = (VawsAnlagenchrono)objectAtRow;
        if (chrono.getId() != null) {
            this.geloeschte.add(chrono);
        }
        return true;
    }

    public List getGeloeschte() {
        return this.geloeschte;
    }

    @Override
    public Object getColumnValue(Object objectAtRow, int columnIndex) {
        String tmp;
        VawsAnlagenchrono ac = (VawsAnlagenchrono)objectAtRow;
        switch (columnIndex) {
            case 0: {
                tmp = AuikUtils.getStringFromDate(ac.getDatum());
                break;
            }
            case 1: {
                tmp = ac.getSachverhalt();
                break;
            }
            case 2: {
                tmp = AuikUtils.getStringFromDate(ac.getWv());
                break;
            }
            default: {
                tmp = "ERROR";
            }
        }
        return tmp;
    }

    public VawsAnlagenchrono getDatenSatz(int row) {
        return (VawsAnlagenchrono)this.getObjectAtRow(row);
    }

    @Override
    public void updateList() {
    }
}

