/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.common.editors;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisGemarkung;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisStandort;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisStrassen;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsStandortgghwsg;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsWassereinzugsgebiete;
import de.bielefeld.umweltamt.aui.module.common.editors.AbstractBaseEditor;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.DoubleField;
import de.bielefeld.umweltamt.aui.utils.IntegerField;
import de.bielefeld.umweltamt.aui.utils.LimitedTextField;
import de.bielefeld.umweltamt.aui.utils.SearchBox;
import de.bielefeld.umweltamt.aui.utils.SwingWorkerVariant;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.hibernate.HibernateException;

public class StandortEditor
extends AbstractBaseEditor {
    private static String[] strassen = null;
    private static BasisGemarkung[] gemarkungen = null;
    private static VawsStandortgghwsg[] standortggs = null;
    private static String[] entwgebiete = null;
    private static VawsWassereinzugsgebiete[] wEinzugsgebiete = null;
    private JFormattedTextField hausnrEditFeld;
    private JTextField hausnrZusFeld;
    private JTextField plzFeld;
    private JTextField flurFeld;
    private JTextField flurStkFeld;
    private JFormattedTextField rechtsWFeld;
    private JFormattedTextField hochWFeld;
    private JButton ausAblageButton;
    private JTextField datumFeld;
    private JLabel handzeichenLabel;
    private JTextField handzeichenAltFeld;
    private JTextField handzeichenNeuFeld;
    private JTextField sachbe33ravFeld;
    private JTextField sachbe33heeFeld;
    private JFormattedTextField wassermengeFeld;
    private JComboBox strassenBox;
    private JComboBox gemarkungBox;
    private JComboBox standortGgBox;
    private JComboBox entwGebBox;
    private JComboBox wEinzugsGebBox;

    public StandortEditor(BasisStandort bsta, HauptFrame owner) {
        super("Standort (" + bsta.getStandortid() + ")", bsta, owner);
    }

    @Override
    protected JComponent buildContentArea() {
        this.strassenBox = new SearchBox();
        this.hausnrEditFeld = new IntegerField();
        this.hausnrZusFeld = new JTextField();
        this.plzFeld = new LimitedTextField(10, "");
        this.flurFeld = new LimitedTextField(50);
        this.flurStkFeld = new LimitedTextField(50);
        this.sachbe33ravFeld = new LimitedTextField(50);
        this.sachbe33heeFeld = new LimitedTextField(50);
        this.wassermengeFeld = new IntegerField();
        this.rechtsWFeld = new DoubleField(1);
        this.hochWFeld = new DoubleField(1);
        this.datumFeld = new JTextField();
        this.datumFeld.setEditable(false);
        this.datumFeld.setFocusable(false);
        this.datumFeld.setToolTipText("Wird bei \u00c4nderungen automatisch aktualisiert.");
        this.handzeichenLabel = new JLabel("Handzeichen:");
        this.handzeichenAltFeld = new JTextField();
        this.handzeichenAltFeld.setEditable(false);
        this.handzeichenAltFeld.setFocusable(false);
        this.handzeichenAltFeld.setToolTipText("Handzeichen der letzten Revision");
        this.handzeichenNeuFeld = new LimitedTextField(10);
        this.handzeichenNeuFeld.setToolTipText("Neues Handzeichen bei \u00c4nderungen obligatorisch!");
        this.gemarkungBox = new JComboBox();
        this.standortGgBox = new JComboBox();
        this.entwGebBox = new JComboBox();
        this.entwGebBox.setEditable(true);
        this.wEinzugsGebBox = new JComboBox();
        KeyAdapter escEnterListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getSource().equals(StandortEditor.this.handzeichenNeuFeld) && e.getKeyCode() == 10) {
                    if (StandortEditor.this.handzeichenNeuFeld.getText().equals("")) {
                        StandortEditor.this.handzeichenLabel.setForeground(HauptFrame.ERROR_COLOR);
                        StandortEditor.this.handzeichenNeuFeld.requestFocus();
                    } else {
                        StandortEditor.this.button1.requestFocus();
                    }
                }
                if (e.getKeyCode() == 27) {
                    StandortEditor.this.doCancel();
                }
            }
        };
        this.strassenBox.addKeyListener(escEnterListener);
        this.hausnrEditFeld.addKeyListener(escEnterListener);
        this.hausnrZusFeld.addKeyListener(escEnterListener);
        this.plzFeld.addKeyListener(escEnterListener);
        this.gemarkungBox.addKeyListener(escEnterListener);
        this.standortGgBox.addKeyListener(escEnterListener);
        this.entwGebBox.addKeyListener(escEnterListener);
        this.wEinzugsGebBox.addKeyListener(escEnterListener);
        this.flurFeld.addKeyListener(escEnterListener);
        this.flurStkFeld.addKeyListener(escEnterListener);
        this.rechtsWFeld.addKeyListener(escEnterListener);
        this.hochWFeld.addKeyListener(escEnterListener);
        this.handzeichenNeuFeld.addKeyListener(escEnterListener);
        this.sachbe33ravFeld.addKeyListener(escEnterListener);
        this.sachbe33heeFeld.addKeyListener(escEnterListener);
        this.wassermengeFeld.addKeyListener(escEnterListener);
        String linkeSpalten = "r:p, 3dlu, 50dlu:g, 3dlu, 50dlu:g, 5dlu, 20dlu:g(0.2), 3dlu, 15dlu:g(0.2)";
        String rechteSpalten = "r:p, 3dlu, 50dlu:g, 3dlu, 50dlu:g";
        int rS = 10;
        FormLayout layout = new FormLayout(linkeSpalten + ", 10dlu, " + rechteSpalten, "pref, 3dlu, pref, 3dlu, pref, 10dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 10dlu, pref, 3dlu, pref, 3dlu, pref, 10dlu, pref, 3dlu, pref, 10dlu, bottom:pref:grow");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.addSeparator("Stammdaten", cc.xyw(1, 1, 9));
        builder.addLabel("Stra\u00dfe:", cc.xy(1, 3));
        builder.add((Component)this.strassenBox, cc.xyw(3, 3, 3));
        builder.add((Component)this.hausnrEditFeld, cc.xy(7, 3));
        builder.add((Component)this.hausnrZusFeld, cc.xy(9, 3));
        builder.addLabel("PLZ:", cc.xy(1, 5));
        builder.add((Component)this.plzFeld, cc.xy(3, 5));
        builder.addLabel("Rechtswert:", cc.xy(1, 7));
        builder.add((Component)this.rechtsWFeld, cc.xy(3, 7));
        builder.addLabel("Hochwert:", cc.xy(1, 9));
        builder.add((Component)this.hochWFeld, cc.xy(3, 9));
        builder.add((Component)this.getAusAblageButton(), cc.xywh(5, 7, 1, 3));
        builder.addLabel("Gemarkung:", cc.xy(1, 11));
        builder.add((Component)this.gemarkungBox, cc.xyw(3, 11, 3));
        builder.addLabel("Entw\u00e4sserungsgebiet:", cc.xy(1, 13));
        builder.add((Component)this.entwGebBox, cc.xyw(3, 13, 3));
        builder.addLabel("Flur:", cc.xy(1, 15));
        builder.add((Component)this.flurFeld, cc.xy(3, 15));
        builder.addLabel("Flurst\u00fcck:", cc.xy(1, 17));
        builder.add((Component)this.flurStkFeld, cc.xy(3, 17));
        builder.addSeparator("VAWS", cc.xyw(1 + rS, 1, 5));
        builder.addLabel("Standortgegebenheit:", cc.xy(1 + rS, 3));
        builder.add((Component)this.standortGgBox, cc.xyw(3 + rS, 3, 3));
        builder.addLabel("W.Einzugsgebiet:", cc.xy(1 + rS, 5));
        builder.add((Component)this.wEinzugsGebBox, cc.xyw(3 + rS, 5, 3));
        builder.addSeparator("Indirekteinleiter", cc.xyw(1 + rS, 9, 5));
        builder.addLabel("Sachbearbeiter Rav.:", cc.xy(1 + rS, 11));
        builder.add((Component)this.sachbe33ravFeld, cc.xyw(3 + rS, 11, 3));
        builder.addLabel("Sachbearbeiter Heepen:", cc.xy(1 + rS, 13));
        builder.add((Component)this.sachbe33heeFeld, cc.xyw(3 + rS, 13, 3));
        builder.addLabel("Wasserverbrauch:", cc.xy(1 + rS, 15));
        builder.add((Component)this.wassermengeFeld, cc.xyw(3 + rS, 15, 3));
        builder.addSeparator("Letzte Revision", cc.xyw(1, 19, 5));
        builder.addLabel("Datum:", cc.xy(1, 21));
        builder.add((Component)this.datumFeld, cc.xyw(3, 21, 3));
        builder.addLabel("Handzeichen:", cc.xy(1, 23));
        builder.add((Component)this.handzeichenAltFeld, cc.xyw(3, 23, 3));
        builder.addSeparator("Neue Revision", cc.xyw(1 + rS, 19, 5));
        builder.add((Component)this.handzeichenLabel, cc.xy(1 + rS, 21));
        builder.add((Component)this.handzeichenNeuFeld, cc.xyw(3 + rS, 21, 3));
        this.strassenBox.addActionListener(new ActionListener(){
            private int strassenCounter = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == StandortEditor.this.strassenBox) {
                    BasisStrassen stra;
                    if ((StandortEditor.this.plzFeld.getText().equals("") || this.strassenCounter > 0) && (stra = BasisStrassen.getStrasseByName((String)StandortEditor.this.strassenBox.getSelectedItem())) != null) {
                        if (stra.getPlz() != null) {
                            StandortEditor.this.frame.clearStatus();
                            StandortEditor.this.plzFeld.setText(stra.getPlz().toString());
                        } else {
                            StandortEditor.this.frame.changeStatus("Die Stra\u00dfe '" + stra + "' hat keine eindeutige PLZ, bitte selbst eintragen!");
                            StandortEditor.this.plzFeld.setText("");
                        }
                    }
                    ++this.strassenCounter;
                }
            }
        });
        return builder.getPanel();
    }

    @Override
    protected void fillForm() {
        this.frame.changeStatus("Besch\u00e4ftigt...");
        SwingWorkerVariant worker = new SwingWorkerVariant(this){

            @Override
            protected void doNonUILogic() throws RuntimeException {
                try {
                    if (strassen == null) {
                        StandortEditor.access$802(BasisStrassen.getStrassen());
                    }
                    if (gemarkungen == null) {
                        StandortEditor.access$902(BasisGemarkung.getGemarkungen());
                    }
                    if (standortggs == null) {
                        StandortEditor.access$1002(VawsStandortgghwsg.getStandortGg());
                    }
                    if (entwgebiete == null) {
                        StandortEditor.access$1102(BasisStandort.getEntwGebiete());
                    }
                    if (wEinzugsgebiete == null) {
                        StandortEditor.access$1202(VawsWassereinzugsgebiete.getWEinzugsgebiete());
                    }
                }
                catch (HibernateException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            protected void doUIUpdateLogic() throws RuntimeException {
                if (strassen != null) {
                    StandortEditor.this.strassenBox.setModel(new DefaultComboBoxModel<String>(strassen));
                    StandortEditor.this.strassenBox.setSelectedItem(StandortEditor.this.getStandort().getStrasse());
                }
                if (gemarkungen != null) {
                    StandortEditor.this.gemarkungBox.setModel(new DefaultComboBoxModel<BasisGemarkung>(gemarkungen));
                    StandortEditor.this.gemarkungBox.setSelectedItem(StandortEditor.this.getStandort().getBasisGemarkung());
                }
                if (standortggs != null) {
                    StandortEditor.this.standortGgBox.setModel(new DefaultComboBoxModel<VawsStandortgghwsg>(standortggs));
                    StandortEditor.this.standortGgBox.setSelectedItem(StandortEditor.this.getStandort().getVawsStandortgghwsg());
                }
                if (entwgebiete != null) {
                    StandortEditor.this.entwGebBox.setModel(new DefaultComboBoxModel<String>(entwgebiete));
                    StandortEditor.this.entwGebBox.setSelectedItem(StandortEditor.this.getStandort().getEntgebid());
                }
                if (wEinzugsgebiete != null) {
                    StandortEditor.this.wEinzugsGebBox.setModel(new DefaultComboBoxModel<VawsWassereinzugsgebiete>(wEinzugsgebiete));
                    StandortEditor.this.wEinzugsGebBox.setSelectedItem(StandortEditor.this.getStandort().getVawsWassereinzugsgebiete());
                }
                StandortEditor.this.hausnrEditFeld.setValue(StandortEditor.this.getStandort().getHausnr());
                StandortEditor.this.hausnrZusFeld.setText(StandortEditor.this.getStandort().getHausnrzus());
                if (StandortEditor.this.getStandort().getPlz() != null) {
                    StandortEditor.this.plzFeld.setText(StandortEditor.this.getStandort().getPlz());
                }
                StandortEditor.this.flurFeld.setText(StandortEditor.this.getStandort().getFlur());
                StandortEditor.this.flurStkFeld.setText(StandortEditor.this.getStandort().getFlurstueck());
                StandortEditor.this.rechtsWFeld.setValue(StandortEditor.this.getStandort().getRechtswert());
                StandortEditor.this.hochWFeld.setValue(StandortEditor.this.getStandort().getHochwert());
                Date datum = StandortEditor.this.getStandort().getRevidatum();
                StandortEditor.this.datumFeld.setText(AuikUtils.getStringFromDate(datum));
                StandortEditor.this.handzeichenAltFeld.setText(StandortEditor.this.getStandort().getRevihandz());
                StandortEditor.this.sachbe33ravFeld.setText(StandortEditor.this.getStandort().getSachbe33rav());
                StandortEditor.this.sachbe33heeFeld.setText(StandortEditor.this.getStandort().getSachbe33hee());
                StandortEditor.this.wassermengeFeld.setValue(StandortEditor.this.getStandort().getWassermenge());
                StandortEditor.this.frame.clearStatus();
            }
        };
        worker.start();
    }

    @Override
    protected boolean canSave() {
        if (this.handzeichenNeuFeld.getText() == null || this.handzeichenNeuFeld.getText().equals("")) {
            this.handzeichenLabel.setForeground(HauptFrame.ERROR_COLOR);
            this.handzeichenNeuFeld.requestFocus();
            this.frame.changeStatus("Neues Handzeichen erforderlich!", HauptFrame.ERROR_COLOR);
            return false;
        }
        return true;
    }

    @Override
    protected boolean doSave() {
        String sachhee;
        String flurstk;
        String stra = (String)this.strassenBox.getSelectedItem();
        this.getStandort().setStrasse(stra);
        Integer hausnr = ((IntegerField)this.hausnrEditFeld).getIntValue();
        this.getStandort().setHausnr(hausnr);
        String hausnrZus = this.hausnrZusFeld.getText();
        if ("".equals(hausnrZus)) {
            this.getStandort().setHausnrzus(null);
        } else {
            this.getStandort().setHausnrzus(hausnrZus);
        }
        String plz = this.plzFeld.getText().trim();
        if ("".equals(plz)) {
            this.getStandort().setPlz(null);
        } else {
            this.getStandort().setPlz(plz);
        }
        BasisGemarkung bgem = (BasisGemarkung)this.gemarkungBox.getSelectedItem();
        this.getStandort().setBasisGemarkung(bgem);
        VawsStandortgghwsg stgg = (VawsStandortgghwsg)this.standortGgBox.getSelectedItem();
        this.getStandort().setVawsStandortgghwsg(stgg);
        String entgb = (String)this.entwGebBox.getSelectedItem();
        if (entgb != null) {
            entgb = entgb.trim();
        }
        if ("".equals(entgb)) {
            this.getStandort().setEntgebid(null);
        } else {
            this.getStandort().setEntgebid(entgb);
        }
        VawsWassereinzugsgebiete wezg = (VawsWassereinzugsgebiete)this.wEinzugsGebBox.getSelectedItem();
        this.getStandort().setVawsWassereinzugsgebiete(wezg);
        String flur = this.flurFeld.getText();
        if (flur != null) {
            if ((flur = flur.trim()).equals("")) {
                this.getStandort().setFlur(null);
            } else {
                this.getStandort().setFlur(flur);
            }
        }
        if ((flurstk = this.flurStkFeld.getText()) != null) {
            if (flurstk.equals("")) {
                this.getStandort().setFlurstueck(null);
            } else {
                this.getStandort().setFlurstueck(flurstk);
            }
        }
        Float rechtsWert = ((DoubleField)this.rechtsWFeld).getFloatValue();
        this.getStandort().setRechtswert(rechtsWert);
        Float hochWert = ((DoubleField)this.hochWFeld).getFloatValue();
        this.getStandort().setHochwert(hochWert);
        String handzeichen = this.handzeichenNeuFeld.getText().trim();
        this.getStandort().setRevihandz(handzeichen);
        this.getStandort().setRevidatum(new Date());
        String sachrav = this.sachbe33ravFeld.getText();
        if (sachrav != null) {
            if (sachrav.equals("")) {
                this.getStandort().setSachbe33rav(null);
            } else {
                this.getStandort().setSachbe33rav(sachrav);
            }
        }
        if ((sachhee = this.sachbe33heeFeld.getText()) != null) {
            if (sachhee.equals("")) {
                this.getStandort().setSachbe33hee(null);
            } else {
                this.getStandort().setSachbe33hee(sachhee);
            }
        }
        Integer wassermng = ((IntegerField)this.wassermengeFeld).getIntValue();
        this.getStandort().setWassermenge(wassermng);
        BasisStandort bsta = BasisStandort.saveStandort(this.getStandort());
        if (bsta != null) {
            this.setEditedObject(bsta);
            AUIKataster.debugOutput("\u00c4nderungen gespeichert!", "editStandort");
            return true;
        }
        return false;
    }

    public BasisStandort getStandort() {
        return (BasisStandort)this.getEditedObject();
    }

    private void readClipboard() {
        Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferData = systemClipboard.getContents(null);
        for (DataFlavor dataFlavor : transferData.getTransferDataFlavors()) {
            Object content = null;
            try {
                content = transferData.getTransferData(dataFlavor);
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!(content instanceof String)) continue;
            String[] tmp = content.toString().split(",");
            if (tmp.length == 4) {
                String rechtswertAusZeile = tmp[2];
                String hochwertAusZeile = tmp[3];
                this.rechtsWFeld.setText(rechtswertAusZeile.substring(0, 7));
                this.hochWFeld.setText(hochwertAusZeile.substring(0, 7));
                this.frame.changeStatus("Rechts- und Hochwert eingetragen", HauptFrame.SUCCESS_COLOR);
                break;
            }
            this.frame.changeStatus("Zwischenablage enth\u00e4lt keine verwertbaren Daten", HauptFrame.ERROR_COLOR);
            break;
        }
    }

    public JButton getAusAblageButton() {
        if (this.ausAblageButton == null) {
            this.ausAblageButton = new JButton("aus QGis");
            this.ausAblageButton.setToolTipText("Rechts- und Hochwert aus Zwischenablage einf\u00fcgen");
            this.ausAblageButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StandortEditor.this.readClipboard();
                }
            });
        }
        return this.ausAblageButton;
    }

    static /* synthetic */ String[] access$802(String[] x0) {
        strassen = x0;
        return x0;
    }

    static /* synthetic */ BasisGemarkung[] access$902(BasisGemarkung[] x0) {
        gemarkungen = x0;
        return x0;
    }

    static /* synthetic */ VawsStandortgghwsg[] access$1002(VawsStandortgghwsg[] x0) {
        standortggs = x0;
        return x0;
    }

    static /* synthetic */ String[] access$1102(String[] x0) {
        entwgebiete = x0;
        return x0;
    }

    static /* synthetic */ VawsWassereinzugsgebiete[] access$1202(VawsWassereinzugsgebiete[] x0) {
        wEinzugsgebiete = x0;
        return x0;
    }
}

