/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.common.editors;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlAnalyseposition;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlEinheiten;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlParameter;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlParameterGruppen;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbeart;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbenahmen;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlStatus;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisBetreiber;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisSachbearbeiter;
import de.bielefeld.umweltamt.aui.module.common.editors.AbstractApplyEditor;
import de.bielefeld.umweltamt.aui.module.common.editors.ParameterChooser;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.ComboBoxRenderer;
import de.bielefeld.umweltamt.aui.utils.CurrencyDouble;
import de.bielefeld.umweltamt.aui.utils.DateUtils;
import de.bielefeld.umweltamt.aui.utils.DoubleField;
import de.bielefeld.umweltamt.aui.utils.DoubleRenderer;
import de.bielefeld.umweltamt.aui.utils.JRMapDataSource;
import de.bielefeld.umweltamt.aui.utils.KommaDouble;
import de.bielefeld.umweltamt.aui.utils.LimitedTextArea;
import de.bielefeld.umweltamt.aui.utils.PDFExporter;
import de.bielefeld.umweltamt.aui.utils.SelectTable;
import de.bielefeld.umweltamt.aui.utils.TextFieldDateChooser;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.EditableListTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class ProbenEditor
extends AbstractApplyEditor {
    public static final double PERSONAL_UND_SACHKOSTEN = 40.99;
    public static final int ZIFFERN_RECHNUNGS_FELD = 19;
    public static final String KASSE_FILENAME = "kasse.txt";
    private Dimension minimumSize;
    private JComboBox vorgangsstatus;
    private JButton statusHoch;
    private TextFieldDateChooser datum;
    private JFormattedTextField uhrzeitVon;
    private JFormattedTextField uhrzeitBis;
    private JFormattedTextField fahrtzeit;
    private JTextField bezug;
    private JTextField beteiligte;
    private JTextField probenummer;
    private JLabel rechnungsDatum;
    private JLabel rechnungsBetrag;
    private JTextArea bemerkungsArea;
    private JComboBox sachbearbeiter;
    private JTextField bescheidDatei;
    private JButton bescheidWahl;
    private JButton bescheidDrucken;
    private JTextField auftragDatei;
    private JButton auftragWahl;
    private JButton auftragDrucken;
    private JFileChooser dateiChooser;
    private JLabel betrieb;
    private JLabel entnahmepunkt;
    private JFormattedTextField icpEinwaageFeld;
    private TextFieldDateChooser icpDatum;
    private JTable parameterTabelle;
    private JComboBox parameterBox;
    private JComboBox einheitenBox;
    private ParameterModel parameterModel;
    private boolean isNew;

    public ProbenEditor(AtlProbenahmen probe, HauptFrame owner, boolean isNew) {
        super("Probenahme " + probe.getKennummer(), probe, owner);
        this.isNew = isNew;
        if (!isNew) {
            this.setEditedObject(AtlProbenahmen.getProbenahme(probe.getId(), true));
        }
        this.parameterModel = new ParameterModel(this.getProbe(), isNew);
        this.parameterTabelle.setModel(this.parameterModel);
        this.initColumns();
    }

    @Override
    protected JComponent buildContentArea() {
        NumberFormat nf = NumberFormat.getCurrencyInstance(Locale.GERMANY);
        SimpleDateFormat f = new SimpleDateFormat("HH:mm");
        this.entnahmepunkt = new JLabel();
        this.datum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        this.rechnungsDatum = new JLabel();
        this.uhrzeitVon = new JFormattedTextField(f);
        this.uhrzeitBis = new JFormattedTextField(f);
        this.fahrtzeit = new JFormattedTextField(f);
        this.rechnungsBetrag = new JLabel();
        this.bezug = new JTextField();
        this.beteiligte = new JTextField();
        this.probenummer = new JTextField();
        this.vorgangsstatus = new JComboBox();
        this.statusHoch = new JButton("erh\u00f6hen");
        this.sachbearbeiter = new JComboBox();
        this.bescheidDatei = new JTextField();
        this.bescheidWahl = new JButton("Ausw\u00e4hlen");
        this.bescheidDrucken = new JButton("Speichern und Drucken");
        this.auftragDatei = new JTextField();
        this.auftragWahl = new JButton("Ausw\u00e4hlen");
        this.auftragDrucken = new JButton("Speichern und Drucken");
        this.dateiChooser = new JFileChooser();
        this.icpEinwaageFeld = new DoubleField(0);
        this.icpDatum = new TextFieldDateChooser(AuikUtils.DATUMSFORMATE);
        this.bemerkungsArea = new LimitedTextArea(255);
        this.betrieb = new JLabel();
        this.parameterTabelle = new SelectTable();
        String[] bezeichnungen = AtlStatus.getStatusAsString();
        DefaultComboBoxModel<String> comboModel = new DefaultComboBoxModel<String>(bezeichnungen);
        this.vorgangsstatus.setModel(comboModel);
        BasisSachbearbeiter[] bSachbearbeiter = BasisSachbearbeiter.getSachbearbeiter();
        this.sachbearbeiter.setModel(new DefaultComboBoxModel<BasisSachbearbeiter>(bSachbearbeiter));
        this.dateiChooser.addChoosableFileFilter(new FileNameExtensionFilter("PDF Dateien", "pdf"));
        this.bescheidDatei.setEnabled(false);
        this.auftragDatei.setEnabled(false);
        this.statusHoch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AtlStatus current = ProbenEditor.this.getVorgangsstatus();
                if (current == null) {
                    return;
                }
                AtlStatus next = AtlStatus.getStatus(current.getId() + 1);
                if (next == null) {
                    return;
                }
                ProbenEditor.this.updateVorgangsstatus(next.getBezeichnung());
            }
        });
        this.auftragWahl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProbenEditor.this.openFileChooser(ProbenEditor.this.auftragDatei);
            }
        });
        this.bescheidWahl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProbenEditor.this.openFileChooser(ProbenEditor.this.bescheidDatei);
            }
        });
        this.auftragDrucken.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AtlProbenahmen probe = ProbenEditor.this.getProbe();
                ProbenEditor.this.doSave();
                Map params = ProbenEditor.this.getAuftragDruckMap(probe);
                String path = ProbenEditor.this.auftragDatei.getText();
                if (path == null || path.equals("")) {
                    ProbenEditor.this.frame.showErrorMessage("Bitte geben Sie den Pfad zum Speichern des PDFs an.", "Pfad zum Speichern fehlt");
                    return;
                }
                params.put("localFile", path);
                try {
                    JRMapDataSource subdata = AtlProbenahmen.getAuftragDataSource(probe);
                    AUIKataster.debugOutput(this.getClass().getName(), "F\u00fclle Probenahmeauftrag mit " + subdata.size() + " Zeilen.");
                    PDFExporter.getInstance().exportAuftrag(params, subdata, path, true);
                    String gedruckt = ProbenEditor.this.updateVorgangsstatus("Probenahmeauftrag gedruckt");
                    probe.setAtlStatus(AtlStatus.getStatus(gedruckt));
                    AtlProbenahmen.updateProbenahme(probe);
                    ProbenEditor.this.frame.showInfoMessage("Der Probenahmeauftrag wurde erfolgreich gedruckt und \nunter '" + path + "' gespeichert.", "Probenahmeauftrag erfolgreich");
                }
                catch (Exception ex) {
                    AUIKataster.errorOutput("Druck schlug fehlt: " + ex.getMessage(), this.getClass().getName());
                    ProbenEditor.this.frame.showErrorMessage("Der Druck des Probenahmeauftrags ist fehlgeschlagen.\n" + ex.getLocalizedMessage(), "Probenahmeauftrag-Druck fehlgeschlagen");
                }
            }
        });
        this.bescheidDrucken.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AtlProbenahmen probe = ProbenEditor.this.getProbe();
                String path = ProbenEditor.this.bescheidDatei.getText();
                if (path == null || path.equals("")) {
                    ProbenEditor.this.frame.showErrorMessage("Bitte geben Sie den Pfad zum Speichern des PDFs an.", "Pfad zum Speichern fehlt");
                    return;
                }
                try {
                    ProbenEditor.this.updateRechnungsdatum(probe);
                    ProbenEditor.this.doSave();
                    ProbenEditor.this.updateRechnungsbetrag(probe);
                    Map params = ProbenEditor.this.getBescheidDruckMap(probe);
                    JRMapDataSource subdata = AtlProbenahmen.getBescheidDataSource(probe);
                    PDFExporter.getInstance().exportBescheid(params, subdata, path, true);
                    AtlStatus currentStatus = ProbenEditor.this.getVorgangsstatus();
                    String currentBez = currentStatus.getBezeichnung();
                    currentBez = currentBez.trim();
                    if (!currentBez.equals("Bescheid gedruckt")) {
                        AUIKataster.debugOutput(this.getClass().getName(), "Erstelle kasse.txt f\u00fcr Geb\u00fchrenbescheid.");
                        try {
                            ProbenEditor.this.createKasseFile(path);
                        }
                        catch (ParseException pe) {
                            pe.printStackTrace();
                            ProbenEditor.this.frame.showErrorMessage("Der Druck des Geb\u00fchrenbescheids ist fehlgeschlagen.Die Datei kasse.txt konnte nicht erstellt werden.", "Geb\u00fchrenbescheid-Druck fehlgeschlagen");
                            return;
                        }
                    }
                    String gedruckt = ProbenEditor.this.updateVorgangsstatus("Bescheid gedruckt");
                    probe.setAtlStatus(AtlStatus.getStatus(gedruckt));
                    AtlProbenahmen.updateProbenahme(probe);
                    ProbenEditor.this.frame.showInfoMessage("Der Geb\u00fchrenbescheid wurde erfolgreich gedruckt und \nunter '" + path + "' gespeichert.", "Geb\u00fchrenbescheid erfolgreich");
                }
                catch (Exception ex) {
                    AUIKataster.errorOutput("Druck schlug fehlt.", this.getClass().getName());
                    ex.printStackTrace();
                    ProbenEditor.this.frame.showErrorMessage("Der Druck des Geb\u00fchrenbescheids ist fehlgeschlagen.\n" + ex.getLocalizedMessage(), "Geb\u00fchrenbescheid-Druck fehlgeschlagen");
                }
            }
        });
        this.bemerkungsArea.setLineWrap(true);
        this.bemerkungsArea.setWrapStyleWord(true);
        JScrollPane bemerkungsScroller = new JScrollPane(this.bemerkungsArea, 20, 31);
        bemerkungsScroller.setPreferredSize(new Dimension(0, 50));
        this.parameterTabelle.setRowHeight(20);
        AbstractAction aposRemoveAction = new AbstractAction("Analyseposition l\u00f6schen"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ProbenEditor.this.parameterTabelle.getSelectedRow();
                if (row != -1 && ProbenEditor.this.parameterTabelle.getEditingRow() == -1) {
                    ProbenEditor.this.parameterModel.removeRow(row);
                }
            }
        };
        KeyStroke deleteKeyStroke = KeyStroke.getKeyStroke(127, 0, false);
        aposRemoveAction.putValue("AcceleratorKey", deleteKeyStroke);
        this.parameterTabelle.getInputMap().put(deleteKeyStroke, aposRemoveAction.getValue("Name"));
        this.parameterTabelle.getActionMap().put(aposRemoveAction.getValue("Name"), aposRemoveAction);
        JScrollPane parameterScroller = new JScrollPane(this.parameterTabelle, 20, 31);
        FormLayout layout = new FormLayout("70dlu, 50dlu, 30dlu, 5dlu, 30dlu, 5dlu, 60dlu, 5dlu, 60dlu, 50dlu, 5dlu, 50dlu", "pref, 8dlu, pref, 8dlu, pref, 8dlu, pref, 8dlu, pref, 8dlu,pref, 8dlu, pref, 8dlu, pref, 8dlu, pref, 8dlu, pref, 8dlu, pref, 16dlu,pref, 8dlu, pref, 16dlu, pref, 8dlu, pref, 16dlu, pref, 8dlu, 150dlu");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        int row = 1;
        builder.addSeparator("Probe", cc.xyw(1, row, 12));
        builder.addLabel("Probenummer:", cc.xyw(1, row += 2, 1));
        builder.add((Component)this.probenummer, cc.xyw(2, row, 4));
        builder.add((Component)new JLabel("Vorgangsstatus:"), cc.xyw(1, row += 2, 1));
        builder.add((Component)this.vorgangsstatus, cc.xyw(2, row, 4));
        builder.addLabel("", cc.xyw(1, row, 1));
        builder.add((Component)this.statusHoch, cc.xyw(7, row, 1));
        builder.addLabel("Sachbearbeiter:", cc.xyw(1, row += 2, 1));
        builder.add((Component)this.sachbearbeiter, cc.xyw(2, row, 4));
        builder.addLabel("Name des Betriebs:", cc.xyw(1, row += 2, 1));
        builder.add((Component)this.betrieb, cc.xyw(2, row, 8));
        builder.addLabel("Entnahmepunkt:", cc.xyw(1, row += 2, 1));
        builder.add((Component)this.entnahmepunkt, cc.xyw(2, row, 8));
        builder.add((Component)new JLabel("Datum:"), cc.xyw(1, row += 2, 1));
        builder.add((Component)this.datum, cc.xyw(2, row, 1));
        builder.addLabel("von:", cc.xyw(3, row, 1, CellConstraints.RIGHT, CellConstraints.CENTER));
        builder.addLabel("", cc.xyw(4, row, 1));
        builder.add((Component)this.uhrzeitVon, cc.xyw(5, row, 1));
        builder.addLabel("", cc.xyw(6, row, 1));
        builder.addLabel("bis:", cc.xyw(7, row, 1, CellConstraints.RIGHT, CellConstraints.CENTER));
        builder.addLabel("", cc.xyw(8, row, 1));
        builder.add((Component)this.uhrzeitBis, cc.xyw(9, row, 1));
        builder.addLabel("Fahrtzeit:", cc.xyw(10, row, 1, CellConstraints.RIGHT, CellConstraints.CENTER));
        builder.addLabel("", cc.xyw(11, row, 1));
        builder.add((Component)this.fahrtzeit, cc.xyw(12, row, 1));
        builder.addLabel("Bezug:", cc.xyw(1, row += 2, 1));
        builder.add((Component)this.bezug, cc.xyw(2, row, 4));
        builder.addLabel("", cc.xyw(6, row, 1));
        builder.addLabel("Beteiligte:", cc.xyw(7, row, 1, CellConstraints.RIGHT, CellConstraints.CENTER));
        builder.addLabel("", cc.xyw(8, row, 1));
        builder.add((Component)this.beteiligte, cc.xyw(9, row, 1));
        builder.addLabel("Rechnungsdatum:", cc.xyw(1, row += 2, 1));
        builder.add((Component)this.rechnungsDatum, cc.xyw(2, row, 2));
        builder.addLabel("Rechnungsbetrag:", cc.xyw(4, row, 4, CellConstraints.RIGHT, CellConstraints.CENTER));
        builder.addLabel("", cc.xyw(8, row, 1));
        builder.add((Component)this.rechnungsBetrag, cc.xyw(9, row, 1));
        builder.addLabel("Probenahmeauftrag:", cc.xyw(1, row += 2, 1));
        builder.add((Component)this.auftragDatei, cc.xyw(2, row, 4));
        builder.addLabel("", cc.xyw(1, row, 1));
        builder.add((Component)this.auftragWahl, cc.xyw(7, row, 1));
        builder.addLabel("", cc.xyw(8, row, 1));
        builder.add((Component)this.auftragDrucken, cc.xyw(9, row, 2));
        builder.addLabel("Geb\u00fchrenbescheid:", cc.xyw(1, row += 2, 1));
        builder.add((Component)this.bescheidDatei, cc.xyw(2, row, 4));
        builder.addLabel("", cc.xyw(1, row, 1));
        builder.add((Component)this.bescheidWahl, cc.xyw(7, row, 1));
        builder.addLabel("", cc.xyw(8, row, 1));
        builder.add((Component)this.bescheidDrucken, cc.xyw(9, row, 2));
        builder.addSeparator("ICP", cc.xyw(1, row += 2, 12));
        builder.addLabel("Einwaage:", cc.xyw(1, row += 2, 1));
        builder.add((Component)this.icpEinwaageFeld, cc.xyw(2, row, 1));
        builder.addLabel("Datum:", cc.xyw(3, row, 5, CellConstraints.RIGHT, CellConstraints.CENTER));
        builder.addLabel("", cc.xyw(8, row, 1));
        builder.add((Component)this.icpDatum, cc.xyw(9, row, 1));
        builder.addSeparator("Bemerkung", cc.xyw(1, row += 2, 12));
        builder.add((Component)bemerkungsScroller, cc.xyw(1, row += 2, 12));
        builder.addSeparator("Parameter", cc.xyw(1, row += 2, 12));
        builder.add((Component)parameterScroller, cc.xyw(1, row += 2, 12));
        return builder.getPanel();
    }

    protected void openFileChooser(JTextField datei) {
        this.dateiChooser.showSaveDialog(this);
        File file = this.dateiChooser.getSelectedFile();
        if (file != null) {
            AUIKataster.debugOutput("Speichere Datei unter: " + file.getAbsolutePath(), this.getClass().getName());
            datei.setText(file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createKasseFile(String bescheid) throws ParseException {
        File path = new File(bescheid).getParentFile();
        File kasse = new File(path, KASSE_FILENAME);
        AtlProbenahmen probe = this.getProbe();
        BasisBetreiber basisBetr = probe.getBasisBetreiber();
        Date rechnungsdatum = DateUtils.getDateOfBill(probe.getBescheid());
        CurrencyDouble cd = new CurrencyDouble(this.getRechnungsbetrag(probe), Locale.GERMANY);
        String rechnungsbetrag = cd.toString();
        rechnungsbetrag = rechnungsbetrag.replace("\u20ac", "");
        rechnungsbetrag = rechnungsbetrag.replace(",", "");
        rechnungsbetrag = rechnungsbetrag.trim();
        String kasseDatum = DateUtils.format(rechnungsdatum, "ddmmyyyy");
        StringBuilder sb = new StringBuilder();
        int fill = 19;
        fill -= kasseDatum.length();
        fill -= rechnungsbetrag.length();
        sb.append(basisBetr.getKassenzeichen() + "\t");
        sb.append(basisBetr.getBetrname() + "\t");
        sb.append(basisBetr.getBetriebsgrundstueck() + "\t");
        sb.append("Gebuehr fuer Abwasserunters.\t");
        sb.append(kasseDatum);
        for (int i = 1; i <= fill; ++i) {
            sb.append("0");
        }
        sb.append(rechnungsbetrag);
        String row = sb.toString();
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(kasse));
            writer.write(row, 0, row.length());
            writer.flush();
        }
        catch (IOException ioe) {
            this.frame.showErrorMessage(ioe.getLocalizedMessage());
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    @Override
    protected void fillForm() {
        Date bescheid;
        NumberFormat nf = NumberFormat.getCurrencyInstance(Locale.GERMANY);
        this.minimumSize = new Dimension(this.getSize());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                ProbenEditor.this.setSize(Math.max(((ProbenEditor)ProbenEditor.this).minimumSize.width, ProbenEditor.this.getWidth()), Math.max(((ProbenEditor)ProbenEditor.this).minimumSize.height, ProbenEditor.this.getHeight()));
            }
        });
        AtlProbenahmen probe = this.getProbe();
        BasisBetreiber basisBetr = probe.getBasisBetreiber();
        this.probenummer.setText(probe.getKennummer());
        this.entnahmepunkt.setText(probe.getAtlProbepkt().getBasisObjekt().getBeschreibung());
        Date entnahmeDatum = probe.getDatumDerEntnahme();
        this.datum.setDate(entnahmeDatum);
        this.uhrzeitVon.setText(probe.getUhrzeitbeginn());
        this.uhrzeitBis.setText(probe.getUhrzeitende());
        this.fahrtzeit.setText(probe.getFahrtzeit());
        if (basisBetr != null) {
            String name = basisBetr.getBetrname();
            String addr = basisBetr.getBetriebsgrundstueck();
            StringBuilder sb = new StringBuilder();
            if (name != null) {
                sb.append(name);
            }
            if (addr != null) {
                sb.append(", ");
                sb.append(addr);
            }
            this.betrieb.setText(sb.toString());
        }
        if (probe.getAnzahlbeteiligte() != null) {
            this.beteiligte.setText(Integer.toString(probe.getAnzahlbeteiligte()));
        }
        if ((bescheid = probe.getBescheid()) != null) {
            this.rechnungsDatum.setText(DateUtils.format(bescheid, "dd.MM.yyyy"));
        }
        try {
            double kosten = this.getProbe().getKosten();
            CurrencyDouble cd = new CurrencyDouble(kosten, Locale.GERMANY);
            this.rechnungsBetrag.setText(cd.toString());
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        this.fillVorgangsstatus();
        this.fillSachbearbeiter();
        if (this.getProbe().isKlaerschlammProbe()) {
            this.icpEinwaageFeld.setValue(this.getProbe().getEinwaage());
        } else {
            this.icpEinwaageFeld.setEditable(false);
            this.icpEinwaageFeld.setEnabled(false);
        }
        Date icpDate = this.getProbe().getDatumIcp();
        this.icpDatum.setDate(icpDate);
        this.bemerkungsArea.setText(this.getProbe().getBemerkung());
    }

    private void initColumns() {
        TableColumn parameterColumn = this.parameterTabelle.getColumnModel().getColumn(0);
        parameterColumn.setPreferredWidth(150);
        AtlParameter[] parameter = AtlParameter.getRelevanteParameter();
        this.parameterBox = new JComboBox<AtlParameter>(parameter);
        this.parameterBox.setEditable(false);
        this.parameterBox.setBorder(BorderFactory.createEmptyBorder());
        this.parameterBox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ProbenEditor.this.parameterBox.showPopup();
            }
        });
        parameterColumn.setCellEditor(new DefaultCellEditor(this.parameterBox));
        parameterColumn.setCellRenderer(new ComboBoxRenderer());
        this.parameterTabelle.setDefaultRenderer(Double.class, new DoubleRenderer());
        this.parameterTabelle.setDefaultRenderer(KommaDouble.class, new DoubleRenderer());
        TableColumn einheitenColumn = this.parameterTabelle.getColumnModel().getColumn(3);
        einheitenColumn.setPreferredWidth(100);
        AtlEinheiten[] einheiten = AtlEinheiten.getEinheiten();
        this.einheitenBox = new JComboBox<AtlEinheiten>(einheiten);
        this.einheitenBox.setEditable(false);
        this.einheitenBox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ProbenEditor.this.einheitenBox.showPopup();
            }
        });
        this.einheitenBox.setBorder(BorderFactory.createEmptyBorder());
        einheitenColumn.setCellEditor(new DefaultCellEditor(this.einheitenBox));
        einheitenColumn.setCellRenderer(new ComboBoxRenderer());
        TableColumn analyseColumn = this.parameterTabelle.getColumnModel().getColumn(4);
        analyseColumn.setPreferredWidth(100);
        TableColumn normwertColumn = this.parameterTabelle.getColumnModel().getColumn(6);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(11);
        normwertColumn.setCellRenderer(renderer);
    }

    protected void fillVorgangsstatus() {
        AtlProbenahmen probe = this.getProbe();
        if (probe == null || probe.getAtlStatus() == null) {
            return;
        }
        AtlStatus status = probe.getAtlStatus();
        AUIKataster.debugOutput("Aktueller Status: " + status.getBezeichnung(), this.getClass().getName());
        String bezeichnung = status.getBezeichnung();
        this.updateVorgangsstatus(bezeichnung);
    }

    protected void fillSachbearbeiter() {
        AtlProbenahmen probe = this.getProbe();
        if (probe == null) {
            return;
        }
        String sb = probe.getSachbearbeiter();
        ComboBoxModel model = this.sachbearbeiter.getModel();
        int anzahl = model.getSize();
        for (int i = 0; i < anzahl; ++i) {
            BasisSachbearbeiter b = (BasisSachbearbeiter)model.getElementAt(i);
            if (!b.getName().equals(sb)) continue;
            this.sachbearbeiter.setSelectedItem(b);
            return;
        }
    }

    protected AtlStatus getVorgangsstatus() {
        String selection = (String)this.vorgangsstatus.getSelectedItem();
        AtlStatus current = AtlStatus.getStatus(selection);
        return current;
    }

    protected BasisSachbearbeiter getSachbearbeiter() {
        ComboBoxModel model = this.sachbearbeiter.getModel();
        return (BasisSachbearbeiter)model.getSelectedItem();
    }

    protected String updateVorgangsstatus(String bezeichnung) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.vorgangsstatus.getModel();
        String selection = null;
        int size = model.getSize();
        bezeichnung = bezeichnung.trim().toLowerCase();
        for (int i = 0; i < size; ++i) {
            String tmp = (String)model.getElementAt(i);
            if (!bezeichnung.equals(tmp.trim().toLowerCase())) continue;
            selection = tmp;
            break;
        }
        if (selection != null) {
            model.setSelectedItem(selection);
        }
        return selection;
    }

    @Override
    protected boolean canSave() {
        return true;
    }

    @Override
    protected boolean doSave() {
        boolean success;
        String newBemerkung;
        String kennnummer;
        String uhrzeitBisVal;
        String uhrzeitVonVal;
        AUIKataster.debugOutput("Speichere Probenahmedetails", this.getClass().getName());
        AtlProbenahmen probe = this.getProbe();
        String status = (String)this.vorgangsstatus.getSelectedItem();
        if (status != null) {
            probe.setAtlStatus(AtlStatus.getStatus(status));
        }
        if ((uhrzeitVonVal = this.uhrzeitVon.getText()) != null) {
            probe.setUhrzeitbeginn(uhrzeitVonVal);
        }
        if ((uhrzeitBisVal = this.uhrzeitBis.getText()) != null) {
            probe.setUhrzeitende(uhrzeitBisVal);
        }
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm");
        String datumVal = df.format(this.datum.getDate());
        String timestring = (String)datumVal.subSequence(0, 11) + uhrzeitVonVal;
        Date convertedDate = new Date();
        try {
            convertedDate = df.parse(timestring);
            probe.setDatumDerEntnahme(new Timestamp(convertedDate.getTime()));
        }
        catch (ParseException e) {
            AUIKataster.errorOutput("Fehler beim Speichern von 'datumDerEntnahme'.", this.getClass().getName());
        }
        String fahrtzeitVal = this.fahrtzeit.getText();
        if (fahrtzeitVal != null) {
            probe.setFahrtzeit(fahrtzeitVal);
        }
        try {
            int anzahl = Integer.parseInt(this.beteiligte.getText());
            probe.setAnzahlbeteiligte(anzahl);
        }
        catch (NumberFormatException nfe) {
            AUIKataster.errorOutput("Fehler beim Speichern von 'beteiligte'.", this.getClass().getName());
        }
        BasisSachbearbeiter b = (BasisSachbearbeiter)this.sachbearbeiter.getSelectedItem();
        if (b != null) {
            probe.setSachbearbeiter(b.getName());
        }
        if ((kennnummer = this.probenummer.getText()) != null) {
            probe.setKennummer(kennnummer);
        }
        if ((newBemerkung = this.bemerkungsArea.getText()) != null) {
            newBemerkung = newBemerkung.trim();
        }
        if (!"".equals(newBemerkung)) {
            this.getProbe().setBemerkung(newBemerkung);
        } else {
            this.getProbe().setBemerkung(null);
        }
        HashSet newPositionen = new HashSet(this.parameterModel.getList());
        this.getProbe().getAtlAnalysepositionen().clear();
        this.getProbe().getAtlAnalysepositionen().addAll(newPositionen);
        AUIKataster.debugOutput("Analysepositionen ge\u00e4ndert: " + this.getProbe().getAtlAnalysepositionen(), "ProbenEditor.doSave");
        if (this.isNew) {
            this.isNew = false;
            success = AtlProbenahmen.saveProbenahme(probe);
        } else {
            success = AtlProbenahmen.updateProbenahme(probe);
        }
        return success;
    }

    public Map getAuftragDruckMap(AtlProbenahmen probe) {
        BasisBetreiber betr = probe.getBasisBetreiber();
        AtlProbeart art = probe.getAtlProbepkt().getAtlProbeart();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("kennnummer", this.probenummer.getText());
        params.put("name", betr.toString());
        params.put("art", art.getArt());
        params.put("betriebsgrundstueck", betr.getBetriebsgrundstueck());
        try {
            Integer anzahl = Integer.parseInt(this.beteiligte.getText());
            params.put("anzahlMitarbeiter", anzahl.toString());
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm");
        params.put("entnahmeDatum", df.format(this.datum.getDate()));
        params.put("beginn", this.uhrzeitVon.getText());
        params.put("ende", this.uhrzeitBis.getText());
        params.put("fahrtzeit", this.fahrtzeit.getText());
        params.put("entnahmestelle", this.entnahmepunkt.getText());
        BasisSachbearbeiter sb = (BasisSachbearbeiter)this.sachbearbeiter.getSelectedItem();
        StringBuilder info = new StringBuilder();
        if (sb != null) {
            info.append(sb.getName());
            info.append(", ");
            info.append(sb.getKennummer());
            info.append(", ");
            info.append(sb.getTelefon());
        }
        params.put("sachbearbeiterInfo", info.toString());
        params.put("anzahlEntnahmestellen", "1");
        return params;
    }

    public Map getBescheidDruckMap(AtlProbenahmen probe) throws IllegalArgumentException {
        BasisBetreiber betr = probe.getBasisBetreiber();
        HashMap<String, String> params = new HashMap<String, String>();
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.GERMAN);
        nf.setMinimumFractionDigits(2);
        nf.setMaximumFractionDigits(2);
        String entnahmedatum = DateUtils.format(this.datum.getDate(), "dd.MM.yyyy");
        String entnahmezeit = DateUtils.format(this.datum.getDate(), "HH:mm");
        String entnahmezeitpunkt = entnahmedatum + ", " + entnahmezeit + " Uhr";
        Date now = new Date();
        params.put("datum", DateUtils.format(now, "dd.MM.yyyy"));
        params.put("entnahmedatum", entnahmezeitpunkt);
        params.put("entnahmeort", betr.getBetriebsgrundstueck());
        params.put("entnahmestelle", probe.getAtlProbepkt().getBasisObjekt().getBeschreibung());
        params.put("entnahmestellen", "1");
        params.put("maxdatum", DateUtils.format(DateUtils.getDateOfBill(now), "dd.MM.yyyy"));
        params.put("kosten", Double.toString(40.99));
        params.put("kassenzeichen", betr.getKassenzeichen());
        try {
            Integer anzahl = Integer.parseInt(this.beteiligte.getText());
            params.put("probenehmer", anzahl.toString());
        }
        catch (NumberFormatException nfe) {
            params.put("probenehmer", "1");
        }
        try {
            String beginn = this.uhrzeitVon.getText();
            String ende = this.uhrzeitBis.getText();
            Date beginnDate = DateUtils.parse(beginn, "HH:mm");
            Date endeDate = DateUtils.parse(ende, "HH:mm");
            double dauer = DateUtils.getDurationHours(beginnDate, endeDate);
            double kosten = this.getSachUndPersonalkosten();
            params.put("personalsachkosten", nf.format(kosten));
            params.put("analysekosten", nf.format(this.getAnalysekosten(probe)) + " \u20ac");
            params.put("gesamtkosten", nf.format(kosten + this.getAnalysekosten(probe)) + " \u20ac");
            params.put("dauer", DateUtils.getDuration(beginnDate, endeDate));
        }
        catch (ParseException pe) {
            params.put("dauer", "hh:mm");
            params.put("gesamtkosten", "xx,xx");
        }
        return params;
    }

    protected double getDauer() throws ParseException {
        String beginn = this.uhrzeitVon.getText();
        String ende = this.uhrzeitBis.getText();
        Date beginnDate = DateUtils.parse(beginn, "HH:mm");
        Date endeDate = DateUtils.parse(ende, "HH:mm");
        return DateUtils.getDurationHours(beginnDate, endeDate);
    }

    public double getSachUndPersonalkosten() throws ParseException {
        return 40.99 * this.getDauer();
    }

    public double getAnalysekosten(AtlProbenahmen probe) throws IllegalArgumentException {
        List sorted = AtlProbenahmen.sortAnalysepositionen(probe);
        HashMap gruppen = new HashMap();
        double single = 0.0;
        double group = 0.0;
        for (int i = 0; i < sorted.size(); ++i) {
            AtlAnalyseposition pos = (AtlAnalyseposition)sorted.get(i);
            AtlParameter para = pos.getAtlParameter();
            AtlParameterGruppen gruppe = para.getAtlParameterGruppe();
            if (gruppe == null) {
                single += para.getPreisfueranalyse().doubleValue();
                continue;
            }
            Integer id = gruppe.getId();
            if (gruppen.containsKey(id)) {
                ((List)gruppen.get(id)).add(para);
                continue;
            }
            ArrayList<AtlParameter> neu = new ArrayList<AtlParameter>();
            neu.add(para);
            gruppen.put(id, neu);
        }
        int anzahlGruppen = gruppen.size();
        if (anzahlGruppen == 0) {
            return single;
        }
        Set keys = gruppen.keySet();
        for (Integer id : keys) {
            group += this.getGruppierteAnalysekosten(id, (List)gruppen.get(id));
        }
        return single + group;
    }

    public double getGruppierteAnalysekosten(int gruppe, List params) throws IllegalArgumentException {
        double preis = 0.0;
        if (AtlParameterGruppen.isGroupComplete(gruppe, params)) {
            AtlParameterGruppen g = AtlParameterGruppen.getParameterGroup(gruppe);
            if (g == null) {
                System.out.println("No such group with id: " + gruppe);
                return 0.0;
            }
            preis += g.getPreisfueranalyse().doubleValue();
        } else {
            int parameter = params.size();
            for (int i = 0; i < parameter; ++i) {
                AtlParameter p = (AtlParameter)params.get(i);
                if (p.getEinzelnBeauftragbar().booleanValue()) {
                    preis += p.getPreisfueranalyse().doubleValue();
                    continue;
                }
                String msg = "Parameter " + p.getOrdnungsbegriff() + " ist nicht " + "einzeln pr\u00fcfbar.";
                AUIKataster.errorOutput(msg, this.getClass().getName());
                throw new IllegalArgumentException(msg);
            }
        }
        return preis;
    }

    public double getRechnungsbetrag(AtlProbenahmen probe) throws ParseException, IllegalArgumentException {
        return this.getSachUndPersonalkosten() + this.getAnalysekosten(probe);
    }

    protected void updateRechnungsbetrag(AtlProbenahmen probe) throws ParseException {
        double betrag = this.getRechnungsbetrag(probe);
        probe.setKosten(betrag);
        CurrencyDouble cd = new CurrencyDouble(betrag, Locale.GERMANY);
        this.rechnungsBetrag.setText(cd.toString());
    }

    protected void updateRechnungsdatum(AtlProbenahmen probe) {
        Date now = new Date();
        Date datum = DateUtils.getDateOfBill(now);
        probe.setBescheid(now);
        this.rechnungsDatum.setText(DateUtils.format(now, "dd.MM.yyyy"));
    }

    @Override
    protected void doApply() {
        ParameterChooser chooser = new ParameterChooser(this.frame);
        chooser.addOKListener(new OKListener(){

            @Override
            public void onOK(AtlParameter[] params) {
                for (AtlParameter param : params) {
                    ProbenEditor.this.parameterModel.addParameter(param);
                }
            }
        });
        chooser.setVisible(true);
    }

    public AtlProbenahmen getProbe() {
        return (AtlProbenahmen)this.getEditedObject();
    }

    private class ParameterModel
    extends EditableListTableModel {
        private AtlProbenahmen probe;
        private boolean isNew;

        public ParameterModel(AtlProbenahmen probe, boolean isNew) {
            super(new String[]{"Parameter", "GrKl", "Messwert", "Einheit", "Analyse von", "Grenzwert", "% Normwert"}, false, true);
            this.probe = probe;
            this.isNew = isNew;
            this.updateList();
        }

        @Override
        public void updateList() {
            if (!this.isNew) {
                this.probe = AtlProbenahmen.getProbenahme(this.probe.getId(), true);
                this.setList(AtlProbenahmen.sortAnalysepositionen(this.probe));
            } else {
                this.setList(new ArrayList());
            }
            this.fireTableDataChanged();
        }

        @Override
        public Object getColumnValue(Object objectAtRow, int columnIndex) {
            Object value;
            AtlAnalyseposition pos = (AtlAnalyseposition)objectAtRow;
            switch (columnIndex) {
                case 0: {
                    value = pos.getAtlParameter();
                    break;
                }
                case 1: {
                    value = pos.getGrkl();
                    break;
                }
                case 2: {
                    value = new KommaDouble(pos.getWert().floatValue());
                    break;
                }
                case 3: {
                    value = pos.getAtlEinheiten();
                    break;
                }
                case 4: {
                    value = pos.getAnalyseVon();
                    break;
                }
                case 5: {
                    value = null;
                    Double grenzWert = null;
                    if (this.probe.isKlaerschlammProbe()) {
                        grenzWert = pos.getAtlParameter().getKlaerschlammGw();
                    } else if (this.probe.getProbeArt().isSielhaut()) {
                        grenzWert = pos.getAtlParameter().getSielhautGw();
                    }
                    if (grenzWert == null || grenzWert.equals(new Double(0.0))) break;
                    value = grenzWert;
                    break;
                }
                case 6: {
                    value = "-";
                    if (!pos.getAtlEinheiten().getId().equals(AtlEinheiten.MG_KG_ID)) break;
                    double tmpVal = -1.0;
                    if (this.probe.isKlaerschlammProbe()) {
                        if (pos.getAtlParameter().getKlaerschlammGw() != null && !pos.getAtlParameter().getKlaerschlammGw().equals(new Double(0.0))) {
                            tmpVal = pos.getWert().doubleValue() / pos.getAtlParameter().getKlaerschlammGw();
                        }
                    } else if (this.probe.getProbeArt().isSielhaut() && pos.getAtlParameter().getSielhautGw() != null && !pos.getAtlParameter().getSielhautGw().equals(new Double(0.0))) {
                        tmpVal = pos.getWert().doubleValue() / pos.getAtlParameter().getSielhautGw();
                    }
                    if (tmpVal == -1.0) break;
                    NumberFormat percentFormat = NumberFormat.getPercentInstance();
                    percentFormat.setMinimumFractionDigits(1);
                    if (tmpVal > 1.0) {
                        value = "<html><font color=#ff0000>" + percentFormat.format(tmpVal) + "</font></html>";
                        break;
                    }
                    value = percentFormat.format(tmpVal);
                    break;
                }
                default: {
                    value = null;
                }
            }
            return value;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 5 && columnIndex != 6;
        }

        @Override
        public void editObject(Object objectAtRow, int columnIndex, Object newValue) {
            AtlAnalyseposition tmp = (AtlAnalyseposition)objectAtRow;
            switch (columnIndex) {
                case 0: {
                    if (!(newValue instanceof AtlParameter)) break;
                    AtlParameter tmpPara = (AtlParameter)newValue;
                    tmp.setAtlParameter(tmpPara);
                    break;
                }
                case 1: {
                    String tmpGrKl = (String)newValue;
                    if (tmpGrKl == null) break;
                    if ((tmpGrKl = tmpGrKl.trim()).equals("")) {
                        tmp.setGrkl(null);
                        break;
                    }
                    if (!(tmpGrKl = tmpGrKl.substring(0, 1)).equals("<") && !tmpGrKl.equals(">")) break;
                    tmp.setGrkl(tmpGrKl);
                    break;
                }
                case 2: {
                    Float tmpWert = null;
                    if (newValue instanceof Float) {
                        tmpWert = (Float)newValue;
                    } else if (newValue instanceof KommaDouble) {
                        tmpWert = Float.valueOf(((KommaDouble)newValue).getValue().floatValue());
                    }
                    tmp.setWert(tmpWert);
                    break;
                }
                case 3: {
                    AtlEinheiten tmpEinheit = (AtlEinheiten)newValue;
                    tmp.setAtlEinheiten(tmpEinheit);
                    break;
                }
                case 4: {
                    String tmpAnalyse = (String)newValue;
                    if (tmpAnalyse == null) break;
                    if ((tmpAnalyse = tmpAnalyse.trim()).equals("")) {
                        tmp.setAnalyseVon(null);
                        break;
                    }
                    tmp.setAnalyseVon(tmpAnalyse);
                    break;
                }
            }
            AUIKataster.debugOutput("EDIT: " + tmp, "ParameterModel.editObject");
        }

        @Override
        public Object newObject() {
            AtlAnalyseposition tmp = new AtlAnalyseposition(this.probe);
            if (this.probe.isKlaerschlammProbe() || this.probe.getProbeArt().isSielhaut()) {
                tmp.setAtlEinheiten(AtlEinheiten.getEinheit(AtlEinheiten.MG_KG_ID));
            } else {
                tmp.setAtlEinheiten(AtlEinheiten.getEinheit(AtlEinheiten.MG_L_ID));
            }
            tmp.setAtlParameter((AtlParameter)ProbenEditor.this.parameterBox.getSelectedItem());
            tmp.setAtlEinheiten(AtlEinheiten.getEinheit(tmp.getAtlParameter().getWirdgemessenineinheit()));
            return tmp;
        }

        public void addParameter(AtlParameter parameter) {
            if (this.isParameterAlreadyThere(parameter)) {
                AUIKataster.debugOutput(this.getClass().getName(), "Der Parameter wird bereits gepr\u00fcft.");
                return;
            }
            AtlAnalyseposition pos = new AtlAnalyseposition(this.probe);
            pos.setAtlParameter(parameter);
            pos.setAtlEinheiten(AtlEinheiten.getEinheit(parameter.getWirdgemessenineinheit()));
            this.getList().add(pos);
            this.fireTableDataChanged();
        }

        public boolean isParameterAlreadyThere(AtlParameter newParam) {
            List data = this.getList();
            int size = data.size();
            String newOrdnungsbegriff = newParam.getOrdnungsbegriff();
            for (int i = 0; i < size; ++i) {
                AtlAnalyseposition pos = (AtlAnalyseposition)data.get(i);
                AtlParameter param = pos.getAtlParameter();
                if (!param.getOrdnungsbegriff().equals(newOrdnungsbegriff)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean objectRemoved(Object objectAtRow) {
            return true;
        }

        public Class getColumnClass(int columnIndex) {
            Class tmp;
            switch (columnIndex) {
                case 0: {
                    tmp = AtlParameter.class;
                    break;
                }
                case 2: {
                    tmp = KommaDouble.class;
                    break;
                }
                case 3: {
                    tmp = AtlEinheiten.class;
                    break;
                }
                case 5: {
                    tmp = Double.class;
                    break;
                }
                case 6: {
                    tmp = String.class;
                    break;
                }
                default: {
                    tmp = super.getColumnClass(columnIndex);
                }
            }
            return tmp;
        }
    }

    public static interface OKListener {
        public void onOK(AtlParameter[] var1);
    }
}

