/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.common.editors;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlParameter;
import de.bielefeld.umweltamt.aui.module.common.editors.ParameterAuswahlModel;
import de.bielefeld.umweltamt.aui.module.common.editors.ProbenEditor;
import de.bielefeld.umweltamt.aui.utils.SelectTable;
import de.bielefeld.umweltamt.aui.utils.TabAction;
import de.bielefeld.umweltamt.aui.utils.TableFocusListener;
import de.bielefeld.umweltamt.aui.utils.dialogbase.OkCancelDialog;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;

class ParameterChooser
extends OkCancelDialog {
    private JTable ergebnisTabelle;
    private ParameterAuswahlModel parameterAuswahlModel = new ParameterAuswahlModel();
    private AtlParameter chosenParameter = null;
    private ProbenEditor.OKListener oklistener;

    public ParameterChooser(HauptFrame owner) {
        super("Parameter ausw\u00e4hlen", owner);
        this.getErgebnisTabelle().setModel(this.parameterAuswahlModel);
        this.ergebnisTabelle.setColumnSelectionInterval(0, 0);
        this.ergebnisTabelle.getColumnModel().getColumn(0).setPreferredWidth(20);
        this.ergebnisTabelle.getColumnModel().getColumn(1).setPreferredWidth(230);
        this.setResizable(true);
        this.parameterAuswahlModel.filterList();
        this.parameterAuswahlModel.fireTableDataChanged();
    }

    public void addOKListener(ProbenEditor.OKListener listener) {
        this.oklistener = listener;
    }

    @Override
    protected void doOk() {
        AtlParameter[] selected = this.parameterAuswahlModel.getSelectedParameter();
        this.fireOKEvent(selected);
        this.dispose();
    }

    protected void fireOKEvent(AtlParameter[] parameter) {
        if (this.oklistener == null) {
            return;
        }
        this.oklistener.onOK(parameter);
    }

    public AtlParameter getChosenParameter() {
        return this.chosenParameter;
    }

    @Override
    protected JComponent buildContentArea() {
        JScrollPane tabellenScroller = new JScrollPane(this.getErgebnisTabelle(), 20, 31);
        TabAction ta = new TabAction();
        ta.addComp(this.ergebnisTabelle);
        FormLayout layout = new FormLayout("180dlu:g, 3dlu, min(16dlu;p)", "20dlu, 3dlu, 300dlu:g");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        builder.add((Component)tabellenScroller, cc.xyw(1, 3, 3));
        return builder.getPanel();
    }

    private JTable getErgebnisTabelle() {
        if (this.ergebnisTabelle == null) {
            this.ergebnisTabelle = new SelectTable();
            AbstractAction submitAction = new AbstractAction("Ausw\u00e4hlen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParameterChooser.this.doOk();
                }
            };
            submitAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0, false));
            this.ergebnisTabelle.getInputMap().put((KeyStroke)submitAction.getValue("AcceleratorKey"), submitAction.getValue("Name"));
            this.ergebnisTabelle.getActionMap().put(submitAction.getValue("Name"), submitAction);
            this.ergebnisTabelle.addFocusListener(TableFocusListener.getInstance());
            this.ergebnisTabelle.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        Point origin = e.getPoint();
                        int n = ParameterChooser.this.ergebnisTabelle.rowAtPoint(origin);
                    }
                }
            });
        }
        return this.ergebnisTabelle;
    }
}

