/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.common.editors;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.indeinl.AnhEntsorger;
import de.bielefeld.umweltamt.aui.module.common.editors.AbstractBaseEditor;
import de.bielefeld.umweltamt.aui.utils.IntegerField;
import de.bielefeld.umweltamt.aui.utils.LimitedTextField;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;

public class EntsorgerEditor
extends AbstractBaseEditor {
    private JTextField namenFeld;
    private JTextField strassenFeld;
    private JFormattedTextField hausnrFeld;
    private JTextField plzFeld;
    private JTextField ortsFeld;
    private JTextField ansprechpartnerFeld;
    private JTextField telefonFeld;

    public EntsorgerEditor(AnhEntsorger entsorg, HauptFrame owner) {
        super("Entsorger (" + entsorg.getEntsorger() + ")", entsorg, owner);
    }

    @Override
    protected JComponent buildContentArea() {
        this.namenFeld = new LimitedTextField(100, "");
        this.strassenFeld = new LimitedTextField(100, "");
        this.hausnrFeld = new IntegerField();
        this.plzFeld = new LimitedTextField(5, "");
        this.ortsFeld = new LimitedTextField(50, "");
        this.ansprechpartnerFeld = new LimitedTextField(50, "");
        this.telefonFeld = new LimitedTextField(25, "");
        KeyAdapter escListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    EntsorgerEditor.this.doCancel();
                }
            }
        };
        this.namenFeld.addKeyListener(escListener);
        this.hausnrFeld.addKeyListener(escListener);
        this.plzFeld.addKeyListener(escListener);
        this.ortsFeld.addKeyListener(escListener);
        this.telefonFeld.addKeyListener(escListener);
        String columnString = "r:p, 3dlu, 30dlu, 40dlu:g, 5dlu, r:p, 3dlu, 27dlu";
        FormLayout layout = new FormLayout(columnString, "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref");
        layout.setRowGroups((int[][])new int[][]{{1, 3, 5, 7, 9}});
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator("Stammdaten", cc.xyw(1, 1, 8));
        builder.addLabel("Name:", cc.xy(1, 3));
        builder.add((Component)this.namenFeld, cc.xyw(3, 3, 6));
        builder.addLabel("Stra\u00dfe:", cc.xy(1, 5));
        builder.add((Component)this.strassenFeld, cc.xyw(3, 5, 4));
        builder.add((Component)this.hausnrFeld, cc.xy(8, 5));
        builder.addLabel("Ort:", cc.xy(1, 7));
        builder.add((Component)this.plzFeld, cc.xy(3, 7));
        builder.add((Component)this.ortsFeld, cc.xyw(4, 7, 5));
        builder.addLabel("Telefon:", cc.xy(1, 9));
        builder.add((Component)this.telefonFeld, cc.xyw(3, 9, 4));
        return builder.getPanel();
    }

    @Override
    protected void fillForm() {
        this.namenFeld.setText(this.getEntsorger().getEntsorger());
        this.strassenFeld.setText(this.getEntsorger().getStrasse());
        this.hausnrFeld.setValue(this.getEntsorger().getHausnr());
        this.plzFeld.setText(this.getEntsorger().getPlz());
        this.ortsFeld.setText(this.getEntsorger().getOrt());
        this.ansprechpartnerFeld.setText(this.getEntsorger().getAnsprechpartner());
        this.telefonFeld.setText(this.getEntsorger().getTelefon());
    }

    @Override
    protected boolean canSave() {
        return true;
    }

    @Override
    protected boolean doSave() {
        boolean success;
        String name = this.namenFeld.getText();
        if ("".equals(name)) {
            this.getEntsorger().setEntsorger(null);
        } else {
            this.getEntsorger().setEntsorger(name);
        }
        String stra = this.strassenFeld.getText();
        if ("".equals(stra)) {
            this.getEntsorger().setStrasse(null);
        } else {
            this.getEntsorger().setStrasse(stra);
        }
        Integer hausnr = ((IntegerField)this.hausnrFeld).getIntValue();
        this.getEntsorger().setHausnr(hausnr);
        String plz = this.plzFeld.getText();
        if (plz.equals("")) {
            this.getEntsorger().setPlz(null);
        } else {
            this.getEntsorger().setPlz(plz);
        }
        String ort = this.ortsFeld.getText();
        if ("".equals(ort)) {
            this.getEntsorger().setOrt(null);
        } else {
            this.getEntsorger().setOrt(ort);
        }
        String telefon = this.telefonFeld.getText();
        if (telefon != null) {
            if ((telefon = telefon.trim()).equals("")) {
                this.getEntsorger().setTelefon(null);
            } else {
                this.getEntsorger().setTelefon(telefon);
            }
        }
        this.setEditedObject(AnhEntsorger.saveEntsorger(this.getEntsorger()));
        if (this.getEntsorger() != null) {
            success = true;
            AUIKataster.debugOutput("\u00c4nderungen gespeichert!", "editEntsorger");
        } else {
            success = false;
        }
        return success;
    }

    public AnhEntsorger getEntsorger() {
        return (AnhEntsorger)this.getEditedObject();
    }
}

