/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.common.editors;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisBetreiber;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisStrassen;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsWirtschaftszweige;
import de.bielefeld.umweltamt.aui.module.common.editors.AbstractBaseEditor;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.IntegerField;
import de.bielefeld.umweltamt.aui.utils.LimitedTextArea;
import de.bielefeld.umweltamt.aui.utils.LimitedTextField;
import de.bielefeld.umweltamt.aui.utils.LongNameComboBoxRenderer;
import de.bielefeld.umweltamt.aui.utils.SwingWorkerVariant;
import de.bielefeld.umweltamt.aui.utils.TabAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Calendar;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.hibernate.HibernateException;

public class BetreiberEditor
extends AbstractBaseEditor {
    private static String[] strassen = null;
    private static VawsWirtschaftszweige[] wirtschaftszweige = null;
    private JLabel handzeichenLabel;
    private JLabel namenLabel;
    private JTextField anredeFeld;
    private JTextField namenFeld;
    private JTextField nameZusFeld;
    private JFormattedTextField hausnrFeld;
    private JTextField hausnrZusFeld;
    private JTextField plzZsFeld;
    private JTextField plzFeld;
    private JTextField ortsFeld;
    private JTextField telefonFeld;
    private JTextField telefaxFeld;
    private JTextField emailFeld;
    private JTextField betrBeaufVornameFeld;
    private JTextField betrBeaufNachnameFeld;
    private JTextField revdatumsFeld;
    private JTextField handzeichenAltFeld;
    private JTextField handzeichenNeuFeld;
    private JTextArea bemerkungsArea;
    private JComboBox strassenBox;
    private JComboBox wirtschaftszweigBox;

    public BetreiberEditor(BasisBetreiber betr, HauptFrame owner) {
        super("Betreiber (" + betr.getBetreiberid() + ")", betr, owner);
    }

    @Override
    protected JComponent buildContentArea() {
        this.anredeFeld = new LimitedTextField(100);
        this.namenFeld = new LimitedTextField(100);
        this.nameZusFeld = new LimitedTextField(50);
        this.hausnrFeld = new IntegerField();
        this.hausnrZusFeld = new LimitedTextField(10);
        this.plzZsFeld = new LimitedTextField(3);
        this.plzFeld = new LimitedTextField(10);
        this.ortsFeld = new LimitedTextField(50);
        this.telefonFeld = new LimitedTextField(50);
        this.telefaxFeld = new LimitedTextField(50);
        this.emailFeld = new LimitedTextField(50);
        this.betrBeaufVornameFeld = new LimitedTextField(50);
        this.betrBeaufNachnameFeld = new LimitedTextField(50);
        this.revdatumsFeld = new JTextField();
        this.revdatumsFeld.setEditable(false);
        this.revdatumsFeld.setFocusable(false);
        this.revdatumsFeld.setToolTipText("Wird bei \u00c4nderungen automatisch aktualisiert.");
        this.handzeichenAltFeld = new JTextField();
        this.handzeichenAltFeld.setEditable(false);
        this.handzeichenAltFeld.setFocusable(false);
        this.handzeichenAltFeld.setToolTipText("Handzeichen der letzten Revision");
        this.handzeichenNeuFeld = new LimitedTextField(10, "");
        this.handzeichenNeuFeld.setToolTipText("Neues Handzeichen bei \u00c4nderungen obligatorisch!");
        this.bemerkungsArea = new LimitedTextArea(2000);
        this.bemerkungsArea.setLineWrap(true);
        this.bemerkungsArea.setWrapStyleWord(true);
        JScrollPane bemerkungsScroller = new JScrollPane(this.bemerkungsArea, 20, 31);
        this.strassenBox = new JComboBox();
        this.strassenBox.setEditable(true);
        this.wirtschaftszweigBox = new JComboBox();
        this.wirtschaftszweigBox.setRenderer(new LongNameComboBoxRenderer());
        KeyAdapter escEnterListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getSource().equals(BetreiberEditor.this.handzeichenNeuFeld) && e.getKeyCode() == 10) {
                    if (BetreiberEditor.this.handzeichenNeuFeld.getText().equals("")) {
                        BetreiberEditor.this.handzeichenLabel.setForeground(Color.RED);
                        BetreiberEditor.this.handzeichenNeuFeld.requestFocus();
                    } else {
                        BetreiberEditor.this.button1.requestFocus();
                    }
                }
                if (e.getKeyCode() == 27) {
                    BetreiberEditor.this.doCancel();
                }
            }
        };
        this.anredeFeld.addKeyListener(escEnterListener);
        this.namenFeld.addKeyListener(escEnterListener);
        this.nameZusFeld.addKeyListener(escEnterListener);
        this.hausnrFeld.addKeyListener(escEnterListener);
        this.hausnrZusFeld.addKeyListener(escEnterListener);
        this.plzZsFeld.addKeyListener(escEnterListener);
        this.plzFeld.addKeyListener(escEnterListener);
        this.ortsFeld.addKeyListener(escEnterListener);
        this.telefonFeld.addKeyListener(escEnterListener);
        this.telefaxFeld.addKeyListener(escEnterListener);
        this.emailFeld.addKeyListener(escEnterListener);
        this.betrBeaufVornameFeld.addKeyListener(escEnterListener);
        this.betrBeaufNachnameFeld.addKeyListener(escEnterListener);
        this.handzeichenNeuFeld.addKeyListener(escEnterListener);
        this.bemerkungsArea.addKeyListener(escEnterListener);
        this.strassenBox.addKeyListener(escEnterListener);
        this.wirtschaftszweigBox.addKeyListener(escEnterListener);
        bemerkungsScroller.getVerticalScrollBar().setFocusable(false);
        bemerkungsScroller.getHorizontalScrollBar().setFocusable(false);
        TabAction tac = new TabAction(this.bemerkungsArea, this.handzeichenNeuFeld);
        String columnString = "right:pref, 3dlu, 20dlu, 40dlu:grow(1.0), 5dlu, right:pref, 3dlu, 27dlu:grow(1.0), 3dlu, 30dlu:grow(1.0)";
        FormLayout layout = new FormLayout(columnString + ", 10dlu, " + columnString, "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref");
        layout.setRowGroups((int[][])new int[][]{{1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21}});
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.addSeparator("Stammdaten", cc.xyw(1, 1, 10));
        builder.addLabel("Anrede:", cc.xy(1, 3));
        builder.add((Component)this.anredeFeld, cc.xyw(3, 3, 8));
        this.namenLabel = builder.addLabel("Name:", cc.xy(1, 5));
        builder.add((Component)this.namenFeld, cc.xyw(3, 5, 8));
        builder.addLabel("Vorname/Zusatz:", cc.xy(1, 7));
        builder.add((Component)this.nameZusFeld, cc.xyw(3, 7, 8));
        builder.addLabel("Wirtschaftszweig:", cc.xy(1, 9));
        builder.add((Component)this.wirtschaftszweigBox, cc.xyw(3, 9, 8));
        builder.addSeparator("Adresse", cc.xyw(1, 11, 10));
        builder.addLabel("Stra\u00dfe:", cc.xy(1, 13));
        builder.add((Component)this.strassenBox, cc.xyw(3, 13, 4));
        builder.add((Component)this.hausnrFeld, cc.xy(8, 13));
        builder.add((Component)this.hausnrZusFeld, cc.xy(10, 13));
        builder.addLabel("Ort:", cc.xy(1, 15));
        builder.add((Component)this.plzZsFeld, cc.xy(3, 15));
        builder.add((Component)this.plzFeld, cc.xy(4, 15));
        builder.add((Component)this.ortsFeld, cc.xyw(6, 15, 5));
        builder.addLabel("Telefon:", cc.xy(1, 17));
        builder.add((Component)this.telefonFeld, cc.xyw(3, 17, 4));
        builder.addLabel("Telefax:", cc.xy(1, 19));
        builder.add((Component)this.telefaxFeld, cc.xyw(3, 19, 4));
        builder.addLabel("E-Mail:", cc.xy(1, 21));
        builder.add((Component)this.emailFeld, cc.xyw(3, 21, 4));
        builder.addSeparator("Ansprechpartner", cc.xyw(12, 1, 10));
        builder.addLabel("Vorname:", cc.xy(12, 3));
        builder.add((Component)this.betrBeaufVornameFeld, cc.xyw(14, 3, 2));
        builder.addLabel("Nachname:", cc.xy(17, 3));
        builder.add((Component)this.betrBeaufNachnameFeld, cc.xyw(19, 3, 3));
        builder.addSeparator("Bemerkungen", cc.xyw(12, 5, 10));
        builder.add((Component)bemerkungsScroller, cc.xywh(12, 7, 10, 3));
        builder.addSeparator("Letzte Revision", cc.xyw(12, 11, 10));
        builder.addLabel("Datum:", cc.xy(12, 13));
        builder.add((Component)this.revdatumsFeld, cc.xyw(14, 13, 4));
        builder.addLabel("Handzeichen:", cc.xy(12, 15));
        builder.add((Component)this.handzeichenAltFeld, cc.xyw(14, 15, 4));
        builder.addSeparator("Neue Revision", cc.xyw(12, 17, 10));
        this.handzeichenLabel = builder.addLabel("Handzeichen:", cc.xy(12, 19));
        builder.add((Component)this.handzeichenNeuFeld, cc.xyw(14, 19, 4));
        return builder.getPanel();
    }

    @Override
    protected void fillForm() {
        SwingWorkerVariant worker = new SwingWorkerVariant(this){

            @Override
            protected void doNonUILogic() throws RuntimeException {
                try {
                    if (strassen == null) {
                        BetreiberEditor.access$402(BasisStrassen.getStrassen());
                    }
                    if (wirtschaftszweige == null) {
                        BetreiberEditor.access$502(VawsWirtschaftszweige.getWirtschaftszweige());
                    }
                }
                catch (HibernateException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            protected void doUIUpdateLogic() throws RuntimeException {
                if (strassen != null) {
                    BetreiberEditor.this.strassenBox.setModel(new DefaultComboBoxModel<String>(strassen));
                    BetreiberEditor.this.strassenBox.setSelectedItem(BetreiberEditor.this.getBetreiber().getStrasse());
                }
                if (wirtschaftszweige != null) {
                    BetreiberEditor.this.wirtschaftszweigBox.setModel(new DefaultComboBoxModel<VawsWirtschaftszweige>(wirtschaftszweige));
                    BetreiberEditor.this.wirtschaftszweigBox.setSelectedItem(BetreiberEditor.this.getBetreiber().getVawsWirtschaftszweige());
                }
                BetreiberEditor.this.anredeFeld.setText(BetreiberEditor.this.getBetreiber().getBetranrede());
                BetreiberEditor.this.namenFeld.setText(BetreiberEditor.this.getBetreiber().getBetrname());
                BetreiberEditor.this.nameZusFeld.setText(BetreiberEditor.this.getBetreiber().getBetrnamezus());
                BetreiberEditor.this.hausnrFeld.setValue(BetreiberEditor.this.getBetreiber().getHausnr());
                BetreiberEditor.this.hausnrZusFeld.setText(BetreiberEditor.this.getBetreiber().getHausnrzus());
                String plzZs = BetreiberEditor.this.getBetreiber().getPlzzs();
                if (plzZs != null) {
                    plzZs = plzZs.trim();
                }
                BetreiberEditor.this.plzZsFeld.setText(plzZs);
                BetreiberEditor.this.plzFeld.setText(BetreiberEditor.this.getBetreiber().getPlz());
                BetreiberEditor.this.ortsFeld.setText(BetreiberEditor.this.getBetreiber().getOrt());
                BetreiberEditor.this.telefonFeld.setText(BetreiberEditor.this.getBetreiber().getTelefon());
                BetreiberEditor.this.telefaxFeld.setText(BetreiberEditor.this.getBetreiber().getTelefax());
                BetreiberEditor.this.emailFeld.setText(BetreiberEditor.this.getBetreiber().getEmail());
                BetreiberEditor.this.betrBeaufVornameFeld.setText(BetreiberEditor.this.getBetreiber().getVornamebetrbeauf());
                BetreiberEditor.this.betrBeaufNachnameFeld.setText(BetreiberEditor.this.getBetreiber().getNamebetrbeauf());
                BetreiberEditor.this.handzeichenAltFeld.setText(BetreiberEditor.this.getBetreiber().getRevihandz());
                BetreiberEditor.this.bemerkungsArea.setText(BetreiberEditor.this.getBetreiber().getBemerkungen());
                Date datum = BetreiberEditor.this.getBetreiber().getRevidatum();
                BetreiberEditor.this.revdatumsFeld.setText(AuikUtils.getStringFromDate(datum));
                BetreiberEditor.this.frame.clearStatus();
            }
        };
        this.frame.changeStatus("Besch\u00e4ftigt...");
        worker.start();
    }

    @Override
    protected boolean canSave() {
        if (this.namenFeld.getText().equals("")) {
            this.namenLabel.setForeground(HauptFrame.ERROR_COLOR);
            this.namenFeld.requestFocus();
            String nameErr = "Der Name darf nicht leer sein!";
            this.frame.changeStatus(nameErr, HauptFrame.ERROR_COLOR);
            AUIKataster.debugOutput(nameErr, "BetreiberEdit.doSave");
            return false;
        }
        if (this.handzeichenNeuFeld.getText().equals("")) {
            this.handzeichenLabel.setForeground(HauptFrame.ERROR_COLOR);
            this.handzeichenNeuFeld.requestFocus();
            String handzErr = "Neues Handzeichen erforderlich!";
            this.frame.changeStatus(handzErr, HauptFrame.ERROR_COLOR);
            AUIKataster.debugOutput(handzErr, "BetreiberEdit.doSave");
            return false;
        }
        return true;
    }

    @Override
    protected boolean doSave() {
        String betrBeaufNachname;
        String betrBeaufVorname;
        String email;
        String telefax;
        String telefon;
        String ort;
        String anrede = this.anredeFeld.getText();
        if ("".equals(anrede)) {
            this.getBetreiber().setBetranrede(null);
        } else {
            this.getBetreiber().setBetranrede(anrede);
        }
        String name = this.namenFeld.getText();
        if ("".equals(name)) {
            this.getBetreiber().setBetrname(null);
        } else {
            this.getBetreiber().setBetrname(name);
        }
        String nameZusatz = this.nameZusFeld.getText();
        if ("".equals(nameZusatz)) {
            this.getBetreiber().setBetrnamezus(null);
        } else {
            this.getBetreiber().setBetrnamezus(nameZusatz);
        }
        String stra = (String)this.strassenBox.getSelectedItem();
        if (stra != null) {
            if ((stra = stra.trim()).length() > 50) {
                stra = stra.substring(0, 50);
            }
            if ("".equals(stra)) {
                this.getBetreiber().setStrasse(null);
            } else {
                this.getBetreiber().setStrasse(stra);
            }
        }
        Integer hausnr = ((IntegerField)this.hausnrFeld).getIntValue();
        this.getBetreiber().setHausnr(hausnr);
        String hausnrZus = this.hausnrZusFeld.getText();
        if ("".equals(hausnrZus)) {
            this.getBetreiber().setHausnrzus(null);
        } else {
            this.getBetreiber().setHausnrzus(hausnrZus);
        }
        String plzZs = this.plzZsFeld.getText();
        if ("".equals(plzZs)) {
            this.getBetreiber().setPlzzs(null);
        } else {
            this.getBetreiber().setPlzzs(plzZs.toUpperCase().trim());
        }
        String plz = this.plzFeld.getText();
        if (plz != null) {
            if ((plz = plz.trim()).equals("")) {
                this.getBetreiber().setPlz(null);
            } else {
                this.getBetreiber().setPlz(plz);
            }
        }
        if ((ort = this.ortsFeld.getText()) != null) {
            if ((ort = ort.trim()).equals("")) {
                this.getBetreiber().setOrt(null);
            } else {
                this.getBetreiber().setOrt(ort);
            }
        }
        if ((telefon = this.telefonFeld.getText()) != null) {
            if ((telefon = telefon.trim()).equals("")) {
                this.getBetreiber().setTelefon(null);
            } else {
                this.getBetreiber().setTelefon(telefon);
            }
        }
        if ((telefax = this.telefaxFeld.getText()) != null) {
            if ((telefax = telefax.trim()).equals("")) {
                this.getBetreiber().setTelefax(null);
            } else {
                this.getBetreiber().setTelefax(telefax);
            }
        }
        if ((email = this.emailFeld.getText()) != null) {
            if ((email = email.trim()).equals("")) {
                this.getBetreiber().setEmail(null);
            } else {
                this.getBetreiber().setEmail(email);
            }
        }
        if ((betrBeaufVorname = this.betrBeaufVornameFeld.getText()) != null) {
            if ((betrBeaufVorname = betrBeaufVorname.trim()).equals("")) {
                this.getBetreiber().setVornamebetrbeauf(null);
            } else {
                this.getBetreiber().setVornamebetrbeauf(betrBeaufVorname);
            }
        }
        if ((betrBeaufNachname = this.betrBeaufNachnameFeld.getText()) != null) {
            if ((betrBeaufNachname = betrBeaufNachname.trim()).equals("")) {
                this.getBetreiber().setNamebetrbeauf(null);
            } else {
                this.getBetreiber().setNamebetrbeauf(betrBeaufNachname);
            }
        }
        VawsWirtschaftszweige wizw = (VawsWirtschaftszweige)this.wirtschaftszweigBox.getSelectedItem();
        this.getBetreiber().setVawsWirtschaftszweige(wizw);
        String bemerkungen = this.bemerkungsArea.getText();
        if (bemerkungen != null) {
            if ((bemerkungen = bemerkungen.trim()).equals("")) {
                this.getBetreiber().setBemerkungen(null);
            } else {
                this.getBetreiber().setBemerkungen(bemerkungen);
            }
        }
        String handzeichen = this.handzeichenNeuFeld.getText().trim();
        this.getBetreiber().setRevihandz(handzeichen);
        this.getBetreiber().setRevidatum(Calendar.getInstance().getTime());
        BasisBetreiber betr = BasisBetreiber.saveBetreiber(this.getBetreiber());
        if (betr != null) {
            this.setEditedObject(betr);
            AUIKataster.debugOutput("\u00c4nderungen gespeichert!", "editStandort");
            return true;
        }
        return false;
    }

    public BasisBetreiber getBetreiber() {
        return (BasisBetreiber)this.getEditedObject();
    }

    static /* synthetic */ String[] access$402(String[] x0) {
        strassen = x0;
        return x0;
    }

    static /* synthetic */ VawsWirtschaftszweige[] access$502(VawsWirtschaftszweige[] x0) {
        wirtschaftszweige = x0;
        return x0;
    }
}

