/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.common.editors;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.ModulManager;
import de.bielefeld.umweltamt.aui.utils.dialogbase.OkCancelApplyDialog;

public abstract class AbstractApplyEditor
extends OkCancelApplyDialog {
    protected Object editedObject;
    protected String objektName;
    protected ModulManager manager;
    protected boolean saved;

    public AbstractApplyEditor(String objektName, Object editedObject, HauptFrame frame) {
        super(objektName + " bearbeiten", frame);
        this.objektName = objektName;
        this.editedObject = editedObject;
        this.manager = frame.getManager();
        this.saved = false;
        this.fillForm();
        if (this.manager.getSettingsManager().getBoolSetting("auik.prefs.save_size")) {
            int x = this.manager.getSettingsManager().getIntSetting("auik.prefs.size_x.dialog_" + this.getEditedClassName());
            int y = this.manager.getSettingsManager().getIntSetting("auik.prefs.size_y.dialog_" + this.getEditedClassName());
            if (x > 10 && y > 10) {
                AUIKataster.debugOutput("Setze Gr\u00f6\u00dfe auf " + x + "x" + y, "Editor");
                this.setSize(x, y);
            }
        }
    }

    protected String getEditedClassName() {
        String longName = this.editedObject.getClass().getName();
        String className = longName.substring(longName.lastIndexOf(".") + 1);
        return className;
    }

    private void saveDialogSize() {
        if (this.manager.getSettingsManager().getBoolSetting("auik.prefs.save_size")) {
            this.manager.getSettingsManager().setSetting("auik.prefs.size_x.dialog_" + this.getEditedClassName(), this.getWidth(), true);
            this.manager.getSettingsManager().setSetting("auik.prefs.size_y.dialog_" + this.getEditedClassName(), this.getHeight(), true);
        }
    }

    @Override
    protected String getOkButtonText() {
        return "Speichern";
    }

    @Override
    protected void doOk() {
        if (this.canSave()) {
            if (this.doSave()) {
                this.saved = true;
                this.frame.changeStatus(this.objektName + " erfolgreich gespeichert.", HauptFrame.SUCCESS_COLOR);
            } else {
                this.saved = false;
                this.frame.changeStatus("Konnte " + this.objektName + " nicht speichern!", HauptFrame.ERROR_COLOR);
            }
            this.saveDialogSize();
            super.close();
        }
    }

    @Override
    public void close() {
        this.saved = false;
        this.frame.changeStatus("Bearbeiten abgebrochen.");
        this.saveDialogSize();
        super.close();
    }

    public Object getEditedObject() {
        return this.editedObject;
    }

    public void setEditedObject(Object newObject) {
        this.editedObject = newObject;
    }

    public boolean wasSaved() {
        return this.saved;
    }

    protected abstract void fillForm();

    protected abstract boolean canSave();

    protected abstract boolean doSave();
}

