/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.common.editors;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh49Abscheiderdetails;
import de.bielefeld.umweltamt.aui.module.common.editors.AbstractBaseEditor;
import de.bielefeld.umweltamt.aui.utils.IntegerField;
import de.bielefeld.umweltamt.aui.utils.LimitedTextArea;
import de.bielefeld.umweltamt.aui.utils.LimitedTextField;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class AbscheiderEditor
extends AbstractBaseEditor {
    private JTextField lageFeld;
    private JTextField herstellerFeld;
    private JFormattedTextField nrFeld;
    private JFormattedTextField vonFeld;
    private JTextField baujahrFeld;
    private JFormattedTextField ngsfFeld;
    private JFormattedTextField ngbaFeld;
    private JFormattedTextField ngkaFeld;
    private JFormattedTextField ngfaFeld;
    private JCheckBox tankstelleCheck;
    private JCheckBox schlammfangCheck;
    private JCheckBox benzinabscheiderCheck;
    private JCheckBox koalenszenzfilterCheck;
    private JCheckBox integriertCheck;
    private JCheckBox emulsionCheck;
    private JCheckBox schwimmerCheck;
    private JCheckBox wohnhausCheck;
    private JTextArea bemerkungsArea;

    public AbscheiderEditor(Anh49Abscheiderdetails details, HauptFrame owner) {
        super("Abscheider", details, owner);
    }

    public Anh49Abscheiderdetails getDetails() {
        return (Anh49Abscheiderdetails)this.getEditedObject();
    }

    @Override
    protected JComponent buildContentArea() {
        String columnString = "right:pref, 3dlu, 30dlu, 10dlu:g, left:max(pref;60dlu):grow";
        FormLayout layout = new FormLayout(columnString, "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, 40dlu:g");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator("Stammdaten", cc.xyw(1, 1, 5));
        builder.addLabel("Lage:", cc.xy(1, 3));
        builder.add((Component)this.getLageFeld(), cc.xyw(3, 3, 3));
        builder.addLabel("Hersteller:", cc.xy(1, 5));
        builder.add((Component)this.getHerstellerFeld(), cc.xyw(3, 5, 3));
        builder.addLabel("Nr.:", cc.xy(1, 7));
        builder.add((Component)this.getNrFeld(), cc.xy(3, 7));
        builder.add((Component)this.getTankstelleCheck(), cc.xy(5, 7));
        builder.addLabel("Von:", cc.xy(1, 9));
        builder.add((Component)this.getVonFeld(), cc.xy(3, 9));
        builder.add((Component)this.getSchlammfangCheck(), cc.xy(5, 9));
        builder.add((Component)this.getBenzinabscheiderCheck(), cc.xy(5, 11));
        builder.addLabel("NG SF:", cc.xy(1, 13));
        builder.add((Component)this.getNgsfFeld(), cc.xy(3, 13));
        builder.add((Component)this.getKoalenszenzfilterCheck(), cc.xy(5, 13));
        builder.addLabel("NG BA:", cc.xy(1, 15));
        builder.add((Component)this.getNgbaFeld(), cc.xy(3, 15));
        builder.add((Component)this.getIntegriertCheck(), cc.xy(5, 15));
        builder.addLabel("NG KA:", cc.xy(1, 17));
        builder.add((Component)this.getNgkaFeld(), cc.xy(3, 17));
        builder.add((Component)this.getEmulsionCheck(), cc.xy(5, 17));
        builder.addLabel("NG FA:", cc.xy(1, 19));
        builder.add((Component)this.getNgfaFeld(), cc.xy(3, 19));
        builder.add((Component)this.getSchwimmerCheck(), cc.xy(5, 19));
        builder.add((Component)this.getWohnhausCheck(), cc.xy(5, 21));
        builder.addSeparator("Bemerkungen", cc.xyw(1, 23, 5));
        JScrollPane bemerkungsScroller = new JScrollPane(this.getBemerkungsArea(), 20, 31);
        builder.add((Component)bemerkungsScroller, cc.xyw(1, 25, 5, "fill, fill"));
        return builder.getPanel();
    }

    @Override
    protected void fillForm() {
        this.getLageFeld().setText(this.getDetails().getLage());
        this.getHerstellerFeld().setText(this.getDetails().getHersteller());
        this.getNrFeld().setValue(this.getDetails().getAbscheidernr());
        this.getVonFeld().setValue(this.getDetails().getVon());
        this.getNgsfFeld().setValue(this.getDetails().getNgSf());
        this.getNgbaFeld().setValue(this.getDetails().getNgBa());
        this.getNgkaFeld().setValue(this.getDetails().getNgKa());
        this.getNgfaFeld().setValue(this.getDetails().getNenngroesse());
        this.getBemerkungsArea().setText(this.getDetails().getBemerkung());
        if (this.getDetails().getTankstelle().booleanValue()) {
            this.getTankstelleCheck().setSelected(true);
        } else {
            this.getTankstelleCheck().setSelected(false);
        }
        if (this.getDetails().getSchlammfang().booleanValue()) {
            this.getSchlammfangCheck().setSelected(true);
        } else {
            this.getSchlammfangCheck().setSelected(false);
        }
        if (this.getDetails().getBenzinOelabscheider().booleanValue()) {
            this.getBenzinabscheiderCheck().setSelected(true);
        } else {
            this.getBenzinabscheiderCheck().setSelected(false);
        }
        if (this.getDetails().getKoaleszenzfilter().booleanValue()) {
            this.getKoalenszenzfilterCheck().setSelected(true);
        } else {
            this.getKoalenszenzfilterCheck().setSelected(false);
        }
        if (this.getDetails().getIntegriert().booleanValue()) {
            this.getIntegriertCheck().setSelected(true);
        } else {
            this.getIntegriertCheck().setSelected(false);
        }
        if (this.getDetails().getEmulsionsspaltanlage().booleanValue()) {
            this.getEmulsionCheck().setSelected(true);
        } else {
            this.getEmulsionCheck().setSelected(false);
        }
        if (this.getDetails().getSchwimmer().booleanValue()) {
            this.getSchwimmerCheck().setSelected(true);
        } else {
            this.getSchwimmerCheck().setSelected(false);
        }
        if (this.getDetails().getWohnhaus().booleanValue()) {
            this.getWohnhausCheck().setSelected(true);
        } else {
            this.getWohnhausCheck().setSelected(false);
        }
    }

    @Override
    protected boolean canSave() {
        return true;
    }

    @Override
    protected boolean doSave() {
        String lage = this.lageFeld.getText();
        this.getDetails().setLage(lage);
        String herst = this.herstellerFeld.getText();
        this.getDetails().setHersteller(herst);
        Integer nr = ((IntegerField)this.nrFeld).getIntValue();
        this.getDetails().setAbscheidernr(nr);
        Integer von = ((IntegerField)this.vonFeld).getIntValue();
        this.getDetails().setVon(von);
        Integer ngsf = ((IntegerField)this.ngsfFeld).getIntValue();
        this.getDetails().setNgSf(ngsf);
        Integer ngba = ((IntegerField)this.ngbaFeld).getIntValue();
        this.getDetails().setNgBa(ngba);
        Integer ngka = ((IntegerField)this.ngkaFeld).getIntValue();
        this.getDetails().setNgKa(ngka);
        Integer ngfa = ((IntegerField)this.ngfaFeld).getIntValue();
        this.getDetails().setNenngroesse(ngfa);
        if (this.getTankstelleCheck().isSelected()) {
            this.getDetails().setTankstelle(true);
        } else {
            this.getDetails().setTankstelle(false);
        }
        if (this.getSchlammfangCheck().isSelected()) {
            this.getDetails().setSchlammfang(true);
        } else {
            this.getDetails().setSchlammfang(false);
        }
        if (this.getBenzinabscheiderCheck().isSelected()) {
            this.getDetails().setBenzinOelabscheider(true);
        } else {
            this.getDetails().setBenzinOelabscheider(false);
        }
        if (this.getKoalenszenzfilterCheck().isSelected()) {
            this.getDetails().setKoaleszenzfilter(true);
        } else {
            this.getDetails().setKoaleszenzfilter(false);
        }
        if (this.getIntegriertCheck().isSelected()) {
            this.getDetails().setIntegriert(true);
        } else {
            this.getDetails().setIntegriert(false);
        }
        if (this.getEmulsionCheck().isSelected()) {
            this.getDetails().setEmulsionsspaltanlage(true);
        } else {
            this.getDetails().setEmulsionsspaltanlage(false);
        }
        if (this.getSchwimmerCheck().isSelected()) {
            this.getDetails().setSchwimmer(true);
        } else {
            this.getDetails().setSchwimmer(false);
        }
        if (this.getWohnhausCheck().isSelected()) {
            this.getDetails().setWohnhaus(true);
        } else {
            this.getDetails().setWohnhaus(false);
        }
        String bem = this.bemerkungsArea.getText();
        this.getDetails().setBemerkung(bem);
        boolean save = Anh49Abscheiderdetails.saveAbscheider(this.getDetails());
        save = true;
        if (true) {
            AUIKataster.debugOutput("\u00c4nderungen gespeichert!", "editStandort");
            return true;
        }
        return false;
    }

    private JTextField getBaujahrFeld() {
        if (this.baujahrFeld == null) {
            this.baujahrFeld = new LimitedTextField(50);
        }
        return this.baujahrFeld;
    }

    private JCheckBox getBenzinabscheiderCheck() {
        if (this.benzinabscheiderCheck == null) {
            this.benzinabscheiderCheck = new JCheckBox("Benzinabscheider");
        }
        return this.benzinabscheiderCheck;
    }

    private JCheckBox getEmulsionCheck() {
        if (this.emulsionCheck == null) {
            this.emulsionCheck = new JCheckBox("Emulsionsspaltanlage");
        }
        return this.emulsionCheck;
    }

    private JTextField getHerstellerFeld() {
        if (this.herstellerFeld == null) {
            this.herstellerFeld = new LimitedTextField(50);
        }
        return this.herstellerFeld;
    }

    private JCheckBox getIntegriertCheck() {
        if (this.integriertCheck == null) {
            this.integriertCheck = new JCheckBox("integriert");
        }
        return this.integriertCheck;
    }

    private JCheckBox getKoalenszenzfilterCheck() {
        if (this.koalenszenzfilterCheck == null) {
            this.koalenszenzfilterCheck = new JCheckBox("Koaleszenzfilter");
        }
        return this.koalenszenzfilterCheck;
    }

    private JTextField getLageFeld() {
        if (this.lageFeld == null) {
            this.lageFeld = new LimitedTextField(50);
        }
        return this.lageFeld;
    }

    private JFormattedTextField getNgbaFeld() {
        if (this.ngbaFeld == null) {
            this.ngbaFeld = new IntegerField();
        }
        return this.ngbaFeld;
    }

    private JFormattedTextField getNgkaFeld() {
        if (this.ngkaFeld == null) {
            this.ngkaFeld = new IntegerField();
        }
        return this.ngkaFeld;
    }

    private JFormattedTextField getNgfaFeld() {
        if (this.ngfaFeld == null) {
            this.ngfaFeld = new IntegerField();
        }
        return this.ngfaFeld;
    }

    private JFormattedTextField getNgsfFeld() {
        if (this.ngsfFeld == null) {
            this.ngsfFeld = new IntegerField();
        }
        return this.ngsfFeld;
    }

    private JFormattedTextField getNrFeld() {
        if (this.nrFeld == null) {
            this.nrFeld = new IntegerField();
        }
        return this.nrFeld;
    }

    private JCheckBox getSchlammfangCheck() {
        if (this.schlammfangCheck == null) {
            this.schlammfangCheck = new JCheckBox("Schlammfang");
        }
        return this.schlammfangCheck;
    }

    private JCheckBox getSchwimmerCheck() {
        if (this.schwimmerCheck == null) {
            this.schwimmerCheck = new JCheckBox("Schwimmer");
        }
        return this.schwimmerCheck;
    }

    private JCheckBox getTankstelleCheck() {
        if (this.tankstelleCheck == null) {
            this.tankstelleCheck = new JCheckBox("Tankstelle");
        }
        return this.tankstelleCheck;
    }

    private JFormattedTextField getVonFeld() {
        if (this.vonFeld == null) {
            this.vonFeld = new IntegerField();
        }
        return this.vonFeld;
    }

    private JCheckBox getWohnhausCheck() {
        if (this.wohnhausCheck == null) {
            this.wohnhausCheck = new JCheckBox("Wohnhaus");
        }
        return this.wohnhausCheck;
    }

    private JTextArea getBemerkungsArea() {
        if (this.bemerkungsArea == null) {
            this.bemerkungsArea = new LimitedTextArea(255);
            this.bemerkungsArea.setLineWrap(true);
            this.bemerkungsArea.setWrapStyleWord(true);
        }
        return this.bemerkungsArea;
    }
}

