/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.common;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.toedter.calendar.JDateChooser;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlKlaeranlagen;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbeart;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbenahmen;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbepkt;
import de.bielefeld.umweltamt.aui.module.common.editors.ProbenEditor;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.ProbenahmenModel;
import de.bielefeld.umweltamt.aui.utils.LimitedTextField;
import de.bielefeld.umweltamt.aui.utils.SwingWorkerVariant;
import de.bielefeld.umweltamt.aui.utils.TableFocusListener;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Timestamp;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class SchlammPanel
extends JPanel {
    private AtlProbeart art;
    private HauptFrame frame;
    private ProbenahmenModel probeModel;
    private AtlProbenahmen lastProbe;
    private Action probeEditAction;
    private Action probeLoeschAction;
    private JComboBox anlageBox;
    private JTable probeTabelle;
    private JPanel anlegenPanel;
    private JTextField kennummerFeld;
    private JDateChooser datumsChooser;
    private JButton anlegenButton;
    private JPopupMenu probePopup;

    public SchlammPanel(AtlProbeart art, HauptFrame frame) {
        super((LayoutManager)new FormLayout("pref, 4dlu, pref:grow", "pref, 3dlu, 140dlu:grow, 3dlu, pref"));
        this.art = art;
        this.frame = frame;
        this.setBorder(Borders.DIALOG_BORDER);
        this.probeModel = new ProbenahmenModel();
        TableFocusListener tfl = TableFocusListener.getInstance();
        this.getProbeTabelle().addFocusListener(tfl);
        JScrollPane probeScroller = new JScrollPane(this.getProbeTabelle());
        JLabel anlageLabel = new JLabel("Kl\u00e4ranlage:");
        FormLayout anlegenLayout = new FormLayout("pref, 4dlu, max(60dlu;pref), 7dlu, pref, 4dlu, max(60dlu;pref), 7dlu, max(60dlu;pref)", "");
        DefaultFormBuilder anlPanelBuilder = new DefaultFormBuilder(anlegenLayout);
        anlPanelBuilder.appendSeparator("Neue Probenahme");
        anlPanelBuilder.append("Kennummer:", (Component)this.getKennummerFeld());
        anlPanelBuilder.append("Datum:", (Component)this.getDatumsChooser());
        anlPanelBuilder.append((Component)this.getAnlegenButton());
        this.anlegenPanel = anlPanelBuilder.getPanel();
        CellConstraints cc = new CellConstraints();
        this.add((Component)anlageLabel, cc.xy(1, 1));
        this.add((Component)this.getAnlageBox(), cc.xy(3, 1));
        this.add((Component)probeScroller, cc.xyw(1, 3, 3, "f, f"));
        this.add((Component)this.anlegenPanel, cc.xyw(1, 5, 3));
    }

    public void updateProbeListe() {
        AtlKlaeranlagen ka = (AtlKlaeranlagen)this.getAnlageBox().getSelectedItem();
        this.setKlaeranlage(ka, this.art);
    }

    public void setKlaeranlage(final AtlKlaeranlagen ka, final AtlProbeart art) {
        SwingWorkerVariant worker = new SwingWorkerVariant(this.getProbeTabelle()){

            @Override
            protected void doNonUILogic() throws RuntimeException {
                SchlammPanel.this.probeModel.findByKA(art, ka);
            }

            @Override
            protected void doUIUpdateLogic() throws RuntimeException {
                SchlammPanel.this.probeModel.fireTableDataChanged();
                if (SchlammPanel.this.lastProbe != null) {
                    int row = SchlammPanel.this.probeModel.getList().indexOf(SchlammPanel.this.lastProbe);
                    if (row != -1) {
                        SchlammPanel.this.getProbeTabelle().setRowSelectionInterval(row, row);
                        SchlammPanel.this.getProbeTabelle().scrollRectToVisible(SchlammPanel.this.getProbeTabelle().getCellRect(row, 0, true));
                    }
                } else {
                    String statusMsg = "Suche: " + SchlammPanel.this.probeModel.getRowCount() + " " + art + "-Probenahme";
                    if (SchlammPanel.this.probeModel.getRowCount() != 1) {
                        statusMsg = statusMsg + "n";
                    }
                    statusMsg = statusMsg + " in der KA " + ka + " gefunden.";
                    SchlammPanel.this.frame.changeStatus(statusMsg);
                }
            }
        };
        if (this.lastProbe == null) {
            this.frame.changeStatus("Suche...");
        }
        worker.start();
    }

    public void editProbenahme(AtlProbenahmen probe) {
        ProbenEditor editDialog = new ProbenEditor(probe, this.frame, false);
        editDialog.setVisible(true);
        this.lastProbe = probe;
        this.updateProbeListe();
    }

    public void neueProbenahme(String kennNummer, Timestamp datum) {
        boolean exists = AtlProbenahmen.probenahmeExists(kennNummer);
        if (!exists) {
            AtlProbenahmen probe = new AtlProbenahmen();
            probe.setKennummer(kennNummer);
            probe.setDatumDerEntnahme(datum);
            probe.setAtlAnalysepositionen(new HashSet());
            AtlKlaeranlagen ka = (AtlKlaeranlagen)this.getAnlageBox().getSelectedItem();
            AtlProbepkt pkt = AtlProbepkt.getKlaerschlammProbepunkt(this.art, ka);
            if (pkt != null) {
                probe.setAtlProbepkt(pkt);
                ProbenEditor editDialog = new ProbenEditor(probe, this.frame, true);
                editDialog.setVisible(true);
                this.lastProbe = probe;
                this.updateProbeListe();
            } else {
                this.frame.changeStatus("F\u00fcr " + this.art + " existiert in der KA " + ka + " kein Probepunkt!", HauptFrame.ERROR_COLOR);
            }
        } else {
            this.frame.changeStatus("Eine Probenahme mit dieser Kennnummer existiert schon!", HauptFrame.ERROR_COLOR);
        }
    }

    public void showContent() {
        this.lastProbe = null;
        if (AtlKlaeranlagen.getKlaeranlagen().length != 0) {
            this.getAnlageBox().setSelectedIndex(AtlKlaeranlagen.HEEPEN - 1);
        }
    }

    private Action getProbeEditAction() {
        if (this.probeEditAction == null) {
            this.probeEditAction = new AbstractAction("Bearbeiten"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = SchlammPanel.this.getProbeTabelle().getSelectedRow();
                    if (row != -1) {
                        AtlProbenahmen probe = SchlammPanel.this.probeModel.getRow(row);
                        SchlammPanel.this.editProbenahme(probe);
                    }
                }
            };
            this.probeEditAction.putValue("MnemonicKey", new Integer(66));
            this.probeEditAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0, false));
        }
        return this.probeEditAction;
    }

    private Action getProbeLoeschAction() {
        if (this.probeLoeschAction == null) {
            this.probeLoeschAction = new AbstractAction("L\u00f6schen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = SchlammPanel.this.getProbeTabelle().getSelectedRow();
                    if (row != -1 && SchlammPanel.this.getProbeTabelle().getEditingRow() == -1) {
                        AtlProbenahmen probe = SchlammPanel.this.probeModel.getRow(row);
                        if (SchlammPanel.this.frame.showQuestion("Soll die Probenahme '" + probe.getKennummer() + "' wirklich inkl. aller Analysen gel\u00f6scht werden?", "L\u00f6schen best\u00e4tigen")) {
                            if (SchlammPanel.this.probeModel.removeRow(row)) {
                                SchlammPanel.this.frame.changeStatus("Probenahme gel\u00f6scht!", HauptFrame.SUCCESS_COLOR);
                                AUIKataster.debugOutput("Probe " + probe.getKennummer() + " wurde gel\u00f6scht!", "SchlammPanel.removeAction");
                            } else {
                                SchlammPanel.this.frame.changeStatus("Konnte Probenahme nicht l\u00f6schen!", HauptFrame.ERROR_COLOR);
                            }
                        }
                    }
                }
            };
            this.probeLoeschAction.putValue("MnemonicKey", new Integer(76));
            this.probeLoeschAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0, false));
        }
        return this.probeLoeschAction;
    }

    private void showProbePopup(MouseEvent e) {
        if (this.probePopup == null) {
            this.probePopup = new JPopupMenu("Probe");
            JMenuItem bearbItem = new JMenuItem(this.getProbeEditAction());
            JMenuItem loeschItem = new JMenuItem(this.getProbeLoeschAction());
            this.probePopup.add(bearbItem);
            this.probePopup.add(loeschItem);
        }
        if (e.isPopupTrigger()) {
            Point origin = e.getPoint();
            int row = this.getProbeTabelle().rowAtPoint(origin);
            if (row != -1) {
                this.getProbeTabelle().setRowSelectionInterval(row, row);
                this.probePopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private JComboBox getAnlageBox() {
        if (this.anlageBox == null) {
            this.anlageBox = new JComboBox<AtlKlaeranlagen>(AtlKlaeranlagen.getKlaeranlagen());
            this.anlageBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SchlammPanel.this.lastProbe = null;
                    SchlammPanel.this.updateProbeListe();
                }
            });
        }
        return this.anlageBox;
    }

    private JTable getProbeTabelle() {
        if (this.probeTabelle == null) {
            this.probeTabelle = new JTable(this.probeModel);
            this.probeTabelle.setSelectionMode(0);
            this.probeTabelle.setColumnSelectionAllowed(false);
            this.probeTabelle.setRowSelectionAllowed(true);
            this.probeTabelle.getColumnModel().getColumn(0).setPreferredWidth(30);
            this.probeTabelle.getColumnModel().getColumn(1).setPreferredWidth(30);
            this.probeTabelle.getColumnModel().getColumn(2).setPreferredWidth(200);
            this.probeTabelle.getInputMap().put((KeyStroke)this.getProbeEditAction().getValue("AcceleratorKey"), this.getProbeEditAction().getValue("Name"));
            this.probeTabelle.getActionMap().put(this.getProbeEditAction().getValue("Name"), this.getProbeEditAction());
            this.probeTabelle.getInputMap().put((KeyStroke)this.getProbeLoeschAction().getValue("AcceleratorKey"), this.getProbeLoeschAction().getValue("Name"));
            this.probeTabelle.getActionMap().put(this.getProbeLoeschAction().getValue("Name"), this.getProbeLoeschAction());
            this.probeTabelle.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        Point origin = e.getPoint();
                        int row = SchlammPanel.this.getProbeTabelle().rowAtPoint(origin);
                        AtlProbenahmen probe = SchlammPanel.this.probeModel.getRow(row);
                        SchlammPanel.this.editProbenahme(probe);
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    SchlammPanel.this.showProbePopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    SchlammPanel.this.showProbePopup(e);
                }
            });
        }
        return this.probeTabelle;
    }

    private JTextField getKennummerFeld() {
        if (this.kennummerFeld == null) {
            this.kennummerFeld = new LimitedTextField(50, "");
        }
        return this.kennummerFeld;
    }

    private JDateChooser getDatumsChooser() {
        if (this.datumsChooser == null) {
            this.datumsChooser = new JDateChooser("dd.MM.yy", false);
        }
        return this.datumsChooser;
    }

    private JButton getAnlegenButton() {
        if (this.anlegenButton == null) {
            this.anlegenButton = new JButton("Anlegen");
            this.anlegenButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SchlammPanel.this.getKennummerFeld().getText().trim().equals("")) {
                        SchlammPanel.this.getKennummerFeld().requestFocus();
                        SchlammPanel.this.frame.changeStatus("Leere Kennummer!", HauptFrame.ERROR_COLOR);
                    } else {
                        String kennNummer = SchlammPanel.this.getKennummerFeld().getText().trim().replaceAll(" ", "");
                        Timestamp datum = new Timestamp(SchlammPanel.this.getDatumsChooser().getDate().getTime());
                        SchlammPanel.this.neueProbenahme(kennNummer, datum);
                    }
                }
            });
        }
        return this.anlegenButton;
    }
}

