/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.common;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjekt;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjektverknuepfung;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.BasisObjektModel;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.ObjektVerknuepfungModel;
import de.bielefeld.umweltamt.aui.utils.TabAction;
import de.bielefeld.umweltamt.aui.utils.TableFocusListener;
import de.bielefeld.umweltamt.aui.utils.dialogbase.OkCancelDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class ObjektChooser
extends OkCancelDialog {
    private JTable ergebnisTabelle;
    private BasisObjektModel objektModel = new BasisObjektModel("Betreiber", null);
    private BasisObjekt chosenObjekt = null;
    private BasisObjekt objekt = null;
    private ObjektVerknuepfungModel objektVerknuepfungModel;

    public ObjektChooser(HauptFrame owner, BasisObjekt objekt, ObjektVerknuepfungModel objektVerknuepfungModel) {
        super("Objekt ausw\u00e4hlen", owner);
        this.objekt = objekt;
        this.objektVerknuepfungModel = objektVerknuepfungModel;
        this.getErgebnisTabelle().setModel(this.objektModel);
        this.ergebnisTabelle.getColumnModel().getColumn(0).setPreferredWidth(10);
        this.ergebnisTabelle.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.ergebnisTabelle.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.ergebnisTabelle.getColumnModel().getColumn(3).setPreferredWidth(100);
        this.setResizable(true);
        this.objektModel.searchByStandort(objekt.getBasisStandort());
        this.objektModel.fireTableDataChanged();
    }

    @Override
    protected void doOk() {
        int row = this.getErgebnisTabelle().getSelectedRow();
        this.choose(row, this.objekt, this.objektVerknuepfungModel);
    }

    private void choose(int row, BasisObjekt objekt, ObjektVerknuepfungModel objektVerknuepfungModel) {
        if (row != -1) {
            this.chosenObjekt = (BasisObjekt)this.objektModel.getObjectAtRow(row);
            BasisObjektverknuepfung neueov = new BasisObjektverknuepfung();
            neueov.setBasisObjektByObjekt(objekt);
            neueov.setBasisObjektByIstVerknuepftMit(this.chosenObjekt);
            BasisObjektverknuepfung.saveObjektVerknuepfung(neueov);
            objektVerknuepfungModel.updateList();
            this.dispose();
        }
    }

    public BasisObjekt getChosenObjekt() {
        return this.chosenObjekt;
    }

    @Override
    protected JComponent buildContentArea() {
        JScrollPane tabellenScroller = new JScrollPane(this.getErgebnisTabelle(), 20, 31);
        TabAction ta = new TabAction();
        ta.addComp(this.ergebnisTabelle);
        FormLayout layout = new FormLayout("180dlu:g, 3dlu, min(16dlu;p)", "300dlu:g");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        builder.add((Component)tabellenScroller, cc.xyw(1, 1, 3));
        return builder.getPanel();
    }

    private JTable getErgebnisTabelle() {
        if (this.ergebnisTabelle == null) {
            this.ergebnisTabelle = new JTable();
            AbstractAction submitAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ObjektChooser.this.doOk();
                }
            };
            submitAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0, false));
            this.ergebnisTabelle.getInputMap().put((KeyStroke)submitAction.getValue("AcceleratorKey"), submitAction.getValue("Name"));
            this.ergebnisTabelle.getActionMap().put(submitAction.getValue("Name"), submitAction);
            this.ergebnisTabelle.addFocusListener(TableFocusListener.getInstance());
        }
        return this.ergebnisTabelle;
    }
}

