/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module.common;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AbstractModul;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjekt;
import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh49Abscheiderdetails;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.ListTableModel;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public abstract class AbstractQueryModul
extends AbstractModul {
    private JScrollPane tableScroller;
    private JTable resultTable;
    private Action objektEditAction;
    private Action saveAction;
    private JPopupMenu resultPopup;

    @Override
    public String getCategory() {
        return "Auswertung";
    }

    @Override
    public JPanel getPanel() {
        if (this.panel == null) {
            FormLayout layout = new FormLayout("100dlu:g", "pref, 3dlu, f:150dlu:grow");
            PanelBuilder builder = new PanelBuilder(layout);
            builder.setDefaultDialogBorder();
            CellConstraints cc = new CellConstraints();
            builder.add((Component)this.getQueryOptionsPanel(), cc.xy(1, 1));
            builder.add((Component)this.getTableScroller(), cc.xy(1, 3));
            this.panel = builder.getPanel();
        }
        return this.panel;
    }

    public abstract JPanel getQueryOptionsPanel();

    public abstract ListTableModel getTableModel();

    protected BasisObjekt getBasisObjektFromFachdaten(Object fachdaten) {
        BasisObjekt tmp;
        try {
            Method getBO = fachdaten.getClass().getMethod("getBasisObjekt", null);
            tmp = (BasisObjekt)getBO.invoke(fachdaten, null);
        }
        catch (Exception e) {
            tmp = null;
        }
        return tmp;
    }

    protected JTable getResultTable() {
        if (this.resultTable == null) {
            this.resultTable = new JTable(this.getTableModel());
            this.resultTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        Point origin = e.getPoint();
                        int row = AbstractQueryModul.this.resultTable.rowAtPoint(origin);
                        AbstractQueryModul.this.editObject(row);
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    AbstractQueryModul.this.showResultPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    AbstractQueryModul.this.showResultPopup(e);
                }
            });
            this.resultTable.getInputMap().put((KeyStroke)this.getObjektEditAction().getValue("AcceleratorKey"), this.getObjektEditAction().getValue("Name"));
            this.resultTable.getActionMap().put(this.getObjektEditAction().getValue("Name"), this.getObjektEditAction());
        }
        return this.resultTable;
    }

    private JScrollPane getTableScroller() {
        if (this.tableScroller == null) {
            this.tableScroller = new JScrollPane(this.getResultTable());
        }
        return this.tableScroller;
    }

    protected Action getObjektEditAction() {
        if (this.objektEditAction == null) {
            this.objektEditAction = new AbstractAction("Bearbeiten"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = AbstractQueryModul.this.getResultTable().getSelectedRow();
                    AbstractQueryModul.this.editObject(row);
                }
            };
            this.objektEditAction.putValue("MnemonicKey", new Integer(66));
            this.objektEditAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0, false));
        }
        return this.objektEditAction;
    }

    protected Action getSaveAction() {
        if (this.saveAction == null) {
            this.saveAction = new AbstractAction("Tabelle exportieren"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AuikUtils.saveTabelle(AbstractQueryModul.this.getResultTable(), AbstractQueryModul.this.frame);
                }
            };
            this.saveAction.putValue("MnemonicKey", new Integer(69));
            this.saveAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 512, false));
        }
        return this.saveAction;
    }

    private void showResultPopup(MouseEvent e) {
        if (this.resultPopup == null) {
            this.resultPopup = new JPopupMenu("Objekt");
            JMenuItem bearbItem = new JMenuItem(this.getObjektEditAction());
            JMenuItem saveItem = new JMenuItem(this.getSaveAction());
            this.resultPopup.add(bearbItem);
            this.resultPopup.add(saveItem);
        }
        if (e.isPopupTrigger()) {
            Point origin = e.getPoint();
            int row = this.getResultTable().rowAtPoint(origin);
            if (row != -1) {
                this.getResultTable().setRowSelectionInterval(row, row);
                this.resultPopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    protected void editObject(int row) {
        if (row != -1) {
            Anh49Abscheiderdetails ad;
            BasisObjekt obj = this.getBasisObjektFromFachdaten(this.getTableModel().getObjectAtRow(row));
            if (obj == null && (ad = (Anh49Abscheiderdetails)this.getTableModel().getObjectAtRow(row)) != null) {
                obj = ad.getAnh49Fachdaten().getBasisObjekt();
            }
            if (obj != null) {
                this.manager.getSettingsManager().setSetting("auik.imc.edit_object", obj.getObjektid(), false);
                this.manager.switchModul("m_objekt_bearbeiten");
            }
        }
    }
}

