/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module;

import de.bielefeld.umweltamt.aui.mappings.vaws.VawsFachdaten;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsKontrollen;
import de.bielefeld.umweltamt.aui.module.WiedervorlageSVModel;
import de.bielefeld.umweltamt.aui.module.common.AbstractQueryModul;
import de.bielefeld.umweltamt.aui.module.common.editors.VawsEditor;
import de.bielefeld.umweltamt.aui.utils.SwingWorkerVariant;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.ListTableModel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class VawsKontrollenAuswertung
extends AbstractQueryModul {
    private WiedervorlageSVModel model;

    @Override
    protected void editObject(int row) {
        if (row != -1) {
            VawsFachdaten fd = ((VawsKontrollen)this.model.getObjectAtRow(row)).getVawsFachdaten();
            VawsEditor editor = new VawsEditor(fd, this.frame, "Sachverst\u00e4ndigenpr\u00fcfung");
            editor.setVisible(true);
            if (editor.wasSaved()) {
                this.updateListe();
            }
        }
    }

    @Override
    public JPanel getQueryOptionsPanel() {
        return new JPanel();
    }

    @Override
    public ListTableModel getTableModel() {
        if (this.model == null) {
            this.model = new WiedervorlageSVModel();
        }
        return this.model;
    }

    public void updateListe() {
        SwingWorkerVariant worker = new SwingWorkerVariant(this.getResultTable(10, 10, 15, 250, 250)){

            @Override
            protected void doNonUILogic() throws RuntimeException {
                ((WiedervorlageSVModel)VawsKontrollenAuswertung.this.getTableModel()).updateList();
            }

            @Override
            protected void doUIUpdateLogic() throws RuntimeException {
                VawsKontrollenAuswertung.this.getTableModel().fireTableDataChanged();
                VawsKontrollenAuswertung.this.frame.changeStatus(VawsKontrollenAuswertung.this.getTableModel().getRowCount() + " Objekte gefunden");
            }
        };
        worker.start();
    }

    private JTable getResultTable(int a, int b, int c, int d, int e) {
        JTable resultTable = this.getResultTable();
        resultTable.setAutoResizeMode(1);
        TableColumn column = null;
        for (int i = 0; i < 5; ++i) {
            column = resultTable.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(a);
                continue;
            }
            if (i == 1) {
                column.setPreferredWidth(b);
                continue;
            }
            if (i == 2) {
                column.setPreferredWidth(c);
                continue;
            }
            if (i == 3) {
                column.setPreferredWidth(d);
                continue;
            }
            if (i != 4) continue;
            column.setPreferredWidth(e);
        }
        return resultTable;
    }

    @Override
    public void show() {
        super.show();
        this.updateListe();
    }

    @Override
    public String getName() {
        return "Wiedervorlage Sachverst\u00e4ndigen - Pr\u00fcfung";
    }

    @Override
    public String getCategory() {
        return "VAwS";
    }
}

