/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsFachdaten;
import de.bielefeld.umweltamt.aui.module.common.AbstractQueryModul;
import de.bielefeld.umweltamt.aui.module.common.editors.VawsEditor;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.HerstellNrSuchenModel;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.ListTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VawsHerstellernummerSuchen
extends AbstractQueryModul {
    private JPanel queryPanel;
    private String iconPath = "filefind32.png";
    private JTextField herstellFeld;
    private JButton suchenButton;
    private HerstellNrSuchenModel ergebnisModel;

    @Override
    public String getName() {
        return "Herstellnr. suchen";
    }

    @Override
    public String getCategory() {
        return "VAwS";
    }

    @Override
    public Icon getIcon() {
        return super.getIcon(this.iconPath);
    }

    public void SuchStart() {
        String herstellnr = this.herstellFeld.getText();
        AUIKataster.debugOutput("(VawsHerstellernummerSuchen): Suche nach Herstellnummer " + herstellnr);
        ((HerstellNrSuchenModel)this.getTableModel()).setList(VawsFachdaten.findherstellnr(herstellnr));
        ((HerstellNrSuchenModel)this.getTableModel()).fireTableDataChanged();
        this.frame.changeStatus("" + this.getTableModel().getRowCount() + " Objekte gefunden");
        AUIKataster.debugOutput("(VawsHerstellernummerSuchen): " + this.getTableModel().getRowCount() + " Objekt(e) mit Herstellnummer " + herstellnr + " gefunden");
    }

    @Override
    public JPanel getQueryOptionsPanel() {
        if (this.queryPanel == null) {
            this.herstellFeld = new JTextField("", 12);
            this.suchenButton = new JButton("Suchen");
            this.suchenButton.setToolTipText("Herstellnummer suchen");
            this.herstellFeld.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        VawsHerstellernummerSuchen.this.SuchStart();
                    }
                }
            });
            this.suchenButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VawsHerstellernummerSuchen.this.SuchStart();
                }
            });
            FormLayout layout = new FormLayout("pref, 3dlu, pref, 3dlu, pref, 20dlu, pref, 3dlu, pref, 3dlu, pref, 20dlu, pref");
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.append("Herstellnr.:", (Component)this.herstellFeld, (Component)this.suchenButton);
            builder.nextLine();
            builder.append("");
            this.queryPanel = builder.getPanel();
        }
        return this.queryPanel;
    }

    @Override
    protected void editObject(int row) {
        if (row != -1) {
            VawsFachdaten fachdaten = (VawsFachdaten)this.ergebnisModel.getObjectAtRow(row);
            VawsEditor editor = new VawsEditor(fachdaten, this.frame, "Herstellnummer");
            editor.setVisible(true);
        }
    }

    @Override
    public ListTableModel getTableModel() {
        if (this.ergebnisModel == null) {
            this.ergebnisModel = new HerstellNrSuchenModel();
        }
        return this.ergebnisModel;
    }
}

