/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module;

import de.bielefeld.umweltamt.aui.mappings.atl.AtlAnalyseposition;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlParameter;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbenahmen;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbepkt;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.ListTableModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SielhautProbeModel
extends ListTableModel {
    private AtlProbepkt probepkt;
    private Map wertMap;
    private AtlParameter[] params = new AtlParameter[]{AtlParameter.getParameter("L11380"), AtlParameter.getParameter("L11650"), AtlParameter.getParameter("L11510"), AtlParameter.getParameter("L11610"), AtlParameter.getParameter("L11880"), AtlParameter.getParameter("L11660"), AtlParameter.getParameter("L11640")};

    public SielhautProbeModel() {
        super(new String[]{"Kennnummer", "Datum"}, false, true);
        this.columns = new String[this.params.length + 2];
        this.columns[0] = "Kennnummer";
        this.columns[1] = "Datum";
        for (int i = 0; i < this.params.length; ++i) {
            if (this.params[i] == null) continue;
            this.columns[i + 2] = this.params[i].toString();
        }
        this.wertMap = new HashMap();
    }

    public void setProbepunkt(AtlProbepkt probepkt) {
        this.probepkt = probepkt;
    }

    @Override
    public void updateList() {
        if (this.probepkt != null) {
            this.setList(AtlProbenahmen.getProbenahmen(this.probepkt, true, -1));
            this.wertMap.clear();
            for (int i = 0; i < this.getList().size(); ++i) {
                AtlProbenahmen probe = this.getRow(i);
                ArrayList<AtlAnalyseposition> wertList = new ArrayList<AtlAnalyseposition>(this.params.length);
                for (int j = 0; j < this.params.length; ++j) {
                    AtlParameter param = this.params[j];
                    List posList = AtlAnalyseposition.getAnalysepositionen(probe, param);
                    AtlAnalyseposition pos = posList.size() > 0 ? (AtlAnalyseposition)posList.get(0) : null;
                    wertList.add(j, pos);
                }
                this.wertMap.put(this.getList().get(i), wertList);
            }
        }
    }

    @Override
    public Object getColumnValue(Object objectAtRow, int columnIndex) {
        String tmp;
        List wertList;
        AtlAnalyseposition pos;
        AtlProbenahmen probe = (AtlProbenahmen)objectAtRow;
        String value = columnIndex == 0 ? probe.getKennummer() : (columnIndex == 1 ? AuikUtils.getStringFromDate(probe.getDatumDerEntnahme()) : ((pos = (AtlAnalyseposition)(wertList = (List)this.wertMap.get(probe)).get(columnIndex - 2)) != null ? (tmp = pos.getWert().toString().replace(".", ",")) : "-"));
        return value;
    }

    @Override
    public boolean objectRemoved(Object objectAtRow) {
        AtlProbenahmen removedProbe = (AtlProbenahmen)objectAtRow;
        boolean removed = removedProbe.getKennummer() != null ? AtlProbenahmen.removeProbenahme(removedProbe) : true;
        return removed;
    }

    public AtlProbenahmen getRow(int rowIndex) {
        return (AtlProbenahmen)this.getObjectAtRow(rowIndex);
    }
}

