/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlSielhaut;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.ListTableModel;

class SielhautModel
extends ListTableModel {
    public SielhautModel() {
        super(new String[]{"Bezeichnung", "Lage", "R", "F", "A", "N"}, false);
    }

    @Override
    public Object getColumnValue(Object objectAtRow, int columnIndex) {
        Object tmp;
        AtlSielhaut spunkt = (AtlSielhaut)objectAtRow;
        switch (columnIndex) {
            case 0: {
                tmp = spunkt.getBezeichnung();
                break;
            }
            case 1: {
                tmp = spunkt.getLage();
                break;
            }
            case 2: {
                if (spunkt.getPsielhaut() == null) {
                    tmp = new Boolean(false);
                    break;
                }
                tmp = new Boolean(spunkt.getPsielhaut());
                break;
            }
            case 3: {
                if (spunkt.getPfirmenprobe() == null) {
                    tmp = new Boolean(false);
                    break;
                }
                tmp = new Boolean(spunkt.getPfirmenprobe());
                break;
            }
            case 4: {
                if (spunkt.getPalarmplan() == null) {
                    tmp = new Boolean(false);
                    break;
                }
                tmp = new Boolean(spunkt.getPalarmplan());
                break;
            }
            case 5: {
                if (spunkt.getPnachprobe() == null) {
                    tmp = new Boolean(false);
                    break;
                }
                tmp = new Boolean(spunkt.getPnachprobe());
                break;
            }
            default: {
                tmp = "FEHLER!";
            }
        }
        return tmp;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex > 1) {
            return Boolean.class;
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public void updateList() {
    }

    public void filterList(String suche) {
        this.setList(AtlSielhaut.findPunkte(suche));
        AUIKataster.debugOutput("Suche nach '" + suche + "' (" + this.getList().size() + " Ergebnisse)", "SielhautModel.filterList()");
    }
}

