/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.AbstractModul;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlAnalyseposition;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlEinheiten;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlParameter;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbenahmen;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.ListTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SielhautImport
extends AbstractModul {
    private JFileChooser fc = null;
    private JLabel stepOneLabel = null;
    private JLabel stepTwoLabel = null;
    private JLabel stepThreeLabel = null;
    private Icon stepOneW;
    private Icon stepOneG;
    private Icon stepOneGrey;
    private Icon stepTwoW;
    private Icon stepTwoG;
    private Icon stepTwoGrey;
    private Icon stepThreeW;
    private Icon stepThreeG;
    private Icon stepThreeGrey;
    private JButton dateiButton;
    private JButton importButton;
    private JLabel dateiLabel;
    private JTable importTabelle;
    private JScrollPane importScroller;
    private JLabel erklaerungsLabel;
    private FileImporter fileImporter;
    private int step;

    @Override
    public String getName() {
        return "Sielhaut-Import";
    }

    @Override
    public String getIdentifier() {
        return "m_sielhaut_import";
    }

    @Override
    public String getCategory() {
        return "Sielhaut";
    }

    @Override
    public Icon getIcon() {
        return super.getIcon("ksysguard.png");
    }

    @Override
    public JPanel getPanel() {
        if (this.panel == null) {
            this.initIcons();
            FormLayout layout = new FormLayout("40px, 5dlu, 65dlu, 5dlu, 175dlu:g", "");
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.setDefaultDialogBorder();
            builder.append((Component)this.getStepOneLabel(), (Component)this.getDateiButton(), (Component)this.getDateiLabel());
            builder.appendRelatedComponentsGapRow();
            builder.appendRow("f:50dlu:g");
            builder.nextLine(2);
            builder.append((Component)this.getStepTwoLabel());
            builder.append((Component)this.getImportScroller(), 3);
            builder.appendRelatedComponentsGapRow();
            builder.nextLine(2);
            builder.append("");
            builder.append((Component)this.getErklaerungsLabel(), 3);
            builder.appendRelatedComponentsGapRow();
            builder.nextLine(2);
            builder.append((Component)this.getStepThreeLabel(), (Component)this.getImportButton());
            this.panel = builder.getPanel();
        }
        return this.panel;
    }

    @Override
    public void show() {
        super.show();
        this.switchToStep(1);
    }

    private void initIcons() {
        this.stepOneW = AuikUtils.getIcon("step1_w.png", "Schritt Eins");
        this.stepOneG = AuikUtils.getIcon("step1_g.png", "Schritt Eins");
        this.stepOneGrey = AuikUtils.getIcon("step1_grey.png", "Schritt Eins");
        this.stepTwoW = AuikUtils.getIcon("step2_w.png", "Schritt Zwei");
        this.stepTwoG = AuikUtils.getIcon("step2_g.png", "Schritt Zwei");
        this.stepTwoGrey = AuikUtils.getIcon("step2_grey.png", "Schritt Zwei");
        this.stepThreeW = AuikUtils.getIcon("step3_w.png", "Schritt Drei");
        this.stepThreeG = AuikUtils.getIcon("step3_g.png", "Schritt Drei");
        this.stepThreeGrey = AuikUtils.getIcon("step3_grey.png", "Schritt Drei");
    }

    private JLabel getStepOneLabel() {
        if (this.stepOneLabel == null) {
            this.stepOneLabel = new JLabel(this.stepOneGrey);
        }
        return this.stepOneLabel;
    }

    private JLabel getStepTwoLabel() {
        if (this.stepTwoLabel == null) {
            this.stepTwoLabel = new JLabel(this.stepTwoGrey);
        }
        return this.stepTwoLabel;
    }

    private JLabel getStepThreeLabel() {
        if (this.stepThreeLabel == null) {
            this.stepThreeLabel = new JLabel(this.stepThreeGrey);
        }
        return this.stepThreeLabel;
    }

    private JButton getDateiButton() {
        if (this.dateiButton == null) {
            this.dateiButton = new JButton("Datei w\u00e4hlen");
            this.dateiButton.setToolTipText("W\u00e4hlt eine Datei zum Importieren aus");
            this.dateiButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file = SielhautImport.this.frame.openFile(new String[]{"csv"});
                    if (file != null) {
                        SielhautImport.this.switchToStep(1);
                        SielhautImport.this.fileImporter.openFile(file);
                    }
                }
            });
        }
        return this.dateiButton;
    }

    private JLabel getDateiLabel() {
        if (this.dateiLabel == null) {
            this.dateiLabel = new JLabel();
        }
        return this.dateiLabel;
    }

    private JButton getImportButton() {
        if (this.importButton == null) {
            this.importButton = new JButton("Importieren");
            this.importButton.setToolTipText("Importiert die gew\u00e4hlten Analysepositionen");
            this.importButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        SielhautImport.this.fileImporter.doImport();
                    }
                    catch (Exception e1) {
                        SielhautImport.this.frame.showErrorMessage("<html>Beim importieren ist ein Fehler aufgetreten:<br>" + e1.getMessage() + "</html>");
                    }
                }
            });
        }
        return this.importButton;
    }

    private JLabel getErklaerungsLabel() {
        if (this.erklaerungsLabel == null) {
            String sErklaerung = "<html><font color=green>Gr\u00fcn:</font> Position kann problemlos importiert werden.<br><font color=red>Rot:</font> Probenahme nicht gefunden oder Parameter/Einheit unbekannt.</html>";
            this.erklaerungsLabel = new JLabel(sErklaerung);
        }
        return this.erklaerungsLabel;
    }

    private JTable getImportTabelle() {
        if (this.importTabelle == null) {
            if (this.fileImporter == null) {
                this.fileImporter = new FileImporter();
            }
            this.importTabelle = new JTable(this.fileImporter);
            this.importTabelle.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    if (SielhautImport.this.importTabelle.getSelectedRowCount() != 0) {
                        int[] selectedRows = SielhautImport.this.importTabelle.getSelectedRows();
                        for (int i = 0; i < selectedRows.length; ++i) {
                            if (!SielhautImport.this.fileImporter.isRowImportable(selectedRows[i])) {
                                SielhautImport.this.importTabelle.removeRowSelectionInterval(selectedRows[i], selectedRows[i]);
                                continue;
                            }
                            if (SielhautImport.this.step == 3) continue;
                            SielhautImport.this.switchToStep(3);
                        }
                    } else if (SielhautImport.this.step != 2) {
                        SielhautImport.this.switchToStep(2);
                    }
                }
            });
        }
        return this.importTabelle;
    }

    private JScrollPane getImportScroller() {
        if (this.importScroller == null) {
            this.importScroller = new JScrollPane(this.getImportTabelle());
        }
        return this.importScroller;
    }

    public void switchToStep(int step) {
        this.step = step;
        switch (step) {
            case 1: {
                this.fileImporter.reset();
                this.getDateiLabel().setText("");
                this.getStepOneLabel().setIcon(this.stepOneW);
                this.getStepTwoLabel().setIcon(this.stepTwoGrey);
                this.getStepThreeLabel().setIcon(this.stepThreeGrey);
                this.enableStepComponents(1, true);
                this.enableStepComponents(2, false);
                this.enableStepComponents(3, false);
                this.getDateiButton().requestFocus();
                break;
            }
            case 2: {
                this.getStepOneLabel().setIcon(this.stepOneG);
                this.getStepTwoLabel().setIcon(this.stepTwoW);
                this.getStepThreeLabel().setIcon(this.stepThreeGrey);
                this.enableStepComponents(1, true);
                this.enableStepComponents(2, true);
                this.enableStepComponents(3, false);
                this.getImportTabelle().requestFocus();
                break;
            }
            case 3: {
                this.getStepOneLabel().setIcon(this.stepOneG);
                this.getStepTwoLabel().setIcon(this.stepTwoG);
                this.getStepThreeLabel().setIcon(this.stepThreeW);
                this.enableStepComponents(1, true);
                this.enableStepComponents(2, true);
                this.enableStepComponents(3, true);
                this.getImportTabelle().requestFocus();
                break;
            }
        }
    }

    private void enableStepComponents(int step, boolean enabled) {
        switch (step) {
            case 1: {
                this.getDateiButton().setEnabled(enabled);
                this.getDateiLabel().setEnabled(enabled);
                break;
            }
            case 2: {
                this.getImportTabelle().setEnabled(enabled);
                this.getErklaerungsLabel().setEnabled(enabled);
                break;
            }
            case 3: {
                this.getImportButton().setEnabled(enabled);
                break;
            }
        }
    }

    private class FileImporter
    extends ListTableModel {
        private File importFile;
        private Map importableRows;

        public FileImporter() {
            super(new String[]{"Probe", "Parameter", "Wert", "Einheit"}, false);
            this.importFile = null;
            this.importableRows = null;
        }

        @Override
        public Object getColumnValue(Object objectAtRow, int columnIndex) {
            String value;
            String[] tmpArr = (String[])objectAtRow;
            switch (columnIndex) {
                case 0: {
                    String tmp = "<html><font color=";
                    tmp = this.isPositionImportable(tmpArr) ? tmp + "00cc00" : tmp + "red";
                    String nr = this.kennummerAusZeile(tmpArr);
                    value = tmp + ">" + nr + "</font> ";
                    break;
                }
                case 1: {
                    value = this.paramAusZeile(tmpArr);
                    break;
                }
                case 2: {
                    value = this.wertAusZeile(tmpArr);
                    break;
                }
                case 3: {
                    value = this.einheitAusZeile(tmpArr);
                    break;
                }
                default: {
                    value = null;
                }
            }
            return value;
        }

        @Override
        public void updateList() throws Exception {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(this.importFile));
            int count = 0;
            while ((line = in.readLine()) != null) {
                if (count == 0 && !line.startsWith("Probenahmedatum")) {
                    throw new IOException("Datei ist kein SielhautBearbeiten-CSV!");
                }
                String[] tmp = line.split(";");
                if (tmp.length != 8) {
                    throw new IOException("Datei ist besch\u00e4digt!");
                }
                if (!tmp[0].startsWith("Probenahmedatum")) {
                    this.getList().add(tmp);
                }
                ++count;
            }
            in.close();
            this.fireTableDataChanged();
        }

        public void reset() {
            this.setList(new ArrayList());
            this.importFile = null;
            this.importableRows = null;
            this.fireTableDataChanged();
        }

        public void selectAllImportableRows() {
            if (this.importFile != null) {
                for (int i = 0; i < this.getList().size(); ++i) {
                    if (!this.isRowImportable(i)) continue;
                    SielhautImport.this.getImportTabelle().addRowSelectionInterval(i, i);
                }
                int count = SielhautImport.this.getImportTabelle().getSelectedRowCount();
                SielhautImport.this.frame.changeStatus(count + " Analysen direkt importierbar!");
            }
        }

        private String einheitAusZeile(String[] zeile) {
            return zeile[7].trim();
        }

        private String wertAusZeile(String[] zeile) {
            return zeile[6].trim();
        }

        private String kennummerAusZeile(String[] zeile) {
            String tmp = zeile[3].replaceFirst(" \\(.*\\)", "");
            return tmp;
        }

        private String paramAusZeile(String[] zeile) {
            return zeile[5];
        }

        public boolean isRowImportable(int rowIndex) {
            return this.isPositionImportable((String[])this.getObjectAtRow(rowIndex));
        }

        private boolean isPositionImportable(String[] pos) {
            if (this.importableRows == null) {
                this.importableRows = new HashMap(this.getList().size());
            }
            if (!this.importableRows.containsKey(pos)) {
                if (!AtlParameter.isParameterSupported(this.paramAusZeile(pos)) || !AtlEinheiten.isEinheitSupported(this.einheitAusZeile(pos))) {
                    this.importableRows.put(pos, new Boolean(false));
                } else {
                    String kennummer = this.kennummerAusZeile(pos);
                    if (AtlProbenahmen.probenahmeExists(kennummer)) {
                        this.importableRows.put(pos, new Boolean(true));
                    } else {
                        this.importableRows.put(pos, new Boolean(false));
                    }
                }
            }
            return (Boolean)this.importableRows.get(pos);
        }

        public void openFile(File file) {
            if (file.isFile() && file.canRead()) {
                SielhautImport.this.getDateiLabel().setText("Datei: " + file.getName());
                this.importFile = file;
                try {
                    this.updateList();
                }
                catch (Exception e) {
                    SielhautImport.this.frame.showErrorMessage("<html>Konnte Datei nicht \u00f6ffnen: <br>" + e.getLocalizedMessage() + "</html>");
                    SielhautImport.this.switchToStep(1);
                    return;
                }
                if (this.getList() != null && this.getList().size() > 0) {
                    SielhautImport.this.switchToStep(2);
                    this.selectAllImportableRows();
                } else {
                    SielhautImport.this.frame.showInfoMessage("Die Datei enth\u00e4lt keine importierbaren Analysepositionen!", "Import");
                }
            } else {
                SielhautImport.this.frame.showErrorMessage("Konnte die angegebene Datei nicht \u00f6ffnen!", "Fehler beim \u00f6ffnen");
            }
        }

        public void doImport() throws Exception {
            if (SielhautImport.this.step == 3 && this.importFile != null && this.getList() != null) {
                int importCount = 0;
                int[] selectedRows = SielhautImport.this.importTabelle.getSelectedRows();
                NumberFormat decform = DecimalFormat.getInstance();
                String problemMessage = "";
                for (int i = 0; i < selectedRows.length; ++i) {
                    boolean problem = false;
                    String[] current = (String[])this.getObjectAtRow(selectedRows[i]);
                    if (!this.isPositionImportable(current)) continue;
                    AtlAnalyseposition pos = new AtlAnalyseposition();
                    String kennumer = this.kennummerAusZeile(current);
                    AtlProbenahmen probe = AtlProbenahmen.getProbenahme(kennumer, true);
                    if (probe == null) {
                        throw new Exception("Probenahme nicht gefunden!");
                    }
                    probe.addAnalyseposition(pos);
                    String strWert = this.wertAusZeile(current);
                    if (strWert.startsWith("<")) {
                        pos.setGrkl("<");
                        strWert = strWert.replaceFirst("< *", "");
                    }
                    Float wert = new Float(decform.parse(strWert).floatValue());
                    pos.setWert(wert);
                    String sParam = this.paramAusZeile(current);
                    if (sParam != null) {
                        AtlParameter para = AtlParameter.getParameter(AtlParameter.getOrdnungsbegriff(sParam));
                        if (para != null) {
                            pos.setAtlParameter(para);
                        } else {
                            problem = true;
                            if (!problemMessage.equals("")) {
                                problemMessage = problemMessage + "<br>";
                            }
                            problemMessage = problemMessage + "Unbekannter Parameter: " + sParam;
                        }
                    } else {
                        throw new Exception("Importdatei besch\u00e4digt!");
                    }
                    String sEinheit = this.einheitAusZeile(current);
                    AtlEinheiten einheit = AtlEinheiten.getEinheit(AtlEinheiten.getID(sEinheit));
                    if (einheit != null) {
                        pos.setAtlEinheiten(einheit);
                    } else {
                        problem = true;
                        if (!problemMessage.equals("")) {
                            problemMessage = problemMessage + "<br>";
                        }
                        problemMessage = problemMessage + "Unbekannte Einheit: " + sEinheit;
                    }
                    pos.setAnalyseVon(SielhautImport.this.manager.getSettingsManager().getSetting("auik.prefs.sielhaut_labor"));
                    if (problem) continue;
                    if (AtlAnalyseposition.saveAnalyseposition(pos)) {
                        ++importCount;
                        AUIKataster.debugOutput("Habe " + pos + " gespeichert!");
                        continue;
                    }
                    throw new Exception("Konnte Analyseposition nicht in der Datenbank speichern!");
                }
                SielhautImport.this.frame.changeStatus(importCount + " Datens\u00e4tze importiert!");
                SielhautImport.this.switchToStep(1);
                if (!problemMessage.equals("")) {
                    throw new Exception(problemMessage);
                }
            }
        }
    }
}

