/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlSielhaut;
import de.bielefeld.umweltamt.aui.module.SielhautModel;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.SwingWorkerVariant;
import de.bielefeld.umweltamt.aui.utils.TabAction;
import de.bielefeld.umweltamt.aui.utils.TableFocusListener;
import de.bielefeld.umweltamt.aui.utils.dialogbase.OkCancelDialog;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

class SielhautChooser
extends OkCancelDialog {
    private JTextField suchFeld;
    private JButton submitButton;
    private JTable ergebnisTabelle;
    private SielhautModel sielhautModel = new SielhautModel();
    private AtlSielhaut chosenSielhaut = null;

    public SielhautChooser(HauptFrame owner) {
        super("Sielhautpunkt ausw\u00e4hlen", owner);
        this.getErgebnisTabelle().setModel(this.sielhautModel);
        this.ergebnisTabelle.getColumnModel().getColumn(0).setPreferredWidth(80);
        this.ergebnisTabelle.getColumnModel().getColumn(1).setPreferredWidth(230);
        this.ergebnisTabelle.getColumnModel().getColumn(2).setPreferredWidth(10);
        this.ergebnisTabelle.getColumnModel().getColumn(3).setPreferredWidth(10);
        this.ergebnisTabelle.getColumnModel().getColumn(4).setPreferredWidth(10);
        this.ergebnisTabelle.getColumnModel().getColumn(5).setPreferredWidth(10);
        this.setResizable(true);
        this.sielhautModel.filterList("");
        this.sielhautModel.fireTableDataChanged();
    }

    @Override
    protected void doOk() {
        int row = this.getErgebnisTabelle().getSelectedRow();
        this.choose(row);
    }

    protected void doSearch() {
        final String suche = this.getSuchFeld().getText();
        SwingWorkerVariant worker = new SwingWorkerVariant(this.getErgebnisTabelle()){

            @Override
            protected void doNonUILogic() throws RuntimeException {
                SielhautChooser.this.sielhautModel.filterList(suche);
            }

            @Override
            protected void doUIUpdateLogic() throws RuntimeException {
                SielhautChooser.this.sielhautModel.fireTableDataChanged();
            }
        };
        worker.start();
    }

    private void choose(int row) {
        if (row != -1) {
            this.chosenSielhaut = (AtlSielhaut)this.sielhautModel.getObjectAtRow(row);
            this.dispose();
        }
    }

    public AtlSielhaut getChosenSielhaut() {
        return this.chosenSielhaut;
    }

    @Override
    protected JComponent buildContentArea() {
        JScrollPane tabellenScroller = new JScrollPane(this.getErgebnisTabelle(), 20, 31);
        TabAction ta = new TabAction();
        ta.addComp(this.ergebnisTabelle);
        ta.addComp(this.button1);
        JToolBar submitToolBar = new JToolBar();
        submitToolBar.setFloatable(false);
        submitToolBar.setRollover(true);
        submitToolBar.add(this.getSubmitButton());
        FormLayout layout = new FormLayout("180dlu:g, 3dlu, min(16dlu;p)", "20dlu, 3dlu, 300dlu:g");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        builder.add((Component)this.getSuchFeld(), cc.xy(1, 1));
        builder.add((Component)submitToolBar, cc.xy(3, 1));
        builder.add((Component)tabellenScroller, cc.xyw(1, 3, 3));
        return builder.getPanel();
    }

    private JTextField getSuchFeld() {
        if (this.suchFeld == null) {
            this.suchFeld = new JTextField();
            this.suchFeld.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SielhautChooser.this.doSearch();
                }
            });
            this.suchFeld.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    String text = SielhautChooser.this.suchFeld.getText();
                    AUIKataster.debugOutput("keyChar: " + e.getKeyChar() + ", Text: " + text, "SielhautChooser");
                    if (Character.isLetterOrDigit(e.getKeyChar())) {
                        text = text + e.getKeyChar();
                    }
                    SielhautChooser.this.sielhautModel.filterList(text);
                    SielhautChooser.this.sielhautModel.fireTableDataChanged();
                }
            });
        }
        return this.suchFeld;
    }

    private JButton getSubmitButton() {
        if (this.submitButton == null) {
            this.submitButton = new JButton(AuikUtils.getIcon(16, "key_enter.png"));
            this.submitButton.setToolTipText("Suche starten");
            this.submitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SielhautChooser.this.doSearch();
                }
            });
        }
        return this.submitButton;
    }

    private JTable getErgebnisTabelle() {
        if (this.ergebnisTabelle == null) {
            this.ergebnisTabelle = new JTable();
            AbstractAction submitAction = new AbstractAction("Ausw\u00e4hlen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SielhautChooser.this.doOk();
                }
            };
            submitAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0, false));
            this.ergebnisTabelle.getInputMap().put((KeyStroke)submitAction.getValue("AcceleratorKey"), submitAction.getValue("Name"));
            this.ergebnisTabelle.getActionMap().put(submitAction.getValue("Name"), submitAction);
            this.ergebnisTabelle.addFocusListener(TableFocusListener.getInstance());
            this.ergebnisTabelle.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        Point origin = e.getPoint();
                        int row = SielhautChooser.this.ergebnisTabelle.rowAtPoint(origin);
                        SielhautChooser.this.choose(row);
                    }
                }
            });
        }
        return this.ergebnisTabelle;
    }
}

