/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.toedter.calendar.JDateChooser;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.AbstractModul;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.ReportManager;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlAnalyseposition;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbeart;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbenahmen;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbepkt;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlSielhaut;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisBetreiber;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjekt;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjektarten;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisStandort;
import de.bielefeld.umweltamt.aui.module.SielhautChooser;
import de.bielefeld.umweltamt.aui.module.SielhautProbeModel;
import de.bielefeld.umweltamt.aui.module.common.editors.ProbenEditor;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.DoubleField;
import de.bielefeld.umweltamt.aui.utils.LimitedTextArea;
import de.bielefeld.umweltamt.aui.utils.LimitedTextField;
import de.bielefeld.umweltamt.aui.utils.RetractablePanel;
import de.bielefeld.umweltamt.aui.utils.SwingWorkerVariant;
import de.bielefeld.umweltamt.aui.utils.charts.APosDataItem;
import de.bielefeld.umweltamt.aui.utils.charts.ChartDataSets;
import de.bielefeld.umweltamt.aui.utils.charts.Charts;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.eclipse.birt.report.engine.api.EngineException;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class SielhautBearbeiten
extends AbstractModul {
    private JTextField punktFeld;
    private JToolBar punktToolBar;
    private JButton punktChooseButton;
    private JButton punktEditButton;
    private JButton punktPrintButton;
    private JButton punktNeuButton;
    private JButton punktSaveButton;
    private JPanel datenPanel;
    private RetractablePanel probenRtPanel;
    private RetractablePanel fotoRtPanel;
    private RetractablePanel kartenRtPanel;
    private JPanel auswertungPanel;
    private JPanel neuProbPanel;
    private JTextField spNamenFeld;
    private JTextField spEntgebFeld;
    private JTextField spLageFeld;
    private JTextArea spBemerkungsArea;
    private DoubleField spRechtsWertFeld;
    private DoubleField spHochWertFeld;
    private JTextField spHaltungsnrFeld;
    private JTextField spAlarmplannrFeld;
    private JButton ausAblageButton;
    private JCheckBox spSielhautCheck;
    private JCheckBox spNachprobeCheck;
    private JCheckBox spAlarmplanCheck;
    private JCheckBox spFirmenprobeCheck;
    private JTable prTabelle;
    private JTextField prNummerFeld;
    private JDateChooser prDateChooser;
    private JButton prAnlegenButton;
    private JButton tabelleExportButton;
    private JPopupMenu probePopup;
    private Action probeEditAction;
    private Action probeLoeschAction;
    private Action probeSaveAction;
    private JLabel fotoLabel;
    private JLabel kartenLabel;
    private AtlSielhaut spunkt;
    private AtlProbepkt sprobePkt;
    private BasisObjekt objekt;
    private BasisStandort standort;
    private BasisBetreiber betreiber;
    private BasisObjektarten art;
    private SielhautProbeModel probeModel;
    private JDateChooser vonDateChooser;
    private JDateChooser bisDateChooser;
    private JCheckBox BleiCheck;
    private JCheckBox CadmiumCheck;
    private JCheckBox ChromCheck;
    private JCheckBox KupferCheck;
    private JCheckBox NickelCheck;
    private JCheckBox QuecksilberCheck;
    private JCheckBox ZinkCheck;
    private JButton submitButton;
    private int pkt;
    private TimeSeriesCollection dataSet1;
    private JList auswahlList;

    @Override
    public void show() {
        super.show();
        if (this.manager.getSettingsManager().getSetting("auik.imc.edit_object") != null) {
            this.objekt = BasisObjekt.getObjekt(new Integer(this.manager.getSettingsManager().getIntSetting("auik.imc.edit_object")));
            this.manager.getSettingsManager().removeSetting("auik.imc.edit_object");
            this.sprobePkt = AtlProbepkt.getProbepunktByObjekt(this.objekt);
            this.spunkt = AtlSielhaut.getSielhaut(this.sprobePkt.getAtlSielhaut().getId());
            this.setSielhautPunkt(this.spunkt);
        } else if (BasisObjekt.getObjekt(24856) != null) {
            this.objekt = BasisObjekt.getObjekt(24856);
            this.sprobePkt = AtlProbepkt.getProbepunktByObjekt(this.objekt);
            this.spunkt = AtlSielhaut.getSielhaut(this.sprobePkt.getAtlSielhaut().getId());
            this.setSielhautPunkt(this.spunkt);
        }
    }

    public void setSielhautPunkt(AtlSielhaut sp) {
        this.spunkt = sp;
        if (this.spunkt.getId() != null) {
            this.sprobePkt = AtlProbepkt.getSielhautProbepunkt(this.spunkt);
            this.getPrAnlegenButton().setEnabled(true);
            this.getTabelleExportButton().setEnabled(true);
        } else {
            this.objekt = new BasisObjekt();
            this.standort = BasisStandort.getStandort(41);
            this.betreiber = BasisBetreiber.getBetreiber(3);
            this.art = BasisObjektarten.getObjektart(32);
            this.objekt.setBasisStandort(this.standort);
            this.objekt.setBasisBetreiber(this.betreiber);
            this.objekt.setBasisObjektarten(this.art);
            this.sprobePkt = new AtlProbepkt();
            this.sprobePkt.setAtlProbeart(AtlProbeart.getProbeart(AtlProbeart.SIELHAUT));
            this.getPrAnlegenButton().setEnabled(false);
            this.getTabelleExportButton().setEnabled(false);
            this.getFotoLabel().setIcon(null);
            this.getFotoLabel().setText("<html><b>- Kein Foto verf\u00fcgbar! -</b></html>");
            this.getKartenLabel().setIcon(null);
            this.getKartenLabel().setText("<html><b>- Keine Karte verf\u00fcgbar! -</b></html>");
        }
        String titel = this.spunkt.getBezeichnung();
        if (this.spunkt.getLage() != null) {
            titel = titel + " \"" + this.spunkt.getLage() + "\"";
        }
        this.getPunktFeld().setText(titel);
        this.getSpNamenFeld().setText(this.spunkt.getBezeichnung());
        this.getSpEntgebFeld().setText(this.spunkt.getEntgeb());
        this.getSpLageFeld().setText(this.spunkt.getLage());
        this.getSpBemerkungsArea().setText(this.spunkt.getBemerkungen());
        this.getSpRechtsWertFeld().setValue(this.spunkt.getRechtswert());
        this.getSpHochWertFeld().setValue(this.spunkt.getHochwert());
        this.getSpHaltungsnrFeld().setText(this.spunkt.getHaltungsnr());
        this.getSpAlarmplannrFeld().setText(this.spunkt.getAlarmplannr());
        if (this.spunkt.getPsielhaut() == null) {
            this.getSpSielhautCheck().setSelected(false);
        } else {
            this.getSpSielhautCheck().setSelected(this.spunkt.getPsielhaut());
        }
        if (this.spunkt.getPnachprobe() == null) {
            this.getSpNachprobeCheck().setSelected(false);
        } else {
            this.getSpNachprobeCheck().setSelected(this.spunkt.getPnachprobe());
        }
        if (this.spunkt.getPalarmplan() == null) {
            this.getSpAlarmplanCheck().setSelected(false);
        } else {
            this.getSpAlarmplanCheck().setSelected(this.spunkt.getPalarmplan());
        }
        if (this.spunkt.getPfirmenprobe() == null) {
            this.getSpFirmenprobeCheck().setSelected(false);
        } else {
            this.getSpFirmenprobeCheck().setSelected(this.spunkt.getPfirmenprobe());
        }
        this.probeModel.setProbepunkt(this.sprobePkt);
        if (this.getProbenRtPanel().isOpen()) {
            this.getProbenRtPanel().setOpen(true);
        }
        if (this.getFotoRtPanel().isOpen()) {
            this.getFotoRtPanel().setOpen(true);
        }
        if (this.getKartenRtPanel().isOpen()) {
            this.getKartenRtPanel().setOpen(true);
        }
        this.getPunktSaveButton().setEnabled(true);
        this.getPunktEditButton().setEnabled(true);
        this.punktPrintButton.setEnabled(true);
    }

    public void neuerSielhautPunkt() {
        AtlSielhaut neuerPunkt = new AtlSielhaut();
        neuerPunkt.setBezeichnung("Neuer Sielhaut-Punkt");
        this.setSielhautPunkt(neuerPunkt);
    }

    public boolean saveObjekt() {
        boolean saved = false;
        this.objekt = BasisObjekt.saveBasisObjekt(this.objekt);
        saved = true;
        return saved;
    }

    public boolean saveProbepunkt(BasisObjekt objekt) {
        boolean saved = false;
        objekt = BasisObjekt.getObjekt(objekt.getObjektid());
        this.sprobePkt.setBasisObjekt(objekt);
        this.spunkt = AtlSielhaut.getSielhaut(this.spunkt.getId());
        this.sprobePkt.setAtlSielhaut(this.spunkt);
        AtlProbepkt.saveProbepunkt(this.sprobePkt);
        saved = true;
        return saved;
    }

    public void saveSielhautPunkt() {
        if (this.getSpNamenFeld().getText() == null || this.getSpNamenFeld().getText().equals("")) {
            this.frame.showErrorMessage("Der Name darf nicht leer sein!");
            this.getSpNamenFeld().requestFocus();
        } else {
            this.spunkt.setBezeichnung(this.getSpNamenFeld().getText());
            if ("".equals(this.getSpEntgebFeld().getText())) {
                this.spunkt.setEntgeb(null);
            } else {
                this.spunkt.setEntgeb(this.getSpEntgebFeld().getText());
            }
            if ("".equals(this.getSpLageFeld().getText())) {
                this.spunkt.setLage(null);
            } else {
                this.spunkt.setLage(this.getSpLageFeld().getText());
            }
            if ("".equals(this.getSpBemerkungsArea().getText())) {
                this.spunkt.setBemerkungen(null);
            } else {
                this.spunkt.setBemerkungen(this.getSpBemerkungsArea().getText());
            }
            this.spunkt.setRechtswert(this.getSpRechtsWertFeld().getDoubleValue());
            this.spunkt.setHochwert(this.getSpHochWertFeld().getDoubleValue());
            if ("".equals(this.getSpHaltungsnrFeld().getText())) {
                this.spunkt.setHaltungsnr(null);
            } else {
                this.spunkt.setHaltungsnr(this.getSpHaltungsnrFeld().getText());
            }
            if ("".equals(this.getSpAlarmplannrFeld().getText())) {
                this.spunkt.setAlarmplannr(null);
            } else {
                this.spunkt.setAlarmplannr(this.getSpAlarmplannrFeld().getText());
            }
            this.spunkt.setPsielhaut(this.getSpSielhautCheck().isSelected());
            this.spunkt.setPnachprobe(this.getSpNachprobeCheck().isSelected());
            this.spunkt.setPalarmplan(this.getSpAlarmplanCheck().isSelected());
            this.spunkt.setPfirmenprobe(this.getSpFirmenprobeCheck().isSelected());
            if (this.saveObjekt()) {
                if (AtlSielhaut.saveSielhautPunkt(this.spunkt) && this.saveProbepunkt(this.objekt)) {
                    this.frame.changeStatus("Sielhaut-Messpunkt erfolgreich gespeichert.", HauptFrame.SUCCESS_COLOR);
                    this.setSielhautPunkt(this.spunkt);
                }
            } else {
                this.frame.changeStatus("Sielhaut-Messpunkt konnte nicht gespeichert werden!", HauptFrame.ERROR_COLOR);
            }
        }
    }

    public void showReport() throws EngineException {
        if (this.spunkt.getId() != null || this.spunkt.getHaltungsnr() != null) {
            ReportManager.getInstance().startReportWorker("SielhautBearbeiten", this.spunkt.getId(), this.spunkt.getBezeichnung(), (Component)this.punktPrintButton);
        } else {
            AUIKataster.debugOutput("Dem zu druckenden Sielhaut-Probenahmepunkt fehlen Eingaben!");
        }
    }

    public void neueProbenahme() {
        if (this.sprobePkt != null) {
            if (this.getPrNummerFeld().getText().trim().equals("")) {
                this.getPrNummerFeld().requestFocus();
                this.frame.changeStatus("Leere Kennummer!", HauptFrame.ERROR_COLOR);
            } else {
                String kennNummer = this.getPrNummerFeld().getText().trim().replaceAll(" ", "");
                Date datum = this.getPrDateChooser().getDate();
                boolean exists = AtlProbenahmen.probenahmeExists(kennNummer);
                if (!exists) {
                    AtlProbenahmen probe = new AtlProbenahmen();
                    probe.setKennummer(kennNummer);
                    probe.setDatumDerEntnahme((Timestamp)datum);
                    probe.setAtlAnalysepositionen(new HashSet());
                    probe.setAtlProbepkt(this.sprobePkt);
                    ProbenEditor editDialog = new ProbenEditor(probe, this.frame, true);
                    editDialog.setVisible(true);
                    this.updateProbeListe();
                } else {
                    this.frame.changeStatus("Eine Probenahme mit dieser Kennnummer existiert schon!", HauptFrame.ERROR_COLOR);
                }
            }
        } else {
            this.frame.changeStatus("Fehler beim Anlegen: Kein Probepunkt!", HauptFrame.ERROR_COLOR);
        }
    }

    public void editProbenahme(AtlProbenahmen probe) {
        ProbenEditor editDialog = new ProbenEditor(probe, this.frame, false);
        editDialog.setVisible(true);
        if (editDialog.wasSaved()) {
            this.updateProbeListe();
        }
    }

    public void saveTabelle() {
        File exportDatei = this.getFrame().saveFile(new String[]{"csv"});
        if (exportDatei != null) {
            String ext = AuikUtils.getExtension(exportDatei);
            if (ext == null) {
                String newExt = exportDatei.getName().endsWith(".") ? "csv" : ".csv";
                exportDatei = new File(exportDatei.getParent(), exportDatei.getName() + newExt);
            }
            boolean doIt = false;
            if (exportDatei.exists()) {
                boolean answer = this.getFrame().showQuestion("Soll die vorhandene Datei " + exportDatei.getName() + " wirklich \u00fcberschrieben werden?", "Datei bereits vorhanden!");
                if (answer && exportDatei.canWrite()) {
                    doIt = true;
                }
            } else if (exportDatei.getParentFile().canWrite()) {
                doIt = true;
            }
            if (doIt) {
                AUIKataster.debugOutput("Speichere nach '" + exportDatei.getName() + "' (Ext: '" + ext + "') in '" + exportDatei.getParent() + "' !");
                if (AuikUtils.exportTableDataToCVS(this.getPrTabelle(), exportDatei)) {
                    AUIKataster.debugOutput("Speichern erfolgreich!");
                } else {
                    AUIKataster.debugOutput("Fehler beim Speichern!");
                    this.getFrame().showErrorMessage("Beim Speichern der Datei '" + exportDatei + "' trat ein Fehler auf!");
                }
            }
        }
    }

    private void updateProbeListe() {
        SwingWorkerVariant worker = new SwingWorkerVariant(this.getPrTabelle()){

            @Override
            protected void doNonUILogic() throws RuntimeException {
                SielhautBearbeiten.this.probeModel.updateList();
                AUIKataster.debugOutput("Liste geupdatet!");
            }

            @Override
            protected void doUIUpdateLogic() throws RuntimeException {
                SielhautBearbeiten.this.probeModel.fireTableDataChanged();
                AUIKataster.debugOutput("Tabelle geupdatet!");
            }
        };
        worker.start();
    }

    private Action getProbeEditAction() {
        if (this.probeEditAction == null) {
            this.probeEditAction = new AbstractAction("Bearbeiten"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = SielhautBearbeiten.this.getPrTabelle().getSelectedRow();
                    if (row != -1) {
                        AtlProbenahmen probe = SielhautBearbeiten.this.probeModel.getRow(row);
                        SielhautBearbeiten.this.editProbenahme(probe);
                    }
                }
            };
            this.probeEditAction.putValue("MnemonicKey", new Integer(66));
            this.probeEditAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0, false));
        }
        return this.probeEditAction;
    }

    private Action getProbeSaveAction() {
        if (this.probeEditAction == null) {
            this.probeEditAction = new AbstractAction("Speichern"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SielhautBearbeiten.this.saveTabelle();
                }
            };
            this.probeEditAction.putValue("MnemonicKey", new Integer(66));
            this.probeEditAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0, false));
        }
        return this.probeSaveAction;
    }

    private Action getProbeLoeschAction() {
        if (this.probeLoeschAction == null) {
            this.probeLoeschAction = new AbstractAction("L\u00f6schen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = SielhautBearbeiten.this.getPrTabelle().getSelectedRow();
                    if (row != -1 && SielhautBearbeiten.this.getPrTabelle().getEditingRow() == -1) {
                        AtlProbenahmen probe = SielhautBearbeiten.this.probeModel.getRow(row);
                        if (SielhautBearbeiten.this.frame.showQuestion("Soll die Probenahme '" + probe.getKennummer() + "' wirklich inkl. aller Analysen gel\u00f6scht werden?", "L\u00f6schen best\u00e4tigen")) {
                            if (SielhautBearbeiten.this.probeModel.removeRow(row)) {
                                SielhautBearbeiten.this.frame.changeStatus("Probenahme gel\u00f6scht!", HauptFrame.SUCCESS_COLOR);
                                AUIKataster.debugOutput("Probe " + probe.getKennummer() + " wurde gel\u00f6scht!", "SchlammPanel.removeAction");
                            } else {
                                SielhautBearbeiten.this.frame.changeStatus("Konnte Probenahme nicht l\u00f6schen!", HauptFrame.ERROR_COLOR);
                            }
                        }
                    }
                }
            };
            this.probeLoeschAction.putValue("MnemonicKey", new Integer(76));
            this.probeLoeschAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0, false));
        }
        return this.probeLoeschAction;
    }

    private void showProbePopup(MouseEvent e) {
        if (this.probePopup == null) {
            this.probePopup = new JPopupMenu("Probe");
            JMenuItem bearbItem = new JMenuItem(this.getProbeEditAction());
            JMenuItem loeschItem = new JMenuItem(this.getProbeLoeschAction());
            this.probePopup.add(bearbItem);
            this.probePopup.add(loeschItem);
        }
        if (e.isPopupTrigger()) {
            Point origin = e.getPoint();
            int row = this.getPrTabelle().rowAtPoint(origin);
            if (row != -1) {
                this.getPrTabelle().setRowSelectionInterval(row, row);
                this.probePopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    @Override
    public String getName() {
        return "Sielhautpunkte";
    }

    @Override
    public String getIdentifier() {
        return "m_sielhaut1";
    }

    @Override
    public String getCategory() {
        return "Sielhaut";
    }

    public HauptFrame getFrame() {
        return this.frame;
    }

    @Override
    public JPanel getPanel() {
        if (this.panel == null) {
            this.probeModel = new SielhautProbeModel();
            RetractablePanel datenRP = new RetractablePanel(DefaultComponentFactory.getInstance().createSeparator("Stammdaten"), this.getDatenPanel(), true, null);
            FormLayout layout = new FormLayout("pref, 5dlu, 100dlu:g, 3dlu, l:p", "p, 3dlu, t:p, 10dlu, t:p, 10dlu, t:p, 10dlu, t:p");
            PanelBuilder builder = new PanelBuilder(layout);
            CellConstraints cc = new CellConstraints();
            builder.setDefaultDialogBorder();
            builder.addLabel("Messstelle:", cc.xy(1, 1));
            builder.add((Component)this.getPunktFeld(), cc.xy(3, 1));
            builder.add((Component)this.getPunktToolBar(), cc.xy(5, 1));
            builder.add((Component)datenRP, cc.xyw(1, 3, 5, "f, f"));
            builder.add((Component)this.getProbenRtPanel(), cc.xyw(1, 5, 5, "f, f"));
            builder.add((Component)this.getFotoRtPanel(), cc.xyw(1, 7, 5, "f, f"));
            builder.add((Component)this.getKartenRtPanel(), cc.xyw(1, 9, 5, "f, f"));
            this.panel = builder.getPanel();
        }
        return this.panel;
    }

    private JTextField getPunktFeld() {
        if (this.punktFeld == null) {
            this.punktFeld = new JTextField();
            this.punktFeld.setEditable(false);
        }
        return this.punktFeld;
    }

    private JToolBar getPunktToolBar() {
        if (this.punktToolBar == null) {
            this.punktToolBar = new JToolBar();
            this.punktToolBar.setFloatable(false);
            this.punktToolBar.setRollover(true);
            this.punktToolBar.add(this.getPunktChooseButton());
            this.punktToolBar.add(this.getPunktEditButton());
            this.punktToolBar.add(this.getPunktNeuButton());
            this.punktToolBar.add(this.getPunktSaveButton());
            this.punktToolBar.add(this.getPunktPrintButton());
        }
        return this.punktToolBar;
    }

    private JButton getPunktChooseButton() {
        if (this.punktChooseButton == null) {
            this.punktChooseButton = new JButton(AuikUtils.getIcon(16, "reload.png"));
            this.punktChooseButton.setToolTipText("Messpunkt ausw\u00e4hlen");
            this.punktChooseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SielhautChooser chooser = new SielhautChooser(SielhautBearbeiten.this.frame);
                    chooser.setVisible(true);
                    AtlSielhaut tmp = chooser.getChosenSielhaut();
                    if (tmp != null) {
                        SielhautBearbeiten.this.setSielhautPunkt(tmp);
                    }
                }
            });
        }
        return this.punktChooseButton;
    }

    private JButton getPunktEditButton() {
        if (this.punktEditButton == null) {
            this.punktEditButton = new JButton(AuikUtils.getIcon(16, "edit.png"));
            this.punktEditButton.setToolTipText("Bearbeiten");
            this.punktEditButton.setEnabled(false);
            this.punktEditButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AtlProbepkt probepkt = new AtlProbepkt();
                    AtlProbepkt sielprobepkt = AtlProbepkt.getSielhautProbepunkt(SielhautBearbeiten.this.spunkt);
                    SielhautBearbeiten.this.manager.getSettingsManager().setSetting("auik.imc.edit_object", sielprobepkt.getObjektid(), false);
                    SielhautBearbeiten.this.manager.switchModul("m_objekt_bearbeiten");
                }
            });
        }
        return this.punktEditButton;
    }

    private JButton getPunktPrintButton() {
        if (this.punktPrintButton == null) {
            this.punktPrintButton = new JButton(AuikUtils.getIcon(16, "fileprint.png"));
            this.punktPrintButton.setToolTipText("Drucken");
            this.punktPrintButton.setEnabled(false);
            this.punktPrintButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        SielhautBearbeiten.this.showReport();
                    }
                    catch (EngineException e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }
        return this.punktPrintButton;
    }

    private JButton getPunktNeuButton() {
        if (this.punktNeuButton == null) {
            this.punktNeuButton = new JButton(AuikUtils.getIcon(16, "filenew.png"));
            this.punktNeuButton.setToolTipText("Neuer Messpunkt");
            this.punktNeuButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SielhautBearbeiten.this.neuerSielhautPunkt();
                }
            });
        }
        return this.punktNeuButton;
    }

    private JButton getPunktSaveButton() {
        if (this.punktSaveButton == null) {
            this.punktSaveButton = new JButton(AuikUtils.getIcon(16, "filesave.png"));
            this.punktSaveButton.setToolTipText("Speichern");
            this.punktSaveButton.setEnabled(false);
            this.punktSaveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SielhautBearbeiten.this.spunkt != null) {
                        SielhautBearbeiten.this.saveSielhautPunkt();
                    }
                }
            });
        }
        return this.punktSaveButton;
    }

    private JPanel getDatenPanel() {
        if (this.datenPanel == null) {
            FormLayout layout = new FormLayout("r:p, 3dlu, 150dlu, 10dlu, 70dlu, 10dlu, 100dlu", "pref, 3dlu, pref, 3dlu, pref, 3dlu, fill:30dlu, 10dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, ");
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.setDefaultDialogBorder();
            CellConstraints cc = new CellConstraints();
            JScrollPane bemerkungsScroller = new JScrollPane(this.getSpBemerkungsArea(), 20, 31);
            builder.addLabel("<html><b>Name:</b></html>", cc.xy(1, 1));
            builder.add((Component)this.getSpNamenFeld(), cc.xy(3, 1));
            builder.addLabel("Entw\u00e4sserungsgebiet:", cc.xy(1, 3));
            builder.add((Component)this.getSpEntgebFeld(), cc.xy(3, 3));
            builder.addLabel("Lage:", cc.xy(1, 5));
            builder.add((Component)this.getSpLageFeld(), cc.xy(3, 5));
            builder.addLabel("Bemerkungen:", cc.xy(1, 7));
            builder.add((Component)bemerkungsScroller, cc.xyw(3, 7, 5));
            builder.addLabel("Rechtswert:", cc.xy(1, 9));
            builder.add((Component)this.getSpRechtsWertFeld(), cc.xy(3, 9));
            builder.add((Component)this.getAusAblageButton(), cc.xywh(5, 9, 1, 3));
            builder.add((Component)this.getSpSielhautCheck(), cc.xy(7, 9));
            builder.addLabel("Hochwert:", cc.xy(1, 11));
            builder.add((Component)this.getSpHochWertFeld(), cc.xy(3, 11));
            builder.add((Component)this.getSpFirmenprobeCheck(), cc.xy(7, 11));
            builder.addLabel("Schacht-Nr.:", cc.xy(1, 13));
            builder.add((Component)this.getSpHaltungsnrFeld(), cc.xyw(3, 13, 3));
            builder.add((Component)this.getSpNachprobeCheck(), cc.xy(7, 13));
            builder.addLabel("Alarmplan-Nr.:", cc.xy(1, 15));
            builder.add((Component)this.getSpAlarmplannrFeld(), cc.xyw(3, 15, 3));
            builder.add((Component)this.getSpAlarmplanCheck(), cc.xy(7, 15));
            this.datenPanel = builder.getPanel();
        }
        return this.datenPanel;
    }

    private JCheckBox getSpAlarmplanCheck() {
        if (this.spAlarmplanCheck == null) {
            this.spAlarmplanCheck = new JCheckBox("Alarmplan");
        }
        return this.spAlarmplanCheck;
    }

    private JTextField getSpAlarmplannrFeld() {
        if (this.spAlarmplannrFeld == null) {
            this.spAlarmplannrFeld = new LimitedTextField(50);
        }
        return this.spAlarmplannrFeld;
    }

    private JTextArea getSpBemerkungsArea() {
        if (this.spBemerkungsArea == null) {
            this.spBemerkungsArea = new LimitedTextArea(255);
            this.spBemerkungsArea.setLineWrap(true);
            this.spBemerkungsArea.setWrapStyleWord(true);
        }
        return this.spBemerkungsArea;
    }

    private JTextField getSpEntgebFeld() {
        if (this.spEntgebFeld == null) {
            this.spEntgebFeld = new LimitedTextField(50);
        }
        return this.spEntgebFeld;
    }

    private JTextField getSpHaltungsnrFeld() {
        if (this.spHaltungsnrFeld == null) {
            this.spHaltungsnrFeld = new LimitedTextField(50);
        }
        return this.spHaltungsnrFeld;
    }

    private DoubleField getSpHochWertFeld() {
        if (this.spHochWertFeld == null) {
            this.spHochWertFeld = new DoubleField(1);
        }
        return this.spHochWertFeld;
    }

    private JTextField getSpLageFeld() {
        if (this.spLageFeld == null) {
            this.spLageFeld = new LimitedTextField(50);
        }
        return this.spLageFeld;
    }

    private JCheckBox getSpNachprobeCheck() {
        if (this.spNachprobeCheck == null) {
            this.spNachprobeCheck = new JCheckBox("Nachprobe");
        }
        return this.spNachprobeCheck;
    }

    private JCheckBox getSpFirmenprobeCheck() {
        if (this.spFirmenprobeCheck == null) {
            this.spFirmenprobeCheck = new JCheckBox("Firmenprobe");
        }
        return this.spFirmenprobeCheck;
    }

    private JTextField getSpNamenFeld() {
        if (this.spNamenFeld == null) {
            this.spNamenFeld = new LimitedTextField(50);
        }
        return this.spNamenFeld;
    }

    private DoubleField getSpRechtsWertFeld() {
        if (this.spRechtsWertFeld == null) {
            this.spRechtsWertFeld = new DoubleField(1);
        }
        return this.spRechtsWertFeld;
    }

    private JCheckBox getSpSielhautCheck() {
        if (this.spSielhautCheck == null) {
            this.spSielhautCheck = new JCheckBox("Routinekontrolle");
        }
        return this.spSielhautCheck;
    }

    private RetractablePanel getProbenRtPanel() {
        if (this.probenRtPanel == null) {
            FormLayout layout = new FormLayout("p, 4dlu, p:g, 7dlu, p, 4dlu, max(60dlu;p), 7dlu,max(60dlu;p),7dlu,max(60dlu;p) ");
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.setDefaultDialogBorder();
            builder.appendRow("f:65dlu:g");
            builder.append((Component)new JScrollPane(this.getPrTabelle()), 11);
            builder.appendSeparator("Neue Probenahme");
            builder.append((Component)this.getNeuProbPanel());
            builder.nextLine();
            builder.appendSeparator("Auswertung");
            builder.append((Component)this.getAuswertungPanel());
            JPanel probenPanel = builder.getPanel();
            this.probenRtPanel = new RetractablePanel(DefaultComponentFactory.getInstance().createSeparator("Probenahmen"), probenPanel, false, null){

                @Override
                public void opening() {
                    SwingWorkerVariant worker = new SwingWorkerVariant(SielhautBearbeiten.this.getSpNamenFeld()){

                        @Override
                        protected void doNonUILogic() throws RuntimeException {
                            SielhautBearbeiten.this.probeModel.updateList();
                        }

                        @Override
                        protected void doUIUpdateLogic() throws RuntimeException {
                            SielhautBearbeiten.this.probeModel.fireTableDataChanged();
                        }
                    };
                    worker.start();
                }
            };
        }
        return this.probenRtPanel;
    }

    private JPanel getNeuProbPanel() {
        if (this.neuProbPanel == null) {
            FormLayout layout = new FormLayout("pref, 5dlu,  pref, 5dlu, pref, 5dlu,  pref, 5dlu, pref, 5dlu,pref, 5dlu, pref, 5dlu,pref, 5dlu,pref, 5dlu,  pref, 5dlu, pref, 5dlu,  pref, 5dlu, pref, 5dlu,pref,pref, 5dlu, pref, 5dlu,pref", "pref, 3dlu, pref");
            CellConstraints cc = new CellConstraints();
            CellConstraints cc2 = (CellConstraints)cc.clone();
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.setDefaultDialogBorder();
            builder.add(new JLabel("Kennummer:"), cc.xy(1, 1), (Component)this.getPrNummerFeld(), cc2.xyw(3, 1, 20));
            builder.add(new JLabel("Datum:"), cc.xy(25, 1), (Component)this.getPrDateChooser(), cc2.xy(28, 1));
            builder.add((Component)this.getPrAnlegenButton(), cc.xy(30, 1));
            builder.add((Component)this.getTabelleExportButton(), cc.xy(32, 1));
            this.neuProbPanel = builder.getPanel();
        }
        return this.neuProbPanel;
    }

    private JPanel getAuswertungPanel() {
        if (this.auswertungPanel == null) {
            FormLayout layout = new FormLayout("pref, 5dlu,  pref, 5dlu, pref, 5dlu,  pref, 5dlu, pref, 5dlu,pref, 5dlu, pref, 5dlu,pref, 5dlu,pref, 5dlu,  pref, 5dlu, pref, 5dlu,  pref, 5dlu, pref, 5dlu,pref", "pref, 3dlu, pref");
            CellConstraints cc = new CellConstraints();
            CellConstraints cc2 = (CellConstraints)cc.clone();
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.setDefaultDialogBorder();
            builder.add(new JLabel("Von:"), cc.xy(1, 1), (Component)this.getVonDateChooser(), cc2.xy(3, 1));
            builder.add(new JLabel("Bis:"), cc.xy(5, 1), (Component)this.getBisDateChooser(), cc2.xy(7, 1));
            builder.add((Component)this.getBleiCheck(), cc.xy(11, 1));
            builder.add((Component)this.getCadmiumCheck(), cc.xy(13, 1));
            builder.add((Component)this.getChromCheck(), cc.xy(15, 1));
            builder.add((Component)this.getKupferCheck(), cc.xy(17, 1));
            builder.add((Component)this.getNickelCheck(), cc.xy(19, 1));
            builder.add((Component)this.getQuecksilberCheck(), cc.xy(21, 1));
            builder.add((Component)this.getZinkCheck(), cc.xy(23, 1));
            builder.add((Component)this.getSubmitButton(), cc.xy(27, 1));
            this.auswertungPanel = builder.getPanel();
        }
        return this.auswertungPanel;
    }

    private JTable getPrTabelle() {
        if (this.prTabelle == null) {
            this.prTabelle = new JTable(this.probeModel);
            this.prTabelle.getColumnModel().getColumn(0).setWidth(40);
            this.prTabelle.getColumnModel().getColumn(1).setWidth(75);
            this.prTabelle.setSelectionMode(0);
            this.prTabelle.getInputMap().put((KeyStroke)this.getProbeEditAction().getValue("AcceleratorKey"), this.getProbeEditAction().getValue("Name"));
            this.prTabelle.getActionMap().put(this.getProbeEditAction().getValue("Name"), this.getProbeEditAction());
            this.prTabelle.getInputMap().put((KeyStroke)this.getProbeLoeschAction().getValue("AcceleratorKey"), this.getProbeLoeschAction().getValue("Name"));
            this.prTabelle.getActionMap().put(this.getProbeLoeschAction().getValue("Name"), this.getProbeLoeschAction());
            this.prTabelle.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        Point origin = e.getPoint();
                        int row = SielhautBearbeiten.this.getPrTabelle().rowAtPoint(origin);
                        AtlProbenahmen probe = SielhautBearbeiten.this.probeModel.getRow(row);
                        SielhautBearbeiten.this.editProbenahme(probe);
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    SielhautBearbeiten.this.showProbePopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    SielhautBearbeiten.this.showProbePopup(e);
                }
            });
        }
        return this.prTabelle;
    }

    private JButton getSubmitButton() {
        if (this.submitButton == null) {
            this.submitButton = new JButton("Abschicken");
            this.submitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SielhautBearbeiten.this.showResultOneAxis();
                }
            });
        }
        return this.submitButton;
    }

    public void showResultOneAxis() {
        SwingWorkerVariant worker = new SwingWorkerVariant(this.getSubmitButton()){

            @Override
            protected void doNonUILogic() throws RuntimeException {
                SielhautBearbeiten.this.dataSet1 = SielhautBearbeiten.this.createDataset();
            }

            @Override
            protected void doUIUpdateLogic() throws RuntimeException {
                if (SielhautBearbeiten.this.dataSet1.getSeriesCount() > 0) {
                    AuswertungsDialog dialog = new AuswertungsDialog("SielhautBearbeiten", SielhautBearbeiten.this.dataSet1, null, SielhautBearbeiten.this.frame);
                    dialog.setVisible(true);
                } else {
                    SielhautBearbeiten.this.frame.changeStatus("Keine Parameter ausgew\u00e4hlt!");
                }
            }
        };
        this.frame.changeStatus("Bereite Auswertung vor...");
        worker.start();
    }

    private TimeSeriesCollection createDataset() {
        TimeSeriesCollection col = new TimeSeriesCollection();
        Date von = this.getVonDateChooser().getDate();
        Date bis = this.getBisDateChooser().getDate();
        DefaultListModel leftModel = (DefaultListModel)this.getAuswahlList().getModel();
        if (this.getBleiCheck().isSelected()) {
            leftModel.addElement("Blei (Pb)");
        }
        if (this.getCadmiumCheck().isSelected()) {
            leftModel.addElement("Cadmium (Cd)");
        }
        if (this.getChromCheck().isSelected()) {
            leftModel.addElement("Chrom (Cr)");
        }
        if (this.getKupferCheck().isSelected()) {
            leftModel.addElement("Kupfer (Cu)");
        }
        if (this.getNickelCheck().isSelected()) {
            leftModel.addElement("Nickel (Ni)");
        }
        if (this.getQuecksilberCheck().isSelected()) {
            leftModel.addElement("Quecksilber (Hg)");
        }
        if (this.getZinkCheck().isSelected()) {
            leftModel.addElement("Zink (Zn)");
        }
        JList paramList = this.getAuswahlList();
        this.pkt = this.sprobePkt.getObjektid();
        int parameterAnzahl = this.getAuswahlList().getModel().getSize();
        if (parameterAnzahl == 0) {
            leftModel.addElement("Blei (Pb)");
            leftModel.addElement("Cadmium (Cd)");
            leftModel.addElement("Chrom (Cr)");
            leftModel.addElement("Kupfer (Cu)");
            leftModel.addElement("Nickel (Ni)");
            leftModel.addElement("Quecksilber (Hg)");
            leftModel.addElement("Zink (Zn)");
        }
        this.createSeries(paramList, this.pkt, von, bis, col);
        leftModel.clear();
        return col;
    }

    private JList getAuswahlList() {
        if (this.auswahlList == null) {
            DefaultListModel listModel = new DefaultListModel();
            this.auswahlList = new JList(listModel);
            this.auswahlList.setPrototypeCellValue("Abcdefghij (Ab)");
            this.auswahlList.setSelectionMode(0);
        }
        return this.auswahlList;
    }

    private void createSeries(JList paramList, Integer pkt, Date von, Date bis, TimeSeriesCollection col) {
        if (pkt != null) {
            for (int i = 0; i < paramList.getModel().getSize(); ++i) {
                String p = (String)paramList.getModel().getElementAt(i);
                AtlAnalyseposition position = AtlAnalyseposition.getAnalysepositionObjekt(pkt);
                String einheit = "Verh\u00e4ltnis zum Hintergrundwert";
                List list = AtlAnalyseposition.getSielhautpos(p, pkt, von, bis);
                TimeSeries series = ChartDataSets.createAnalysePositionenSielhautSeries(list, p + " ", einheit);
                col.addSeries(series);
            }
        }
        this.frame.changeStatus("Auswertung abgeschlossen");
    }

    private JDateChooser getVonDateChooser() {
        if (this.vonDateChooser == null) {
            this.vonDateChooser = new JDateChooser("dd.MM.yy", false);
        }
        return this.vonDateChooser;
    }

    private JDateChooser getBisDateChooser() {
        if (this.bisDateChooser == null) {
            this.bisDateChooser = new JDateChooser("dd.MM.yy", false);
        }
        return this.bisDateChooser;
    }

    private JCheckBox getBleiCheck() {
        if (this.BleiCheck == null) {
            this.BleiCheck = new JCheckBox("Blei", false);
        }
        return this.BleiCheck;
    }

    private JCheckBox getCadmiumCheck() {
        if (this.CadmiumCheck == null) {
            this.CadmiumCheck = new JCheckBox("Cadmium", false);
        }
        return this.CadmiumCheck;
    }

    private JCheckBox getChromCheck() {
        if (this.ChromCheck == null) {
            this.ChromCheck = new JCheckBox("Chrom", false);
        }
        return this.ChromCheck;
    }

    private JCheckBox getKupferCheck() {
        if (this.KupferCheck == null) {
            this.KupferCheck = new JCheckBox("Kupfer", false);
        }
        return this.KupferCheck;
    }

    private JCheckBox getNickelCheck() {
        if (this.NickelCheck == null) {
            this.NickelCheck = new JCheckBox("Nickel", false);
        }
        return this.NickelCheck;
    }

    private JCheckBox getQuecksilberCheck() {
        if (this.QuecksilberCheck == null) {
            this.QuecksilberCheck = new JCheckBox("Quecksilber", false);
        }
        return this.QuecksilberCheck;
    }

    private JCheckBox getZinkCheck() {
        if (this.ZinkCheck == null) {
            this.ZinkCheck = new JCheckBox("Zink", false);
        }
        return this.ZinkCheck;
    }

    private JTextField getPrNummerFeld() {
        if (this.prNummerFeld == null) {
            this.prNummerFeld = new LimitedTextField(50, "");
        }
        return this.prNummerFeld;
    }

    private JDateChooser getPrDateChooser() {
        if (this.prDateChooser == null) {
            this.prDateChooser = new JDateChooser("dd.MM.yy", false);
        }
        return this.prDateChooser;
    }

    private JButton getPrAnlegenButton() {
        if (this.prAnlegenButton == null) {
            this.prAnlegenButton = new JButton("Anlegen");
            this.prAnlegenButton.setEnabled(false);
            this.prAnlegenButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SielhautBearbeiten.this.neueProbenahme();
                }
            });
        }
        return this.prAnlegenButton;
    }

    private JButton getTabelleExportButton() {
        if (this.tabelleExportButton == null) {
            this.tabelleExportButton = new JButton("Tabelle speichern");
            this.tabelleExportButton.setEnabled(false);
            this.tabelleExportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SielhautBearbeiten.this.saveTabelle();
                }
            });
        }
        return this.tabelleExportButton;
    }

    private RetractablePanel getFotoRtPanel() {
        if (this.fotoRtPanel == null) {
            JPanel fotoPanel = new JPanel();
            fotoPanel.add(this.getFotoLabel());
            fotoPanel.setBackground(Color.WHITE);
            fotoPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.fotoRtPanel = new RetractablePanel(DefaultComponentFactory.getInstance().createSeparator("Foto"), fotoPanel, false, null){

                @Override
                public void opening() {
                    if (SielhautBearbeiten.this.spunkt != null && SielhautBearbeiten.this.spunkt.getId() != null) {
                        String imgPath = SielhautBearbeiten.this.manager.getSettingsManager().getSetting("auik.system.spath_fotos") + SielhautBearbeiten.this.spunkt.getBezeichnung() + ".jpg";
                        File imgFile = new File(imgPath);
                        if (imgFile.canRead()) {
                            ImageIcon imgIcon = new ImageIcon(imgFile.getAbsolutePath());
                            int panelWidth = SielhautBearbeiten.this.getPanel().getWidth() - 50;
                            if (imgIcon.getIconWidth() > panelWidth) {
                                imgIcon.setImage(imgIcon.getImage().getScaledInstance(panelWidth, -1, 2));
                            }
                            SielhautBearbeiten.this.getFotoLabel().setIcon(null);
                            SielhautBearbeiten.this.getFotoLabel().setIcon(imgIcon);
                            SielhautBearbeiten.this.getFotoLabel().setText(null);
                        } else {
                            SielhautBearbeiten.this.getFotoLabel().setIcon(null);
                            SielhautBearbeiten.this.getFotoLabel().setText("<html><b>-  Foto " + SielhautBearbeiten.this.spunkt.getBezeichnung() + ".jpg nicht gefunden!  -</b></html>");
                        }
                    }
                }
            };
        }
        return this.fotoRtPanel;
    }

    private JLabel getFotoLabel() {
        if (this.fotoLabel == null) {
            this.fotoLabel = new JLabel("<html><b>- Kein Foto verf\u00fcgbar! -</b></html>");
        }
        return this.fotoLabel;
    }

    private RetractablePanel getKartenRtPanel() {
        if (this.kartenRtPanel == null) {
            JPanel kartenPanel = new JPanel();
            kartenPanel.add(this.getKartenLabel());
            kartenPanel.setBackground(Color.WHITE);
            kartenPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.kartenRtPanel = new RetractablePanel(DefaultComponentFactory.getInstance().createSeparator("Kartenausschnitt"), kartenPanel, false, null){

                @Override
                public void opening() {
                    if (SielhautBearbeiten.this.spunkt != null && SielhautBearbeiten.this.spunkt.getId() != null) {
                        String imgPath = SielhautBearbeiten.this.manager.getSettingsManager().getSetting("auik.system.spath_karten") + SielhautBearbeiten.this.spunkt.getBezeichnung() + ".jpg";
                        File imgFile = new File(imgPath);
                        if (imgFile.canRead()) {
                            ImageIcon imgIcon = new ImageIcon(imgFile.getAbsolutePath());
                            int panelWidth = SielhautBearbeiten.this.getPanel().getWidth() - 55;
                            if (imgIcon.getIconWidth() > panelWidth) {
                                imgIcon.setImage(imgIcon.getImage().getScaledInstance(panelWidth, -1, 2));
                            }
                            SielhautBearbeiten.this.getKartenLabel().setIcon(imgIcon);
                            SielhautBearbeiten.this.getKartenLabel().setText(null);
                        } else {
                            SielhautBearbeiten.this.getKartenLabel().setIcon(null);
                            SielhautBearbeiten.this.getKartenLabel().setText("<html><b>-  Karte " + SielhautBearbeiten.this.spunkt.getBezeichnung() + ".jpg nicht gefunden!  -</b></html>");
                        }
                    }
                }
            };
        }
        this.kartenRtPanel.repaint();
        return this.kartenRtPanel;
    }

    private JLabel getKartenLabel() {
        if (this.kartenLabel == null) {
            this.kartenLabel = new JLabel("<html><b>- Keine Karte verf\u00fcgbar -</b></html>");
        }
        return this.kartenLabel;
    }

    private void readClipboard() {
        Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferData = systemClipboard.getContents(null);
        for (DataFlavor dataFlavor : transferData.getTransferDataFlavors()) {
            Object content = null;
            try {
                content = transferData.getTransferData(dataFlavor);
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!(content instanceof String)) continue;
            String[] tmp = content.toString().split(",");
            if (tmp.length == 4) {
                String rechtswertAusZeile = tmp[2];
                String hochwertAusZeile = tmp[3];
                this.spRechtsWertFeld.setText(rechtswertAusZeile.substring(0, 7));
                this.spHochWertFeld.setText(hochwertAusZeile.substring(0, 7));
                this.frame.changeStatus("Rechts- und Hochwert eingetragen", HauptFrame.SUCCESS_COLOR);
                break;
            }
            this.frame.changeStatus("Zwischenablage enth\u00e4lt keine verwertbaren Daten", HauptFrame.ERROR_COLOR);
            break;
        }
    }

    public JButton getAusAblageButton() {
        if (this.ausAblageButton == null) {
            this.ausAblageButton = new JButton("aus QGis");
            this.ausAblageButton.setToolTipText("Rechts- und Hochwert aus Zwischenablage einf\u00fcgen");
            this.ausAblageButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SielhautBearbeiten.this.readClipboard();
                }
            });
        }
        return this.ausAblageButton;
    }

    private class AuswertungsDialog
    extends JDialog {
        private JButton speichernButton;
        private JButton abbrechenButton;
        private JTable exportTable;
        private JPopupMenu tabellenMenu;
        private JTabbedPane tabbedPane;
        private ChartPanel chartPanel;
        private DialogListener listener;
        private String title;
        private TimeSeriesCollection leftDataset;
        private TimeSeriesCollection rightDataset;
        private HauptFrame owner;

        public AuswertungsDialog(String title, TimeSeriesCollection leftDataset, TimeSeriesCollection rightDataset, HauptFrame owner) {
            super(owner, title + "-Auswertung", true);
            this.owner = owner;
            this.title = title;
            this.leftDataset = leftDataset;
            this.rightDataset = rightDataset;
            this.listener = new DialogListener();
            this.setDefaultCloseOperation(0);
            this.addWindowListener(this.listener);
            this.speichernButton = new JButton("Speichern");
            this.speichernButton.addActionListener(this.listener);
            this.abbrechenButton = new JButton("Schlie\u00dfen");
            this.abbrechenButton.addActionListener(this.listener);
            JPanel tmp = new JPanel(new BorderLayout(0, 7));
            tmp.add((Component)this.initializeContent(), "Center");
            JPanel buttonBar = ButtonBarFactory.buildOKCancelBar((JButton)this.speichernButton, (JButton)this.abbrechenButton);
            tmp.add((Component)buttonBar, "South");
            tmp.setBorder(Borders.TABBED_DIALOG_BORDER);
            this.setContentPane(tmp);
            this.pack();
            this.setLocationRelativeTo(SielhautBearbeiten.this.frame);
        }

        private JComponent initializeContent() {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.addTab("Diagramm", this.createDiagrammPanel());
            this.tabbedPane.addTab("Tabelle", this.createTabellenPanel());
            return this.tabbedPane;
        }

        private JPanel createDiagrammPanel() {
            JFreeChart chart = this.rightDataset == null ? Charts.createDefaultTimeSeriesChart(this.title, this.leftDataset) : Charts.createDefaultTimeSeriesChart(this.title, this.leftDataset, this.rightDataset);
            this.chartPanel = new ChartPanel(chart, false);
            this.chartPanel.setBorder(Borders.DIALOG_BORDER);
            return this.chartPanel;
        }

        private JComponent createTabellenPanel() {
            this.exportTable = new JTable(new ExportTableModel(this.leftDataset, this.rightDataset));
            this.exportTable.setBorder(BorderFactory.createBevelBorder(0));
            this.exportTable.setColumnSelectionAllowed(true);
            this.exportTable.setRowSelectionAllowed(true);
            this.exportTable.setAutoResizeMode(0);
            this.exportTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    AuswertungsDialog.this.showTabellenPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    AuswertungsDialog.this.showTabellenPopup(e);
                }
            });
            DefaultTableCellRenderer zentrierterRenderer = new DefaultTableCellRenderer();
            zentrierterRenderer.setHorizontalAlignment(0);
            DefaultTableCellRenderer rechtsBuendigRenderer = new DefaultTableCellRenderer();
            rechtsBuendigRenderer.setHorizontalAlignment(4);
            TableColumn column = null;
            for (int i = 0; i < this.exportTable.getColumnCount(); ++i) {
                column = this.exportTable.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setCellRenderer(zentrierterRenderer);
                    column.setPreferredWidth(75);
                    continue;
                }
                column.setCellRenderer(rechtsBuendigRenderer);
                column.setPreferredWidth(90);
            }
            JScrollPane tabellenScroller = new JScrollPane(this.exportTable, 20, 32);
            tabellenScroller.setBorder(Borders.DIALOG_BORDER);
            return tabellenScroller;
        }

        public void saveTabelle() {
            SielhautBearbeiten.this.frame.clearStatus();
            String[] csv = new String[]{"csv"};
            File exportDatei = this.owner.saveFile(csv);
            if (exportDatei != null) {
                String ext = AuikUtils.getExtension(exportDatei);
                if (ext == null) {
                    String newExt = exportDatei.getName().endsWith(".") ? "csv" : ".csv";
                    exportDatei = new File(exportDatei.getParent(), exportDatei.getName() + newExt);
                }
                boolean doIt = false;
                if (exportDatei.exists()) {
                    boolean answer = this.owner.showQuestion("Soll die vorhandene Datei " + exportDatei.getName() + " wirklich \u00fcberschrieben werden?", "Datei bereits vorhanden!");
                    if (answer && exportDatei.canWrite()) {
                        doIt = true;
                    }
                } else if (exportDatei.getParentFile().canWrite()) {
                    doIt = true;
                }
                if (doIt) {
                    AUIKataster.debugOutput("Speichere nach '" + exportDatei.getName() + "' (Ext: '" + ext + "') in '" + exportDatei.getParent() + "' !");
                    if (AuikUtils.exportTableDataToCVS(this.exportTable, exportDatei)) {
                        this.owner.showInfoMessage("Speichern der CSV-Datei erfolgreich!", "Speichern erfolgreich");
                    } else {
                        AUIKataster.debugOutput("Beim Speichern der Datei '" + exportDatei + "' trat ein Fehler auf!");
                        this.owner.showErrorMessage("Beim Speichern der Datei '" + exportDatei + "' trat ein Fehler auf!");
                    }
                }
            }
        }

        private void showTabellenPopup(MouseEvent e) {
            if (this.tabellenMenu == null) {
                this.tabellenMenu = new JPopupMenu("Tabelle");
                JMenuItem speichernItem = new JMenuItem(new AbstractAction("Speichern"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AuswertungsDialog.this.saveTabelle();
                    }
                });
                this.tabellenMenu.add(speichernItem);
            }
            if (e.isPopupTrigger()) {
                Point origin = e.getPoint();
                int row = this.exportTable.rowAtPoint(origin);
                int col = this.exportTable.columnAtPoint(origin);
                if (row != -1) {
                    this.exportTable.setRowSelectionInterval(row, row);
                    this.exportTable.setColumnSelectionInterval(col, col);
                    this.tabellenMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }

        public void doAbbrechen() {
            SielhautBearbeiten.this.frame.clearStatus();
            this.dispose();
        }

        public void doSpeichern() {
            SielhautBearbeiten.this.frame.clearStatus();
            if (this.tabbedPane.getSelectedIndex() == 0) {
                try {
                    this.chartPanel.doSaveAs();
                }
                catch (IOException e) {
                    AUIKataster.debugOutput("Konnte Datei nicht speichern!");
                }
            } else if (this.tabbedPane.getSelectedIndex() == 1) {
                this.saveTabelle();
            }
        }

        private class ExportTableModel
        extends AbstractTableModel {
            private TimeSeriesCollection col1;
            private TimeSeriesCollection col2;
            private List dateList;

            public ExportTableModel(TimeSeriesCollection col1, TimeSeriesCollection col2) {
                this.col1 = col1;
                this.col2 = col2;
                this.dateList = new ArrayList();
                this.initializeData();
            }

            private void initializeData() {
                APosDataItem item;
                int j;
                TimeSeries series;
                int i;
                for (i = 0; i < this.col1.getSeriesCount(); ++i) {
                    series = this.col1.getSeries(i);
                    for (j = 0; j < series.getItemCount(); ++j) {
                        item = (APosDataItem)series.getDataItem(j);
                        if (this.dateList.contains(item.getMinute())) continue;
                        this.dateList.add(item.getMinute());
                    }
                }
                if (this.col2 != null) {
                    for (i = 0; i < this.col2.getSeriesCount(); ++i) {
                        series = this.col2.getSeries(i);
                        for (j = 0; j < series.getItemCount(); ++j) {
                            item = (APosDataItem)series.getDataItem(j);
                            if (this.dateList.contains(item.getMinute())) continue;
                            this.dateList.add(item.getMinute());
                        }
                    }
                }
                Collections.sort(this.dateList);
            }

            @Override
            public int getColumnCount() {
                return this.col1.getSeriesCount() + (this.col2 != null ? this.col2.getSeriesCount() : 0) + 1;
            }

            @Override
            public int getRowCount() {
                return this.dateList.size();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                String tmp = "!OOB!";
                NumberFormat kommaFormat = NumberFormat.getNumberInstance();
                kommaFormat.setGroupingUsed(false);
                kommaFormat.setMinimumFractionDigits(1);
                int seriesIndex = columnIndex - 1;
                int series2Index = seriesIndex - this.col1.getSeriesCount();
                int itemIndex = rowIndex;
                Minute min = (Minute)this.dateList.get(itemIndex);
                if (columnIndex == 0) {
                    Date date = new Date(min.getFirstMillisecond());
                    tmp = AuikUtils.getStringFromDate(date);
                } else {
                    APosDataItem item = null;
                    if (seriesIndex < this.col1.getSeriesCount()) {
                        item = (APosDataItem)this.col1.getSeries(seriesIndex).getDataItem((RegularTimePeriod)min);
                    } else if (this.col2 != null) {
                        item = (APosDataItem)this.col2.getSeries(series2Index).getDataItem((RegularTimePeriod)min);
                    }
                    tmp = item != null ? kommaFormat.format(item.getValue()) : "";
                }
                return tmp;
            }

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public String getColumnName(int column) {
                String tmp = "!OOB!";
                int seriesIndex = column - 1;
                int series2Index = seriesIndex - this.col1.getSeriesCount();
                if (column == 0) {
                    tmp = "Datum";
                } else if (seriesIndex < this.col1.getSeriesCount()) {
                    tmp = this.col1.getSeriesName(seriesIndex) + ", " + this.col1.getSeries(seriesIndex).getRangeDescription();
                } else if (this.col2 != null) {
                    tmp = this.col2.getSeriesName(series2Index) + ", " + this.col2.getSeries(series2Index).getRangeDescription();
                }
                return tmp;
            }
        }

        private class DialogListener
        extends WindowAdapter
        implements ActionListener {
            private DialogListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == AuswertungsDialog.this.abbrechenButton) {
                    AuswertungsDialog.this.doAbbrechen();
                } else if (e.getSource() == AuswertungsDialog.this.speichernButton) {
                    AuswertungsDialog.this.doSpeichern();
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                SielhautBearbeiten.this.frame.clearStatus();
                AuswertungsDialog.this.doAbbrechen();
            }
        }
    }
}

