/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.AbstractModul;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbenahmen;
import de.bielefeld.umweltamt.aui.module.common.editors.ProbenEditor;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.ProbenahmenModel;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.NamedObject;
import de.bielefeld.umweltamt.aui.utils.SwingWorkerVariant;
import de.bielefeld.umweltamt.aui.utils.TabAction;
import de.bielefeld.umweltamt.aui.utils.TableFocusListener;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class LaborProbeSuchen
extends AbstractModul {
    private String iconPath = "filefind32.png";
    private JComboBox suchBox;
    private JTextField suchFeld;
    private JButton submitButton;
    private JTable probeTabelle;
    private Action probeEditAction;
    private Action probeLoeschAction;
    private JPopupMenu probePopup;
    private ProbenahmenModel probeModel;
    private String lastSuche;
    private String lastProperty;
    private AtlProbenahmen lastProbe;

    @Override
    public String getName() {
        return "Probenahme suchen";
    }

    @Override
    public String getIdentifier() {
        return "m_probe_suchen";
    }

    @Override
    public String getCategory() {
        return "Labor";
    }

    @Override
    public Icon getIcon() {
        return super.getIcon(this.iconPath);
    }

    @Override
    public JPanel getPanel() {
        if (this.panel == null) {
            this.probeModel = new ProbenahmenModel("Art");
            TableFocusListener tfl = TableFocusListener.getInstance();
            this.getProbeTabelle().addFocusListener(tfl);
            JScrollPane probeScroller = new JScrollPane(this.getProbeTabelle(), 20, 31);
            JToolBar submitToolBar = new JToolBar();
            submitToolBar.setFloatable(false);
            submitToolBar.setRollover(true);
            submitToolBar.add(this.getSubmitButton());
            TabAction ta = new TabAction();
            ta.addComp(this.getSuchFeld());
            ta.addComp(this.getProbeTabelle());
            FormLayout layout = new FormLayout("65dlu, 4dlu, pref:grow, 3dlu, min(16dlu;p)", "pref, 3dlu, f:150dlu:grow");
            PanelBuilder builder = new PanelBuilder(layout);
            builder.setDefaultDialogBorder();
            CellConstraints cc = new CellConstraints();
            builder.add((Component)this.getSuchBox(), cc.xy(1, 1));
            builder.add((Component)this.getSuchFeld(), cc.xy(3, 1));
            builder.add((Component)submitToolBar, cc.xy(5, 1));
            builder.add((Component)probeScroller, cc.xyw(1, 3, 5));
            this.panel = builder.getPanel();
        }
        return this.panel;
    }

    @Override
    public void show() {
        super.show();
        this.clearForm();
    }

    public void clearForm() {
        this.probeModel.setList(new ArrayList());
        this.probeModel.fireTableDataChanged();
        this.getSuchFeld().selectAll();
        this.getSuchFeld().requestFocus();
    }

    public void editProbe(AtlProbenahmen probe) {
        ProbenEditor editor = new ProbenEditor(probe, this.frame, false);
        editor.setVisible(true);
        this.lastProbe = probe;
        if (editor.wasSaved()) {
            this.updateProbeListe();
        }
    }

    public void updateProbeListe() {
        if (this.lastSuche != null && this.lastProperty != null) {
            this.filterProbeListe(this.lastSuche, this.lastProperty);
        }
    }

    public void filterProbeListe(final String suche, final String column) {
        SwingWorkerVariant worker = new SwingWorkerVariant(this.getProbeTabelle()){

            @Override
            protected void doNonUILogic() throws RuntimeException {
                LaborProbeSuchen.this.probeModel.findByProperty(suche, column);
                LaborProbeSuchen.this.lastSuche = suche;
                LaborProbeSuchen.this.lastProperty = column;
            }

            @Override
            protected void doUIUpdateLogic() throws RuntimeException {
                LaborProbeSuchen.this.getProbeTabelle().clearSelection();
                LaborProbeSuchen.this.probeModel.fireTableDataChanged();
                if (LaborProbeSuchen.this.lastProbe != null) {
                    int row = LaborProbeSuchen.this.probeModel.getList().indexOf(LaborProbeSuchen.this.lastProbe);
                    if (row != -1) {
                        LaborProbeSuchen.this.getProbeTabelle().setRowSelectionInterval(row, row);
                        LaborProbeSuchen.this.getProbeTabelle().scrollRectToVisible(LaborProbeSuchen.this.getProbeTabelle().getCellRect(row, 0, true));
                    }
                } else {
                    String statusMsg = "Suche: " + LaborProbeSuchen.this.probeModel.getRowCount() + " Ergebnis";
                    if (LaborProbeSuchen.this.probeModel.getRowCount() != 1) {
                        statusMsg = statusMsg + "se";
                    }
                    statusMsg = statusMsg + ".";
                    LaborProbeSuchen.this.frame.changeStatus(statusMsg);
                }
            }
        };
        if (this.lastProbe == null) {
            this.frame.changeStatus("Suche...");
        }
        worker.start();
    }

    private Action getProbeEditAction() {
        if (this.probeEditAction == null) {
            this.probeEditAction = new AbstractAction("Bearbeiten"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = LaborProbeSuchen.this.getProbeTabelle().getSelectedRow();
                    AUIKataster.debugOutput("Enter in Zeile " + row, "probeTabelle");
                    if (row != -1) {
                        AtlProbenahmen probe = LaborProbeSuchen.this.probeModel.getRow(row);
                        LaborProbeSuchen.this.editProbe(probe);
                    }
                }
            };
            this.probeEditAction.putValue("MnemonicKey", new Integer(66));
            this.probeEditAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0, false));
        }
        return this.probeEditAction;
    }

    private Action getProbeLoeschAction() {
        if (this.probeLoeschAction == null) {
            this.probeLoeschAction = new AbstractAction("L\u00f6schen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = LaborProbeSuchen.this.getProbeTabelle().getSelectedRow();
                    if (row != -1 && LaborProbeSuchen.this.getProbeTabelle().getEditingRow() == -1) {
                        AtlProbenahmen probe = LaborProbeSuchen.this.probeModel.getRow(row);
                        int answer = JOptionPane.showConfirmDialog(LaborProbeSuchen.this.panel, "Soll die Probenahme '" + probe.getKennummer() + "' wirklich inkl. aller Analysen gel\u00f6scht werden?", "L\u00f6schen best\u00e4tigen", 0);
                        if (answer == 0) {
                            if (LaborProbeSuchen.this.probeModel.removeRow(row)) {
                                LaborProbeSuchen.this.frame.changeStatus("Probenahme gel\u00f6scht.", HauptFrame.SUCCESS_COLOR);
                                AUIKataster.debugOutput("Probe " + probe + " wurde gel\u00f6scht!", "BasisBetreiberSuchen.removeAction");
                            } else {
                                LaborProbeSuchen.this.frame.changeStatus("Konnte die Probenahme nicht l\u00f6schen!", HauptFrame.ERROR_COLOR);
                            }
                        }
                    }
                }
            };
            this.probeLoeschAction.putValue("MnemonicKey", new Integer(76));
            this.probeLoeschAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0, false));
        }
        return this.probeLoeschAction;
    }

    private void showProbePopup(MouseEvent e) {
        if (this.probePopup == null) {
            this.probePopup = new JPopupMenu("Probe");
            JMenuItem bearbItem = new JMenuItem(this.getProbeEditAction());
            JMenuItem loeschItem = new JMenuItem(this.getProbeLoeschAction());
            this.probePopup.add(bearbItem);
            this.probePopup.add(loeschItem);
        }
        if (e.isPopupTrigger()) {
            Point origin = e.getPoint();
            int row = this.getProbeTabelle().rowAtPoint(origin);
            if (row != -1) {
                this.getProbeTabelle().setRowSelectionInterval(row, row);
                this.probePopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private JTable getProbeTabelle() {
        if (this.probeTabelle == null) {
            this.probeTabelle = new JTable(this.probeModel);
            this.probeTabelle.setAutoResizeMode(1);
            this.probeTabelle.getColumnModel().getColumn(0).setPreferredWidth(30);
            this.probeTabelle.getColumnModel().getColumn(1).setPreferredWidth(45);
            this.probeTabelle.getColumnModel().getColumn(2).setPreferredWidth(30);
            this.probeTabelle.getColumnModel().getColumn(3).setPreferredWidth(200);
            this.probeTabelle.setSelectionMode(0);
            this.probeTabelle.setColumnSelectionAllowed(false);
            this.probeTabelle.setRowSelectionAllowed(true);
            this.probeTabelle.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        Point origin = e.getPoint();
                        int row = LaborProbeSuchen.this.getProbeTabelle().rowAtPoint(origin);
                        AtlProbenahmen probe = LaborProbeSuchen.this.probeModel.getRow(row);
                        AUIKataster.debugOutput("Doppelklick auf Zeile " + row, "BasisBetreiberSuchen");
                        LaborProbeSuchen.this.editProbe(probe);
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    LaborProbeSuchen.this.showProbePopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    LaborProbeSuchen.this.showProbePopup(e);
                }
            });
            this.probeTabelle.getInputMap().put((KeyStroke)this.getProbeEditAction().getValue("AcceleratorKey"), this.getProbeEditAction().getValue("Name"));
            this.probeTabelle.getActionMap().put(this.getProbeEditAction().getValue("Name"), this.getProbeEditAction());
            this.probeTabelle.getInputMap().put((KeyStroke)this.getProbeLoeschAction().getValue("AcceleratorKey"), this.getProbeLoeschAction().getValue("Name"));
            this.probeTabelle.getActionMap().put(this.getProbeLoeschAction().getValue("Name"), this.getProbeLoeschAction());
        }
        return this.probeTabelle;
    }

    private JComboBox getSuchBox() {
        if (this.suchBox == null) {
            this.suchBox = new JComboBox<NamedObject>(new NamedObject[]{new NamedObject("Kennnummer:", "kennummer"), new NamedObject("Bemerkung:", "bemerkung")});
        }
        return this.suchBox;
    }

    private JTextField getSuchFeld() {
        if (this.suchFeld == null) {
            this.suchFeld = new JTextField("");
            this.suchFeld.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String suche = LaborProbeSuchen.this.getSuchFeld().getText();
                    String spalte = (String)((NamedObject)LaborProbeSuchen.this.getSuchBox().getSelectedItem()).getValue();
                    LaborProbeSuchen.this.lastProbe = null;
                    LaborProbeSuchen.this.filterProbeListe(suche, spalte);
                }
            });
            this.suchFeld.setFocusTraversalKeys(0, Collections.EMPTY_SET);
            this.suchFeld.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 9) {
                        String suche = LaborProbeSuchen.this.getSuchFeld().getText();
                        String spalte = (String)((NamedObject)LaborProbeSuchen.this.getSuchBox().getSelectedItem()).getValue();
                        LaborProbeSuchen.this.filterProbeListe(suche, spalte);
                    }
                }
            });
        }
        return this.suchFeld;
    }

    private JButton getSubmitButton() {
        if (this.submitButton == null) {
            this.submitButton = new JButton(AuikUtils.getIcon(16, "key_enter.png"));
            this.submitButton.setToolTipText("Suche starten");
            this.submitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String suche = LaborProbeSuchen.this.getSuchFeld().getText();
                    String spalte = (String)((NamedObject)LaborProbeSuchen.this.getSuchBox().getSelectedItem()).getValue();
                    LaborProbeSuchen.this.lastProbe = null;
                    LaborProbeSuchen.this.filterProbeListe(suche, spalte);
                }
            });
        }
        return this.submitButton;
    }
}

