/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.AbstractModul;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlAnalyseposition;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlEinheiten;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlParameter;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbenahmen;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.ListTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LaborIcpImport
extends AbstractModul {
    private JFileChooser fc = null;
    private JLabel stepOneLabel = null;
    private JLabel stepTwoLabel = null;
    private JLabel stepThreeLabel = null;
    private Icon stepOneW;
    private Icon stepOneG;
    private Icon stepOneGrey;
    private Icon stepTwoW;
    private Icon stepTwoG;
    private Icon stepTwoGrey;
    private Icon stepThreeW;
    private Icon stepThreeG;
    private Icon stepThreeGrey;
    private JButton dateiButton;
    private JButton importButton;
    private JLabel dateiLabel;
    private JTable importTabelle;
    private JScrollPane importScroller;
    private JLabel erklaerungsLabel;
    private FileImporter fileImporter;
    private int step;

    @Override
    public String getName() {
        return "ICP Import";
    }

    @Override
    public String getIdentifier() {
        return "atl_icp_import";
    }

    @Override
    public String getCategory() {
        return "Labor";
    }

    @Override
    public Icon getIcon() {
        return super.getIcon("ksysguard.png");
    }

    @Override
    public JPanel getPanel() {
        if (this.panel == null) {
            this.initIcons();
            FormLayout layout = new FormLayout("40px, 5dlu, 65dlu, 5dlu, 175dlu:g", "");
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.setDefaultDialogBorder();
            builder.append((Component)this.getStepOneLabel(), (Component)this.getDateiButton(), (Component)this.getDateiLabel());
            builder.appendRelatedComponentsGapRow();
            builder.appendRow("f:50dlu:g");
            builder.nextLine(2);
            builder.append((Component)this.getStepTwoLabel());
            builder.append((Component)this.getImportScroller(), 3);
            builder.appendRelatedComponentsGapRow();
            builder.nextLine(2);
            builder.append("");
            builder.append((Component)this.getErklaerungsLabel(), 3);
            builder.appendRelatedComponentsGapRow();
            builder.nextLine(2);
            builder.append((Component)this.getStepThreeLabel(), (Component)this.getImportButton());
            this.panel = builder.getPanel();
        }
        return this.panel;
    }

    @Override
    public void show() {
        super.show();
        this.switchToStep(1);
    }

    private void initIcons() {
        this.stepOneW = AuikUtils.getIcon("step1_w.png", "Schritt Eins");
        this.stepOneG = AuikUtils.getIcon("step1_g.png", "Schritt Eins");
        this.stepOneGrey = AuikUtils.getIcon("step1_grey.png", "Schritt Eins");
        this.stepTwoW = AuikUtils.getIcon("step2_w.png", "Schritt Zwei");
        this.stepTwoG = AuikUtils.getIcon("step2_g.png", "Schritt Zwei");
        this.stepTwoGrey = AuikUtils.getIcon("step2_grey.png", "Schritt Zwei");
        this.stepThreeW = AuikUtils.getIcon("step3_w.png", "Schritt Drei");
        this.stepThreeG = AuikUtils.getIcon("step3_g.png", "Schritt Drei");
        this.stepThreeGrey = AuikUtils.getIcon("step3_grey.png", "Schritt Drei");
    }

    private JLabel getStepOneLabel() {
        if (this.stepOneLabel == null) {
            this.stepOneLabel = new JLabel(this.stepOneGrey);
        }
        return this.stepOneLabel;
    }

    private JLabel getStepTwoLabel() {
        if (this.stepTwoLabel == null) {
            this.stepTwoLabel = new JLabel(this.stepTwoGrey);
        }
        return this.stepTwoLabel;
    }

    private JLabel getStepThreeLabel() {
        if (this.stepThreeLabel == null) {
            this.stepThreeLabel = new JLabel(this.stepThreeGrey);
        }
        return this.stepThreeLabel;
    }

    private JButton getDateiButton() {
        if (this.dateiButton == null) {
            this.dateiButton = new JButton("Datei w\u00e4hlen");
            this.dateiButton.setToolTipText("W\u00e4hlt eine Datei zum Importieren aus");
            this.dateiButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file = LaborIcpImport.this.frame.openFile(new String[]{"txt"});
                    if (file != null) {
                        LaborIcpImport.this.switchToStep(1);
                        LaborIcpImport.this.fileImporter.openFile(file);
                    }
                }
            });
        }
        return this.dateiButton;
    }

    private JLabel getDateiLabel() {
        if (this.dateiLabel == null) {
            this.dateiLabel = new JLabel();
        }
        return this.dateiLabel;
    }

    private JButton getImportButton() {
        if (this.importButton == null) {
            this.importButton = new JButton("Importieren");
            this.importButton.setToolTipText("Importiert die gew\u00e4hlten Analysepositionen");
            this.importButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        LaborIcpImport.this.fileImporter.doImport();
                    }
                    catch (Exception e1) {
                        LaborIcpImport.this.frame.showErrorMessage("<html>Beim importieren ist ein Fehler aufgetreten:<br>" + e1.getMessage() + "</html>");
                    }
                }
            });
        }
        return this.importButton;
    }

    private JLabel getErklaerungsLabel() {
        if (this.erklaerungsLabel == null) {
            String sErklaerung = "<html><font color=green>Gr\u00fcn:</font> Position kann problemlos importiert werden.<br><font color=#ff8200>Orange:</font> Wert a\u00dferhalb des kalibrierten Bereichs oder KS-Einwaage nicht festgelegt.<br><font color=red>Rot:</font> Probenahme nicht gefunden oder Parameter unbekannt.</html>";
            this.erklaerungsLabel = new JLabel(sErklaerung);
        }
        return this.erklaerungsLabel;
    }

    private JTable getImportTabelle() {
        if (this.importTabelle == null) {
            if (this.fileImporter == null) {
                this.fileImporter = new FileImporter();
            }
            this.importTabelle = new JTable(this.fileImporter);
            this.importTabelle.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    if (LaborIcpImport.this.importTabelle.getSelectedRowCount() != 0) {
                        int[] selectedRows = LaborIcpImport.this.importTabelle.getSelectedRows();
                        for (int i = 0; i < selectedRows.length; ++i) {
                            if (!LaborIcpImport.this.fileImporter.isRowImportable(selectedRows[i])) {
                                LaborIcpImport.this.importTabelle.removeRowSelectionInterval(selectedRows[i], selectedRows[i]);
                                continue;
                            }
                            if (LaborIcpImport.this.step == 3) continue;
                            LaborIcpImport.this.switchToStep(3);
                        }
                    } else if (LaborIcpImport.this.step != 2) {
                        LaborIcpImport.this.switchToStep(2);
                    }
                }
            });
        }
        return this.importTabelle;
    }

    private JScrollPane getImportScroller() {
        if (this.importScroller == null) {
            this.importScroller = new JScrollPane(this.getImportTabelle());
        }
        return this.importScroller;
    }

    public void switchToStep(int step) {
        this.step = step;
        switch (step) {
            case 1: {
                this.fileImporter.reset();
                this.getDateiLabel().setText("");
                this.getStepOneLabel().setIcon(this.stepOneW);
                this.getStepTwoLabel().setIcon(this.stepTwoGrey);
                this.getStepThreeLabel().setIcon(this.stepThreeGrey);
                this.enableStepComponents(1, true);
                this.enableStepComponents(2, false);
                this.enableStepComponents(3, false);
                this.getDateiButton().requestFocus();
                break;
            }
            case 2: {
                this.getStepOneLabel().setIcon(this.stepOneG);
                this.getStepTwoLabel().setIcon(this.stepTwoW);
                this.getStepThreeLabel().setIcon(this.stepThreeGrey);
                this.enableStepComponents(1, true);
                this.enableStepComponents(2, true);
                this.enableStepComponents(3, false);
                this.getImportTabelle().requestFocus();
                break;
            }
            case 3: {
                this.getStepOneLabel().setIcon(this.stepOneG);
                this.getStepTwoLabel().setIcon(this.stepTwoG);
                this.getStepThreeLabel().setIcon(this.stepThreeW);
                this.enableStepComponents(1, true);
                this.enableStepComponents(2, true);
                this.enableStepComponents(3, true);
                this.getImportTabelle().requestFocus();
                break;
            }
        }
    }

    private void enableStepComponents(int step, boolean enabled) {
        switch (step) {
            case 1: {
                this.getDateiButton().setEnabled(enabled);
                this.getDateiLabel().setEnabled(enabled);
                break;
            }
            case 2: {
                this.getImportTabelle().setEnabled(enabled);
                this.getErklaerungsLabel().setEnabled(enabled);
                break;
            }
            case 3: {
                this.getImportButton().setEnabled(enabled);
                break;
            }
        }
    }

    private class FileImporter
    extends ListTableModel {
        private File importFile;
        private Map perfectRows;
        private Map importableRows;

        public FileImporter() {
            super(new String[]{"Probe", "Parameter", "Wert", "Einheit", "Flags"}, false);
            this.importFile = null;
            this.perfectRows = null;
            this.importableRows = null;
        }

        @Override
        public Object getColumnValue(Object objectAtRow, int columnIndex) {
            String value;
            String[] tmpArr = (String[])objectAtRow;
            switch (columnIndex) {
                case 0: {
                    String tmp = "<html><font color=";
                    tmp = this.isPositionPerfect(tmpArr) ? tmp + "00cc00" : (this.isPositionImportable(tmpArr) ? tmp + "ff8200" : tmp + "red");
                    String nr = this.kennummerAusZeile(tmpArr);
                    value = tmp + ">" + nr + "</font> " + tmpArr[0].replaceFirst(nr, "").trim() + "</html>";
                    break;
                }
                case 1: {
                    value = this.paramAusZeile(tmpArr);
                    break;
                }
                case 2: {
                    value = this.wertAusZeile(tmpArr);
                    break;
                }
                case 3: {
                    value = this.einheitAusZeile(tmpArr);
                    break;
                }
                case 4: {
                    value = this.flagsAusZeile(tmpArr);
                    break;
                }
                default: {
                    value = null;
                }
            }
            return value;
        }

        @Override
        public void updateList() throws Exception {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(this.importFile));
            int count = 0;
            while ((line = in.readLine()) != null) {
                if (count == 0 && !line.startsWith("Solution Label")) {
                    throw new IOException("Datei ist kein ICP-Export!");
                }
                String[] tmp = line.split("    ");
                if (tmp.length != 18 && tmp.length != 15) {
                    throw new IOException("Datei ist besch\u00e4digt!");
                }
                if (!tmp[0].startsWith("Standard") && tmp[1].equals("Samp") && !tmp[2].startsWith("Ar")) {
                    this.getList().add(tmp);
                }
                ++count;
            }
            System.out.println(this.getList().size() + " Zeilen gelesen!");
            in.close();
            this.fireTableDataChanged();
        }

        public void reset() {
            this.setList(new ArrayList());
            this.importFile = null;
            this.perfectRows = null;
            this.importableRows = null;
            this.fireTableDataChanged();
        }

        public void selectAllImportableRows() {
            if (this.importFile != null) {
                for (int i = 0; i < this.getList().size(); ++i) {
                    if (!this.isRowPerfect(i)) continue;
                    LaborIcpImport.this.getImportTabelle().addRowSelectionInterval(i, i);
                }
            }
        }

        private String datumAusZeile(String[] zeile) {
            return zeile[9].trim() + " " + zeile[10].trim();
        }

        private String einheitAusZeile(String[] zeile) {
            return zeile[7].trim();
        }

        private String wertAusZeile(String[] zeile) {
            return zeile[6].trim();
        }

        private String kennummerAusZeile(String[] zeile) {
            return this.spalteAusZeile(zeile, 0);
        }

        private String paramAusZeile(String[] zeile) {
            return this.spalteAusZeile(zeile, 2);
        }

        private String flagsAusZeile(String[] zeile) {
            String tmp = this.spalteAusZeile(zeile, 3);
            String result = null;
            if (tmp != null) {
                result = tmp.trim();
            }
            return result;
        }

        private String spalteAusZeile(String[] zeile, int spalte) {
            if (zeile != null && zeile.length > spalte) {
                return zeile[spalte].replaceFirst(" .*", "");
            }
            return null;
        }

        private boolean isRowPerfect(int rowIndex) {
            return this.isPositionPerfect((String[])this.getObjectAtRow(rowIndex));
        }

        private boolean isPositionPerfect(String[] pos) {
            if (this.perfectRows == null) {
                this.perfectRows = new HashMap(this.getList().size());
            }
            if (!this.perfectRows.containsKey(pos)) {
                if (!AtlParameter.isParameterSupported(this.paramAusZeile(pos))) {
                    this.perfectRows.put(pos, Boolean.FALSE);
                } else {
                    String kennummer = this.kennummerAusZeile(pos);
                    AtlProbenahmen probe = AtlProbenahmen.getProbenahme(kennummer, false);
                    if (probe != null) {
                        if (this.flagsAusZeile(pos).equals("")) {
                            if (probe.isKlaerschlammProbe()) {
                                if (probe.getEinwaage() == null || probe.getEinwaage().floatValue() == 0.0f) {
                                    this.perfectRows.put(pos, Boolean.FALSE);
                                } else {
                                    this.perfectRows.put(pos, Boolean.TRUE);
                                }
                            } else {
                                this.perfectRows.put(pos, Boolean.TRUE);
                            }
                        } else {
                            this.perfectRows.put(pos, Boolean.FALSE);
                        }
                    } else {
                        this.perfectRows.put(pos, Boolean.FALSE);
                    }
                }
            }
            return (Boolean)this.perfectRows.get(pos);
        }

        public boolean isRowImportable(int rowIndex) {
            return this.isPositionImportable((String[])this.getObjectAtRow(rowIndex));
        }

        private boolean isPositionImportable(String[] pos) {
            if (this.importableRows == null) {
                this.importableRows = new HashMap(this.getList().size());
            }
            if (!this.importableRows.containsKey(pos)) {
                if (this.isPositionPerfect(pos)) {
                    this.importableRows.put(pos, new Boolean(true));
                } else if (!AtlParameter.isParameterSupported(this.paramAusZeile(pos))) {
                    this.importableRows.put(pos, new Boolean(false));
                } else {
                    String kennummer = this.kennummerAusZeile(pos);
                    AtlProbenahmen probe = AtlProbenahmen.getProbenahme(kennummer, false);
                    if (probe != null) {
                        this.importableRows.put(pos, new Boolean(true));
                    } else {
                        this.importableRows.put(pos, new Boolean(false));
                    }
                }
            }
            return (Boolean)this.importableRows.get(pos);
        }

        public void openFile(File file) {
            if (file.isFile() && file.canRead()) {
                LaborIcpImport.this.getDateiLabel().setText("Datei: " + file.getName());
                this.importFile = file;
                try {
                    this.updateList();
                }
                catch (Exception e) {
                    LaborIcpImport.this.frame.showErrorMessage("<html>Konnte Datei nicht \u00f6ffnen: <br>" + e.getLocalizedMessage() + "</html>");
                    LaborIcpImport.this.switchToStep(1);
                    return;
                }
                if (this.getList() != null && this.getList().size() > 0) {
                    LaborIcpImport.this.switchToStep(2);
                    this.selectAllImportableRows();
                } else {
                    LaborIcpImport.this.frame.showInfoMessage("Die Datei enth\u00e4lt keine importierbaren Analysepositionen!", "ICP-Import");
                }
            } else {
                LaborIcpImport.this.frame.showErrorMessage("Konnte die angegebene Datei nicht \u00f6ffnen!", "Fehler beim \u00d6ffnen");
            }
        }

        public void doImport() throws Exception {
            if (LaborIcpImport.this.step == 3 && this.importFile != null && this.getList() != null) {
                int importCount = 0;
                int[] selectedRows = LaborIcpImport.this.importTabelle.getSelectedRows();
                DateFormat df = DateFormat.getDateTimeInstance();
                String problemMessage = "";
                for (int i = 0; i < selectedRows.length; ++i) {
                    Date date;
                    String sParam;
                    boolean problem = false;
                    String[] current = (String[])this.getObjectAtRow(selectedRows[i]);
                    if (!this.isPositionImportable(current)) continue;
                    AtlAnalyseposition pos = new AtlAnalyseposition();
                    String kennumer = this.kennummerAusZeile(current);
                    AtlProbenahmen probe = AtlProbenahmen.getProbenahme(kennumer, true);
                    if (probe == null) {
                        throw new Exception("Probenahme nicht gefunden!");
                    }
                    probe.addAnalyseposition(pos);
                    Float wert = new Float(this.wertAusZeile(current));
                    if ((double)wert.floatValue() < 0.0) {
                        wert = new Float(0.0);
                        pos.setGrkl("<");
                    }
                    pos.setWert(wert);
                    if (probe.isKlaerschlammProbe() && (probe.getEinwaage() == null || probe.getEinwaage().floatValue() == 0.0f)) {
                        probe.setEinwaage(new Float(3.0f));
                        AUIKataster.debugOutput("Einwaage von " + probe + " auf 3g korrigiert.");
                    }
                    if ((sParam = this.paramAusZeile(current)) != null) {
                        AtlParameter para = AtlParameter.getParameter(AtlParameter.getOrdnungsbegriff(sParam));
                        if (para != null) {
                            pos.setAtlParameter(para);
                        } else {
                            problem = true;
                            if (!problemMessage.equals("")) {
                                problemMessage = problemMessage + "<br>";
                            }
                            problemMessage = problemMessage + "Unbekannter Parameter: " + sParam;
                        }
                    } else {
                        throw new Exception("Importdatei besc\u00e4digt!");
                    }
                    String sEinheit = this.einheitAusZeile(current);
                    AtlEinheiten einheit = null;
                    if (sEinheit.equals("mg/L")) {
                        if (probe.isKlaerschlammProbe()) {
                            Float einwaage = probe.getEinwaage();
                            AUIKataster.debugOutput("Kl\u00e4rschlamm-Umrechnung n\u00f6tig, Einwaage: " + einwaage);
                            if (einwaage != null) {
                                BigDecimal rundWert = new BigDecimal(wert.doubleValue() * 100.0 / einwaage.doubleValue());
                                rundWert = rundWert.setScale(1, 0);
                                pos.setWert(new Float(rundWert.floatValue()));
                                einheit = AtlEinheiten.getEinheit(AtlEinheiten.MG_KG_ID);
                                AUIKataster.debugOutput("Kl\u00e4rschlamm-Umrechnung: (" + wert + " mg/L * 100) / " + einwaage + " = " + pos.getWert() + " mg/KG");
                            }
                        } else {
                            AUIKataster.debugOutput("Keine Kl\u00e4rschlamm-Umrechnung n\u00f6tig.");
                            einheit = AtlEinheiten.getEinheit(AtlEinheiten.MG_L_ID);
                        }
                    }
                    if (einheit != null) {
                        pos.setAtlEinheiten(einheit);
                    } else {
                        problem = true;
                        if (!problemMessage.equals("")) {
                            problemMessage = problemMessage + "<br>";
                        }
                        problemMessage = problemMessage + "Unbekannte Einheit: " + sEinheit;
                    }
                    try {
                        date = df.parse(this.datumAusZeile(current));
                    }
                    catch (ParseException e2) {
                        date = null;
                        AUIKataster.debugOutput("Konnte ICP-Datum nicht parsen!");
                    }
                    if (date != null) {
                        AUIKataster.debugOutput("Setze ICP-Datum auf: " + df.format(date));
                        probe.setDatumIcp(date);
                    }
                    pos.setAnalyseVon("360.33");
                    if (problem) continue;
                    if (AtlAnalyseposition.saveAnalyseposition(pos)) {
                        ++importCount;
                        AUIKataster.debugOutput("Habe " + pos + " gespeichert!");
                        continue;
                    }
                    throw new Exception("Konnte Analyseposition nicht in der Datenbank speichern!");
                }
                LaborIcpImport.this.frame.changeStatus(importCount + " Datens\u00e4tze importiert!");
                LaborIcpImport.this.switchToStep(1);
                if (!problemMessage.equals("")) {
                    throw new Exception(problemMessage);
                }
            }
        }
    }
}

