/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.toedter.calendar.JDateChooser;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.AbstractModul;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlAnalyseposition;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlEinheiten;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlKlaeranlagen;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlParameter;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbeart;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbepkt;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.SearchBox;
import de.bielefeld.umweltamt.aui.utils.SwingWorkerVariant;
import de.bielefeld.umweltamt.aui.utils.charts.APosDataItem;
import de.bielefeld.umweltamt.aui.utils.charts.ChartDataSets;
import de.bielefeld.umweltamt.aui.utils.charts.Charts;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class KlaerschlammAuswertung
extends AbstractModul {
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private JCheckBox heepenCheck;
    private JCheckBox brakeCheck;
    private JCheckBox sennestCheck;
    private JCheckBox olutterCheck;
    private JCheckBox verlCheck;
    private JComboBox artBox;
    private JDateChooser vonDateChooser;
    private JDateChooser bisDateChooser;
    private JPanel parameterPanel;
    private JList rightList;
    private JList leftList;
    private JButton submitButton;
    private JComboBox parameterBox;
    private JButton leftDeleteButton;
    private JButton rightDeleteButton;
    private JComboBox leftEinheitenBox;
    private JComboBox rightEinheitenBox;
    private JTextField leftAnalyseFeld;
    private JTextField rightAnalyseFeld;
    private ActionListener rlButtonListener;
    private AtlEinheiten[] einheiten;
    private TimeSeriesCollection dataSet1;
    private TimeSeriesCollection dataSet2;

    @Override
    public String getName() {
        return "Auswertung Kl\u00e4rschlamm";
    }

    @Override
    public String getIdentifier() {
        return "m_schlaemme_auswertung";
    }

    @Override
    public Icon getIcon() {
        return super.getIcon("log.png");
    }

    @Override
    public String getCategory() {
        return "Kl\u00e4rschlamm";
    }

    @Override
    public JPanel getPanel() {
        if (this.panel == null) {
            this.einheiten = AtlEinheiten.getEinheiten();
            String spaltenTeil = "pref, 5dlu, pref:g";
            String zeileLuecke = "pref, 3dlu";
            FormLayout gesamtLayout = new FormLayout("pref, 5dlu, " + spaltenTeil + ", 10dlu:g(0.2), " + spaltenTeil, zeileLuecke + ", " + zeileLuecke + ", " + zeileLuecke + ", " + zeileLuecke + ", " + "pref, 10dlu, " + "pref");
            gesamtLayout.setColumnGroups((int[][])new int[][]{{1, 3, 5, 9}});
            gesamtLayout.setRowGroups((int[][])new int[][]{{3, 5}});
            PanelBuilder builder = new PanelBuilder(gesamtLayout);
            builder.setDefaultDialogBorder();
            CellConstraints cc = new CellConstraints();
            CellConstraints cc2 = (CellConstraints)cc.clone();
            builder.addSeparator("Kl\u00e4ranlagen / Art", cc.xyw(1, 1, 5));
            builder.add((Component)this.getHeepenCheck(), cc.xy(1, 3));
            builder.add((Component)this.getBrakeCheck(), cc.xy(3, 3));
            builder.add((Component)this.getSennestCheck(), cc.xy(5, 3));
            builder.add((Component)this.getOlutterCheck(), cc.xy(1, 5));
            builder.add((Component)this.getVerlCheck(), cc.xy(3, 5));
            builder.add((Component)this.getArtBox(), cc.xy(5, 5, "l,d"));
            builder.addSeparator("Zeitraum", cc.xyw(7, 1, 3));
            builder.add(new JLabel("Von:"), cc.xy(7, 3, "r,d"), (Component)this.getVonDateChooser(), cc2.xy(9, 3, "l,d"));
            builder.add(new JLabel("Bis:"), cc.xy(7, 5, "r,d"), (Component)this.getBisDateChooser(), cc2.xy(9, 5, "l,d"));
            builder.addSeparator("Parameter", cc.xyw(1, 7, 9));
            builder.add((Component)this.getParameterPanel(), cc.xyw(1, 9, 9, "fill, fill"));
            JPanel buttonPanel = ButtonBarFactory.buildOKBar((JButton)this.getSubmitButton());
            builder.add((Component)buttonPanel, cc.xyw(1, 11, 9, "fill, fill"));
            this.panel = builder.getPanel();
        }
        return this.panel;
    }

    public void showResultOneAxis(final String axis) {
        SwingWorkerVariant worker = new SwingWorkerVariant(this.getSubmitButton()){

            @Override
            protected void doNonUILogic() throws RuntimeException {
                KlaerschlammAuswertung.this.dataSet1 = KlaerschlammAuswertung.this.createDataset(axis);
            }

            @Override
            protected void doUIUpdateLogic() throws RuntimeException {
                if (KlaerschlammAuswertung.this.dataSet1.getSeriesCount() > 0) {
                    KlaerschlammAuswertung.this.frame.clearStatus();
                    AuswertungsDialog dialog = new AuswertungsDialog(KlaerschlammAuswertung.this.getArtBox().getSelectedItem().toString(), KlaerschlammAuswertung.this.dataSet1, null, KlaerschlammAuswertung.this.frame);
                    dialog.setVisible(true);
                } else {
                    KlaerschlammAuswertung.this.frame.changeStatus("Keine Parameter ausgew\u00e4hlt!");
                }
            }
        };
        this.frame.changeStatus("Bereite Auswertung vor...");
        worker.start();
    }

    public void showResultDualAxis() {
        SwingWorkerVariant worker = new SwingWorkerVariant(this.getSubmitButton()){
            private int seriesCount;
            {
                this.seriesCount = 0;
            }

            @Override
            protected void doNonUILogic() throws RuntimeException {
                KlaerschlammAuswertung.this.dataSet1 = KlaerschlammAuswertung.this.createDataset(KlaerschlammAuswertung.LEFT);
                KlaerschlammAuswertung.this.dataSet2 = KlaerschlammAuswertung.this.createDataset(KlaerschlammAuswertung.RIGHT);
                this.seriesCount = KlaerschlammAuswertung.this.dataSet1.getSeriesCount() + KlaerschlammAuswertung.this.dataSet2.getSeriesCount();
            }

            @Override
            protected void doUIUpdateLogic() throws RuntimeException {
                if (this.seriesCount > 0) {
                    KlaerschlammAuswertung.this.frame.clearStatus();
                    AuswertungsDialog dialog = new AuswertungsDialog(KlaerschlammAuswertung.this.getArtBox().getSelectedItem().toString(), KlaerschlammAuswertung.this.dataSet1, KlaerschlammAuswertung.this.dataSet2, KlaerschlammAuswertung.this.frame);
                    dialog.setVisible(true);
                } else {
                    KlaerschlammAuswertung.this.frame.changeStatus("Keine Parameter ausgew\u00e4hlt!");
                }
            }
        };
        this.frame.changeStatus("Bereite Auswertung vor...");
        worker.start();
    }

    private TimeSeriesCollection createDataset(String axis) {
        String analyseVon;
        JList paramList;
        AtlEinheiten einheit;
        TimeSeriesCollection col = new TimeSeriesCollection();
        if (axis.equals(LEFT)) {
            int parameterAnzahl = this.getLeftList().getModel().getSize();
            einheit = (AtlEinheiten)this.getLeftEinheitenBox().getSelectedItem();
            paramList = this.getLeftList();
            analyseVon = this.getLeftAnalyseFeld().getText().toLowerCase().trim();
        } else {
            int parameterAnzahl = this.getRightList().getModel().getSize();
            einheit = (AtlEinheiten)this.getRightEinheitenBox().getSelectedItem();
            paramList = this.getRightList();
            analyseVon = this.getRightAnalyseFeld().getText().toLowerCase().trim();
        }
        AtlProbeart art = (AtlProbeart)this.getArtBox().getSelectedItem();
        Date vonDate = this.getVonDateChooser().getDate();
        Date bisDate = this.getBisDateChooser().getDate();
        if (this.getHeepenCheck().isSelected()) {
            this.createSeries(art, AtlKlaeranlagen.getKlaeranlage(AtlKlaeranlagen.HEEPEN), einheit, paramList, analyseVon, vonDate, bisDate, col);
        }
        if (this.getBrakeCheck().isSelected()) {
            this.createSeries(art, AtlKlaeranlagen.getKlaeranlage(AtlKlaeranlagen.BRAKE), einheit, paramList, analyseVon, vonDate, bisDate, col);
        }
        if (this.getSennestCheck().isSelected()) {
            this.createSeries(art, AtlKlaeranlagen.getKlaeranlage(AtlKlaeranlagen.SENNESTADT), einheit, paramList, analyseVon, vonDate, bisDate, col);
        }
        if (this.getOlutterCheck().isSelected()) {
            this.createSeries(art, AtlKlaeranlagen.getKlaeranlage(AtlKlaeranlagen.OBERE_LUTTER), einheit, paramList, analyseVon, vonDate, bisDate, col);
        }
        if (this.getVerlCheck().isSelected()) {
            this.createSeries(art, AtlKlaeranlagen.getKlaeranlage(AtlKlaeranlagen.VERL_SENDE), einheit, paramList, analyseVon, vonDate, bisDate, col);
        }
        return col;
    }

    private void createSeries(AtlProbeart art, AtlKlaeranlagen ka, AtlEinheiten einheit, JList paramList, String analyseVon, Date vonDate, Date bisDate, TimeSeriesCollection col) {
        AtlProbepkt pkt = AtlProbepkt.getKlaerschlammProbepunkt(art, ka);
        if (pkt != null) {
            for (int i = 0; i < paramList.getModel().getSize(); ++i) {
                AtlParameter p = (AtlParameter)paramList.getModel().getElementAt(i);
                this.frame.changeStatus("Erzeuge Datenreihe f\u00fcr " + p + ", " + ka);
                List list = AtlAnalyseposition.getAnalysepositionen(p, einheit, pkt, vonDate, bisDate, analyseVon);
                TimeSeries series = ChartDataSets.createAnalysePositionenSeries(list, p + ", " + ka, einheit.toString());
                col.addSeries(series);
            }
        }
    }

    private JDateChooser getVonDateChooser() {
        if (this.vonDateChooser == null) {
            this.vonDateChooser = new JDateChooser("dd.MM.yy", false);
        }
        return this.vonDateChooser;
    }

    private JDateChooser getBisDateChooser() {
        if (this.bisDateChooser == null) {
            this.bisDateChooser = new JDateChooser("dd.MM.yy", false);
        }
        return this.bisDateChooser;
    }

    private JCheckBox getBrakeCheck() {
        if (this.brakeCheck == null) {
            this.brakeCheck = new JCheckBox("Brake");
        }
        return this.brakeCheck;
    }

    private JCheckBox getHeepenCheck() {
        if (this.heepenCheck == null) {
            this.heepenCheck = new JCheckBox("Heepen", true);
        }
        return this.heepenCheck;
    }

    private JCheckBox getOlutterCheck() {
        if (this.olutterCheck == null) {
            this.olutterCheck = new JCheckBox("Obere Lutter");
        }
        return this.olutterCheck;
    }

    private JCheckBox getSennestCheck() {
        if (this.sennestCheck == null) {
            this.sennestCheck = new JCheckBox("Sennestadt");
        }
        return this.sennestCheck;
    }

    private JCheckBox getVerlCheck() {
        if (this.verlCheck == null) {
            this.verlCheck = new JCheckBox("Verl-Sende");
        }
        return this.verlCheck;
    }

    private JComboBox getArtBox() {
        if (this.artBox == null) {
            AtlProbeart[] arten = new AtlProbeart[]{AtlProbeart.getProbeart(AtlProbeart.ROHSCHLAMM), AtlProbeart.getProbeart(AtlProbeart.FAULSCHLAMM), AtlProbeart.getProbeart(AtlProbeart.ANLIEFERUNG), AtlProbeart.getProbeart(AtlProbeart.ZULAUF)};
            this.artBox = new JComboBox<AtlProbeart>(arten);
            this.artBox.setPrototypeDisplayValue("Faulschlamm   abc");
        }
        return this.artBox;
    }

    private JButton getSubmitButton() {
        if (this.submitButton == null) {
            this.submitButton = new JButton("Abschicken");
            this.submitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (KlaerschlammAuswertung.this.getRightList().getModel().getSize() == 0) {
                        KlaerschlammAuswertung.this.showResultOneAxis(KlaerschlammAuswertung.LEFT);
                    } else if (KlaerschlammAuswertung.this.getLeftList().getModel().getSize() == 0) {
                        KlaerschlammAuswertung.this.showResultOneAxis(KlaerschlammAuswertung.RIGHT);
                    } else {
                        KlaerschlammAuswertung.this.showResultDualAxis();
                    }
                }
            });
        }
        return this.submitButton;
    }

    private JPanel getParameterPanel() {
        if (this.parameterPanel == null) {
            String zeileLuecke = "pref, 3dlu";
            FormLayout parameterLayout = new FormLayout("l:p:g, 10dlu:g(0.3), r:16px, 5dlu, c:70dlu:g(0.1), 5dlu, l:16px, 10dlu:g(0.3), r:p:g", zeileLuecke + ", " + zeileLuecke + ", " + zeileLuecke + ", " + zeileLuecke + ", " + zeileLuecke + ", " + zeileLuecke + ", " + zeileLuecke + ", " + zeileLuecke + ", " + zeileLuecke + ", " + zeileLuecke + ", " + zeileLuecke + ", " + "pref");
            parameterLayout.setColumnGroups((int[][])new int[][]{{1, 9}, {3, 7}});
            parameterLayout.setRowGroups((int[][])new int[][]{{3, 5}});
            PanelBuilder builder = new PanelBuilder(parameterLayout);
            CellConstraints cc = new CellConstraints();
            builder.add((Component)new JLabel("Erste Y-Achse"), cc.xy(1, 1));
            builder.add((Component)new JLabel("Zweite Y-Achse"), cc.xy(9, 1));
            JList lList = this.getLeftList();
            JList rList = this.getRightList();
            builder.add((Component)new JScrollPane(lList), cc.xywh(1, 3, 1, 15, "fill, fill"));
            builder.add((Component)new JScrollPane(rList), cc.xywh(9, 3, 1, 15, "fill, fill"));
            builder.add((Component)this.createRLButton(true, "L11650"), cc.xy(3, 3));
            builder.add((Component)new JLabel("Cadmium (Cd)", 0), cc.xy(5, 3, "f,d"));
            builder.add((Component)this.createRLButton(false, "L11650"), cc.xy(7, 3));
            builder.add((Component)this.createRLButton(true, "L11510"), cc.xy(3, 5));
            builder.add((Component)new JLabel("Chrom (Cr)", 0), cc.xy(5, 5, "f,d"));
            builder.add((Component)this.createRLButton(false, "L11510"), cc.xy(7, 5));
            builder.add((Component)this.createRLButton(true, "L11610"), cc.xy(3, 7));
            builder.add((Component)new JLabel("Kupfer (Cu)", 0), cc.xy(5, 7, "f,d"));
            builder.add((Component)this.createRLButton(false, "L11610"), cc.xy(7, 7));
            builder.add((Component)this.createRLButton(true, "L11660"), cc.xy(3, 9));
            builder.add((Component)new JLabel("Quecksilber (Hg)", 0), cc.xy(5, 9, "f,d"));
            builder.add((Component)this.createRLButton(false, "L11660"), cc.xy(7, 9));
            builder.add((Component)this.createRLButton(true, "L11880"), cc.xy(3, 11));
            builder.add((Component)new JLabel("Nickel (Ni)", 0), cc.xy(5, 11, "f,d"));
            builder.add((Component)this.createRLButton(false, "L11880"), cc.xy(7, 11));
            builder.add((Component)this.createRLButton(true, "L11380"), cc.xy(3, 13));
            builder.add((Component)new JLabel("Blei (Pb)", 0), cc.xy(5, 13, "f,d"));
            builder.add((Component)this.createRLButton(false, "L11380"), cc.xy(7, 13));
            builder.add((Component)this.createRLButton(true, "L11640"), cc.xy(3, 15));
            builder.add((Component)new JLabel("Zink (Zn)", 0), cc.xy(5, 15, "f,d"));
            builder.add((Component)this.createRLButton(false, "L11640"), cc.xy(7, 15));
            builder.add((Component)this.createRLButton(true, "box"), cc.xy(3, 17));
            builder.add((Component)this.getParameterBox(), cc.xy(5, 17, "f,d"));
            builder.add((Component)this.createRLButton(false, "box"), cc.xy(7, 17));
            builder.add((Component)this.getLeftDeleteButton(), cc.xy(1, 19, "c,d"));
            builder.add((Component)this.getRightDeleteButton(), cc.xy(9, 19, "c,d"));
            builder.add((Component)this.getLeftEinheitenBox(), cc.xy(1, 21, "c,d"));
            builder.add((Component)new JLabel("<  Einheit  >", 0), cc.xy(5, 21, "f,d"));
            builder.add((Component)this.getRightEinheitenBox(), cc.xy(9, 21, "c,d"));
            builder.add((Component)this.getLeftAnalyseFeld(), cc.xy(1, 23, "c,d"));
            builder.add((Component)new JLabel("<  Analyse von  >", 0), cc.xy(5, 23, "f,d"));
            builder.add((Component)this.getRightAnalyseFeld(), cc.xy(9, 23, "c,d"));
            this.parameterPanel = builder.getPanel();
        }
        return this.parameterPanel;
    }

    private JList getRightList() {
        if (this.rightList == null) {
            DefaultListModel listModel = new DefaultListModel();
            this.rightList = new JList(listModel);
            this.rightList.setPrototypeCellValue("Abcdefghij (Ab)");
            this.rightList.setSelectionMode(0);
        }
        return this.rightList;
    }

    private JList getLeftList() {
        if (this.leftList == null) {
            DefaultListModel listModel = new DefaultListModel();
            this.leftList = new JList(listModel);
            this.leftList.setPrototypeCellValue("Abcdefghij (Ab)");
            this.leftList.setSelectionMode(0);
        }
        return this.leftList;
    }

    private JComboBox getParameterBox() {
        if (this.parameterBox == null) {
            this.parameterBox = new SearchBox(AtlParameter.getRelevanteParameter());
        }
        return this.parameterBox;
    }

    private JButton getLeftDeleteButton() {
        if (this.leftDeleteButton == null) {
            this.leftDeleteButton = new JButton("L\u00f6schen");
            this.leftDeleteButton.setEnabled(false);
            this.leftDeleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = KlaerschlammAuswertung.this.getLeftList().getSelectedIndex();
                    DefaultListModel leftModel = (DefaultListModel)KlaerschlammAuswertung.this.getLeftList().getModel();
                    if (index != -1) {
                        leftModel.remove(index);
                        int size = leftModel.getSize();
                        if (size == 0) {
                            KlaerschlammAuswertung.this.leftDeleteButton.setEnabled(false);
                        } else {
                            if (index == size) {
                                --index;
                            }
                            KlaerschlammAuswertung.this.getLeftList().setSelectedIndex(index);
                            KlaerschlammAuswertung.this.getLeftList().ensureIndexIsVisible(index);
                        }
                    }
                }
            });
        }
        return this.leftDeleteButton;
    }

    private JButton getRightDeleteButton() {
        if (this.rightDeleteButton == null) {
            this.rightDeleteButton = new JButton("L\u00f6schen");
            this.rightDeleteButton.setEnabled(false);
            this.rightDeleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = KlaerschlammAuswertung.this.getRightList().getSelectedIndex();
                    DefaultListModel rightModel = (DefaultListModel)KlaerschlammAuswertung.this.getRightList().getModel();
                    if (index != -1) {
                        rightModel.remove(index);
                        int size = rightModel.getSize();
                        if (size == 0) {
                            KlaerschlammAuswertung.this.rightDeleteButton.setEnabled(false);
                        } else {
                            if (index == size) {
                                --index;
                            }
                            KlaerschlammAuswertung.this.getRightList().setSelectedIndex(index);
                            KlaerschlammAuswertung.this.getRightList().ensureIndexIsVisible(index);
                        }
                    }
                }
            });
        }
        return this.rightDeleteButton;
    }

    private JComboBox getLeftEinheitenBox() {
        if (this.leftEinheitenBox == null) {
            this.leftEinheitenBox = new SearchBox(this.einheiten);
            this.leftEinheitenBox.setSelectedItem(AtlEinheiten.getEinheit(AtlEinheiten.MG_KG_ID));
        }
        return this.leftEinheitenBox;
    }

    private JComboBox getRightEinheitenBox() {
        if (this.rightEinheitenBox == null) {
            this.rightEinheitenBox = new SearchBox(this.einheiten);
            this.rightEinheitenBox.setSelectedItem(AtlEinheiten.getEinheit(AtlEinheiten.MG_KG_ID));
        }
        return this.rightEinheitenBox;
    }

    private JTextField getLeftAnalyseFeld() {
        if (this.leftAnalyseFeld == null) {
            this.leftAnalyseFeld = new JTextField("");
            this.leftAnalyseFeld.setPreferredSize(this.getLeftEinheitenBox().getPreferredSize());
        }
        return this.leftAnalyseFeld;
    }

    private JTextField getRightAnalyseFeld() {
        if (this.rightAnalyseFeld == null) {
            this.rightAnalyseFeld = new JTextField("");
            this.rightAnalyseFeld.setPreferredSize(this.getRightEinheitenBox().getPreferredSize());
        }
        return this.rightAnalyseFeld;
    }

    private JButton createRLButton(boolean left, String paramId) {
        String direction;
        Icon rIcon;
        Icon icon;
        if (left) {
            icon = AuikUtils.getIcon(16, "left.png");
            rIcon = AuikUtils.getIcon(16, "left_a.png");
            direction = LEFT;
        } else {
            icon = AuikUtils.getIcon(16, "right.png");
            rIcon = AuikUtils.getIcon(16, "right_a.png");
            direction = RIGHT;
        }
        JButton button = new JButton(icon);
        button.setRolloverIcon(rIcon);
        button.setBorderPainted(false);
        button.setFocusPainted(false);
        button.setActionCommand(direction + "_" + paramId);
        button.addActionListener(this.getRLButtonListener());
        return button;
    }

    private ActionListener getRLButtonListener() {
        if (this.rlButtonListener == null) {
            this.rlButtonListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String direction = e.getActionCommand().replaceFirst("_.*", "");
                    String paramId = e.getActionCommand().replaceFirst(".*_", "");
                    AtlParameter param = null;
                    if (!paramId.equals("")) {
                        param = paramId.equals("box") ? (AtlParameter)KlaerschlammAuswertung.this.getParameterBox().getSelectedItem() : AtlParameter.getParameter(paramId);
                    }
                    if (param != null) {
                        DefaultListModel leftModel = (DefaultListModel)KlaerschlammAuswertung.this.getLeftList().getModel();
                        DefaultListModel rightModel = (DefaultListModel)KlaerschlammAuswertung.this.getRightList().getModel();
                        if (direction.equals(KlaerschlammAuswertung.LEFT)) {
                            if (!leftModel.contains(param)) {
                                if (rightModel.contains(param)) {
                                    rightModel.removeElement(param);
                                    if (rightModel.getSize() == 0) {
                                        KlaerschlammAuswertung.this.getRightDeleteButton().setEnabled(false);
                                    }
                                }
                                leftModel.addElement(param);
                                KlaerschlammAuswertung.this.getLeftDeleteButton().setEnabled(true);
                            }
                        } else if (direction.equals(KlaerschlammAuswertung.RIGHT) && !rightModel.contains(param)) {
                            if (leftModel.contains(param)) {
                                leftModel.removeElement(param);
                                if (leftModel.getSize() == 0) {
                                    KlaerschlammAuswertung.this.getLeftDeleteButton().setEnabled(false);
                                }
                            }
                            rightModel.addElement(param);
                            KlaerschlammAuswertung.this.getRightDeleteButton().setEnabled(true);
                        }
                    }
                }
            };
        }
        return this.rlButtonListener;
    }

    private class AuswertungsDialog
    extends JDialog {
        private JButton speichernButton;
        private JButton abbrechenButton;
        private JTable exportTable;
        private JPopupMenu tabellenMenu;
        private JTabbedPane tabbedPane;
        private ChartPanel chartPanel;
        private HauptFrame owner;
        private DialogListener listener;
        private String title;
        private TimeSeriesCollection leftDataset;
        private TimeSeriesCollection rightDataset;

        public AuswertungsDialog(String title, TimeSeriesCollection leftDataset, TimeSeriesCollection rightDataset, HauptFrame owner) {
            super(owner, title + "-Auswertung", true);
            this.owner = owner;
            this.title = title;
            this.leftDataset = leftDataset;
            this.rightDataset = rightDataset;
            this.listener = new DialogListener();
            this.setDefaultCloseOperation(0);
            this.addWindowListener(this.listener);
            this.speichernButton = new JButton("Speichern");
            this.speichernButton.addActionListener(this.listener);
            this.abbrechenButton = new JButton("Schlie\u00dfen");
            this.abbrechenButton.addActionListener(this.listener);
            JPanel tmp = new JPanel(new BorderLayout(0, 7));
            tmp.add((Component)this.initializeContent(), "Center");
            JPanel buttonBar = ButtonBarFactory.buildOKCancelBar((JButton)this.speichernButton, (JButton)this.abbrechenButton);
            tmp.add((Component)buttonBar, "South");
            tmp.setBorder(Borders.TABBED_DIALOG_BORDER);
            this.setContentPane(tmp);
            this.pack();
            this.setLocationRelativeTo(owner);
        }

        private JComponent initializeContent() {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.addTab("Diagramm", this.createDiagrammPanel());
            this.tabbedPane.addTab("Tabelle", this.createTabellenPanel());
            return this.tabbedPane;
        }

        private JPanel createDiagrammPanel() {
            JFreeChart chart = this.rightDataset == null ? Charts.createDefaultTimeSeriesChart(this.title, this.leftDataset) : Charts.createDefaultTimeSeriesChart(this.title, this.leftDataset, this.rightDataset);
            this.chartPanel = new ChartPanel(chart, false);
            this.chartPanel.setBorder(Borders.DIALOG_BORDER);
            return this.chartPanel;
        }

        private JComponent createTabellenPanel() {
            this.exportTable = new JTable(new ExportTableModel(this.leftDataset, this.rightDataset));
            this.exportTable.setBorder(BorderFactory.createBevelBorder(0));
            this.exportTable.setColumnSelectionAllowed(true);
            this.exportTable.setRowSelectionAllowed(true);
            this.exportTable.setAutoResizeMode(0);
            this.exportTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    AuswertungsDialog.this.showTabellenPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    AuswertungsDialog.this.showTabellenPopup(e);
                }
            });
            DefaultTableCellRenderer zentrierterRenderer = new DefaultTableCellRenderer();
            zentrierterRenderer.setHorizontalAlignment(0);
            DefaultTableCellRenderer rechtsBuendigRenderer = new DefaultTableCellRenderer();
            rechtsBuendigRenderer.setHorizontalAlignment(4);
            TableColumn column = null;
            for (int i = 0; i < this.exportTable.getColumnCount(); ++i) {
                column = this.exportTable.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setCellRenderer(zentrierterRenderer);
                    column.setPreferredWidth(75);
                    continue;
                }
                column.setCellRenderer(rechtsBuendigRenderer);
                column.setPreferredWidth(90);
            }
            JScrollPane tabellenScroller = new JScrollPane(this.exportTable, 20, 32);
            tabellenScroller.setBorder(Borders.DIALOG_BORDER);
            return tabellenScroller;
        }

        public void saveTabelle() {
            File exportDatei = this.owner.saveFile(new String[]{"csv"});
            if (exportDatei != null) {
                String ext = AuikUtils.getExtension(exportDatei);
                if (ext == null) {
                    String newExt = exportDatei.getName().endsWith(".") ? "csv" : ".csv";
                    exportDatei = new File(exportDatei.getParent(), exportDatei.getName() + newExt);
                }
                boolean doIt = false;
                if (exportDatei.exists()) {
                    boolean answer = this.owner.showQuestion("Soll die vorhandene Datei " + exportDatei.getName() + " wirklich \u00fcberschrieben werden?", "Datei bereits vorhanden!");
                    if (answer && exportDatei.canWrite()) {
                        doIt = true;
                    }
                } else if (exportDatei.getParentFile().canWrite()) {
                    doIt = true;
                }
                if (doIt) {
                    AUIKataster.debugOutput("Speichere nach '" + exportDatei.getName() + "' (Ext: '" + ext + "') in '" + exportDatei.getParent() + "' !");
                    if (AuikUtils.exportTableDataToCVS(this.exportTable, exportDatei)) {
                        AUIKataster.debugOutput("Speichern erfolgreich!");
                    } else {
                        AUIKataster.debugOutput("Fehler beim Speichern!");
                        this.owner.showErrorMessage("Beim Speichern der Datei '" + exportDatei + "' trat ein Fehler auf!");
                    }
                }
            }
        }

        private void showTabellenPopup(MouseEvent e) {
            if (this.tabellenMenu == null) {
                this.tabellenMenu = new JPopupMenu("Tabelle");
                JMenuItem speichernItem = new JMenuItem(new AbstractAction("Speichern"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AuswertungsDialog.this.saveTabelle();
                    }
                });
                this.tabellenMenu.add(speichernItem);
            }
            if (e.isPopupTrigger()) {
                Point origin = e.getPoint();
                int row = this.exportTable.rowAtPoint(origin);
                int col = this.exportTable.columnAtPoint(origin);
                if (row != -1) {
                    this.exportTable.setRowSelectionInterval(row, row);
                    this.exportTable.setColumnSelectionInterval(col, col);
                    this.tabellenMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }

        public void doAbbrechen() {
            this.dispose();
        }

        public void doSpeichern() {
            if (this.tabbedPane.getSelectedIndex() == 0) {
                try {
                    this.chartPanel.doSaveAs();
                }
                catch (IOException e) {
                    this.owner.showErrorMessage("Konnte Datei nicht speichern!");
                }
            } else if (this.tabbedPane.getSelectedIndex() == 1) {
                this.saveTabelle();
            }
        }

        private class ExportTableModel
        extends AbstractTableModel {
            private TimeSeriesCollection col1;
            private TimeSeriesCollection col2;
            private List dateList;

            public ExportTableModel(TimeSeriesCollection col1, TimeSeriesCollection col2) {
                this.col1 = col1;
                this.col2 = col2;
                this.dateList = new ArrayList();
                this.initializeData();
            }

            private void initializeData() {
                APosDataItem item;
                int j;
                TimeSeries series;
                int i;
                for (i = 0; i < this.col1.getSeriesCount(); ++i) {
                    series = this.col1.getSeries(i);
                    for (j = 0; j < series.getItemCount(); ++j) {
                        item = (APosDataItem)series.getDataItem(j);
                        if (this.dateList.contains(item.getMinute())) continue;
                        this.dateList.add(item.getMinute());
                    }
                }
                if (this.col2 != null) {
                    for (i = 0; i < this.col2.getSeriesCount(); ++i) {
                        series = this.col2.getSeries(i);
                        for (j = 0; j < series.getItemCount(); ++j) {
                            item = (APosDataItem)series.getDataItem(j);
                            if (this.dateList.contains(item.getMinute())) continue;
                            this.dateList.add(item.getMinute());
                        }
                    }
                }
                Collections.sort(this.dateList);
            }

            @Override
            public int getColumnCount() {
                return this.col1.getSeriesCount() + (this.col2 != null ? this.col2.getSeriesCount() : 0) + 1;
            }

            @Override
            public int getRowCount() {
                return this.dateList.size();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                String tmp = "!OOB!";
                NumberFormat kommaFormat = NumberFormat.getNumberInstance();
                kommaFormat.setGroupingUsed(false);
                kommaFormat.setMinimumFractionDigits(1);
                int seriesIndex = columnIndex - 1;
                int series2Index = seriesIndex - this.col1.getSeriesCount();
                int itemIndex = rowIndex;
                Minute min = (Minute)this.dateList.get(itemIndex);
                if (columnIndex == 0) {
                    Date date = new Date(min.getFirstMillisecond());
                    tmp = AuikUtils.getStringFromDate(date);
                } else {
                    APosDataItem item = null;
                    if (seriesIndex < this.col1.getSeriesCount()) {
                        item = (APosDataItem)this.col1.getSeries(seriesIndex).getDataItem((RegularTimePeriod)min);
                    } else if (this.col2 != null) {
                        item = (APosDataItem)this.col2.getSeries(series2Index).getDataItem((RegularTimePeriod)min);
                    }
                    tmp = item != null ? kommaFormat.format(item.getValue()) : "";
                }
                return tmp;
            }

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public String getColumnName(int column) {
                String tmp = "!OOB!";
                int seriesIndex = column - 1;
                int series2Index = seriesIndex - this.col1.getSeriesCount();
                if (column == 0) {
                    tmp = "Datum";
                } else if (seriesIndex < this.col1.getSeriesCount()) {
                    tmp = this.col1.getSeriesName(seriesIndex) + ", " + this.col1.getSeries(seriesIndex).getRangeDescription();
                } else if (this.col2 != null) {
                    tmp = this.col2.getSeriesName(series2Index) + ", " + this.col2.getSeries(series2Index).getRangeDescription();
                }
                return tmp;
            }
        }

        private class DialogListener
        extends WindowAdapter
        implements ActionListener {
            private DialogListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == AuswertungsDialog.this.abbrechenButton) {
                    AuswertungsDialog.this.doAbbrechen();
                } else if (e.getSource() == AuswertungsDialog.this.speichernButton) {
                    AuswertungsDialog.this.doSpeichern();
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                AuswertungsDialog.this.doAbbrechen();
            }
        }
    }
}

