/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.mappings.indeinl.ViewBwk;
import de.bielefeld.umweltamt.aui.module.common.AbstractQueryModul;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.AnhBwkModel;
import de.bielefeld.umweltamt.aui.utils.SwingWorkerVariant;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.ListTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class EinleiterBrennwertAuswertung
extends AbstractQueryModul {
    private JPanel queryPanel;
    private JComboBox jahrBox;
    private JButton submitButton;
    private AnhBwkModel tmodel;

    @Override
    public String getName() {
        return "BWK";
    }

    @Override
    public JPanel getQueryOptionsPanel() {
        if (this.queryPanel == null) {
            int range = 15;
            Calendar cal = Calendar.getInstance();
            int thisYear = cal.get(1);
            String[] years = new String[2 * range + 1];
            for (int i = 0; i < years.length; ++i) {
                int y = thisYear + (i - range);
                years[i] = Integer.toString(y);
            }
            this.jahrBox = new JComboBox<String>(years);
            this.jahrBox.setSelectedItem(Integer.toString(thisYear));
            this.jahrBox.setEditable(true);
            this.submitButton = new JButton("Suchen");
            this.submitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int jahrTMP;
                    try {
                        jahrTMP = Integer.parseInt((String)EinleiterBrennwertAuswertung.this.jahrBox.getSelectedItem());
                    }
                    catch (NumberFormatException e1) {
                        jahrTMP = -1;
                    }
                    final int jahr = jahrTMP;
                    SwingWorkerVariant worker = new SwingWorkerVariant(EinleiterBrennwertAuswertung.this.getResultTable()){

                        @Override
                        protected void doNonUILogic() {
                            ((AnhBwkModel)EinleiterBrennwertAuswertung.this.getTableModel()).setList(ViewBwk.findByErfassungsjahr(jahr));
                        }

                        @Override
                        protected void doUIUpdateLogic() {
                            ((AnhBwkModel)EinleiterBrennwertAuswertung.this.getTableModel()).fireTableDataChanged();
                            EinleiterBrennwertAuswertung.this.frame.changeStatus("" + EinleiterBrennwertAuswertung.this.getTableModel().getRowCount() + " Objekte gefunden");
                        }
                    };
                    worker.start();
                }
            });
            FormLayout layout = new FormLayout("pref, 3dlu, pref, 3dlu, pref");
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.append("Erfassungsjahr:", (Component)this.jahrBox, (Component)this.submitButton);
            this.queryPanel = builder.getPanel();
        }
        return this.queryPanel;
    }

    @Override
    public ListTableModel getTableModel() {
        if (this.tmodel == null) {
            this.tmodel = new AnhBwkModel();
        }
        return this.tmodel;
    }
}

