/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.mappings.indeinl.Anh49Fachdaten;
import de.bielefeld.umweltamt.aui.module.common.AbstractQueryModul;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.Anh49Model;
import de.bielefeld.umweltamt.aui.utils.IntegerField;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.ListTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EinleiterAnh49Auswertung
extends AbstractQueryModul {
    private JPanel queryPanel;
    private JTextField sachbFeld;
    private IntegerField dekraTuevFeld;
    private JCheckBox abgemeldetCheck;
    private JCheckBox abgerissenCheck;
    private JCheckBox abwasserfreiCheck;
    private JCheckBox wiedervorlageCheck;
    private JButton submitButton;
    private JButton tuevButton;
    private JButton sachbearbeiterButton;
    private JButton alleButton;
    private Anh49Model tmodel;

    @Override
    public String getName() {
        return "Anhang 49";
    }

    @Override
    public String getIdentifier() {
        return "m_auswertung_anh49";
    }

    @Override
    public JPanel getQueryOptionsPanel() {
        if (this.queryPanel == null) {
            this.sachbFeld = new JTextField("", 12);
            this.dekraTuevFeld = new IntegerField();
            this.abgemeldetCheck = new JCheckBox("Abgemeldet");
            this.abgerissenCheck = new JCheckBox("Abgerissen");
            this.abwasserfreiCheck = new JCheckBox("Abwasserfrei");
            this.wiedervorlageCheck = new JCheckBox("Nur abgelaufene Wiedervorlage");
            this.submitButton = new JButton("Suchen");
            this.alleButton = new JButton("Alle anzeigen");
            this.tuevButton = new JButton("Suchen");
            this.tuevButton.setToolTipText("Tuev/Dekra suchen");
            this.sachbearbeiterButton = new JButton("Suchen");
            this.sachbearbeiterButton.setToolTipText("SachbearbeiterIn anzeigen");
            this.submitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean abgem = EinleiterAnh49Auswertung.this.abgemeldetCheck.isSelected();
                    String abgerissen = EinleiterAnh49Auswertung.this.abgerissenCheck.isSelected() ? "%abgerissen" : "";
                    boolean abwfrei = EinleiterAnh49Auswertung.this.abwasserfreiCheck.isSelected();
                    ((Anh49Model)EinleiterAnh49Auswertung.this.getTableModel()).setList(Anh49Fachdaten.findAuswertung(abgem, abgerissen, abwfrei, EinleiterAnh49Auswertung.this.wiedervorlageCheck.isSelected()));
                    ((Anh49Model)EinleiterAnh49Auswertung.this.getTableModel()).fireTableDataChanged();
                    EinleiterAnh49Auswertung.this.frame.changeStatus("" + EinleiterAnh49Auswertung.this.getTableModel().getRowCount() + " Objekte gefunden");
                }
            });
            this.alleButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((Anh49Model)EinleiterAnh49Auswertung.this.getTableModel()).setList(Anh49Fachdaten.findAlle());
                    ((Anh49Model)EinleiterAnh49Auswertung.this.getTableModel()).fireTableDataChanged();
                    EinleiterAnh49Auswertung.this.frame.changeStatus("" + EinleiterAnh49Auswertung.this.getTableModel().getRowCount() + " Objekte gefunden");
                }
            });
            this.tuevButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Integer tuev = EinleiterAnh49Auswertung.this.dekraTuevFeld.getIntValue();
                    ((Anh49Model)EinleiterAnh49Auswertung.this.getTableModel()).setList(Anh49Fachdaten.findTuev(tuev));
                    ((Anh49Model)EinleiterAnh49Auswertung.this.getTableModel()).fireTableDataChanged();
                    EinleiterAnh49Auswertung.this.frame.changeStatus("" + EinleiterAnh49Auswertung.this.getTableModel().getRowCount() + " Objekte gefunden");
                }
            });
            this.sachbearbeiterButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String sachbearb = EinleiterAnh49Auswertung.this.sachbFeld.getText();
                    ((Anh49Model)EinleiterAnh49Auswertung.this.getTableModel()).setList(Anh49Fachdaten.findSachbearbeiter(sachbearb));
                    ((Anh49Model)EinleiterAnh49Auswertung.this.getTableModel()).fireTableDataChanged();
                    EinleiterAnh49Auswertung.this.frame.changeStatus("" + EinleiterAnh49Auswertung.this.getTableModel().getRowCount() + " Objekte gefunden");
                }
            });
            FormLayout layout = new FormLayout("pref, 3dlu, pref, 3dlu, pref, 20dlu, pref, 3dlu, pref, 3dlu, pref, 20dlu, pref");
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.append((Component)this.abgemeldetCheck, (Component)this.abwasserfreiCheck);
            builder.append((Component)this.abgerissenCheck);
            builder.append("SachbearbeiterIn:", (Component)this.sachbFeld, (Component)this.sachbearbeiterButton);
            builder.nextLine();
            builder.append((Component)this.wiedervorlageCheck);
            builder.append("");
            builder.append((Component)this.submitButton);
            builder.append("Dekra-T\u00dcV-T.:", (Component)this.dekraTuevFeld, (Component)this.tuevButton, (Component)this.alleButton);
            this.queryPanel = builder.getPanel();
        }
        return this.queryPanel;
    }

    @Override
    public ListTableModel getTableModel() {
        if (this.tmodel == null) {
            this.tmodel = new Anh49Model();
        }
        return this.tmodel;
    }
}

