/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.uif_lite.component.Factory;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.AbstractModul;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.ReportManager;
import de.bielefeld.umweltamt.aui.SettingsManager;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjekt;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisStandort;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisStrassen;
import de.bielefeld.umweltamt.aui.module.common.editors.StandortEditor;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.BasisObjektModel;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.BasisStandortModel;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.BasicEntryField;
import de.bielefeld.umweltamt.aui.utils.SwingWorkerVariant;
import de.bielefeld.umweltamt.aui.utils.TabAction;
import de.bielefeld.umweltamt.aui.utils.TableFocusListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import org.eclipse.birt.report.engine.api.EngineException;

public class BasisStandortSuchen
extends AbstractModul {
    private JTextField strassenFeld;
    private JTextField hausnrFeld;
    private JButton submitButton;
    private JButton dreiButton;
    private JButton vierButton;
    private JButton probepktButton;
    private JTable standortTabelle;
    private JTable objektTabelle;
    private JSplitPane tabellenSplit;
    private Action standortEditAction;
    private Action objektNeuAction;
    private JPopupMenu standortPopup;
    private Action objektEditAction;
    private Action objektLoeschAction;
    private Action gisAction;
    private JPopupMenu objektPopup;
    private BasisStandortModel standortModel;
    private BasisObjektModel objektModel;
    private BasisStandort lastStandort;
    private Timer suchTimer;
    private JButton reportStandortListeButton;
    protected String betreiber;
    protected String standort;
    protected int standortID;

    @Override
    public String getName() {
        return "Standort suchen";
    }

    @Override
    public String getIdentifier() {
        return "m_standort_suchen";
    }

    @Override
    public String getCategory() {
        return "Betriebe";
    }

    @Override
    public Icon getIcon() {
        return super.getIcon("filefind32.png");
    }

    @Override
    public JPanel getPanel() {
        if (this.panel == null) {
            this.standortModel = new BasisStandortModel();
            this.objektModel = new BasisObjektModel("Betreiber", this.manager.getSettingsManager().getSetting("auik.prefs.abteilungsfilter"));
            TableFocusListener tfl = TableFocusListener.getInstance();
            this.getStandortTabelle().addFocusListener(tfl);
            this.getObjektTabelle().addFocusListener(tfl);
            JScrollPane standortScroller = new JScrollPane(this.getStandortTabelle(), 20, 31);
            JScrollPane objektScroller = new JScrollPane(this.getObjektTabelle(), 20, 31);
            JToolBar submitToolBar = new JToolBar();
            submitToolBar.setFloatable(false);
            submitToolBar.setRollover(true);
            submitToolBar.add(this.getSubmitButton());
            JPanel restrictPanel = new JPanel(new BorderLayout());
            JPanel restrictButtonBar = ButtonBarFactory.buildLeftAlignedBar((JButton)this.getDreiButton(), (JButton)this.getVierButton(), (JButton)this.getProbepktButton());
            JPanel restrictButtonBar2 = ButtonBarFactory.buildRightAlignedBar((JButton)this.getReportListeButton());
            restrictPanel.add((Component)new Label("Objekte einschr\u00e4nken:"), "West");
            restrictPanel.add((Component)restrictButtonBar, "Center");
            restrictPanel.add((Component)restrictButtonBar2, "East");
            TabAction ta = new TabAction();
            ta.addComp(this.getStrassenFeld());
            ta.addComp(this.getHausnrFeld());
            ta.addComp(this.getStandortTabelle());
            ta.addComp(this.getObjektTabelle());
            this.tabellenSplit = Factory.createStrippedSplitPane(0, standortScroller, objektScroller, 0.6);
            FormLayout layout = new FormLayout("l:p, 4dlu, p:g, 10dlu, p, 4dlu, max(30dlu;p), 3dlu, min(16dlu;p)", "pref, 3dlu, 150dlu:grow, 3dlu, 30");
            layout.setColumnGroups((int[][])new int[][]{{1, 5}});
            PanelBuilder builder = new PanelBuilder(layout);
            builder.setDefaultDialogBorder();
            CellConstraints cc = new CellConstraints();
            builder.addLabel("Stra\u00dfe:", cc.xy(1, 1));
            builder.add((Component)this.getStrassenFeld(), cc.xy(3, 1));
            builder.addLabel("Haus-Nr.:", cc.xy(5, 1));
            builder.add((Component)this.getHausnrFeld(), cc.xy(7, 1));
            builder.add((Component)submitToolBar, cc.xy(9, 1));
            builder.add((Component)this.tabellenSplit, cc.xyw(1, 3, 9));
            builder.add((Component)restrictPanel, cc.xyw(1, 5, 9));
            this.panel = builder.getPanel();
        }
        return this.panel;
    }

    @Override
    public void show() {
        super.show();
        if (SettingsManager.getInstance().getSetting("auik.prefs.divloc_standort") != null) {
            double divloc = Double.parseDouble(SettingsManager.getInstance().getSetting("auik.prefs.divloc_standort"));
            this.tabellenSplit.setDividerLocation(divloc);
        }
        this.lastStandort = null;
        this.updateStandortListe();
    }

    @Override
    public void hide() {
        double divloc;
        super.hide();
        if (this.suchTimer != null) {
            this.getSuchTimer().stop();
        }
        if (this.tabellenSplit != null && this.tabellenSplit.getDividerLocation() != -1 && (divloc = (double)((float)this.tabellenSplit.getDividerLocation() / (float)this.tabellenSplit.getHeight())) >= 0.0 && divloc <= 1.0) {
            SettingsManager.getInstance().setSetting("auik.prefs.divloc_standort", Double.toString(divloc), true);
        }
    }

    public void updateStandortListe() {
        SwingWorkerVariant worker = new SwingWorkerVariant(this.getStrassenFeld()){

            @Override
            protected void doNonUILogic() {
                BasisStandortSuchen.this.standortModel.updateList();
            }

            @Override
            protected void doUIUpdateLogic() {
                BasisStandortSuchen.this.standortModel.fireTableDataChanged();
                if (BasisStandortSuchen.this.lastStandort != null) {
                    int row = BasisStandortSuchen.this.standortModel.getList().indexOf(BasisStandortSuchen.this.lastStandort);
                    if (row != -1) {
                        BasisStandortSuchen.this.getStandortTabelle().setRowSelectionInterval(row, row);
                        BasisStandortSuchen.this.getStandortTabelle().scrollRectToVisible(BasisStandortSuchen.this.getStandortTabelle().getCellRect(row, 0, true));
                        BasisStandortSuchen.this.getStandortTabelle().requestFocus();
                    }
                } else {
                    int standortCount = BasisStandortSuchen.this.standortModel.getRowCount();
                    if (standortCount > 0) {
                        String statusMsg = "Suche: " + standortCount + " Ergebnis";
                        if (standortCount != 1) {
                            statusMsg = statusMsg + "se";
                        }
                        statusMsg = statusMsg + ".";
                        BasisStandortSuchen.this.frame.changeStatus(statusMsg);
                    }
                }
                BasisStandortSuchen.this.updateObjekte();
            }
        };
        worker.start();
    }

    public void updateObjekte() {
        ListSelectionModel lsm = this.getStandortTabelle().getSelectionModel();
        if (!lsm.isSelectionEmpty()) {
            int selectedRow = lsm.getMinSelectionIndex();
            BasisStandort standort = this.standortModel.getRow(selectedRow);
            AUIKataster.debugOutput("Standort " + standort + " angew\u00e4hlt.", "BasisStandortSuchen.updateObjekte");
            this.searchObjekteByStandort(standort);
        }
    }

    public void editStandort(BasisStandort standort) {
        StandortEditor editDialog = null;
        editDialog = new StandortEditor(standort, this.frame);
        editDialog.setLocationRelativeTo(this.frame);
        editDialog.setVisible(true);
        this.lastStandort = standort;
        if (editDialog.wasSaved()) {
            this.updateStandortListe();
        }
    }

    public void searchObjekteByStandort(final BasisStandort standort, final String abteilung, final Integer nichtartid) {
        SwingWorkerVariant worker = new SwingWorkerVariant(this.getStandortTabelle()){

            @Override
            protected void doNonUILogic() {
                BasisStandortSuchen.this.objektModel.searchByStandort(standort, abteilung, nichtartid);
            }

            @Override
            protected void doUIUpdateLogic() {
                BasisStandortSuchen.this.objektModel.fireTableDataChanged();
            }
        };
        worker.start();
    }

    public void searchObjekteByStandort(final BasisStandort standort) {
        SwingWorkerVariant worker = new SwingWorkerVariant(this.getStandortTabelle()){

            @Override
            protected void doNonUILogic() {
                BasisStandortSuchen.this.objektModel.searchByStandort(standort);
            }

            @Override
            protected void doUIUpdateLogic() {
                BasisStandortSuchen.this.objektModel.fireTableDataChanged();
            }
        };
        worker.start();
    }

    public void searchObjekteByStandort(final BasisStandort standort, final Integer istartid) {
        SwingWorkerVariant worker = new SwingWorkerVariant(this.getStandortTabelle()){

            @Override
            protected void doNonUILogic() {
                BasisStandortSuchen.this.objektModel.searchByStandort(standort, istartid);
            }

            @Override
            protected void doUIUpdateLogic() {
                BasisStandortSuchen.this.objektModel.fireTableDataChanged();
            }
        };
        worker.start();
    }

    public void filterStandortListe(Component focusComp) {
        int hausnr;
        try {
            hausnr = Integer.parseInt(this.getHausnrFeld().getText());
        }
        catch (NumberFormatException e1) {
            hausnr = -1;
        }
        final int fhausnr = hausnr;
        SwingWorkerVariant worker = new SwingWorkerVariant(focusComp){

            @Override
            protected void doNonUILogic() {
                BasisStandortSuchen.this.standortModel.filterList(BasisStandortSuchen.this.getStrassenFeld().getText(), fhausnr);
            }

            @Override
            protected void doUIUpdateLogic() {
                BasisStandortSuchen.this.getStandortTabelle().clearSelection();
                BasisStandortSuchen.this.standortModel.fireTableDataChanged();
                String statusMsg = "Suche: " + BasisStandortSuchen.this.standortModel.getRowCount() + " Ergebnis";
                if (BasisStandortSuchen.this.standortModel.getRowCount() != 1) {
                    statusMsg = statusMsg + "se";
                }
                statusMsg = statusMsg + ".";
                BasisStandortSuchen.this.frame.changeStatus(statusMsg);
            }
        };
        this.frame.changeStatus("Suche...");
        worker.start();
    }

    public void showReportListe() throws EngineException {
        ListSelectionModel lsm = this.getStandortTabelle().getSelectionModel();
        int selectedRow = lsm.getMinSelectionIndex();
        BasisStandort standort = this.standortModel.getRow(selectedRow);
        String adresse = "" + standort;
        if (standort == null) {
            this.frame.changeStatus("Bitte einen Standort markieren");
        } else {
            this.frame.changeStatus("PDF-Datei wird erstellt");
        }
        this.standortID = standort.getStandortid();
        AUIKataster.debugOutput(adresse + " mit ID: " + this.standortID + " ausgewaehlt", "BasisStandortSuchen.showReportListe");
        ReportManager.getInstance().startReportWorker("VAwS-StandortListe", adresse, this.standortID, (Component)this.reportStandortListeButton);
    }

    private Timer getSuchTimer() {
        if (this.suchTimer == null) {
            this.suchTimer = new Timer(900, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingWorkerVariant worker = new SwingWorkerVariant(BasisStandortSuchen.this.getStrassenFeld()){
                        protected String oldText;
                        private String newText;
                        {
                            this.oldText = "";
                            this.newText = "";
                        }

                        @Override
                        protected void doNonUILogic() {
                            String suchText;
                            BasisStrassen str;
                            this.oldText = BasisStandortSuchen.this.getStrassenFeld().getText();
                            this.newText = this.oldText.equals("") ? "" : ((str = BasisStrassen.getStrasseByName(suchText = AuikUtils.sanitizeQueryInput(this.oldText))) != null ? str.getStrasse() : this.oldText);
                        }

                        @Override
                        protected void doUIUpdateLogic() {
                            BasisStandortSuchen.this.getStrassenFeld().setText(this.newText);
                            BasisStandortSuchen.this.getStrassenFeld().setSelectionStart(this.oldText.length());
                            BasisStandortSuchen.this.getStrassenFeld().setSelectionEnd(this.newText.length());
                        }
                    };
                    worker.start();
                }
            });
            this.suchTimer.setRepeats(false);
        }
        return this.suchTimer;
    }

    private JTextField getStrassenFeld() {
        if (this.strassenFeld == null) {
            this.strassenFeld = new JTextField("");
            this.strassenFeld.setFocusTraversalKeys(0, Collections.EMPTY_SET);
            this.strassenFeld.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasisStandortSuchen.this.getSuchTimer().stop();
                    BasisStandortSuchen.this.filterStandortListe(BasisStandortSuchen.this.getStandortTabelle());
                }
            });
            this.strassenFeld.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 9) {
                        BasisStandortSuchen.this.getSuchTimer().stop();
                        BasisStandortSuchen.this.filterStandortListe(BasisStandortSuchen.this.getHausnrFeld());
                    }
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    if (Character.isLetterOrDigit(e.getKeyChar())) {
                        if (BasisStandortSuchen.this.getSuchTimer().isRunning()) {
                            BasisStandortSuchen.this.getSuchTimer().restart();
                        } else {
                            BasisStandortSuchen.this.getSuchTimer().start();
                        }
                    }
                }
            });
        }
        return this.strassenFeld;
    }

    private JTextField getHausnrFeld() {
        if (this.hausnrFeld == null) {
            this.hausnrFeld = new BasicEntryField();
            this.hausnrFeld.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasisStandortSuchen.this.filterStandortListe(BasisStandortSuchen.this.getStandortTabelle());
                }
            });
        }
        return this.hausnrFeld;
    }

    private JButton getSubmitButton() {
        if (this.submitButton == null) {
            this.submitButton = new JButton(AuikUtils.getIcon(16, "key_enter.png"));
            this.submitButton.setToolTipText("Suche starten");
            this.submitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasisStandortSuchen.this.getSuchTimer().stop();
                    BasisStandortSuchen.this.filterStandortListe(BasisStandortSuchen.this.getStandortTabelle());
                }
            });
        }
        return this.submitButton;
    }

    private JButton getDreiButton() {
        if (this.dreiButton == null) {
            this.dreiButton = new JButton("360.33");
            this.dreiButton.setToolTipText("nur 33er Objekt");
            this.dreiButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ListSelectionModel lsm = BasisStandortSuchen.this.getStandortTabelle().getSelectionModel();
                    if (!lsm.isSelectionEmpty()) {
                        int selectedRow = lsm.getMinSelectionIndex();
                        BasisStandort standort = BasisStandortSuchen.this.standortModel.getRow(selectedRow);
                        AUIKataster.debugOutput("Standort " + standort + " angew\u00e4hlt.", "BasisStandortSuchen.updateObjekte");
                        BasisStandortSuchen.this.searchObjekteByStandort(standort, "360.33", 32);
                    }
                }
            });
        }
        return this.dreiButton;
    }

    private JButton getVierButton() {
        if (this.vierButton == null) {
            this.vierButton = new JButton("360.34");
            this.vierButton.setToolTipText("nur 34er Objekte");
            this.vierButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ListSelectionModel lsm = BasisStandortSuchen.this.getStandortTabelle().getSelectionModel();
                    if (!lsm.isSelectionEmpty()) {
                        int selectedRow = lsm.getMinSelectionIndex();
                        BasisStandort standort = BasisStandortSuchen.this.standortModel.getRow(selectedRow);
                        AUIKataster.debugOutput("Standort " + standort + " angew\u00e4hlt.", "BasisStandortSuchen.updateObjekte");
                        BasisStandortSuchen.this.searchObjekteByStandort(standort, "360.34", 32);
                    }
                }
            });
        }
        return this.vierButton;
    }

    private JButton getProbepktButton() {
        if (this.probepktButton == null) {
            this.probepktButton = new JButton("Probepunkte");
            this.probepktButton.setToolTipText("nur die Probenahmepunkte anzeigen");
            this.probepktButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ListSelectionModel lsm = BasisStandortSuchen.this.getStandortTabelle().getSelectionModel();
                    if (!lsm.isSelectionEmpty()) {
                        int selectedRow = lsm.getMinSelectionIndex();
                        BasisStandort standort = BasisStandortSuchen.this.standortModel.getRow(selectedRow);
                        AUIKataster.debugOutput("Standort " + standort + " angew\u00e4hlt.", "BasisStandortSuchen.updateObjekte");
                        BasisStandortSuchen.this.searchObjekteByStandort(standort, 32);
                    }
                }
            });
        }
        return this.probepktButton;
    }

    private JButton getReportListeButton() {
        if (this.reportStandortListeButton == null) {
            this.reportStandortListeButton = new JButton("PDF-Liste generieren");
            this.reportStandortListeButton.setToolTipText("Liste der VAwS-Objekte am Standort");
            this.reportStandortListeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        BasisStandortSuchen.this.showReportListe();
                    }
                    catch (EngineException e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }
        return this.reportStandortListeButton;
    }

    private JTable getStandortTabelle() {
        if (this.standortTabelle == null) {
            this.standortTabelle = new JTable(this.standortModel);
            ListSelectionModel rowSM = this.standortTabelle.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    BasisStandortSuchen.this.updateObjekte();
                }
            });
            this.standortTabelle.setAutoResizeMode(1);
            TableColumn column = null;
            for (int i = 0; i < this.standortModel.getColumnCount(); ++i) {
                column = this.standortTabelle.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(120);
                    continue;
                }
                if (i == 1) {
                    column.setPreferredWidth(80);
                    continue;
                }
                if (i != 2) continue;
                column.setPreferredWidth(200);
            }
            this.standortTabelle.setSelectionMode(0);
            this.standortTabelle.setColumnSelectionAllowed(false);
            this.standortTabelle.setRowSelectionAllowed(true);
            this.standortTabelle.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Point origin = e.getPoint();
                    int row = BasisStandortSuchen.this.standortTabelle.rowAtPoint(origin);
                    if (row != -1 && e.getButton() == 1 && e.getClickCount() == 2) {
                        BasisStandort bsta = BasisStandortSuchen.this.standortModel.getRow(row);
                        BasisStandortSuchen.this.editStandort(bsta);
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    BasisStandortSuchen.this.showStandortPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    BasisStandortSuchen.this.showStandortPopup(e);
                }
            });
            this.standortTabelle.getInputMap().put((KeyStroke)this.getStandortEditAction().getValue("AcceleratorKey"), this.getStandortEditAction().getValue("Name"));
            this.standortTabelle.getActionMap().put(this.getStandortEditAction().getValue("Name"), this.getStandortEditAction());
        }
        return this.standortTabelle;
    }

    private Action getStandortEditAction() {
        if (this.standortEditAction == null) {
            this.standortEditAction = new AbstractAction("Bearbeiten"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = BasisStandortSuchen.this.standortTabelle.getSelectedRow();
                    if (row != -1) {
                        BasisStandort bsta = BasisStandortSuchen.this.standortModel.getRow(row);
                        BasisStandortSuchen.this.editStandort(bsta);
                    }
                }
            };
            this.standortEditAction.putValue("MnemonicKey", new Integer(66));
            this.standortEditAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0, false));
        }
        return this.standortEditAction;
    }

    private Action getObjektNeuAction() {
        if (this.objektNeuAction == null) {
            this.objektNeuAction = new AbstractAction("Neues Objekt"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = BasisStandortSuchen.this.standortTabelle.getSelectedRow();
                    if (row != -1) {
                        BasisStandort bsta = BasisStandortSuchen.this.standortModel.getRow(row);
                        BasisStandortSuchen.this.manager.getSettingsManager().setSetting("auik.imc.use_standort", bsta.getStandortid(), false);
                        BasisStandortSuchen.this.manager.switchModul("m_objekt_bearbeiten");
                    }
                }
            };
            this.objektNeuAction.putValue("MnemonicKey", new Integer(79));
        }
        return this.objektNeuAction;
    }

    private void showStandortPopup(MouseEvent e) {
        Point origin;
        int row;
        if (this.standortPopup == null) {
            this.standortPopup = new JPopupMenu("Standort");
            JMenuItem bearbItem = new JMenuItem(this.getStandortEditAction());
            JMenuItem neuItem = new JMenuItem(this.getObjektNeuAction());
            JMenuItem gisItem = new JMenuItem(this.getGisAction());
            this.standortPopup.add(bearbItem);
            this.standortPopup.add(neuItem);
            this.standortPopup.add(gisItem);
        }
        if (e.isPopupTrigger() && (row = this.standortTabelle.rowAtPoint(origin = e.getPoint())) != -1) {
            this.standortTabelle.setRowSelectionInterval(row, row);
            this.standortPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private Action getObjektEditAction() {
        if (this.objektEditAction == null) {
            this.objektEditAction = new AbstractAction("Bearbeiten"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = BasisStandortSuchen.this.objektTabelle.getSelectedRow();
                    BasisObjekt obj = BasisStandortSuchen.this.objektModel.getRow(row);
                    if (row != -1 || obj.getBasisObjektarten().getObjektartid() != 40) {
                        BasisStandortSuchen.this.manager.getSettingsManager().setSetting("auik.imc.edit_object", obj.getObjektid(), false);
                        BasisStandortSuchen.this.manager.switchModul("m_objekt_bearbeiten");
                    } else if (row != -1 || obj.getBasisObjektarten().getObjektartid() == 40) {
                        BasisStandortSuchen.this.manager.getSettingsManager().setSetting("auik.imc.edit_object", obj.getObjektid(), false);
                        BasisStandortSuchen.this.manager.switchModul("m_sielhaut1");
                    }
                }
            };
            this.objektEditAction.putValue("MnemonicKey", new Integer(66));
            this.objektEditAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0, false));
        }
        return this.objektEditAction;
    }

    private Action getObjektLoeschAction() {
        if (this.objektLoeschAction == null) {
            this.objektLoeschAction = new AbstractAction("L\u00f6schen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = BasisStandortSuchen.this.getObjektTabelle().getSelectedRow();
                    if (row != -1 && BasisStandortSuchen.this.getObjektTabelle().getEditingRow() == -1) {
                        BasisObjekt objekt = BasisStandortSuchen.this.objektModel.getRow(row);
                        int answer = JOptionPane.showConfirmDialog(BasisStandortSuchen.this.panel, "Soll das Objekt " + objekt.getObjektid() + " und alle seine Fachdaten wirklich gel\u00f6scht werden?\n" + "Hinweis: Manche Objekte k\u00f6nnen auch erst gel\u00f6scht werden, wenn f\u00fcr sie\n" + "keine Fachdaten mehr existieren.", "L\u00f6schen best\u00e4tigen", 0);
                        if (answer == 0) {
                            if (BasisStandortSuchen.this.objektModel.removeRow(row)) {
                                BasisStandortSuchen.this.frame.changeStatus("Objekt gel\u00f6scht.", HauptFrame.SUCCESS_COLOR);
                                AUIKataster.debugOutput("Objekt " + objekt.getObjektid() + " wurde gel\u00f6scht!", "BasisBetreiberSuchen.removeAction");
                            } else {
                                BasisStandortSuchen.this.frame.changeStatus("Konnte das Objekt nicht l\u00f6schen!", HauptFrame.ERROR_COLOR);
                            }
                        }
                    }
                }
            };
            this.objektLoeschAction.putValue("MnemonicKey", new Integer(76));
            this.objektLoeschAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0, false));
        }
        return this.objektLoeschAction;
    }

    private Action getGisAction() {
        if (this.gisAction == null) {
            this.gisAction = new AbstractAction("GIS \u00f6ffnen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String prog = BasisStandortSuchen.this.manager.getSettingsManager().getSetting("auik.gis.programmpath");
                    String proj = BasisStandortSuchen.this.manager.getSettingsManager().getSetting("auik.gis.projectpath");
                    int row = BasisStandortSuchen.this.standortTabelle.getSelectedRow();
                    BasisStandort bsta = BasisStandortSuchen.this.standortModel.getRow(row);
                    ProcessBuilder pb = new ProcessBuilder(prog, proj);
                    Map<String, String> env = pb.environment();
                    env.put("RECHTS", bsta.getRechtswert().toString());
                    env.put("HOCH", bsta.getHochwert().toString());
                    try {
                        Process process = pb.start();
                        StreamGobbler errorGobbler = new StreamGobbler(process.getErrorStream());
                        StreamGobbler outputGobbler = new StreamGobbler(process.getInputStream());
                        errorGobbler.start();
                        outputGobbler.start();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            };
        }
        return this.gisAction;
    }

    private void showObjektPopup(MouseEvent e) {
        Point origin;
        int row;
        if (this.objektPopup == null) {
            this.objektPopup = new JPopupMenu("Objekt");
            JMenuItem bearbItem = new JMenuItem(this.getObjektEditAction());
            JMenuItem loeschItem = new JMenuItem(this.getObjektLoeschAction());
            this.objektPopup.add(bearbItem);
            this.objektPopup.add(loeschItem);
        }
        if (e.isPopupTrigger() && (row = this.objektTabelle.rowAtPoint(origin = e.getPoint())) != -1) {
            this.objektTabelle.setRowSelectionInterval(row, row);
            this.objektPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private JTable getObjektTabelle() {
        if (this.objektTabelle == null) {
            this.objektTabelle = new JTable(this.objektModel);
            this.objektTabelle.setSelectionMode(0);
            TableColumn column = this.objektTabelle.getColumnModel().getColumn(0);
            column.setMaxWidth(60);
            column.setPreferredWidth(column.getMaxWidth() - 10);
            this.objektTabelle.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        Point origin = e.getPoint();
                        int row = BasisStandortSuchen.this.getObjektTabelle().rowAtPoint(origin);
                        BasisObjekt obj = BasisStandortSuchen.this.objektModel.getRow(row);
                        if (row != -1 && obj.getBasisObjektarten().getObjektartid() != 40) {
                            BasisStandortSuchen.this.manager.getSettingsManager().setSetting("auik.imc.edit_object", obj.getObjektid(), false);
                            BasisStandortSuchen.this.manager.switchModul("m_objekt_bearbeiten");
                        } else if (row != -1 && obj.getBasisObjektarten().getObjektartid() == 40) {
                            BasisStandortSuchen.this.manager.getSettingsManager().setSetting("auik.imc.edit_object", obj.getObjektid(), false);
                            BasisStandortSuchen.this.manager.switchModul("m_sielhaut1");
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    BasisStandortSuchen.this.showObjektPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    BasisStandortSuchen.this.showObjektPopup(e);
                }
            });
            this.objektTabelle.getInputMap().put((KeyStroke)this.getObjektEditAction().getValue("AcceleratorKey"), this.getObjektEditAction().getValue("Name"));
            this.objektTabelle.getActionMap().put(this.getObjektEditAction().getValue("Name"), this.getObjektEditAction());
            this.objektTabelle.getInputMap().put((KeyStroke)this.getObjektLoeschAction().getValue("AcceleratorKey"), this.getObjektLoeschAction().getValue("Name"));
            this.objektTabelle.getActionMap().put(this.getObjektLoeschAction().getValue("Name"), this.getObjektLoeschAction());
        }
        return this.objektTabelle;
    }

    class StreamGobbler
    extends Thread {
        InputStream is;

        StreamGobbler(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

