/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.AbstractModul;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisGemarkung;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisStandort;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisStrassen;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsStandortgghwsg;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsWassereinzugsgebiete;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.DoubleField;
import de.bielefeld.umweltamt.aui.utils.IntegerField;
import de.bielefeld.umweltamt.aui.utils.LimitedTextField;
import de.bielefeld.umweltamt.aui.utils.SearchBox;
import de.bielefeld.umweltamt.aui.utils.SwingWorkerVariant;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.hibernate.HibernateException;

public class BasisStandortNeu
extends AbstractModul {
    private JButton speichernButton;
    private JFormattedTextField hausnrEditFeld;
    private JTextField hausnrZusFeld;
    private JTextField plzFeld;
    private JTextField flurFeld;
    private JTextField flurStkFeld;
    private JFormattedTextField rechtsWFeld;
    private JFormattedTextField hochWFeld;
    private JTextField datumFeld;
    private JLabel handzeichenLabel;
    private JTextField handzeichenNeuFeld;
    private JTextField sachbe33ravFeld;
    private JTextField sachbe33heeFeld;
    private JComboBox strassenBox;
    private JComboBox gemarkungBox;
    private JComboBox standortGgBox;
    private JComboBox entwGebBox;
    private JComboBox wEinzugsGebBox;
    private String[] strassen = null;
    private BasisGemarkung[] gemarkungen = null;
    private VawsStandortgghwsg[] standortggs = null;
    private String[] entwgebiete = null;
    private VawsWassereinzugsgebiete[] wEinzugsgebiete = null;

    @Override
    public String getName() {
        return "Neuer Standort";
    }

    @Override
    public String getIdentifier() {
        return "m_standort_neu";
    }

    @Override
    public String getCategory() {
        return "Betriebe";
    }

    @Override
    public Icon getIcon() {
        return super.getIcon("filenew32.png");
    }

    @Override
    public JPanel getPanel() {
        if (this.panel == null) {
            this.speichernButton = new JButton("Speichern");
            JPanel buttonBar = ButtonBarFactory.buildOKBar((JButton)this.speichernButton);
            this.strassenBox = new SearchBox();
            this.hausnrEditFeld = new IntegerField();
            this.hausnrZusFeld = new JTextField();
            this.plzFeld = new LimitedTextField(10);
            this.flurFeld = new LimitedTextField(50);
            this.flurStkFeld = new LimitedTextField(50);
            this.sachbe33ravFeld = new LimitedTextField(50);
            this.sachbe33heeFeld = new LimitedTextField(50);
            this.rechtsWFeld = new DoubleField(1);
            this.rechtsWFeld.setValue(new Float(0.0f));
            this.hochWFeld = new DoubleField(1);
            this.hochWFeld.setValue(new Float(0.0f));
            this.datumFeld = new JTextField();
            this.datumFeld.setEditable(false);
            this.datumFeld.setFocusable(false);
            this.datumFeld.setToolTipText("Wird automatisch gesetzt.");
            this.handzeichenLabel = new JLabel("Handzeichen:");
            this.handzeichenNeuFeld = new LimitedTextField(10);
            this.handzeichenNeuFeld.setToolTipText("Handzeichen obligatorisch!");
            this.gemarkungBox = new JComboBox();
            this.standortGgBox = new JComboBox();
            this.entwGebBox = new JComboBox();
            this.entwGebBox.setEditable(true);
            this.wEinzugsGebBox = new JComboBox();
            this.handzeichenNeuFeld.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        if (BasisStandortNeu.this.handzeichenNeuFeld.getText().equals("")) {
                            BasisStandortNeu.this.handzeichenLabel.setForeground(Color.RED);
                            BasisStandortNeu.this.handzeichenNeuFeld.requestFocus();
                        } else {
                            BasisStandortNeu.this.speichernButton.requestFocus();
                        }
                    }
                }
            });
            FormLayout layout = new FormLayout("right:pref, 3dlu, 50dlu:grow(0.5), 3dlu, 50dlu:grow(1.0), 5dlu, 20dlu:grow(0.2), 3dlu, 15dlu:grow(0.2), 20dlu:grow(2.5)", "pref, 3dlu, pref, 3dlu, pref, 10dlu, pref, 3dlu, pref, 10dlu, pref, 3dlu, pref, 10dlu, pref, 3dlu, pref, 10dlu, pref, 3dlu, pref, 3dlu, pref, 10dlu, pref, 3dlu, pref, 3dlu, pref, 10dlu, bottom:pref:grow");
            PanelBuilder builder = new PanelBuilder(layout);
            builder.setDefaultDialogBorder();
            CellConstraints cc = new CellConstraints();
            builder.addSeparator("Stammdaten", cc.xyw(1, 1, 9));
            builder.addLabel("Stra\u00dfe:", cc.xy(1, 3));
            builder.add((Component)this.strassenBox, cc.xyw(3, 3, 3));
            builder.add((Component)this.hausnrEditFeld, cc.xy(7, 3));
            builder.add((Component)this.hausnrZusFeld, cc.xy(9, 3));
            builder.addLabel("PLZ:", cc.xy(1, 5));
            builder.add((Component)this.plzFeld, cc.xy(3, 5));
            builder.addLabel("Rechtswert:", cc.xy(1, 7));
            builder.add((Component)this.rechtsWFeld, cc.xyw(3, 7, 3));
            builder.addLabel("Hochwert:", cc.xy(1, 9));
            builder.add((Component)this.hochWFeld, cc.xyw(3, 9, 3));
            builder.addLabel("Gemarkung:", cc.xy(1, 11));
            builder.add((Component)this.gemarkungBox, cc.xyw(3, 11, 3));
            builder.addLabel("Entw\u00e4sserungsgebiet:", cc.xy(1, 13));
            builder.add((Component)this.entwGebBox, cc.xyw(3, 13, 3));
            builder.addLabel("Flur:", cc.xy(1, 15));
            builder.add((Component)this.flurFeld, cc.xy(3, 15));
            builder.addLabel("Flurst\u00fcck:", cc.xy(1, 17));
            builder.add((Component)this.flurStkFeld, cc.xy(3, 17));
            builder.addSeparator("VAWS", cc.xyw(1, 19, 9));
            builder.addLabel("Standortgegebenheit:", cc.xy(1, 21));
            builder.add((Component)this.standortGgBox, cc.xyw(3, 21, 3));
            builder.addLabel("W.Einzugsgebiet:", cc.xy(1, 23));
            builder.add((Component)this.wEinzugsGebBox, cc.xyw(3, 23, 3));
            builder.addSeparator("Revision", cc.xyw(1, 25, 9));
            builder.addLabel("Datum:", cc.xy(1, 27));
            builder.add((Component)this.datumFeld, cc.xyw(3, 27, 3));
            builder.add((Component)this.handzeichenLabel, cc.xy(1, 29));
            builder.add((Component)this.handzeichenNeuFeld, cc.xyw(3, 29, 3));
            builder.add((Component)buttonBar, cc.xyw(1, 31, 9));
            StandortNeuListener listener = new StandortNeuListener();
            this.speichernButton.addActionListener(listener);
            this.strassenBox.addActionListener(listener);
            this.panel = builder.getPanel();
        }
        return this.panel;
    }

    @Override
    public void show() {
        super.show();
        this.clearForm();
    }

    private void doSave() {
        if (this.handzeichenNeuFeld.getText().equals("")) {
            this.handzeichenLabel.setForeground(HauptFrame.ERROR_COLOR);
            this.handzeichenNeuFeld.requestFocus();
            AUIKataster.debugOutput("Neues Handzeichen erforderlich!", "doSave");
        } else {
            this.setAllEnabled(false);
            BasisStandort bsta = new BasisStandort();
            String stra = (String)this.strassenBox.getSelectedItem();
            bsta.setStrasse(stra);
            Integer hausnr = ((IntegerField)this.hausnrEditFeld).getIntValue();
            bsta.setHausnr(hausnr);
            String hausnrZus = this.hausnrZusFeld.getText();
            if (hausnrZus.equals("")) {
                bsta.setHausnrzus(null);
            } else {
                bsta.setHausnrzus(hausnrZus);
            }
            String plz = this.plzFeld.getText().trim();
            if (plz.equals("")) {
                bsta.setPlz(null);
            } else {
                bsta.setPlz(plz);
            }
            BasisGemarkung bgem = (BasisGemarkung)this.gemarkungBox.getSelectedItem();
            bsta.setBasisGemarkung(bgem);
            VawsStandortgghwsg stgg = (VawsStandortgghwsg)this.standortGgBox.getSelectedItem();
            bsta.setVawsStandortgghwsg(stgg);
            String ezgb = (String)this.entwGebBox.getSelectedItem();
            if (ezgb != null) {
                if (ezgb.length() > 10) {
                    ezgb = ezgb.substring(0, 10);
                }
                ezgb = ezgb.trim();
            }
            bsta.setEntgebid(ezgb);
            VawsWassereinzugsgebiete wezg = (VawsWassereinzugsgebiete)this.wEinzugsGebBox.getSelectedItem();
            bsta.setVawsWassereinzugsgebiete(wezg);
            String flur = this.flurFeld.getText().trim();
            if (flur.equals("")) {
                bsta.setFlur(null);
            } else {
                bsta.setFlur(flur);
            }
            String flurstk = this.flurStkFeld.getText().trim();
            if (flurstk.equals("")) {
                bsta.setFlurstueck(null);
            } else {
                bsta.setFlurstueck(flurstk);
            }
            Float rechtsWert = ((DoubleField)this.rechtsWFeld).getFloatValue();
            bsta.setRechtswert(rechtsWert);
            Float hochWert = ((DoubleField)this.hochWFeld).getFloatValue();
            bsta.setHochwert(hochWert);
            bsta.setRevidatum(new Date());
            bsta.setRevihandz(this.handzeichenNeuFeld.getText().trim());
            bsta = BasisStandort.saveStandort(bsta);
            if (bsta != null) {
                this.frame.changeStatus("Neuer Standort " + bsta.getStandortid() + " erfolgreich gespeichert!", HauptFrame.SUCCESS_COLOR);
                if (this.manager.getSettingsManager().getBoolSetting("auik.imc.return_to_objekt")) {
                    this.manager.getSettingsManager().setSetting("auik.imc.use_standort", bsta.getStandortid(), false);
                    this.manager.getSettingsManager().removeSetting("auik.imc.return_to_objekt");
                    this.manager.switchModul("m_objekt_bearbeiten");
                } else {
                    this.clearForm();
                }
            } else {
                this.frame.changeStatus("Konnte Standort nicht speichern!", Color.RED);
                AUIKataster.debugOutput("Konnte nicht speichern", "BasisStandortNeu.doSave");
            }
        }
    }

    private void clearForm() {
        this.setAllEnabled(false);
        SwingWorkerVariant worker = new SwingWorkerVariant(this.strassenBox){

            @Override
            protected void doNonUILogic() throws RuntimeException {
                try {
                    if (BasisStandortNeu.this.strassen == null) {
                        BasisStandortNeu.access$402(BasisStandortNeu.this, BasisStrassen.getStrassen());
                    }
                    if (BasisStandortNeu.this.gemarkungen == null) {
                        BasisStandortNeu.access$502(BasisStandortNeu.this, BasisGemarkung.getGemarkungen());
                    }
                    if (BasisStandortNeu.this.standortggs == null) {
                        BasisStandortNeu.access$602(BasisStandortNeu.this, VawsStandortgghwsg.getStandortGg());
                    }
                    if (BasisStandortNeu.this.entwgebiete == null) {
                        BasisStandortNeu.access$702(BasisStandortNeu.this, BasisStandort.getEntwGebiete());
                    }
                    if (BasisStandortNeu.this.wEinzugsgebiete == null) {
                        BasisStandortNeu.access$802(BasisStandortNeu.this, VawsWassereinzugsgebiete.getWEinzugsgebiete());
                    }
                }
                catch (HibernateException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            protected void doUIUpdateLogic() throws RuntimeException {
                if (BasisStandortNeu.this.strassen != null) {
                    BasisStandortNeu.this.strassenBox.setModel(new DefaultComboBoxModel<String>(BasisStandortNeu.this.strassen));
                }
                if (BasisStandortNeu.this.gemarkungen != null) {
                    BasisStandortNeu.this.gemarkungBox.setModel(new DefaultComboBoxModel<BasisGemarkung>(BasisStandortNeu.this.gemarkungen));
                }
                if (BasisStandortNeu.this.standortggs != null) {
                    BasisStandortNeu.this.standortGgBox.setModel(new DefaultComboBoxModel<VawsStandortgghwsg>(BasisStandortNeu.this.standortggs));
                }
                if (BasisStandortNeu.this.entwgebiete != null) {
                    BasisStandortNeu.this.entwGebBox.setModel(new DefaultComboBoxModel<String>(BasisStandortNeu.this.entwgebiete));
                }
                if (BasisStandortNeu.this.wEinzugsgebiete != null) {
                    BasisStandortNeu.this.wEinzugsGebBox.setModel(new DefaultComboBoxModel<VawsWassereinzugsgebiete>(BasisStandortNeu.this.wEinzugsgebiete));
                }
                BasisStandortNeu.this.hausnrEditFeld.setValue(new Integer(0));
                BasisStandortNeu.this.hausnrZusFeld.setText("");
                BasisStandortNeu.this.plzFeld.setText("");
                BasisStandortNeu.this.flurFeld.setText("");
                BasisStandortNeu.this.flurStkFeld.setText("");
                BasisStandortNeu.this.rechtsWFeld.setValue(new Float(0.0f));
                BasisStandortNeu.this.hochWFeld.setValue(new Float(0.0f));
                BasisStandortNeu.this.datumFeld.setText(AuikUtils.getStringFromCurrentDate());
                BasisStandortNeu.this.handzeichenNeuFeld.setText("");
                BasisStandortNeu.this.handzeichenLabel.setForeground(BasisStandortNeu.this.panel.getForeground());
                BasisStandortNeu.this.setAllEnabled(true);
            }
        };
        worker.start();
        AUIKataster.debugOutput("Formular zur\u00fcckgesetzt", this.getIdentifier() + ".clearForm");
    }

    private void setAllEnabled(boolean enabled) {
        this.speichernButton.setEnabled(enabled);
        this.strassenBox.setEnabled(enabled);
        this.hausnrEditFeld.setEditable(enabled);
        this.hausnrZusFeld.setEditable(enabled);
        this.plzFeld.setEditable(enabled);
        this.gemarkungBox.setEnabled(enabled);
        this.standortGgBox.setEnabled(enabled);
        this.entwGebBox.setEnabled(enabled);
        this.entwGebBox.setEditable(enabled);
        this.wEinzugsGebBox.setEnabled(enabled);
        this.flurFeld.setEditable(enabled);
        this.flurStkFeld.setEditable(enabled);
        this.rechtsWFeld.setEditable(enabled);
        this.hochWFeld.setEditable(enabled);
        this.handzeichenNeuFeld.setEditable(enabled);
    }

    static /* synthetic */ String[] access$402(BasisStandortNeu x0, String[] x1) {
        x0.strassen = x1;
        return x1;
    }

    static /* synthetic */ BasisGemarkung[] access$502(BasisStandortNeu x0, BasisGemarkung[] x1) {
        x0.gemarkungen = x1;
        return x1;
    }

    static /* synthetic */ VawsStandortgghwsg[] access$602(BasisStandortNeu x0, VawsStandortgghwsg[] x1) {
        x0.standortggs = x1;
        return x1;
    }

    static /* synthetic */ String[] access$702(BasisStandortNeu x0, String[] x1) {
        x0.entwgebiete = x1;
        return x1;
    }

    static /* synthetic */ VawsWassereinzugsgebiete[] access$802(BasisStandortNeu x0, VawsWassereinzugsgebiete[] x1) {
        x0.wEinzugsgebiete = x1;
        return x1;
    }

    private final class StandortNeuListener
    implements ActionListener {
        private StandortNeuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasisStrassen stra;
            if (e.getSource() == BasisStandortNeu.this.speichernButton) {
                AUIKataster.debugOutput("Speichern gedr\u00fcckt!", BasisStandortNeu.this.getIdentifier());
                BasisStandortNeu.this.doSave();
            } else if (e.getSource() == BasisStandortNeu.this.strassenBox && (stra = BasisStrassen.getStrasseByName((String)BasisStandortNeu.this.strassenBox.getSelectedItem())) != null) {
                if (stra.getPlz() != null) {
                    BasisStandortNeu.this.frame.clearStatus();
                    BasisStandortNeu.this.plzFeld.setText(stra.getPlz().toString());
                } else {
                    BasisStandortNeu.this.frame.changeStatus("Die Stra\u00dfe '" + stra + "' hat keine eindeutige PLZ, bitte selbst eintragen!");
                    BasisStandortNeu.this.plzFeld.setText("");
                }
            }
        }
    }
}

