/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.AbstractModul;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.ModulManager;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisBetreiber;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjekt;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisStandort;
import de.bielefeld.umweltamt.aui.module.objektpanels.Anh40Panel;
import de.bielefeld.umweltamt.aui.module.objektpanels.Anh49AnalysenPanel;
import de.bielefeld.umweltamt.aui.module.objektpanels.Anh49DetailsPanel;
import de.bielefeld.umweltamt.aui.module.objektpanels.Anh49Panel;
import de.bielefeld.umweltamt.aui.module.objektpanels.Anh50Panel;
import de.bielefeld.umweltamt.aui.module.objektpanels.Anh52Panel;
import de.bielefeld.umweltamt.aui.module.objektpanels.Anh53Panel;
import de.bielefeld.umweltamt.aui.module.objektpanels.Anh55Panel;
import de.bielefeld.umweltamt.aui.module.objektpanels.Anh56Panel;
import de.bielefeld.umweltamt.aui.module.objektpanels.BWKPanel;
import de.bielefeld.umweltamt.aui.module.objektpanels.BasisPanel;
import de.bielefeld.umweltamt.aui.module.objektpanels.ChronoPanel;
import de.bielefeld.umweltamt.aui.module.objektpanels.GenehmigungPanel;
import de.bielefeld.umweltamt.aui.module.objektpanels.ProbepktAuswPanel;
import de.bielefeld.umweltamt.aui.module.objektpanels.ProbepunktPanel;
import de.bielefeld.umweltamt.aui.module.objektpanels.SuevPanel;
import de.bielefeld.umweltamt.aui.module.objektpanels.UebergabePanel;
import de.bielefeld.umweltamt.aui.module.objektpanels.VawsPanel;
import de.bielefeld.umweltamt.aui.utils.SwingWorkerVariant;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class BasisObjektBearbeiten
extends AbstractModul {
    private JPanel topPanel;
    private JTabbedPane tabbedPane;
    private JLabel headerLabel;
    private BasisPanel basisTab;
    private ProbepunktPanel probepunktTab;
    private ProbepktAuswPanel probeauswTab;
    private BWKPanel bwkTab;
    private Anh50Panel zahnarztTab;
    private SuevPanel suevTab;
    private Anh40Panel anhang40Tab;
    private Anh49Panel anhang49Tab;
    private Anh49DetailsPanel anh49detailTab;
    private Anh49AnalysenPanel anh49analyseTab;
    private Anh52Panel anhang52Tab;
    private Anh53Panel anhang53Tab;
    private Anh55Panel anhang55Tab;
    private Anh56Panel anhang56Tab;
    private ChronoPanel chronoTab;
    private UebergabePanel uebergabeTab;
    private GenehmigungPanel genehmigungTab;
    private VawsPanel vawsTab;
    private BasisObjekt objekt;
    private boolean isNew = true;

    @Override
    public Icon getIcon() {
        return super.getIcon("edit32.png");
    }

    @Override
    public String getName() {
        return "Objekt neu / bearbeiten";
    }

    @Override
    public String getIdentifier() {
        return "m_objekt_bearbeiten";
    }

    @Override
    public String getCategory() {
        return "Betriebe";
    }

    @Override
    public JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel(new BorderLayout());
            this.panel.add((Component)this.getTopPanel(), "North");
            this.panel.add((Component)this.getTabbedPane(), "Center");
        }
        return this.panel;
    }

    public HauptFrame getFrame() {
        return this.frame;
    }

    public ModulManager getManager() {
        return this.manager;
    }

    public BasisObjekt getObjekt() {
        return this.objekt;
    }

    public void setObjekt(BasisObjekt objekt) {
        this.objekt = objekt;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            FormLayout layout = new FormLayout("100dlu:g");
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.setDefaultDialogBorder();
            builder.append((Component)this.getHeaderLabel());
            this.topPanel = builder.getPanel();
        }
        return this.topPanel;
    }

    private JLabel getHeaderLabel() {
        if (this.headerLabel == null) {
            this.headerLabel = new JLabel(" ", 0);
            this.headerLabel.setFont(new Font("SansSerif", 1, 18));
        }
        return this.headerLabel;
    }

    public BasisPanel getBasisTab() {
        if (this.basisTab == null) {
            this.basisTab = new BasisPanel(this);
        }
        return this.basisTab;
    }

    public ProbepunktPanel getProbepunktTab() {
        if (this.probepunktTab == null) {
            this.probepunktTab = new ProbepunktPanel(this);
        }
        return this.probepunktTab;
    }

    public ProbepktAuswPanel getProbepktAuswTab() {
        if (this.probeauswTab == null) {
            this.probeauswTab = new ProbepktAuswPanel(this);
        }
        return this.probeauswTab;
    }

    public BWKPanel getBWKTab() {
        if (this.bwkTab == null) {
            this.bwkTab = new BWKPanel(this);
        }
        return this.bwkTab;
    }

    public Anh50Panel getZahnarztTab() {
        if (this.zahnarztTab == null) {
            this.zahnarztTab = new Anh50Panel(this);
        }
        return this.zahnarztTab;
    }

    public Anh49Panel getAnhang49Tab() {
        if (this.anhang49Tab == null) {
            this.anhang49Tab = new Anh49Panel(this);
        }
        return this.anhang49Tab;
    }

    public Anh49DetailsPanel getAnh49DetailTab() {
        if (this.anh49detailTab == null) {
            this.anh49detailTab = new Anh49DetailsPanel(this);
        }
        return this.anh49detailTab;
    }

    public Anh49AnalysenPanel getAnh49AnalyseTab() {
        if (this.anh49analyseTab == null) {
            this.anh49analyseTab = new Anh49AnalysenPanel(this);
        }
        return this.anh49analyseTab;
    }

    public SuevPanel getSuevTab() {
        if (this.suevTab == null) {
            this.suevTab = new SuevPanel(this);
        }
        return this.suevTab;
    }

    public Anh40Panel getAnh40Tab() {
        if (this.anhang40Tab == null) {
            this.anhang40Tab = new Anh40Panel(this);
        }
        return this.anhang40Tab;
    }

    public Anh55Panel getAnh55Tab() {
        if (this.anhang55Tab == null) {
            this.anhang55Tab = new Anh55Panel(this);
        }
        return this.anhang55Tab;
    }

    public Anh56Panel getAnh56Tab() {
        if (this.anhang56Tab == null) {
            this.anhang56Tab = new Anh56Panel(this);
        }
        return this.anhang56Tab;
    }

    public Anh52Panel getAnh52Tab() {
        if (this.anhang52Tab == null) {
            this.anhang52Tab = new Anh52Panel(this);
        }
        return this.anhang52Tab;
    }

    public Anh53Panel getAnh53Tab() {
        if (this.anhang53Tab == null) {
            this.anhang53Tab = new Anh53Panel(this);
        }
        return this.anhang53Tab;
    }

    public ChronoPanel getChronoTab() {
        if (this.chronoTab == null) {
            this.chronoTab = new ChronoPanel(this);
        }
        return this.chronoTab;
    }

    public UebergabePanel getUebergabeTab() {
        if (this.uebergabeTab == null) {
            this.uebergabeTab = new UebergabePanel(this);
        }
        return this.uebergabeTab;
    }

    public GenehmigungPanel getGenehmigungTab() {
        if (this.genehmigungTab == null) {
            this.genehmigungTab = new GenehmigungPanel(this);
        }
        return this.genehmigungTab;
    }

    public VawsPanel getVawsTab() {
        if (this.vawsTab == null) {
            this.vawsTab = new VawsPanel(this);
        }
        return this.vawsTab;
    }

    public JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.putClientProperty("jgoodies.noContentBorder", Boolean.TRUE);
            this.tabbedPane.setTabLayoutPolicy(1);
            this.tabbedPane.addTab(this.getBasisTab().getName(), this.getBasisTab());
        }
        return this.tabbedPane;
    }

    @Override
    public void show() {
        super.show();
        if (this.manager.getSettingsManager().getSetting("auik.imc.edit_object") != null) {
            this.isNew = false;
            this.objekt = BasisObjekt.getObjekt(new Integer(this.manager.getSettingsManager().getIntSetting("auik.imc.edit_object")));
            this.manager.getSettingsManager().removeSetting("auik.imc.edit_object");
        } else {
            this.isNew = true;
            this.objekt = new BasisObjekt();
            if (this.manager.getSettingsManager().getSetting("auik.imc.use_standort") != null) {
                BasisStandort sta = BasisStandort.getStandort(new Integer(this.manager.getSettingsManager().getIntSetting("auik.imc.use_standort")));
                this.objekt.setBasisStandort(sta);
                this.manager.getSettingsManager().removeSetting("auik.imc.use_standort");
            }
            if (this.manager.getSettingsManager().getSetting("auik.imc.use_betreiber") != null) {
                BasisBetreiber betr = BasisBetreiber.getBetreiber(new Integer(this.manager.getSettingsManager().getIntSetting("auik.imc.use_betreiber")));
                this.objekt.setBasisBetreiber(betr);
                this.manager.getSettingsManager().removeSetting("auik.imc.use_betreiber");
            }
        }
        this.fillForm();
    }

    public void fillForm() {
        this.enableAll(false);
        this.clearAll();
        SwingWorkerVariant worker = new SwingWorkerVariant(this.getBasisTab()){

            @Override
            protected void doNonUILogic() throws RuntimeException {
                BasisObjektBearbeiten.this.getBasisTab().fetchFormData();
                if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten() != null) {
                    if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isProbepunkt()) {
                        BasisObjektBearbeiten.this.getChronoTab().fetchFormData();
                        BasisObjektBearbeiten.this.getProbepunktTab().fetchFormData();
                    } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isBWK()) {
                        BasisObjektBearbeiten.this.getChronoTab().fetchFormData();
                        BasisObjektBearbeiten.this.getBWKTab().fetchFormData();
                    } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isAnh50()) {
                        BasisObjektBearbeiten.this.getChronoTab().fetchFormData();
                        BasisObjektBearbeiten.this.getZahnarztTab().fetchFormData();
                    } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isAnh49()) {
                        BasisObjektBearbeiten.this.getChronoTab().fetchFormData();
                        BasisObjektBearbeiten.this.getAnhang49Tab().fetchFormData();
                        BasisObjektBearbeiten.this.getAnh49DetailTab().setFachdaten(BasisObjektBearbeiten.this.getAnhang49Tab().getFachdaten());
                        if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isFettabscheider()) {
                            // empty if block
                        }
                        if (!BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isFettabscheider()) {
                            BasisObjektBearbeiten.this.getAnh49AnalyseTab().setFachdaten(BasisObjektBearbeiten.this.getAnhang49Tab().getFachdaten());
                        }
                    } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isSuev()) {
                        BasisObjektBearbeiten.this.getChronoTab().fetchFormData();
                        BasisObjektBearbeiten.this.getSuevTab().fetchFormData();
                    } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isAnh40()) {
                        BasisObjektBearbeiten.this.getChronoTab().fetchFormData();
                        BasisObjektBearbeiten.this.getAnh40Tab().fetchFormData();
                    } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isAnh55()) {
                        BasisObjektBearbeiten.this.getChronoTab().fetchFormData();
                        BasisObjektBearbeiten.this.getAnh55Tab().fetchFormData();
                    } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isAnh56()) {
                        BasisObjektBearbeiten.this.getChronoTab().fetchFormData();
                        BasisObjektBearbeiten.this.getAnh56Tab().fetchFormData();
                    } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isAnh52()) {
                        BasisObjektBearbeiten.this.getChronoTab().fetchFormData();
                        BasisObjektBearbeiten.this.getAnh52Tab().fetchFormData();
                    } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isAnh53Kl()) {
                        BasisObjektBearbeiten.this.getChronoTab().fetchFormData();
                        BasisObjektBearbeiten.this.getAnh53Tab().fetchFormData();
                    } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isAnh53Gr()) {
                        BasisObjektBearbeiten.this.getChronoTab().fetchFormData();
                        BasisObjektBearbeiten.this.getAnh53Tab().fetchFormData();
                    } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isUebergabestelle()) {
                        BasisObjektBearbeiten.this.getChronoTab().fetchFormData();
                        BasisObjektBearbeiten.this.getUebergabeTab().fetchFormData();
                    } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isGenehmigung()) {
                        BasisObjektBearbeiten.this.getChronoTab().fetchFormData();
                        BasisObjektBearbeiten.this.getGenehmigungTab().fetchFormData();
                    } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().abteilungIs34()) {
                        BasisObjektBearbeiten.this.getChronoTab().fetchFormData();
                        BasisObjektBearbeiten.this.getVawsTab().fetchFormData();
                    } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().abteilungIs33()) {
                        BasisObjektBearbeiten.this.getChronoTab().fetchFormData();
                    }
                }
            }

            @Override
            protected void doUIUpdateLogic() throws RuntimeException {
                BasisObjektBearbeiten.this.getBasisTab().updateForm();
                if (BasisObjektBearbeiten.this.isNew) {
                    AUIKataster.debugOutput("Neues Objekt");
                    BasisObjektBearbeiten.this.getHeaderLabel().setForeground(Color.RED);
                    BasisObjektBearbeiten.this.getHeaderLabel().setText("Neues Objekt");
                } else {
                    AUIKataster.debugOutput("Bearbeite Objekt: " + BasisObjektBearbeiten.this.objekt, "BasisObjektBearbeiten.fillForm");
                    BasisObjektBearbeiten.this.getHeaderLabel().setForeground(UIManager.getColor("Label.foreground"));
                    BasisObjektBearbeiten.this.getHeaderLabel().setText(BasisObjektBearbeiten.this.objekt.getBasisStandort() + "; " + BasisObjektBearbeiten.this.objekt.getBasisBetreiber() + "; " + BasisObjektBearbeiten.this.objekt.getBasisObjektarten().getObjektart());
                }
                if (BasisObjektBearbeiten.this.objekt != null) {
                    BasisObjektBearbeiten.this.getTabbedPane().removeAll();
                    BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getBasisTab().getName(), BasisObjektBearbeiten.this.getBasisTab());
                    if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten() != null) {
                        if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isProbepunkt()) {
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getChronoTab().getName(), BasisObjektBearbeiten.this.getChronoTab());
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getProbepunktTab().getName(), BasisObjektBearbeiten.this.getProbepunktTab());
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getProbepktAuswTab().getName(), BasisObjektBearbeiten.this.getProbepktAuswTab());
                            BasisObjektBearbeiten.this.getChronoTab().updateForm();
                            BasisObjektBearbeiten.this.getProbepunktTab().updateForm();
                            BasisObjektBearbeiten.this.getTabbedPane().setSelectedComponent(BasisObjektBearbeiten.this.getProbepunktTab());
                        } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isBWK()) {
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getChronoTab().getName(), BasisObjektBearbeiten.this.getChronoTab());
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getBWKTab().getName(), BasisObjektBearbeiten.this.getBWKTab());
                            BasisObjektBearbeiten.this.getChronoTab().updateForm();
                            BasisObjektBearbeiten.this.getBWKTab().updateForm();
                            BasisObjektBearbeiten.this.getTabbedPane().setSelectedComponent(BasisObjektBearbeiten.this.getBWKTab());
                        } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isAnh50()) {
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getChronoTab().getName(), BasisObjektBearbeiten.this.getChronoTab());
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getZahnarztTab().getName(), BasisObjektBearbeiten.this.getZahnarztTab());
                            BasisObjektBearbeiten.this.getChronoTab().updateForm();
                            BasisObjektBearbeiten.this.getZahnarztTab().updateForm();
                            BasisObjektBearbeiten.this.getTabbedPane().setSelectedComponent(BasisObjektBearbeiten.this.getZahnarztTab());
                        } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isAnh49()) {
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getChronoTab().getName(), BasisObjektBearbeiten.this.getChronoTab());
                            if (!BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isFettabscheider()) {
                                BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getAnhang49Tab().getName(), BasisObjektBearbeiten.this.getAnhang49Tab());
                            }
                            if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isFettabscheider()) {
                                BasisObjektBearbeiten.this.getTabbedPane().addTab("Fettabscheider", BasisObjektBearbeiten.this.getAnhang49Tab());
                            }
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getAnh49DetailTab().getName(), BasisObjektBearbeiten.this.getAnh49DetailTab());
                            if (!BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isFettabscheider()) {
                                BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getAnh49AnalyseTab().getName(), BasisObjektBearbeiten.this.getAnh49AnalyseTab());
                            }
                            if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isFettabscheider()) {
                                // empty if block
                            }
                            BasisObjektBearbeiten.this.getChronoTab().updateForm();
                            BasisObjektBearbeiten.this.getAnhang49Tab().updateForm();
                            BasisObjektBearbeiten.this.getAnh49DetailTab().updateForm();
                            if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isFettabscheider()) {
                                // empty if block
                            }
                            if (!BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isFettabscheider()) {
                                BasisObjektBearbeiten.this.getAnh49AnalyseTab().updateForm();
                            }
                            BasisObjektBearbeiten.this.getTabbedPane().setSelectedComponent(BasisObjektBearbeiten.this.getAnhang49Tab());
                        } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isSuev()) {
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getChronoTab().getName(), BasisObjektBearbeiten.this.getChronoTab());
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getSuevTab().getName(), BasisObjektBearbeiten.this.getSuevTab());
                            BasisObjektBearbeiten.this.getChronoTab().updateForm();
                            BasisObjektBearbeiten.this.getSuevTab().updateForm();
                            BasisObjektBearbeiten.this.getTabbedPane().setSelectedComponent(BasisObjektBearbeiten.this.getSuevTab());
                        } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isAnh40()) {
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getChronoTab().getName(), BasisObjektBearbeiten.this.getChronoTab());
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getAnh40Tab().getName(), BasisObjektBearbeiten.this.getAnh40Tab());
                            BasisObjektBearbeiten.this.getChronoTab().updateForm();
                            BasisObjektBearbeiten.this.getAnh40Tab().updateForm();
                            BasisObjektBearbeiten.this.getTabbedPane().setSelectedComponent(BasisObjektBearbeiten.this.getAnh40Tab());
                        } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isAnh55()) {
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getChronoTab().getName(), BasisObjektBearbeiten.this.getChronoTab());
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getAnh55Tab().getName(), BasisObjektBearbeiten.this.getAnh55Tab());
                            BasisObjektBearbeiten.this.getChronoTab().updateForm();
                            BasisObjektBearbeiten.this.getAnh55Tab().updateForm();
                            BasisObjektBearbeiten.this.getTabbedPane().setSelectedComponent(BasisObjektBearbeiten.this.getAnh55Tab());
                        } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isAnh56()) {
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getChronoTab().getName(), BasisObjektBearbeiten.this.getChronoTab());
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getAnh56Tab().getName(), BasisObjektBearbeiten.this.getAnh56Tab());
                            BasisObjektBearbeiten.this.getChronoTab().updateForm();
                            BasisObjektBearbeiten.this.getAnh56Tab().updateForm();
                            BasisObjektBearbeiten.this.getTabbedPane().setSelectedComponent(BasisObjektBearbeiten.this.getAnh56Tab());
                        } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isAnh52()) {
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getChronoTab().getName(), BasisObjektBearbeiten.this.getChronoTab());
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getAnh52Tab().getName(), BasisObjektBearbeiten.this.getAnh52Tab());
                            BasisObjektBearbeiten.this.getChronoTab().updateForm();
                            BasisObjektBearbeiten.this.getAnh52Tab().updateForm();
                            BasisObjektBearbeiten.this.getTabbedPane().setSelectedComponent(BasisObjektBearbeiten.this.getAnh52Tab());
                        } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isAnh53Kl()) {
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getChronoTab().getName(), BasisObjektBearbeiten.this.getChronoTab());
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getAnh53Tab().getName(), BasisObjektBearbeiten.this.getAnh53Tab());
                            BasisObjektBearbeiten.this.getChronoTab().updateForm();
                            BasisObjektBearbeiten.this.getAnh53Tab().updateForm();
                            BasisObjektBearbeiten.this.getTabbedPane().setSelectedComponent(BasisObjektBearbeiten.this.getAnh53Tab());
                        } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isAnh53Gr()) {
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getChronoTab().getName(), BasisObjektBearbeiten.this.getChronoTab());
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getAnh53Tab().getName(), BasisObjektBearbeiten.this.getAnh53Tab());
                            BasisObjektBearbeiten.this.getChronoTab().updateForm();
                            BasisObjektBearbeiten.this.getAnh53Tab().updateForm();
                            BasisObjektBearbeiten.this.getTabbedPane().setSelectedComponent(BasisObjektBearbeiten.this.getAnh53Tab());
                        } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isUebergabestelle()) {
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getChronoTab().getName(), BasisObjektBearbeiten.this.getChronoTab());
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getUebergabeTab().getName(), BasisObjektBearbeiten.this.getUebergabeTab());
                            BasisObjektBearbeiten.this.getChronoTab().updateForm();
                            BasisObjektBearbeiten.this.getUebergabeTab().updateForm();
                            BasisObjektBearbeiten.this.getTabbedPane().setSelectedComponent(BasisObjektBearbeiten.this.getUebergabeTab());
                        } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().isGenehmigung()) {
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getChronoTab().getName(), BasisObjektBearbeiten.this.getChronoTab());
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getGenehmigungTab().getName(), BasisObjektBearbeiten.this.getGenehmigungTab());
                            BasisObjektBearbeiten.this.getChronoTab().updateForm();
                            BasisObjektBearbeiten.this.getGenehmigungTab().updateForm();
                            BasisObjektBearbeiten.this.getTabbedPane().setSelectedComponent(BasisObjektBearbeiten.this.getGenehmigungTab());
                        } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().abteilungIs34()) {
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getChronoTab().getName(), BasisObjektBearbeiten.this.getChronoTab());
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getVawsTab().getName(), BasisObjektBearbeiten.this.getVawsTab());
                            BasisObjektBearbeiten.this.getChronoTab().updateForm();
                            BasisObjektBearbeiten.this.getVawsTab().updateForm();
                            BasisObjektBearbeiten.this.getTabbedPane().setSelectedComponent(BasisObjektBearbeiten.this.getVawsTab());
                        } else if (BasisObjektBearbeiten.this.objekt.getBasisObjektarten().abteilungIs33()) {
                            BasisObjektBearbeiten.this.getTabbedPane().addTab(BasisObjektBearbeiten.this.getChronoTab().getName(), BasisObjektBearbeiten.this.getChronoTab());
                            BasisObjektBearbeiten.this.getChronoTab().updateForm();
                            BasisObjektBearbeiten.this.getTabbedPane().setSelectedComponent(BasisObjektBearbeiten.this.getBasisTab());
                        }
                    }
                }
                BasisObjektBearbeiten.this.enableAll(true);
            }
        };
        worker.start();
    }

    private void clearAll() {
        AUIKataster.debugOutput("Leere alle Felder", "BasisObjektBearbeiten.clearAll");
        this.getBasisTab().clearForm();
        if (this.objekt.getBasisObjektarten() != null) {
            if (this.objekt.getBasisObjektarten().isProbepunkt()) {
                this.getProbepunktTab().clearForm();
                this.getProbepktAuswTab().clearForm();
            } else if (this.objekt.getBasisObjektarten().isBWK()) {
                this.getBWKTab().clearForm();
            } else if (this.objekt.getBasisObjektarten().isAnh50()) {
                this.getZahnarztTab().clearForm();
            } else if (this.objekt.getBasisObjektarten().isAnh49()) {
                this.getAnhang49Tab().clearForm();
                this.getAnh49DetailTab().clearForm();
                this.getAnh49AnalyseTab().clearForm();
            } else if (this.objekt.getBasisObjektarten().isSuev()) {
                this.getSuevTab().clearForm();
            } else if (this.objekt.getBasisObjektarten().isAnh40()) {
                this.getAnh40Tab().clearForm();
            } else if (this.objekt.getBasisObjektarten().isAnh55()) {
                this.getAnh55Tab().clearForm();
            } else if (this.objekt.getBasisObjektarten().isUebergabestelle()) {
                this.getUebergabeTab().clearForm();
            } else if (this.objekt.getBasisObjektarten().isGenehmigung()) {
                this.getGenehmigungTab().clearForm();
            } else if (this.objekt.getBasisObjektarten().isAnh56()) {
                this.getAnh56Tab().clearForm();
            } else if (this.objekt.getBasisObjektarten().isAnh52()) {
                this.getAnh52Tab().clearForm();
            } else if (this.objekt.getBasisObjektarten().isAnh53Gr()) {
                this.getAnh52Tab().clearForm();
            } else if (this.objekt.getBasisObjektarten().isAnh53Kl()) {
                this.getAnh52Tab().clearForm();
            }
        }
    }

    private void enableAll(boolean enabled) {
        this.getBasisTab().enableAll(enabled);
        if (this.objekt.getBasisObjektarten() != null) {
            if (this.objekt.getBasisObjektarten().isProbepunkt()) {
                this.getProbepunktTab().enableAll(enabled);
            } else if (this.objekt.getBasisObjektarten().isBWK()) {
                this.getBWKTab().enableAll(enabled);
            } else if (this.objekt.getBasisObjektarten().isAnh50()) {
                this.getZahnarztTab().enableAll(enabled);
            } else if (this.objekt.getBasisObjektarten().isAnh49()) {
                this.getAnhang49Tab().enableAll(enabled);
                this.getAnh49DetailTab().enableAll(enabled);
                this.getAnh49AnalyseTab().enableAll(enabled);
            } else if (this.objekt.getBasisObjektarten().isSuev()) {
                this.getSuevTab().enableAll(enabled);
            } else if (this.objekt.getBasisObjektarten().isAnh40()) {
                this.getAnh40Tab().enableAll(enabled);
            } else if (this.objekt.getBasisObjektarten().isAnh55()) {
                this.getAnh55Tab().enableAll(enabled);
            } else if (this.objekt.getBasisObjektarten().isAnh56()) {
                this.getAnh56Tab().enableAll(enabled);
            } else if (this.objekt.getBasisObjektarten().isAnh52()) {
                this.getAnh52Tab().enableAll(enabled);
            } else if (this.objekt.getBasisObjektarten().isAnh53Gr()) {
                this.getAnh52Tab().enableAll(enabled);
            } else if (this.objekt.getBasisObjektarten().isAnh53Kl()) {
                this.getAnh52Tab().enableAll(enabled);
            } else if (this.objekt.getBasisObjektarten().isUebergabestelle()) {
                this.getUebergabeTab().enableAll(enabled);
            } else if (this.objekt.getBasisObjektarten().isGenehmigung()) {
                this.getGenehmigungTab().enableAll(enabled);
            }
        }
    }

    public void completeObjekt() {
        if (this.objekt.getBasisObjektarten() != null) {
            if (this.objekt.getBasisObjektarten().isProbepunkt()) {
                this.getProbepunktTab().completeObjekt();
            } else if (this.objekt.getBasisObjektarten().isBWK()) {
                this.getBWKTab().completeObjekt();
            } else if (this.objekt.getBasisObjektarten().isAnh50()) {
                this.getZahnarztTab().completeObjekt();
            } else if (this.objekt.getBasisObjektarten().isAnh49()) {
                this.getAnhang49Tab().completeObjekt();
            } else if (this.objekt.getBasisObjektarten().isSuev()) {
                this.getSuevTab().completeObjekt();
            } else if (this.objekt.getBasisObjektarten().isAnh40()) {
                this.getAnh40Tab().completeObjekt();
            } else if (this.objekt.getBasisObjektarten().isAnh55()) {
                this.getAnh55Tab().completeObjekt();
            } else if (this.objekt.getBasisObjektarten().isAnh56()) {
                this.getAnh56Tab().completeObjekt();
            } else if (this.objekt.getBasisObjektarten().isAnh52()) {
                this.getAnh52Tab().completeObjekt();
            } else if (this.objekt.getBasisObjektarten().isAnh53Gr()) {
                this.getAnh52Tab().completeObjekt();
            } else if (this.objekt.getBasisObjektarten().isAnh53Kl()) {
                this.getAnh52Tab().completeObjekt();
            } else if (this.objekt.getBasisObjektarten().isUebergabestelle()) {
                this.getUebergabeTab().completeObjekt();
            } else if (this.objekt.getBasisObjektarten().isGenehmigung()) {
                this.getGenehmigungTab().completeObjekt();
            } else if (this.objekt.getBasisObjektarten().isProbepunkt()) {
                this.getProbepunktTab().completeObjekt();
            }
        }
    }
}

