/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.uif_lite.component.Factory;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.AbstractModul;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.SettingsManager;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisBetreiber;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjekt;
import de.bielefeld.umweltamt.aui.module.common.editors.BetreiberEditor;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.BasisBetreiberModel;
import de.bielefeld.umweltamt.aui.module.common.tablemodels.BasisObjektModel;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.NamedObject;
import de.bielefeld.umweltamt.aui.utils.SwingWorkerVariant;
import de.bielefeld.umweltamt.aui.utils.TabAction;
import de.bielefeld.umweltamt.aui.utils.TableFocusListener;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BasisBetreiberSuchen
extends AbstractModul {
    private String iconPath = "filefind32.png";
    private JComboBox suchBox;
    private JTextField suchFeld;
    private JButton submitButton;
    private JSplitPane tabellenSplit;
    private JTable betreiberTabelle;
    private JTable objektTabelle;
    private Action betreiberEditAction;
    private Action betreiberLoeschAction;
    private Action objektNeuAction;
    private JPopupMenu betreiberPopup;
    private Action objektEditAction;
    private Action objektLoeschAction;
    private JPopupMenu objektPopup;
    private BasisBetreiberModel betreiberModel;
    private BasisObjektModel objektModel;
    private BasisBetreiber lastBetreiber;

    @Override
    public String getName() {
        return "Betreiber suchen";
    }

    @Override
    public String getIdentifier() {
        return "m_betreiber_suchen";
    }

    @Override
    public String getCategory() {
        return "Betriebe";
    }

    @Override
    public Icon getIcon() {
        return super.getIcon(this.iconPath);
    }

    @Override
    public JPanel getPanel() {
        if (this.panel == null) {
            this.betreiberModel = new BasisBetreiberModel();
            this.objektModel = new BasisObjektModel("Standort", this.manager.getSettingsManager().getSetting("auik.prefs.abteilungsfilter"));
            TableFocusListener tfl = TableFocusListener.getInstance();
            this.getBetreiberTabelle().addFocusListener(tfl);
            this.getObjektTabelle().addFocusListener(tfl);
            JScrollPane betreiberScroller = new JScrollPane(this.getBetreiberTabelle(), 20, 31);
            JScrollPane objektScroller = new JScrollPane(this.getObjektTabelle(), 20, 31);
            JToolBar submitToolBar = new JToolBar();
            submitToolBar.setFloatable(false);
            submitToolBar.setRollover(true);
            submitToolBar.add(this.getSubmitButton());
            TabAction ta = new TabAction();
            ta.addComp(this.getSuchFeld());
            ta.addComp(this.getBetreiberTabelle());
            ta.addComp(this.getObjektTabelle());
            this.tabellenSplit = Factory.createStrippedSplitPane(0, betreiberScroller, objektScroller, 0.7);
            FormLayout layout = new FormLayout("50dlu, 4dlu, pref:grow, 3dlu, min(16dlu;p)", "pref, 3dlu, 150dlu:grow(1.0)");
            PanelBuilder builder = new PanelBuilder(layout);
            builder.setDefaultDialogBorder();
            CellConstraints cc = new CellConstraints();
            builder.add((Component)this.getSuchBox(), cc.xy(1, 1));
            builder.add((Component)this.getSuchFeld(), cc.xy(3, 1));
            builder.add((Component)submitToolBar, cc.xy(5, 1));
            builder.add((Component)this.tabellenSplit, cc.xyw(1, 3, 5));
            this.panel = builder.getPanel();
        }
        return this.panel;
    }

    @Override
    public void show() {
        super.show();
        if (SettingsManager.getInstance().getSetting("auik.prefs.divloc_betreiber") != null) {
            double divloc = Double.parseDouble(SettingsManager.getInstance().getSetting("auik.prefs.divloc_betreiber"));
            this.tabellenSplit.setDividerLocation(divloc);
        }
        this.lastBetreiber = null;
        this.updateBetreiberListe();
    }

    @Override
    public void hide() {
        double divloc;
        super.hide();
        if (this.tabellenSplit != null && this.tabellenSplit.getDividerLocation() != -1 && (divloc = (double)((float)this.tabellenSplit.getDividerLocation() / (float)this.tabellenSplit.getHeight())) >= 0.0 && divloc <= 1.0) {
            SettingsManager.getInstance().setSetting("auik.prefs.divloc_betreiber", Double.toString(divloc), true);
        }
    }

    public void updateBetreiberListe() {
        SwingWorkerVariant worker = new SwingWorkerVariant(this.getSuchFeld()){

            @Override
            protected void doNonUILogic() throws RuntimeException {
                BasisBetreiberSuchen.this.betreiberModel.updateList();
            }

            @Override
            protected void doUIUpdateLogic() throws RuntimeException {
                BasisBetreiberSuchen.this.betreiberModel.fireTableDataChanged();
                if (BasisBetreiberSuchen.this.lastBetreiber != null) {
                    int row = BasisBetreiberSuchen.this.betreiberModel.getList().indexOf(BasisBetreiberSuchen.this.lastBetreiber);
                    if (row != -1) {
                        BasisBetreiberSuchen.this.getBetreiberTabelle().setRowSelectionInterval(row, row);
                        BasisBetreiberSuchen.this.getBetreiberTabelle().scrollRectToVisible(BasisBetreiberSuchen.this.getBetreiberTabelle().getCellRect(row, 0, true));
                        BasisBetreiberSuchen.this.getBetreiberTabelle().requestFocus();
                    }
                } else {
                    int betreiberCount = BasisBetreiberSuchen.this.betreiberModel.getRowCount();
                    if (betreiberCount > 0) {
                        String statusMsg = "Suche: " + betreiberCount + " Ergebnis";
                        if (betreiberCount != 1) {
                            statusMsg = statusMsg + "se";
                        }
                        statusMsg = statusMsg + ".";
                        BasisBetreiberSuchen.this.frame.changeStatus(statusMsg);
                    }
                }
                BasisBetreiberSuchen.this.updateObjekte();
            }
        };
        worker.start();
    }

    public void updateObjekte() {
        ListSelectionModel lsm = this.getBetreiberTabelle().getSelectionModel();
        if (!lsm.isSelectionEmpty()) {
            int selectedRow = lsm.getMinSelectionIndex();
            BasisBetreiber betr = this.betreiberModel.getRow(selectedRow);
            AUIKataster.debugOutput("Betreiber " + betr.getBetrname() + " (ID" + betr.getBetreiberid() + ") angew\u00e4hlt.", "BasisBetreiberSuchen.updateObjekte");
            this.searchObjekteByBetreiber(betr);
        }
    }

    public void editBetreiber(BasisBetreiber betr) {
        BetreiberEditor editDialog = new BetreiberEditor(betr, this.frame);
        editDialog.setLocationRelativeTo(this.frame);
        editDialog.setVisible(true);
        this.lastBetreiber = betr;
        this.updateBetreiberListe();
    }

    public void searchObjekteByBetreiber(final BasisBetreiber betreiber) {
        SwingWorkerVariant worker = new SwingWorkerVariant(this.getBetreiberTabelle()){

            @Override
            protected void doNonUILogic() throws RuntimeException {
                BasisBetreiberSuchen.this.objektModel.searchByBetreiber(betreiber);
            }

            @Override
            protected void doUIUpdateLogic() throws RuntimeException {
                BasisBetreiberSuchen.this.objektModel.fireTableDataChanged();
            }
        };
        worker.start();
    }

    public void filterBetreiberListe(final String suche, final String column) {
        SwingWorkerVariant worker = new SwingWorkerVariant(this.getBetreiberTabelle()){

            @Override
            protected void doNonUILogic() throws RuntimeException {
                BasisBetreiberSuchen.this.betreiberModel.filterList(suche, column);
            }

            @Override
            protected void doUIUpdateLogic() throws RuntimeException {
                BasisBetreiberSuchen.this.getBetreiberTabelle().clearSelection();
                BasisBetreiberSuchen.this.betreiberModel.fireTableDataChanged();
                String statusMsg = "Suche: " + BasisBetreiberSuchen.this.betreiberModel.getRowCount() + " Ergebnis";
                if (BasisBetreiberSuchen.this.betreiberModel.getRowCount() != 1) {
                    statusMsg = statusMsg + "se";
                }
                statusMsg = statusMsg + ".";
                BasisBetreiberSuchen.this.frame.changeStatus(statusMsg);
            }
        };
        this.frame.changeStatus("Suche...");
        worker.start();
    }

    private Action getBetreiberEditAction() {
        if (this.betreiberEditAction == null) {
            this.betreiberEditAction = new AbstractAction("Bearbeiten"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = BasisBetreiberSuchen.this.getBetreiberTabelle().getSelectedRow();
                    if (row != -1) {
                        BasisBetreiber betr = BasisBetreiberSuchen.this.betreiberModel.getRow(row);
                        BasisBetreiberSuchen.this.editBetreiber(betr);
                    }
                }
            };
            this.betreiberEditAction.putValue("MnemonicKey", new Integer(66));
            this.betreiberEditAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0, false));
        }
        return this.betreiberEditAction;
    }

    private Action getBetreiberLoeschAction() {
        if (this.betreiberLoeschAction == null) {
            this.betreiberLoeschAction = new AbstractAction("L\u00f6schen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = BasisBetreiberSuchen.this.getBetreiberTabelle().getSelectedRow();
                    if (row != -1 && BasisBetreiberSuchen.this.getBetreiberTabelle().getEditingRow() == -1) {
                        if (BasisBetreiberSuchen.this.objektModel.getRowCount() != 0) {
                            BasisBetreiberSuchen.this.frame.changeStatus("Kann Betreiber nicht l\u00f6schen: Zu erst alle zugeh\u00f6rigen Objekte l\u00f6schen!", HauptFrame.ERROR_COLOR);
                        } else {
                            BasisBetreiber betr = BasisBetreiberSuchen.this.betreiberModel.getRow(row);
                            int answer = JOptionPane.showConfirmDialog(BasisBetreiberSuchen.this.panel, "Soll der Betreiber '" + betr + "' wirklich gel\u00f6scht werden?", "L\u00f6schen best\u00e4tigen", 0);
                            if (answer == 0) {
                                if (BasisBetreiberSuchen.this.betreiberModel.removeRow(row)) {
                                    BasisBetreiberSuchen.this.frame.changeStatus("Betreiber gel\u00f6scht.", HauptFrame.SUCCESS_COLOR);
                                    AUIKataster.debugOutput("Betreiber " + betr.getBetreiberid() + " wurde gel\u00f6scht!", "BasisBetreiberSuchen.removeAction");
                                } else {
                                    BasisBetreiberSuchen.this.frame.changeStatus("Konnte den Betreiber nicht l\u00f6schen!", HauptFrame.ERROR_COLOR);
                                }
                            }
                        }
                    }
                }
            };
            this.betreiberLoeschAction.putValue("MnemonicKey", new Integer(76));
            this.betreiberLoeschAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0, false));
        }
        return this.betreiberLoeschAction;
    }

    private Action getObjektNeuAction() {
        if (this.objektNeuAction == null) {
            this.objektNeuAction = new AbstractAction("Neues Objekt"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = BasisBetreiberSuchen.this.betreiberTabelle.getSelectedRow();
                    if (row != -1) {
                        BasisBetreiber betr = BasisBetreiberSuchen.this.betreiberModel.getRow(row);
                        BasisBetreiberSuchen.this.manager.getSettingsManager().setSetting("auik.imc.use_betreiber", betr.getBetreiberid(), false);
                        BasisBetreiberSuchen.this.manager.switchModul("m_objekt_bearbeiten");
                    }
                }
            };
            this.objektNeuAction.putValue("MnemonicKey", new Integer(79));
        }
        return this.objektNeuAction;
    }

    private Action getObjektEditAction() {
        if (this.objektEditAction == null) {
            this.objektEditAction = new AbstractAction("Bearbeiten"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = BasisBetreiberSuchen.this.objektTabelle.getSelectedRow();
                    BasisObjekt obj = BasisBetreiberSuchen.this.objektModel.getRow(row);
                    if (row != -1 || obj.getBasisObjektarten().getObjektartid() != 40) {
                        BasisBetreiberSuchen.this.manager.getSettingsManager().setSetting("auik.imc.edit_object", obj.getObjektid(), false);
                        BasisBetreiberSuchen.this.manager.switchModul("m_objekt_bearbeiten");
                    } else if (row != -1 || obj.getBasisObjektarten().getObjektartid() == 40) {
                        BasisBetreiberSuchen.this.manager.getSettingsManager().setSetting("auik.imc.edit_object", obj.getObjektid(), false);
                        BasisBetreiberSuchen.this.manager.switchModul("m_sielhaut1");
                    }
                }
            };
            this.objektEditAction.putValue("MnemonicKey", new Integer(66));
            this.objektEditAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0, false));
        }
        return this.objektEditAction;
    }

    private Action getObjektLoeschAction() {
        if (this.objektLoeschAction == null) {
            this.objektLoeschAction = new AbstractAction("L\u00f6schen"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = BasisBetreiberSuchen.this.getObjektTabelle().getSelectedRow();
                    if (row != -1 && BasisBetreiberSuchen.this.getObjektTabelle().getEditingRow() == -1) {
                        BasisObjekt objekt = BasisBetreiberSuchen.this.objektModel.getRow(row);
                        int answer = JOptionPane.showConfirmDialog(BasisBetreiberSuchen.this.panel, "Soll das Objekt " + objekt.getObjektid() + " und alle seine Fachdaten wirklich gel\u00f6scht werden?\n" + "Hinweis: Manche Objekte k\u00f6nnen auch erst gel\u00f6scht werden, wenn f\u00fcr sie\n" + "keine Fachdaten mehr existieren.", "L\u00f6schen best\u00e4tigen", 0);
                        if (answer == 0) {
                            if (BasisBetreiberSuchen.this.objektModel.removeRow(row)) {
                                BasisBetreiberSuchen.this.frame.changeStatus("Objekt gel\u00f6scht.", HauptFrame.SUCCESS_COLOR);
                                AUIKataster.debugOutput("Objekt " + objekt.getObjektid() + " wurde gel\u00f6scht!", "BasisBetreiberSuchen.removeAction");
                            } else {
                                BasisBetreiberSuchen.this.frame.changeStatus("Konnte das Objekt nicht l\u00f6schen!", HauptFrame.ERROR_COLOR);
                            }
                        }
                    }
                }
            };
            this.objektLoeschAction.putValue("MnemonicKey", new Integer(76));
            this.objektLoeschAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0, false));
        }
        return this.objektLoeschAction;
    }

    private void showBetreiberPopup(MouseEvent e) {
        Point origin;
        int row;
        if (this.betreiberPopup == null) {
            this.betreiberPopup = new JPopupMenu("Betreiber");
            JMenuItem bearbItem = new JMenuItem(this.getBetreiberEditAction());
            JMenuItem loeschItem = new JMenuItem(this.getBetreiberLoeschAction());
            JMenuItem neuItem = new JMenuItem(this.getObjektNeuAction());
            this.betreiberPopup.add(bearbItem);
            this.betreiberPopup.add(loeschItem);
            this.betreiberPopup.add(neuItem);
        }
        if (e.isPopupTrigger() && (row = this.betreiberTabelle.rowAtPoint(origin = e.getPoint())) != -1) {
            this.betreiberTabelle.setRowSelectionInterval(row, row);
            this.betreiberPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void showObjektPopup(MouseEvent e) {
        Point origin;
        int row;
        if (this.objektPopup == null) {
            this.objektPopup = new JPopupMenu("Objekt");
            JMenuItem bearbItem = new JMenuItem(this.getObjektEditAction());
            JMenuItem loeschItem = new JMenuItem(this.getObjektLoeschAction());
            this.objektPopup.add(bearbItem);
            this.objektPopup.add(loeschItem);
        }
        if (e.isPopupTrigger() && (row = this.objektTabelle.rowAtPoint(origin = e.getPoint())) != -1) {
            this.objektTabelle.setRowSelectionInterval(row, row);
            this.objektPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private JTable getBetreiberTabelle() {
        if (this.betreiberTabelle == null) {
            this.betreiberTabelle = new JTable(this.betreiberModel);
            ListSelectionModel rowSM = this.betreiberTabelle.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    BasisBetreiberSuchen.this.updateObjekte();
                }
            });
            this.betreiberTabelle.getColumnModel().getColumn(0).setPreferredWidth(300);
            this.betreiberTabelle.getColumnModel().getColumn(1).setPreferredWidth(60);
            this.betreiberTabelle.getColumnModel().getColumn(2).setPreferredWidth(70);
            this.betreiberTabelle.setSelectionMode(0);
            this.betreiberTabelle.setColumnSelectionAllowed(false);
            this.betreiberTabelle.setRowSelectionAllowed(true);
            this.betreiberTabelle.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        Point origin = e.getPoint();
                        int row = BasisBetreiberSuchen.this.getBetreiberTabelle().rowAtPoint(origin);
                        BasisBetreiber betr = BasisBetreiberSuchen.this.betreiberModel.getRow(row);
                        AUIKataster.debugOutput("Doppelklick auf Zeile " + row, "BasisBetreiberSuchen");
                        BasisBetreiberSuchen.this.editBetreiber(betr);
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    BasisBetreiberSuchen.this.showBetreiberPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    BasisBetreiberSuchen.this.showBetreiberPopup(e);
                }
            });
            this.betreiberTabelle.getInputMap().put((KeyStroke)this.getBetreiberEditAction().getValue("AcceleratorKey"), this.getBetreiberEditAction().getValue("Name"));
            this.betreiberTabelle.getActionMap().put(this.getBetreiberEditAction().getValue("Name"), this.getBetreiberEditAction());
            this.betreiberTabelle.getInputMap().put((KeyStroke)this.getBetreiberLoeschAction().getValue("AcceleratorKey"), this.getBetreiberLoeschAction().getValue("Name"));
            this.betreiberTabelle.getActionMap().put(this.getBetreiberLoeschAction().getValue("Name"), this.getBetreiberLoeschAction());
        }
        return this.betreiberTabelle;
    }

    private JTable getObjektTabelle() {
        if (this.objektTabelle == null) {
            this.objektTabelle = new JTable(this.objektModel);
            this.objektTabelle.setSelectionMode(0);
            this.objektTabelle.getColumnModel().getColumn(0).setMaxWidth(60);
            this.objektTabelle.getColumnModel().getColumn(0).setPreferredWidth(this.objektTabelle.getColumnModel().getColumn(0).getMaxWidth() - 10);
            this.objektTabelle.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        Point origin = e.getPoint();
                        int row = BasisBetreiberSuchen.this.getObjektTabelle().rowAtPoint(origin);
                        BasisObjekt obj = BasisBetreiberSuchen.this.objektModel.getRow(row);
                        if (row != -1 && obj.getBasisObjektarten().getObjektartid() != 40) {
                            BasisBetreiberSuchen.this.manager.getSettingsManager().setSetting("auik.imc.edit_object", obj.getObjektid(), false);
                            BasisBetreiberSuchen.this.manager.switchModul("m_objekt_bearbeiten");
                        } else if (row != -1 && obj.getBasisObjektarten().getObjektartid() == 40) {
                            BasisBetreiberSuchen.this.manager.getSettingsManager().setSetting("auik.imc.edit_object", obj.getObjektid(), false);
                            BasisBetreiberSuchen.this.manager.switchModul("m_sielhaut1");
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    BasisBetreiberSuchen.this.showObjektPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    BasisBetreiberSuchen.this.showObjektPopup(e);
                }
            });
            this.objektTabelle.getInputMap().put((KeyStroke)this.getObjektEditAction().getValue("AcceleratorKey"), this.getObjektEditAction().getValue("Name"));
            this.objektTabelle.getActionMap().put(this.getObjektEditAction().getValue("Name"), this.getObjektEditAction());
            this.objektTabelle.getInputMap().put((KeyStroke)this.getObjektLoeschAction().getValue("AcceleratorKey"), this.getObjektLoeschAction().getValue("Name"));
            this.objektTabelle.getActionMap().put(this.getObjektLoeschAction().getValue("Name"), this.getObjektLoeschAction());
        }
        return this.objektTabelle;
    }

    private JComboBox getSuchBox() {
        if (this.suchBox == null) {
            this.suchBox = new JComboBox<NamedObject>(new NamedObject[]{new NamedObject("Name:", "name"), new NamedObject("Anrede:", "anrede"), new NamedObject("Zusatz:", "zusatz"), new NamedObject("Irgendwo", null)});
        }
        return this.suchBox;
    }

    private JTextField getSuchFeld() {
        if (this.suchFeld == null) {
            this.suchFeld = new JTextField();
            this.suchFeld.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String suche = BasisBetreiberSuchen.this.getSuchFeld().getText();
                    String spalte = (String)((NamedObject)BasisBetreiberSuchen.this.getSuchBox().getSelectedItem()).getValue();
                    BasisBetreiberSuchen.this.filterBetreiberListe(suche, spalte);
                }
            });
            this.suchFeld.setFocusTraversalKeys(0, Collections.EMPTY_SET);
            this.suchFeld.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 9) {
                        String suche = BasisBetreiberSuchen.this.getSuchFeld().getText();
                        String spalte = (String)((NamedObject)BasisBetreiberSuchen.this.getSuchBox().getSelectedItem()).getValue();
                        BasisBetreiberSuchen.this.filterBetreiberListe(suche, spalte);
                    }
                }
            });
        }
        return this.suchFeld;
    }

    private JButton getSubmitButton() {
        if (this.submitButton == null) {
            this.submitButton = new JButton(AuikUtils.getIcon(16, "key_enter.png"));
            this.submitButton.setToolTipText("Suche starten");
            this.submitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String suche = BasisBetreiberSuchen.this.getSuchFeld().getText();
                    String spalte = (String)((NamedObject)BasisBetreiberSuchen.this.getSuchBox().getSelectedItem()).getValue();
                    BasisBetreiberSuchen.this.filterBetreiberListe(suche, spalte);
                }
            });
        }
        return this.submitButton;
    }
}

