/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.AbstractModul;
import de.bielefeld.umweltamt.aui.HauptFrame;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisBetreiber;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisStrassen;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsWirtschaftszweige;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.IntegerField;
import de.bielefeld.umweltamt.aui.utils.LimitedTextArea;
import de.bielefeld.umweltamt.aui.utils.LimitedTextField;
import de.bielefeld.umweltamt.aui.utils.LongNameComboBoxRenderer;
import de.bielefeld.umweltamt.aui.utils.SwingWorkerVariant;
import de.bielefeld.umweltamt.aui.utils.TabAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import java.util.Calendar;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.hibernate.HibernateException;

public class BasisBetreiberNeu
extends AbstractModul {
    private JButton speichernButton;
    private JLabel handzeichenLabel;
    private JLabel namenLabel;
    private JTextField anredeFeld;
    private JTextField namenFeld;
    private JTextField nameZusFeld;
    private JFormattedTextField hausnrFeld;
    private JTextField hausnrZusFeld;
    private JTextField plzZsFeld;
    private JTextField plzFeld;
    private JTextField ortsFeld;
    private JTextField telefonFeld;
    private JTextField telefaxFeld;
    private JTextField emailFeld;
    private JTextField betrBeaufVornameFeld;
    private JTextField betrBeaufNachnameFeld;
    private JTextField revdatumsFeld;
    private JTextField handzeichenNeuFeld;
    private JTextArea bemerkungsArea;
    private JComboBox strassenBox;
    private JComboBox wirtschaftszweigBox;
    private String[] strassen = null;
    private VawsWirtschaftszweige[] wirtschaftszweige = null;

    @Override
    public String getName() {
        return "Neuer Betreiber";
    }

    @Override
    public String getIdentifier() {
        return "m_betreiber_neu";
    }

    @Override
    public String getCategory() {
        return "Betriebe";
    }

    @Override
    public Icon getIcon() {
        return super.getIcon("filenew32.png");
    }

    @Override
    public JPanel getPanel() {
        if (this.panel == null) {
            this.speichernButton = new JButton("Speichern");
            this.anredeFeld = new LimitedTextField(100);
            this.namenFeld = new LimitedTextField(100);
            this.nameZusFeld = new LimitedTextField(50);
            this.hausnrFeld = new IntegerField();
            this.hausnrZusFeld = new LimitedTextField(10);
            this.plzZsFeld = new LimitedTextField(3, "");
            this.plzFeld = new JTextField();
            this.ortsFeld = new LimitedTextField(50);
            this.telefonFeld = new LimitedTextField(50);
            this.telefaxFeld = new LimitedTextField(50);
            this.emailFeld = new LimitedTextField(50);
            this.betrBeaufVornameFeld = new LimitedTextField(50);
            this.betrBeaufNachnameFeld = new LimitedTextField(50);
            this.revdatumsFeld = new JTextField();
            this.revdatumsFeld.setEditable(false);
            this.revdatumsFeld.setFocusable(false);
            this.revdatumsFeld.setToolTipText("Wird automatisch gesetzt.");
            this.handzeichenNeuFeld = new LimitedTextField(10, "");
            this.handzeichenNeuFeld.setToolTipText("Handzeichen obligatorisch!");
            this.bemerkungsArea = new LimitedTextArea(2000);
            this.bemerkungsArea.setLineWrap(true);
            this.bemerkungsArea.setWrapStyleWord(true);
            JScrollPane bemerkungsScroller = new JScrollPane(this.bemerkungsArea, 20, 31);
            this.strassenBox = new JComboBox();
            this.strassenBox.setEditable(true);
            this.wirtschaftszweigBox = new JComboBox();
            this.wirtschaftszweigBox.setRenderer(new LongNameComboBoxRenderer());
            JPanel buttonBar = ButtonBarFactory.buildOKBar((JButton)this.speichernButton);
            this.handzeichenNeuFeld.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getSource().equals(BasisBetreiberNeu.this.handzeichenNeuFeld) && e.getKeyCode() == 10) {
                        if (BasisBetreiberNeu.this.handzeichenNeuFeld.getText().equals("")) {
                            BasisBetreiberNeu.this.handzeichenLabel.setForeground(Color.RED);
                            BasisBetreiberNeu.this.handzeichenNeuFeld.requestFocus();
                        } else {
                            BasisBetreiberNeu.this.speichernButton.requestFocus();
                        }
                    }
                }
            });
            bemerkungsScroller.getVerticalScrollBar().setFocusable(false);
            bemerkungsScroller.getHorizontalScrollBar().setFocusable(false);
            TabAction tac = new TabAction(this.bemerkungsArea, this.handzeichenNeuFeld);
            FormLayout layout = new FormLayout("right:pref, 3dlu, 20dlu, 40dlu, 5dlu, right:pref, 3dlu, 27dlu, 3dlu, 30dlu, 5dlu:grow(0.5)", "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 10dlu, top:pref:grow");
            layout.setRowGroups((int[][])new int[][]{{1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 30, 31, 33, 35, 37}});
            PanelBuilder builder = new PanelBuilder(layout);
            builder.setDefaultDialogBorder();
            CellConstraints cc = new CellConstraints();
            builder.addSeparator("Stammdaten", cc.xyw(1, 1, 10));
            builder.addLabel("Anrede:", cc.xy(1, 3));
            builder.add((Component)this.anredeFeld, cc.xyw(3, 3, 4));
            this.namenLabel = builder.addLabel("Name:", cc.xy(1, 5));
            builder.add((Component)this.namenFeld, cc.xyw(3, 5, 4));
            builder.addLabel("Zusatz:", cc.xy(1, 7));
            builder.add((Component)this.nameZusFeld, cc.xyw(3, 7, 4));
            builder.addLabel("Wirtschaftszweig:", cc.xy(1, 9));
            builder.add((Component)this.wirtschaftszweigBox, cc.xyw(3, 9, 4));
            builder.addSeparator("Adresse", cc.xyw(1, 11, 10));
            builder.addLabel("Stra\u00dfe:", cc.xy(1, 13));
            builder.add((Component)this.strassenBox, cc.xyw(3, 13, 4));
            builder.add((Component)this.hausnrFeld, cc.xy(8, 13));
            builder.add((Component)this.hausnrZusFeld, cc.xy(10, 13));
            builder.addLabel("Ort:", cc.xy(1, 15));
            builder.add((Component)this.plzZsFeld, cc.xy(3, 15));
            builder.add((Component)this.plzFeld, cc.xy(4, 15));
            builder.add((Component)this.ortsFeld, cc.xyw(6, 15, 5));
            builder.addLabel("Telefon:", cc.xy(1, 17));
            builder.add((Component)this.telefonFeld, cc.xyw(3, 17, 4));
            builder.addLabel("Telefax:", cc.xy(1, 19));
            builder.add((Component)this.telefaxFeld, cc.xyw(3, 19, 4));
            builder.addLabel("E-Mail:", cc.xy(1, 21));
            builder.add((Component)this.emailFeld, cc.xyw(3, 21, 4));
            builder.addSeparator("Ansprechpartner", cc.xyw(1, 23, 10));
            builder.addLabel("Vorname:", cc.xy(1, 25));
            builder.add((Component)this.betrBeaufVornameFeld, cc.xyw(3, 25, 2));
            builder.addLabel("Nachname:", cc.xy(6, 25));
            builder.add((Component)this.betrBeaufNachnameFeld, cc.xyw(8, 25, 3));
            builder.addSeparator("Bemerkungen", cc.xyw(1, 27, 10));
            builder.add((Component)bemerkungsScroller, cc.xywh(1, 29, 10, 3));
            builder.addSeparator("Revision", cc.xyw(1, 33, 10));
            builder.addLabel("Datum:", cc.xy(1, 35));
            builder.add((Component)this.revdatumsFeld, cc.xyw(3, 35, 4));
            this.handzeichenLabel = builder.addLabel("Handzeichen:", cc.xy(1, 37));
            builder.add((Component)this.handzeichenNeuFeld, cc.xyw(3, 37, 4));
            builder.add((Component)buttonBar, cc.xyw(1, 39, 10));
            BetreiberNeuListener dialogListener = new BetreiberNeuListener();
            this.speichernButton.addActionListener(dialogListener);
            this.strassenBox.addActionListener(dialogListener);
            this.panel = builder.getPanel();
        }
        return this.panel;
    }

    @Override
    public void show() {
        super.show();
        this.clearForm();
    }

    private void doSave() {
        if (this.namenFeld.getText().equals("")) {
            this.namenLabel.setForeground(HauptFrame.ERROR_COLOR);
            this.namenFeld.requestFocus();
            String nameErr = "Der Name darf nicht leer sein!";
            this.frame.changeStatus(nameErr, HauptFrame.ERROR_COLOR);
            AUIKataster.debugOutput(nameErr, "BasisBetreiberNeu.doSave");
        } else if (this.handzeichenNeuFeld.getText().equals("")) {
            this.handzeichenLabel.setForeground(HauptFrame.ERROR_COLOR);
            this.handzeichenNeuFeld.requestFocus();
            String handzErr = "Neues Handzeichen erforderlich!";
            this.frame.changeStatus(handzErr, HauptFrame.ERROR_COLOR);
            AUIKataster.debugOutput(handzErr, "BasisBetreiberNeu.doSave");
        } else {
            this.setAllEnabled(false);
            BasisBetreiber betrn = new BasisBetreiber();
            String anrede = this.anredeFeld.getText();
            if (anrede.equals("")) {
                betrn.setBetranrede(null);
            } else {
                betrn.setBetranrede(anrede);
            }
            String name = this.namenFeld.getText();
            if (name.equals("")) {
                betrn.setBetrname(null);
            } else {
                betrn.setBetrname(name);
            }
            String nameZusatz = this.nameZusFeld.getText();
            if (nameZusatz.equals("")) {
                betrn.setBetrnamezus(null);
            } else {
                betrn.setBetrnamezus(nameZusatz);
            }
            String stra = (String)this.strassenBox.getSelectedItem();
            if (stra != null) {
                if ((stra = stra.trim()).length() > 50) {
                    stra = stra.substring(0, 50);
                }
                if (stra.equals("")) {
                    betrn.setStrasse(null);
                } else {
                    betrn.setStrasse(stra);
                }
            }
            try {
                this.hausnrFeld.commitEdit();
            }
            catch (ParseException e1) {
                this.hausnrFeld.setValue(new Integer(0));
            }
            Integer hausnr = this.hausnrFeld.getValue() instanceof Long ? new Integer(((Long)this.hausnrFeld.getValue()).intValue()) : (Integer)this.hausnrFeld.getValue();
            betrn.setHausnr(hausnr);
            String hausnrZus = this.hausnrZusFeld.getText();
            if (hausnrZus.equals("")) {
                betrn.setHausnrzus(null);
            } else {
                betrn.setHausnrzus(hausnrZus);
            }
            String plzZs = this.plzZsFeld.getText();
            if (plzZs.equals("")) {
                betrn.setPlzzs(null);
            } else {
                betrn.setPlzzs(plzZs.toUpperCase().trim());
            }
            String plz = this.plzFeld.getText().trim();
            if (plz.equals("")) {
                betrn.setPlz(null);
            } else {
                betrn.setPlz(plz);
            }
            String ort = this.ortsFeld.getText().trim();
            if (ort.equals("")) {
                betrn.setOrt(null);
            } else {
                betrn.setOrt(ort);
            }
            String telefon = this.telefonFeld.getText().trim();
            if (telefon.equals("")) {
                betrn.setTelefon(null);
            } else {
                betrn.setTelefon(telefon);
            }
            String telefax = this.telefaxFeld.getText().trim();
            if (telefax.equals("")) {
                betrn.setTelefax(null);
            } else {
                betrn.setTelefax(telefax);
            }
            String email = this.emailFeld.getText().trim();
            if (email.equals("")) {
                betrn.setEmail(null);
            } else {
                betrn.setEmail(email);
            }
            String betrBeaufVorname = this.betrBeaufVornameFeld.getText().trim();
            if (betrBeaufVorname.equals("")) {
                betrn.setVornamebetrbeauf(null);
            } else {
                betrn.setVornamebetrbeauf(betrBeaufVorname);
            }
            String betrBeaufNachname = this.betrBeaufNachnameFeld.getText().trim();
            if (betrBeaufNachname.equals("")) {
                betrn.setNamebetrbeauf(null);
            } else {
                betrn.setNamebetrbeauf(betrBeaufNachname);
            }
            VawsWirtschaftszweige wizw = (VawsWirtschaftszweige)this.wirtschaftszweigBox.getSelectedItem();
            betrn.setVawsWirtschaftszweige(wizw);
            String bemerkungen = this.bemerkungsArea.getText().trim();
            if (bemerkungen.equals("")) {
                betrn.setBemerkungen(null);
            } else {
                betrn.setBemerkungen(bemerkungen);
            }
            betrn.setRevidatum(Calendar.getInstance().getTime());
            betrn.setRevihandz(this.handzeichenNeuFeld.getText().trim());
            betrn = BasisBetreiber.saveBetreiber(betrn);
            if (betrn != null) {
                this.frame.changeStatus("Neuer Betreiber " + betrn.getBetreiberid() + " erfolgreich gespeichert.", HauptFrame.SUCCESS_COLOR);
                if (this.manager.getSettingsManager().getBoolSetting("auik.imc.return_to_objekt")) {
                    this.manager.getSettingsManager().setSetting("auik.imc.use_betreiber", betrn.getBetreiberid(), false);
                    this.manager.getSettingsManager().removeSetting("auik.imc.return_to_objekt");
                    this.manager.switchModul("m_objekt_bearbeiten");
                } else {
                    this.clearForm();
                }
            } else {
                this.frame.changeStatus("Konnte Betreiber nicht speichern!", Color.RED);
                AUIKataster.debugOutput("Konnte nicht speichern", "BasisBetreiberNeu.doSave");
            }
        }
    }

    private void clearForm() {
        this.setAllEnabled(false);
        SwingWorkerVariant worker = new SwingWorkerVariant(this.anredeFeld){

            @Override
            protected void doNonUILogic() throws RuntimeException {
                try {
                    if (BasisBetreiberNeu.this.strassen == null) {
                        BasisBetreiberNeu.access$402(BasisBetreiberNeu.this, BasisStrassen.getStrassen());
                    }
                    if (BasisBetreiberNeu.this.wirtschaftszweige == null) {
                        BasisBetreiberNeu.access$502(BasisBetreiberNeu.this, VawsWirtschaftszweige.getWirtschaftszweige());
                    }
                }
                catch (HibernateException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            protected void doUIUpdateLogic() throws RuntimeException {
                if (BasisBetreiberNeu.this.strassen != null) {
                    BasisBetreiberNeu.this.strassenBox.setModel(new DefaultComboBoxModel<String>(BasisBetreiberNeu.this.strassen));
                    BasisBetreiberNeu.this.strassenBox.setSelectedIndex(-1);
                }
                if (BasisBetreiberNeu.this.wirtschaftszweige != null) {
                    BasisBetreiberNeu.this.wirtschaftszweigBox.setModel(new DefaultComboBoxModel<VawsWirtschaftszweige>(BasisBetreiberNeu.this.wirtschaftszweige));
                }
                BasisBetreiberNeu.this.hausnrFeld.setValue(null);
                BasisBetreiberNeu.this.hausnrZusFeld.setText("");
                BasisBetreiberNeu.this.plzZsFeld.setText("D");
                BasisBetreiberNeu.this.plzFeld.setText("");
                BasisBetreiberNeu.this.anredeFeld.setText("");
                BasisBetreiberNeu.this.namenFeld.setText("");
                BasisBetreiberNeu.this.namenLabel.setForeground(BasisBetreiberNeu.this.panel.getForeground());
                BasisBetreiberNeu.this.nameZusFeld.setText("");
                BasisBetreiberNeu.this.ortsFeld.setText("");
                BasisBetreiberNeu.this.telefonFeld.setText("");
                BasisBetreiberNeu.this.telefaxFeld.setText("");
                BasisBetreiberNeu.this.emailFeld.setText("");
                BasisBetreiberNeu.this.betrBeaufNachnameFeld.setText("");
                BasisBetreiberNeu.this.betrBeaufVornameFeld.setText("");
                BasisBetreiberNeu.this.bemerkungsArea.setText("");
                BasisBetreiberNeu.this.revdatumsFeld.setText(AuikUtils.getStringFromCurrentDate());
                BasisBetreiberNeu.this.handzeichenNeuFeld.setText("");
                BasisBetreiberNeu.this.handzeichenLabel.setForeground(BasisBetreiberNeu.this.panel.getForeground());
                BasisBetreiberNeu.this.setAllEnabled(true);
                AUIKataster.debugOutput("Formular zur\u00fcckgesetzt", BasisBetreiberNeu.this.getIdentifier() + ".clearForm");
            }
        };
        worker.start();
    }

    private void setAllEnabled(boolean enabled) {
        this.speichernButton.setEnabled(enabled);
        this.strassenBox.setEnabled(enabled);
        this.wirtschaftszweigBox.setEnabled(enabled);
        this.hausnrFeld.setEditable(enabled);
        this.hausnrZusFeld.setEditable(enabled);
        this.plzFeld.setEditable(enabled);
        this.plzZsFeld.setEditable(enabled);
        this.anredeFeld.setEditable(enabled);
        this.namenFeld.setEditable(enabled);
        this.nameZusFeld.setEditable(enabled);
        this.ortsFeld.setEditable(enabled);
        this.telefonFeld.setEditable(enabled);
        this.telefaxFeld.setEditable(enabled);
        this.emailFeld.setEditable(enabled);
        this.betrBeaufVornameFeld.setEditable(enabled);
        this.betrBeaufNachnameFeld.setEditable(enabled);
        this.bemerkungsArea.setEnabled(enabled);
        this.bemerkungsArea.setEditable(enabled);
        this.handzeichenNeuFeld.setEditable(enabled);
    }

    static /* synthetic */ String[] access$402(BasisBetreiberNeu x0, String[] x1) {
        x0.strassen = x1;
        return x1;
    }

    static /* synthetic */ VawsWirtschaftszweige[] access$502(BasisBetreiberNeu x0, VawsWirtschaftszweige[] x1) {
        x0.wirtschaftszweige = x1;
        return x1;
    }

    private final class BetreiberNeuListener
    implements ActionListener {
        private BetreiberNeuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == BasisBetreiberNeu.this.speichernButton) {
                AUIKataster.debugOutput("Speichern gedr\u00fcckt!", BasisBetreiberNeu.this.getIdentifier());
                BasisBetreiberNeu.this.doSave();
            }
        }
    }
}

