/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlAnalyseposition;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlEinheiten;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlParameter;
import de.bielefeld.umweltamt.aui.mappings.atl.AtlProbenahmen;

public class AnalyseProcessor {
    public static boolean process(String[] columns) {
        AtlEinheiten einheit;
        if (columns == null || columns.length < 8) {
            AUIKataster.errorOutput("Analyseimport: AtlAnalyseoption nicht vollst\u00e4ndig.", "AnalyseProcessor");
        }
        String kennnummer = AnalyseProcessor.unquote(columns[0]);
        String ordnungsbegriff = AnalyseProcessor.unquote(columns[2]);
        String parameterBezeichnung = AnalyseProcessor.unquote(columns[3]);
        String grkl = AnalyseProcessor.unquote(columns[4]);
        String wert = AnalyseProcessor.unquote(columns[5]);
        String einheitId = AnalyseProcessor.unquote(columns[6]);
        int id = -1;
        if (einheitId != null && !einheitId.equals("")) {
            id = Integer.parseInt(einheitId);
        }
        AUIKataster.debugOutput("Verarbeite Analyseposition f\u00fcr Parameter: " + parameterBezeichnung);
        AtlProbenahmen probe = AtlProbenahmen.getProbenahme(kennnummer, true);
        if (probe == null) {
            AUIKataster.errorOutput("Probenahme mit folgender Kennung konnte nicht gefunden werden: " + kennnummer, "AnalyseProcessor");
            return false;
        }
        AtlParameter parameter = AtlParameter.getParameter(ordnungsbegriff);
        AtlAnalyseposition pos = probe.findAtlAnalyseposition(parameter, einheit = AtlEinheiten.getEinheit(id));
        if (pos != null) {
            pos.setWert(Float.valueOf(Float.parseFloat(wert)));
            pos.setGrkl(grkl);
            AtlProbenahmen.updateProbenahme(probe);
        }
        return true;
    }

    public static String unquote(String raw) {
        return raw.substring(1, raw.length() - 1);
    }

    public static int importStatus(String kenn, String param, String einheit) {
        AtlProbenahmen probe = AtlProbenahmen.getProbenahme(kenn, true);
        if (probe == null) {
            return -1;
        }
        if (param == null || einheit == null) {
            return 2;
        }
        int id = Integer.parseInt(einheit);
        AtlParameter p = AtlParameter.getParameter(param);
        AtlEinheiten e = AtlEinheiten.getEinheit(id);
        if (p == null || e == null) {
            return -1;
        }
        AtlAnalyseposition pos = probe.findAtlAnalyseposition(p, e, false);
        return pos != null ? 1 : 2;
    }
}

