/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.module;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.AbstractModul;
import de.bielefeld.umweltamt.aui.module.AnalyseProcessor;
import de.bielefeld.umweltamt.aui.utils.AuikUtils;
import de.bielefeld.umweltamt.aui.utils.tablemodelbase.ListTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class AnalyseImport
extends AbstractModul {
    protected AnalyseImporter importer = new AnalyseImporter();
    protected JButton dateiButton;
    protected JButton importButton;
    protected JLabel dateiLabel;
    protected JLabel parseLabel;
    protected JLabel importLabel;
    protected JLabel beschreibungLabel;
    protected JScrollPane listScroller;
    protected JTable table = new JTable(this.importer);

    public AnalyseImport() {
        this.dateiButton = new JButton("Datei w\u00e4hlen");
        this.dateiLabel = new JLabel();
        this.parseLabel = new JLabel();
        this.listScroller = new JScrollPane(this.table);
        this.beschreibungLabel = new JLabel("<html><table width='100%'><tr><td style='color: green;'>Gr\u00fcn:</td><td>Import m&ouml;glich: Kennnummer und Parameter vorhanden.</td></tr><tr><td style='color: FF8200;'>Orange:</td><td>Import m&ouml;glich: Kennnummer vorhanden, Parameter wird angelegt.</td></tr><tr><td style='color: red;'>Rot:</td><td>Zeile nicht importierbar.</td></tr></table></html>");
        this.importButton = new JButton("Importieren");
        this.importLabel = new JLabel(AuikUtils.getIcon("step3_grey.png", "Schritt Drei"));
        this.activateFileChooser(true, false);
        this.activateImport(false, false);
        this.dateiButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = AnalyseImport.this.frame.openFile(new String[]{"txt"});
                if (file != null) {
                    AnalyseImport.this.doImport(file);
                }
            }
        });
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnalyseImport.this.doSave();
            }
        });
    }

    @Override
    public String getName() {
        return "Import Analyseergebnisse";
    }

    @Override
    public String getIdentifier() {
        return "atl_analyse_import";
    }

    @Override
    public String getCategory() {
        return "Labor";
    }

    @Override
    public Icon getIcon() {
        return super.getIcon("ksysguard.png");
    }

    @Override
    public JPanel getPanel() {
        if (this.panel != null) {
            return this.panel;
        }
        FormLayout layout = new FormLayout("40px,5dlu,65dlu,5dlu,175dlu:g", "");
        DefaultFormBuilder b = new DefaultFormBuilder(layout);
        b.setDefaultDialogBorder();
        b.append((Component)this.getParseLabel(), (Component)this.getDateiButton(), (Component)this.getDateiLabel());
        b.appendRelatedComponentsGapRow();
        b.appendRow("f:50dlu:g");
        b.nextLine(2);
        b.append("");
        b.append((Component)this.getListScroller(), 3);
        b.appendRelatedComponentsGapRow();
        b.nextLine(2);
        b.append("");
        b.append((Component)this.getBeschreibungLabel(), 3);
        b.appendRelatedComponentsGapRow();
        b.nextLine(2);
        b.append((Component)this.getImportLabel(), (Component)this.getImportButton());
        this.panel = b.getPanel();
        return this.panel;
    }

    public JLabel getParseLabel() {
        return this.parseLabel;
    }

    public JLabel getDateiLabel() {
        return this.dateiLabel;
    }

    public JLabel getBeschreibungLabel() {
        return this.beschreibungLabel;
    }

    public JLabel getImportLabel() {
        return this.importLabel;
    }

    public JButton getDateiButton() {
        return this.dateiButton;
    }

    public JButton getImportButton() {
        return this.importButton;
    }

    public JScrollPane getListScroller() {
        return this.listScroller;
    }

    protected void activateFileChooser(boolean active, boolean success) {
        if (active) {
            this.parseLabel.setIcon(AuikUtils.getIcon("step1_w.png", "Schritt Eins"));
        } else if (success) {
            this.parseLabel.setIcon(AuikUtils.getIcon("step1_g.png", "Schritt Eins"));
        } else {
            this.parseLabel.setIcon(AuikUtils.getIcon("step1_grey.png", "Schritt Eins"));
        }
    }

    protected void activateImport(boolean active, boolean success) {
        if (active) {
            this.importLabel.setIcon(AuikUtils.getIcon("step2_w.png", "Schritt Zwei"));
            this.importButton.setEnabled(true);
        } else {
            this.importButton.setEnabled(false);
            if (success) {
                this.importLabel.setIcon(AuikUtils.getIcon("step2_g.png", "Schritt Zwei"));
            } else {
                this.importLabel.setIcon(AuikUtils.getIcon("step2_grey.png", "Schritt Zwei"));
            }
        }
    }

    protected void doImport(File file) {
        this.importer.parse(file);
    }

    protected void doSave() {
        AUIKataster.debugOutput("Speichere die importieren Daten.", this.getClass().getName());
        List data = this.importer.getSelectedRows();
        int size = data.size();
        int count = 0;
        for (int i = 0; i < size; ++i) {
            String[] row = (String[])data.get(i);
            if (!AnalyseProcessor.process(row)) continue;
            ++count;
        }
        this.frame.showInfoMessage("Es wurden " + count + " Zeilen der Analyseergebnisse erfolgreich" + "\nin die Datenbank gespeichert.", "Import erfolgreich");
        this.activateImport(false, true);
    }

    private class AnalyseImporter
    extends ListTableModel {
        protected File toImport;
        protected boolean[] selection;
        protected int[] status;

        public AnalyseImporter() {
            super(new String[]{"Kennnummer", "Ordnungsbegriff", "Parameter", "GrKl", "Wert", "Einheit", "Plausibel"}, false);
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (!this.rowExists(row)) {
                return null;
            }
            String[] columns = (String[])this.getObjectAtRow(row);
            List data = this.getList();
            int status = this.getRowStatus(row);
            switch (col) {
                case 0: {
                    return this.getColoredColumn(status, AnalyseProcessor.unquote(columns[0]));
                }
                case 1: {
                    return this.getColoredColumn(status, AnalyseProcessor.unquote(columns[2]));
                }
                case 2: {
                    return this.getColoredColumn(status, AnalyseProcessor.unquote(columns[3]));
                }
                case 3: {
                    return this.getColoredColumn(status, AnalyseProcessor.unquote(columns[4]));
                }
                case 4: {
                    return this.getColoredColumn(status, AnalyseProcessor.unquote(columns[5]));
                }
                case 5: {
                    return this.getColoredColumn(status, AnalyseProcessor.unquote(columns[7]));
                }
                case 6: {
                    return this.selection[row];
                }
            }
            return null;
        }

        protected int getRowStatus(int row) {
            if (this.status[row] == 0) {
                String[] columns = (String[])this.getObjectAtRow(row);
                this.status[row] = columns.length < 8 ? -1 : AnalyseProcessor.importStatus(AnalyseProcessor.unquote(columns[0]), AnalyseProcessor.unquote(columns[2]), AnalyseProcessor.unquote(columns[6]));
            }
            return this.status[row];
        }

        protected String getColoredColumn(int status, String txt) {
            StringBuilder sb = new StringBuilder("<html>");
            switch (status) {
                case -1: {
                    sb.append("<font color='red'>");
                    sb.append(txt);
                    sb.append("</font>");
                    break;
                }
                case 1: {
                    sb.append("<font color='green'>");
                    sb.append(txt);
                    sb.append("</font>");
                    break;
                }
                case 2: {
                    sb.append("<font color='FF8200'>");
                    sb.append(txt);
                    sb.append("</font>");
                    break;
                }
                default: {
                    sb.append(txt);
                }
            }
            sb.append("</html>");
            return sb.toString();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col != 6) {
                return;
            }
            this.selection[row] = Boolean.TRUE.equals(value);
        }

        @Override
        public Object getColumnValue(Object row, int col) {
            return null;
        }

        public List getSelectedRows() {
            ArrayList<String[]> selected = new ArrayList<String[]>();
            for (int i = 0; i < this.selection.length; ++i) {
                boolean s = Boolean.TRUE.equals(this.getValueAt(i, 6));
                if (!s) continue;
                selected.add((String[])this.getObjectAtRow(i));
            }
            return selected;
        }

        public Class getColumnClass(int col) {
            return col == 6 ? Boolean.class : String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 6 && this.getRowStatus(row) > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateList() throws Exception {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new FileReader(this.toImport));
                List dataList = this.getList();
                String line = null;
                int count = -1;
                while ((line = in.readLine()) != null) {
                    if (count >= 0) {
                        String[] columns = line.split(",");
                        dataList.add(columns);
                    }
                    ++count;
                }
                AUIKataster.debugOutput(count + " Zeilen eingelesen.", this.getClass().getName());
                this.fireTableDataChanged();
                this.status = new int[dataList.size()];
                this.initSelection();
            }
            catch (FileNotFoundException fnfe) {
                AUIKataster.errorOutput("Fehler beim Lesen der Probenahme-Analyseergebnisse: " + fnfe.getMessage(), this.getClass().getName());
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }

        protected void initSelection() {
            int rows = this.getRowCount();
            this.selection = new boolean[rows];
            for (int i = 0; i < rows; ++i) {
                this.selection[i] = this.getRowStatus(i) > 0;
            }
        }

        public void reset() {
            this.setList(new ArrayList());
            this.toImport = null;
            AnalyseImport.this.activateFileChooser(true, false);
            AnalyseImport.this.activateImport(false, false);
            this.fireTableDataChanged();
        }

        public void parse(File f) {
            if (!f.isFile() || !f.canRead()) {
                AnalyseImport.this.frame.showErrorMessage("Konnte die angegebene Datei '" + f.getName() + "' nicht \u00f6ffnen!", "Fehler beim \u00d6ffnen der Datei");
            }
            this.reset();
            String name = f.getName();
            try {
                this.toImport = f;
                AUIKataster.debugOutput("Beginne Analyseergebnisse aus '" + name + "' zu lesen.", this.getClass().getName());
                this.updateList();
                List data = this.getList();
                if (data.size() > 0) {
                    AnalyseImport.this.getDateiLabel().setText("Datei: " + name);
                    AnalyseImport.this.activateFileChooser(false, true);
                    AnalyseImport.this.activateImport(true, false);
                } else {
                    AnalyseImport.this.frame.showInfoMessage("Datei '" + name + "' wurde erfolgreich geladen.\n" + "Es wurden jedoch keine Daten gefunden.", "Keine Daten");
                }
            }
            catch (Exception e) {
                AnalyseImport.this.frame.showErrorMessage("Beim Lesen der Datei " + name + "ist ein Fehler aufgetreten: " + e.getMessage(), "Konnte Datei nicht lesen.");
            }
        }
    }
}

