/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.vaws;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.vaws.AbstractVawsVerwaltungsverf;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsFachdaten;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class VawsVerwaltungsverf
extends AbstractVawsVerwaltungsverf
implements Serializable {
    public static List getAuswertung() {
        List kontrollen;
        String query = "from VawsVerwaltungsverf vf where vf.wiedervorlage < ? and (vf.wvverwverf = ? or vf.wvverwverf is NULL) order by vf.wiedervorlage, vf.vawsFachdaten";
        try {
            Session session = HibernateSessionFactory.currentSession();
            kontrollen = session.createQuery(query).setDate(0, new Date()).setBoolean(1, false).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return kontrollen;
    }

    public static List getVerwaltungsverf(VawsFachdaten fachdaten) {
        List verfahren;
        if (fachdaten.getBehaelterId() == null) {
            verfahren = new ArrayList();
        } else {
            try {
                Session session = HibernateSessionFactory.currentSession();
                verfahren = session.createQuery("from VawsVerwaltungsverf vvf where vvf.vawsFachdaten = ? order by vvf.wvverwverf desc, vvf.datum, vvf.wiedervorlage").setEntity(0, (Object)fachdaten).list();
                AUIKataster.debugOutput(verfahren.size() + " Verfahrens-Eintr\u00e4ge f\u00fcr FD " + fachdaten + " gefunden!", "VawsVerwaltungsverf");
            }
            catch (HibernateException e) {
                throw new RuntimeException("Datenbank-Fehler", e);
            }
            finally {
                HibernateSessionFactory.closeSession();
            }
        }
        return verfahren;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveVerfahren(VawsVerwaltungsverf verfahren) {
        boolean saved;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)verfahren);
            tx.commit();
            saved = true;
        }
        catch (HibernateException e) {
            saved = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "VawsVerwaltungsverf.save", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return saved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeVerfahren(VawsVerwaltungsverf verfahren) {
        boolean removed;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.delete((Object)verfahren);
            tx.commit();
            removed = true;
        }
        catch (HibernateException e) {
            removed = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "VawsVerwaltungsverf.remove", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return removed;
    }
}

