/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.vaws;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.vaws.AbstractVawsVerwaltungsgebuehren;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsFachdaten;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class VawsVerwaltungsgebuehren
extends AbstractVawsVerwaltungsgebuehren
implements Serializable {
    public VawsVerwaltungsgebuehren() {
        this.setBetrag(new Float(0.0));
        this.setAbschnitt("360.12 LW");
    }

    public VawsVerwaltungsgebuehren(Integer id) {
        super(id);
    }

    public static List getVerwaltungsgebuehren(VawsFachdaten fachdaten) {
        List gebuehren;
        if (fachdaten.getBehaelterId() == null) {
            gebuehren = new ArrayList();
        } else {
            try {
                Session session = HibernateSessionFactory.currentSession();
                gebuehren = session.createQuery("from VawsVerwaltungsgebuehren vgb where vgb.vawsFachdaten = ? order by vgb.datum, vgb.abschnitt, vgb.betrag").setEntity(0, (Object)fachdaten).list();
                AUIKataster.debugOutput(gebuehren.size() + " Geb\u00fchren-Eintr\u00e4ge f\u00fcr FD " + fachdaten + " gefunden!", "VawsVerwaltungsgebuehren");
            }
            catch (HibernateException e) {
                throw new RuntimeException("Datenbank-Fehler", e);
            }
            finally {
                HibernateSessionFactory.closeSession();
            }
        }
        return gebuehren;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveGebuehr(VawsVerwaltungsgebuehren gebuehr) {
        boolean saved;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)gebuehr);
            tx.commit();
            saved = true;
        }
        catch (HibernateException e) {
            saved = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "VawsVerwaltungsgebuehren.save", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return saved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeGebuehr(VawsVerwaltungsgebuehren gebuehr) {
        boolean removed;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.delete((Object)gebuehr);
            tx.commit();
            removed = true;
        }
        catch (HibernateException e) {
            removed = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "VawsVerwaltungsgebuehren.remove", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return removed;
    }
}

