/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.vaws;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.vaws.AbstractVawsKontrollen;
import de.bielefeld.umweltamt.aui.mappings.vaws.VawsFachdaten;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class VawsKontrollen
extends AbstractVawsKontrollen
implements Serializable {
    public VawsKontrollen() {
    }

    public VawsKontrollen(Integer kontrollid) {
        super(kontrollid);
    }

    public static List getAuswertung() {
        List kontrollen;
        String query = "from VawsKontrollen vk where vk.naechstepruefung < ? and vk.pruefungabgeschlossen = ? order by vk.naechstepruefung, vk.vawsFachdaten";
        try {
            Session session = HibernateSessionFactory.currentSession();
            kontrollen = session.createQuery(query).setDate(0, new Date()).setBoolean(1, false).list();
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return kontrollen;
    }

    public static List getKontrollen(VawsFachdaten fachdaten) {
        List kontrollen;
        if (fachdaten.getBehaelterId() == null) {
            kontrollen = new ArrayList();
        } else {
            try {
                Session session = HibernateSessionFactory.currentSession();
                kontrollen = session.createQuery("from VawsKontrollen vk where vk.vawsFachdaten = ? order by vk.pruefungabgeschlossen desc, vk.pruefdatum, vk.naechstepruefung").setEntity(0, (Object)fachdaten).list();
                AUIKataster.debugOutput(kontrollen.size() + " Kontrollen-Eintr\u00e4ge f\u00fcr FD " + fachdaten + " gefunden!", "VawsKontrollen");
            }
            catch (HibernateException e) {
                throw new RuntimeException("Datenbank-Fehler", e);
            }
            finally {
                HibernateSessionFactory.closeSession();
            }
        }
        return kontrollen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveKontrolle(VawsKontrollen kontrolle) {
        boolean saved;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)kontrolle);
            tx.commit();
            saved = true;
        }
        catch (HibernateException e) {
            saved = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "VawsKontrollen.save", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return saved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeKontrolle(VawsKontrollen kontrolle) {
        boolean removed;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.delete((Object)kontrolle);
            tx.commit();
            removed = true;
        }
        catch (HibernateException e) {
            removed = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "VawsKontrollen.remove", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return removed;
    }
}

