/*
 * Decompiled with CFR 0.152.
 */
package de.bielefeld.umweltamt.aui.mappings.vaws;

import de.bielefeld.umweltamt.aui.AUIKataster;
import de.bielefeld.umweltamt.aui.HibernateSessionFactory;
import de.bielefeld.umweltamt.aui.mappings.basis.BasisObjekt;
import de.bielefeld.umweltamt.aui.mappings.vaws.AbstractVawsFachdaten;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class VawsFachdaten
extends AbstractVawsFachdaten
implements Serializable {
    public VawsFachdaten() {
    }

    public VawsFachdaten(Integer behaelterId) {
        super(behaelterId);
    }

    public String toString() {
        String tmp = this.getBehaelterId() + ": ";
        if (this.getAnlagenart() != null) {
            tmp = tmp + this.getAnlagenart() + " ";
        }
        if (this.getHerstellnr() != null) {
            tmp = tmp + this.getHerstellnr();
        }
        return tmp;
    }

    public String getStillegungsDatumString() {
        if (this.getStillegungsdatum() != null) {
            DateFormat f = DateFormat.getDateInstance(3);
            return f.format(this.getStillegungsdatum());
        }
        return null;
    }

    public boolean isAbfuellflaeche() {
        return "Abf\u00fcllfl\u00e4che".equals(this.getAnlagenart());
    }

    public boolean isVAWSAbscheider() {
        return "VAwS-Abscheider".equals(this.getAnlagenart());
    }

    public boolean isLageranlage() {
        return !this.isAbfuellflaeche() && !this.isRohrleitung();
    }

    public boolean isRohrleitung() {
        return "Rohrleitung".equals(this.getAnlagenart());
    }

    public static List getVawsByObjekt(BasisObjekt objekt) {
        List vaws;
        if (objekt.getBasisObjektarten().abteilungIs34()) {
            try {
                Session session = HibernateSessionFactory.currentSession();
                vaws = session.createQuery("from VawsFachdaten as v where v.basisObjekt = ? order by v.stillegungsdatum desc, v.anlagenart asc, v.herstellnr asc").setEntity(0, (Object)objekt).list();
                AUIKataster.debugOutput(vaws.size() + " VawsFachdatens\u00e4tze f\u00fcr BO " + objekt + " gefunden!", "VawsFachdaten");
            }
            catch (HibernateException e) {
                throw new RuntimeException("Datenbank-Fehler", e);
            }
            finally {
                HibernateSessionFactory.closeSession();
            }
        } else {
            throw new IllegalArgumentException("Zu diesem BasisObjekt existieren keine VAWS-Fachdaten-Objekte!");
        }
        return vaws;
    }

    public static VawsFachdaten getVawsByBehaelterId(Integer id) {
        VawsFachdaten fachdaten;
        try {
            Session session = HibernateSessionFactory.currentSession();
            fachdaten = (VawsFachdaten)session.get(VawsFachdaten.class, (Serializable)id);
            HibernateSessionFactory.closeSession();
        }
        catch (HibernateException e) {
            fachdaten = null;
        }
        return fachdaten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveFachdaten(VawsFachdaten fachdaten) {
        boolean saved;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)fachdaten);
            tx.commit();
            saved = true;
        }
        catch (HibernateException e) {
            saved = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "VawsFachdaten.save", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return saved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeFachdaten(VawsFachdaten fachdaten) {
        boolean removed;
        Transaction tx = null;
        try {
            Session session = HibernateSessionFactory.currentSession();
            tx = session.beginTransaction();
            session.delete((Object)fachdaten);
            tx.commit();
            removed = true;
        }
        catch (HibernateException e) {
            removed = false;
            e.printStackTrace();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (HibernateException e1) {
                    AUIKataster.handleDBException(e1, "VawsFachdaten.remove", false);
                }
            }
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return removed;
    }

    public static String[] getAusfuehrungen() {
        String[] tmp;
        String suchString = "select distinct fd.ausfuehrung from VawsFachdaten fd order by fd.ausfuehrung";
        try {
            Session session = HibernateSessionFactory.currentSession();
            Query query = session.createQuery(suchString);
            query.setCacheable(true);
            query.setCacheRegion("vawsausfliste");
            List list = query.list();
            tmp = new String[list.size()];
            tmp = list.toArray(tmp);
        }
        catch (HibernateException e) {
            throw new RuntimeException("Datenbank-Fehler", e);
        }
        finally {
            HibernateSessionFactory.closeSession();
        }
        return tmp;
    }

    public static List findherstellnr(String herstellnr) {
        String query = "from VawsFachdaten vaws where vaws.herstellnr like ?";
        Session session = HibernateSessionFactory.currentSession();
        List vaws = session.createQuery(query).setString(0, herstellnr).list();
        HibernateSessionFactory.closeSession();
        return vaws;
    }
}

